//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmarketplace

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AcknowledgeOfferNotificationDetails.
func (a AcknowledgeOfferNotificationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "acknowledge", a.Acknowledge)
	populate(objectMap, "addPlans", a.AddPlans)
	populate(objectMap, "dismiss", a.Dismiss)
	populate(objectMap, "removeOffer", a.RemoveOffer)
	populate(objectMap, "removePlans", a.RemovePlans)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AcknowledgeOfferNotificationDetails.
func (a *AcknowledgeOfferNotificationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "acknowledge":
			err = unpopulate(val, "Acknowledge", &a.Acknowledge)
			delete(rawMsg, key)
		case "addPlans":
			err = unpopulate(val, "AddPlans", &a.AddPlans)
			delete(rawMsg, key)
		case "dismiss":
			err = unpopulate(val, "Dismiss", &a.Dismiss)
			delete(rawMsg, key)
		case "removeOffer":
			err = unpopulate(val, "RemoveOffer", &a.RemoveOffer)
			delete(rawMsg, key)
		case "removePlans":
			err = unpopulate(val, "RemovePlans", &a.RemovePlans)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AcknowledgeOfferNotificationProperties.
func (a AcknowledgeOfferNotificationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", a.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AcknowledgeOfferNotificationProperties.
func (a *AcknowledgeOfferNotificationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminRequestApprovalProperties.
func (a AdminRequestApprovalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminAction", a.AdminAction)
	populate(objectMap, "administrator", a.Administrator)
	populate(objectMap, "approvedPlans", a.ApprovedPlans)
	populate(objectMap, "collectionIds", a.CollectionIDs)
	populate(objectMap, "comment", a.Comment)
	populate(objectMap, "displayName", a.DisplayName)
	populate(objectMap, "offerId", a.OfferID)
	populate(objectMap, "plans", a.Plans)
	populate(objectMap, "publisherId", a.PublisherID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminRequestApprovalProperties.
func (a *AdminRequestApprovalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminAction":
			err = unpopulate(val, "AdminAction", &a.AdminAction)
			delete(rawMsg, key)
		case "administrator":
			err = unpopulate(val, "Administrator", &a.Administrator)
			delete(rawMsg, key)
		case "approvedPlans":
			err = unpopulate(val, "ApprovedPlans", &a.ApprovedPlans)
			delete(rawMsg, key)
		case "collectionIds":
			err = unpopulate(val, "CollectionIDs", &a.CollectionIDs)
			delete(rawMsg, key)
		case "comment":
			err = unpopulate(val, "Comment", &a.Comment)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &a.OfferID)
			delete(rawMsg, key)
		case "plans":
			err = unpopulate(val, "Plans", &a.Plans)
			delete(rawMsg, key)
		case "publisherId":
			err = unpopulate(val, "PublisherID", &a.PublisherID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminRequestApprovalsList.
func (a AdminRequestApprovalsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminRequestApprovalsList.
func (a *AdminRequestApprovalsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AdminRequestApprovalsResource.
func (a AdminRequestApprovalsResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AdminRequestApprovalsResource.
func (a *AdminRequestApprovalsResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BillingAccountsResponse.
func (b BillingAccountsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "billingAccounts", b.BillingAccounts)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BillingAccountsResponse.
func (b *BillingAccountsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "billingAccounts":
			err = unpopulate(val, "BillingAccounts", &b.BillingAccounts)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BulkCollectionsDetails.
func (b BulkCollectionsDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "action", b.Action)
	populate(objectMap, "collectionIds", b.CollectionIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BulkCollectionsDetails.
func (b *BulkCollectionsDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "action":
			err = unpopulate(val, "Action", &b.Action)
			delete(rawMsg, key)
		case "collectionIds":
			err = unpopulate(val, "CollectionIDs", &b.CollectionIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BulkCollectionsPayload.
func (b BulkCollectionsPayload) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", b.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BulkCollectionsPayload.
func (b *BulkCollectionsPayload) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &b.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BulkCollectionsResponse.
func (b BulkCollectionsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failed", b.Failed)
	populate(objectMap, "succeeded", b.Succeeded)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BulkCollectionsResponse.
func (b *BulkCollectionsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failed":
			err = unpopulate(val, "Failed", &b.Failed)
			delete(rawMsg, key)
		case "succeeded":
			err = unpopulate(val, "Succeeded", &b.Succeeded)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Collection.
func (c Collection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", c.ID)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "properties", c.Properties)
	populate(objectMap, "systemData", c.SystemData)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Collection.
func (c *Collection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &c.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectionProperties.
func (c CollectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allSubscriptions", c.AllSubscriptions)
	populate(objectMap, "claim", c.Claim)
	populate(objectMap, "collectionId", c.CollectionID)
	populate(objectMap, "collectionName", c.CollectionName)
	populate(objectMap, "enabled", c.Enabled)
	populate(objectMap, "numberOfOffers", c.NumberOfOffers)
	populate(objectMap, "subscriptionsList", c.SubscriptionsList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectionProperties.
func (c *CollectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allSubscriptions":
			err = unpopulate(val, "AllSubscriptions", &c.AllSubscriptions)
			delete(rawMsg, key)
		case "claim":
			err = unpopulate(val, "Claim", &c.Claim)
			delete(rawMsg, key)
		case "collectionId":
			err = unpopulate(val, "CollectionID", &c.CollectionID)
			delete(rawMsg, key)
		case "collectionName":
			err = unpopulate(val, "CollectionName", &c.CollectionName)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &c.Enabled)
			delete(rawMsg, key)
		case "numberOfOffers":
			err = unpopulate(val, "NumberOfOffers", &c.NumberOfOffers)
			delete(rawMsg, key)
		case "subscriptionsList":
			err = unpopulate(val, "SubscriptionsList", &c.SubscriptionsList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectionsDetails.
func (c CollectionsDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "collectionId", c.CollectionID)
	populate(objectMap, "collectionName", c.CollectionName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectionsDetails.
func (c *CollectionsDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collectionId":
			err = unpopulate(val, "CollectionID", &c.CollectionID)
			delete(rawMsg, key)
		case "collectionName":
			err = unpopulate(val, "CollectionName", &c.CollectionName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectionsList.
func (c CollectionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", c.NextLink)
	populate(objectMap, "value", c.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectionsList.
func (c *CollectionsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &c.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &c.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectionsSubscriptionsMappingDetails.
func (c CollectionsSubscriptionsMappingDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "collectionName", c.CollectionName)
	populate(objectMap, "subscriptions", c.Subscriptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectionsSubscriptionsMappingDetails.
func (c *CollectionsSubscriptionsMappingDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "collectionName":
			err = unpopulate(val, "CollectionName", &c.CollectionName)
			delete(rawMsg, key)
		case "subscriptions":
			err = unpopulate(val, "Subscriptions", &c.Subscriptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectionsToSubscriptionsMappingPayload.
func (c CollectionsToSubscriptionsMappingPayload) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", c.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectionsToSubscriptionsMappingPayload.
func (c *CollectionsToSubscriptionsMappingPayload) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &c.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectionsToSubscriptionsMappingProperties.
func (c CollectionsToSubscriptionsMappingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subscriptionIds", c.SubscriptionIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectionsToSubscriptionsMappingProperties.
func (c *CollectionsToSubscriptionsMappingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subscriptionIds":
			err = unpopulate(val, "SubscriptionIDs", &c.SubscriptionIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectionsToSubscriptionsMappingResponse.
func (c CollectionsToSubscriptionsMappingResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", c.Details)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectionsToSubscriptionsMappingResponse.
func (c *CollectionsToSubscriptionsMappingResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &c.Details)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponseError.
func (e ErrorResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "message", e.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponseError.
func (e *ErrorResponseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NewNotifications.
func (n NewNotifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", n.DisplayName)
	populate(objectMap, "icon", n.Icon)
	populate(objectMap, "isFuturePlansEnabled", n.IsFuturePlansEnabled)
	populate(objectMap, "messageCode", n.MessageCode)
	populate(objectMap, "offerId", n.OfferID)
	populate(objectMap, "plans", n.Plans)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NewNotifications.
func (n *NewNotifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &n.DisplayName)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &n.Icon)
			delete(rawMsg, key)
		case "isFuturePlansEnabled":
			err = unpopulate(val, "IsFuturePlansEnabled", &n.IsFuturePlansEnabled)
			delete(rawMsg, key)
		case "messageCode":
			err = unpopulate(val, "MessageCode", &n.MessageCode)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &n.OfferID)
			delete(rawMsg, key)
		case "plans":
			err = unpopulate(val, "Plans", &n.Plans)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NewPlansNotificationsList.
func (n NewPlansNotificationsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "newPlansNotifications", n.NewPlansNotifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NewPlansNotificationsList.
func (n *NewPlansNotificationsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "newPlansNotifications":
			err = unpopulate(val, "NewPlansNotifications", &n.NewPlansNotifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NotificationsSettingsProperties.
func (n NotificationsSettingsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "recipients", n.Recipients)
	populate(objectMap, "sendToAllMarketplaceAdmins", n.SendToAllMarketplaceAdmins)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NotificationsSettingsProperties.
func (n *NotificationsSettingsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "recipients":
			err = unpopulate(val, "Recipients", &n.Recipients)
			delete(rawMsg, key)
		case "sendToAllMarketplaceAdmins":
			err = unpopulate(val, "SendToAllMarketplaceAdmins", &n.SendToAllMarketplaceAdmins)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Offer.
func (o Offer) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "systemData", o.SystemData)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Offer.
func (o *Offer) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &o.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OfferListResponse.
func (o OfferListResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OfferListResponse.
func (o *OfferListResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OfferProperties.
func (o OfferProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "createdAt", o.CreatedAt)
	populate(objectMap, "eTag", o.ETag)
	populate(objectMap, "iconFileUris", o.IconFileUris)
	populate(objectMap, "modifiedAt", o.ModifiedAt)
	populate(objectMap, "offerDisplayName", o.OfferDisplayName)
	populate(objectMap, "plans", o.Plans)
	populate(objectMap, "privateStoreId", o.PrivateStoreID)
	populate(objectMap, "publisherDisplayName", o.PublisherDisplayName)
	populate(objectMap, "specificPlanIdsLimitation", o.SpecificPlanIDsLimitation)
	populate(objectMap, "uniqueOfferId", o.UniqueOfferID)
	populate(objectMap, "updateSuppressedDueIdempotence", o.UpdateSuppressedDueIdempotence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OfferProperties.
func (o *OfferProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulate(val, "CreatedAt", &o.CreatedAt)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &o.ETag)
			delete(rawMsg, key)
		case "iconFileUris":
			err = unpopulate(val, "IconFileUris", &o.IconFileUris)
			delete(rawMsg, key)
		case "modifiedAt":
			err = unpopulate(val, "ModifiedAt", &o.ModifiedAt)
			delete(rawMsg, key)
		case "offerDisplayName":
			err = unpopulate(val, "OfferDisplayName", &o.OfferDisplayName)
			delete(rawMsg, key)
		case "plans":
			err = unpopulate(val, "Plans", &o.Plans)
			delete(rawMsg, key)
		case "privateStoreId":
			err = unpopulate(val, "PrivateStoreID", &o.PrivateStoreID)
			delete(rawMsg, key)
		case "publisherDisplayName":
			err = unpopulate(val, "PublisherDisplayName", &o.PublisherDisplayName)
			delete(rawMsg, key)
		case "specificPlanIdsLimitation":
			err = unpopulate(val, "SpecificPlanIDsLimitation", &o.SpecificPlanIDsLimitation)
			delete(rawMsg, key)
		case "uniqueOfferId":
			err = unpopulate(val, "UniqueOfferID", &o.UniqueOfferID)
			delete(rawMsg, key)
		case "updateSuppressedDueIdempotence":
			err = unpopulate(val, "UpdateSuppressedDueIdempotence", &o.UpdateSuppressedDueIdempotence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Plan.
func (p Plan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessibility", p.Accessibility)
	populate(objectMap, "altStackReference", p.AltStackReference)
	populate(objectMap, "planDisplayName", p.PlanDisplayName)
	populate(objectMap, "planId", p.PlanID)
	populate(objectMap, "skuId", p.SKUID)
	populate(objectMap, "stackType", p.StackType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Plan.
func (p *Plan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessibility":
			err = unpopulate(val, "Accessibility", &p.Accessibility)
			delete(rawMsg, key)
		case "altStackReference":
			err = unpopulate(val, "AltStackReference", &p.AltStackReference)
			delete(rawMsg, key)
		case "planDisplayName":
			err = unpopulate(val, "PlanDisplayName", &p.PlanDisplayName)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &p.PlanID)
			delete(rawMsg, key)
		case "skuId":
			err = unpopulate(val, "SKUID", &p.SKUID)
			delete(rawMsg, key)
		case "stackType":
			err = unpopulate(val, "StackType", &p.StackType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanDetails.
func (p PlanDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "justification", p.Justification)
	populate(objectMap, "planId", p.PlanID)
	populateAny(objectMap, "requestDate", p.RequestDate)
	populate(objectMap, "status", p.Status)
	populate(objectMap, "subscriptionId", p.SubscriptionID)
	populate(objectMap, "subscriptionName", p.SubscriptionName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanDetails.
func (p *PlanDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "justification":
			err = unpopulate(val, "Justification", &p.Justification)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &p.PlanID)
			delete(rawMsg, key)
		case "requestDate":
			err = unpopulate(val, "RequestDate", &p.RequestDate)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &p.SubscriptionID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &p.SubscriptionName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanNotificationDetails.
func (p PlanNotificationDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "planDisplayName", p.PlanDisplayName)
	populate(objectMap, "planId", p.PlanID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanNotificationDetails.
func (p *PlanNotificationDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "planDisplayName":
			err = unpopulate(val, "PlanDisplayName", &p.PlanDisplayName)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &p.PlanID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlanRequesterDetails.
func (p PlanRequesterDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "planDisplayName", p.PlanDisplayName)
	populate(objectMap, "planId", p.PlanID)
	populate(objectMap, "requesters", p.Requesters)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlanRequesterDetails.
func (p *PlanRequesterDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "planDisplayName":
			err = unpopulate(val, "PlanDisplayName", &p.PlanDisplayName)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &p.PlanID)
			delete(rawMsg, key)
		case "requesters":
			err = unpopulate(val, "Requesters", &p.Requesters)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateStore.
func (p PrivateStore) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateStore.
func (p *PrivateStore) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateStoreList.
func (p PrivateStoreList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateStoreList.
func (p *PrivateStoreList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateStoreNotificationsState.
func (p PrivateStoreNotificationsState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "approvalRequests", p.ApprovalRequests)
	populate(objectMap, "newNotifications", p.NewNotifications)
	populate(objectMap, "stopSellNotifications", p.StopSellNotifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateStoreNotificationsState.
func (p *PrivateStoreNotificationsState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "approvalRequests":
			err = unpopulate(val, "ApprovalRequests", &p.ApprovalRequests)
			delete(rawMsg, key)
		case "newNotifications":
			err = unpopulate(val, "NewNotifications", &p.NewNotifications)
			delete(rawMsg, key)
		case "stopSellNotifications":
			err = unpopulate(val, "StopSellNotifications", &p.StopSellNotifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateStoreProperties.
func (p PrivateStoreProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availability", p.Availability)
	populate(objectMap, "branding", p.Branding)
	populate(objectMap, "collectionIds", p.CollectionIDs)
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "isGov", p.IsGov)
	populate(objectMap, "notificationsSettings", p.NotificationsSettings)
	populate(objectMap, "privateStoreId", p.PrivateStoreID)
	populate(objectMap, "privateStoreName", p.PrivateStoreName)
	populate(objectMap, "tenantId", p.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateStoreProperties.
func (p *PrivateStoreProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availability":
			err = unpopulate(val, "Availability", &p.Availability)
			delete(rawMsg, key)
		case "branding":
			err = unpopulate(val, "Branding", &p.Branding)
			delete(rawMsg, key)
		case "collectionIds":
			err = unpopulate(val, "CollectionIDs", &p.CollectionIDs)
			delete(rawMsg, key)
		case "eTag":
			err = unpopulate(val, "ETag", &p.ETag)
			delete(rawMsg, key)
		case "isGov":
			err = unpopulate(val, "IsGov", &p.IsGov)
			delete(rawMsg, key)
		case "notificationsSettings":
			err = unpopulate(val, "NotificationsSettings", &p.NotificationsSettings)
			delete(rawMsg, key)
		case "privateStoreId":
			err = unpopulate(val, "PrivateStoreID", &p.PrivateStoreID)
			delete(rawMsg, key)
		case "privateStoreName":
			err = unpopulate(val, "PrivateStoreName", &p.PrivateStoreName)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &p.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryApprovedPlans.
func (q QueryApprovedPlans) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "offerId", q.OfferID)
	populate(objectMap, "planIds", q.PlanIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryApprovedPlans.
func (q *QueryApprovedPlans) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "offerId":
			err = unpopulate(val, "OfferID", &q.OfferID)
			delete(rawMsg, key)
		case "planIds":
			err = unpopulate(val, "PlanIDs", &q.PlanIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryApprovedPlansDetails.
func (q QueryApprovedPlansDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allSubscriptions", q.AllSubscriptions)
	populate(objectMap, "planId", q.PlanID)
	populate(objectMap, "subscriptionIds", q.SubscriptionIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryApprovedPlansDetails.
func (q *QueryApprovedPlansDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allSubscriptions":
			err = unpopulate(val, "AllSubscriptions", &q.AllSubscriptions)
			delete(rawMsg, key)
		case "planId":
			err = unpopulate(val, "PlanID", &q.PlanID)
			delete(rawMsg, key)
		case "subscriptionIds":
			err = unpopulate(val, "SubscriptionIDs", &q.SubscriptionIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryApprovedPlansPayload.
func (q QueryApprovedPlansPayload) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", q.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryApprovedPlansPayload.
func (q *QueryApprovedPlansPayload) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryApprovedPlansResponse.
func (q QueryApprovedPlansResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "details", q.Details)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryApprovedPlansResponse.
func (q *QueryApprovedPlansResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "details":
			err = unpopulate(val, "Details", &q.Details)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryOffers.
func (q QueryOffers) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", q.NextLink)
	populate(objectMap, "value", q.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryOffers.
func (q *QueryOffers) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &q.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &q.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryRequestApproval.
func (q QueryRequestApproval) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "etag", q.Etag)
	populate(objectMap, "messageCode", q.MessageCode)
	populate(objectMap, "plansDetails", q.PlansDetails)
	populate(objectMap, "uniqueOfferId", q.UniqueOfferID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryRequestApproval.
func (q *QueryRequestApproval) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "etag":
			err = unpopulate(val, "Etag", &q.Etag)
			delete(rawMsg, key)
		case "messageCode":
			err = unpopulate(val, "MessageCode", &q.MessageCode)
			delete(rawMsg, key)
		case "plansDetails":
			err = unpopulate(val, "PlansDetails", &q.PlansDetails)
			delete(rawMsg, key)
		case "uniqueOfferId":
			err = unpopulate(val, "UniqueOfferID", &q.UniqueOfferID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type QueryRequestApprovalProperties.
func (q QueryRequestApprovalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", q.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type QueryRequestApprovalProperties.
func (q *QueryRequestApprovalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", q, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &q.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", q, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Recipient.
func (r Recipient) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "emailAddress", r.EmailAddress)
	populate(objectMap, "principalId", r.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Recipient.
func (r *Recipient) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "emailAddress":
			err = unpopulate(val, "EmailAddress", &r.EmailAddress)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &r.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestApprovalProperties.
func (r RequestApprovalProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isClosed", r.IsClosed)
	populate(objectMap, "messageCode", r.MessageCode)
	populate(objectMap, "offerDisplayName", r.OfferDisplayName)
	populate(objectMap, "offerId", r.OfferID)
	populate(objectMap, "plansDetails", r.PlansDetails)
	populate(objectMap, "publisherId", r.PublisherID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestApprovalProperties.
func (r *RequestApprovalProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isClosed":
			err = unpopulate(val, "IsClosed", &r.IsClosed)
			delete(rawMsg, key)
		case "messageCode":
			err = unpopulate(val, "MessageCode", &r.MessageCode)
			delete(rawMsg, key)
		case "offerDisplayName":
			err = unpopulate(val, "OfferDisplayName", &r.OfferDisplayName)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &r.OfferID)
			delete(rawMsg, key)
		case "plansDetails":
			err = unpopulate(val, "PlansDetails", &r.PlansDetails)
			delete(rawMsg, key)
		case "publisherId":
			err = unpopulate(val, "PublisherID", &r.PublisherID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestApprovalResource.
func (r RequestApprovalResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestApprovalResource.
func (r *RequestApprovalResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestApprovalsDetails.
func (r RequestApprovalsDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", r.DisplayName)
	populate(objectMap, "icon", r.Icon)
	populate(objectMap, "messageCode", r.MessageCode)
	populate(objectMap, "offerId", r.OfferID)
	populate(objectMap, "plans", r.Plans)
	populate(objectMap, "publisherId", r.PublisherID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestApprovalsDetails.
func (r *RequestApprovalsDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &r.DisplayName)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &r.Icon)
			delete(rawMsg, key)
		case "messageCode":
			err = unpopulate(val, "MessageCode", &r.MessageCode)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &r.OfferID)
			delete(rawMsg, key)
		case "plans":
			err = unpopulate(val, "Plans", &r.Plans)
			delete(rawMsg, key)
		case "publisherId":
			err = unpopulate(val, "PublisherID", &r.PublisherID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestApprovalsList.
func (r RequestApprovalsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestApprovalsList.
func (r *RequestApprovalsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RequestDetails.
func (r RequestDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "planIds", r.PlanIDs)
	populate(objectMap, "publisherId", r.PublisherID)
	populate(objectMap, "subscriptionId", r.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RequestDetails.
func (r *RequestDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "planIds":
			err = unpopulate(val, "PlanIDs", &r.PlanIDs)
			delete(rawMsg, key)
		case "publisherId":
			err = unpopulate(val, "PublisherID", &r.PublisherID)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &r.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SingleOperation.
func (s SingleOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", s.Display)
	populate(objectMap, "isDataAction", s.IsDataAction)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "origin", s.Origin)
	populateAny(objectMap, "properties", s.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SingleOperation.
func (s *SingleOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &s.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &s.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &s.Origin)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SingleOperationDisplay.
func (s SingleOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", s.Description)
	populate(objectMap, "operation", s.Operation)
	populate(objectMap, "provider", s.Provider)
	populate(objectMap, "resource", s.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SingleOperationDisplay.
func (s *SingleOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &s.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &s.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &s.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &s.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StopSellNotifications.
func (s StopSellNotifications) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "icon", s.Icon)
	populate(objectMap, "isEntire", s.IsEntire)
	populate(objectMap, "messageCode", s.MessageCode)
	populate(objectMap, "offerId", s.OfferID)
	populate(objectMap, "plans", s.Plans)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StopSellNotifications.
func (s *StopSellNotifications) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &s.Icon)
			delete(rawMsg, key)
		case "isEntire":
			err = unpopulate(val, "IsEntire", &s.IsEntire)
			delete(rawMsg, key)
		case "messageCode":
			err = unpopulate(val, "MessageCode", &s.MessageCode)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &s.OfferID)
			delete(rawMsg, key)
		case "plans":
			err = unpopulate(val, "Plans", &s.Plans)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StopSellOffersPlansNotificationsList.
func (s StopSellOffersPlansNotificationsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "stopSellNotifications", s.StopSellNotifications)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StopSellOffersPlansNotificationsList.
func (s *StopSellOffersPlansNotificationsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "stopSellNotifications":
			err = unpopulate(val, "StopSellNotifications", &s.StopSellNotifications)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StopSellOffersPlansNotificationsListProperties.
func (s StopSellOffersPlansNotificationsListProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "icon", s.Icon)
	populate(objectMap, "isEntire", s.IsEntire)
	populate(objectMap, "messageCode", s.MessageCode)
	populate(objectMap, "offerId", s.OfferID)
	populate(objectMap, "plans", s.Plans)
	populate(objectMap, "publicContext", s.PublicContext)
	populate(objectMap, "subscriptionsIds", s.SubscriptionsIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StopSellOffersPlansNotificationsListProperties.
func (s *StopSellOffersPlansNotificationsListProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "icon":
			err = unpopulate(val, "Icon", &s.Icon)
			delete(rawMsg, key)
		case "isEntire":
			err = unpopulate(val, "IsEntire", &s.IsEntire)
			delete(rawMsg, key)
		case "messageCode":
			err = unpopulate(val, "MessageCode", &s.MessageCode)
			delete(rawMsg, key)
		case "offerId":
			err = unpopulate(val, "OfferID", &s.OfferID)
			delete(rawMsg, key)
		case "plans":
			err = unpopulate(val, "Plans", &s.Plans)
			delete(rawMsg, key)
		case "publicContext":
			err = unpopulate(val, "PublicContext", &s.PublicContext)
			delete(rawMsg, key)
		case "subscriptionsIds":
			err = unpopulate(val, "SubscriptionsIDs", &s.SubscriptionsIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StopSellSubscriptions.
func (s StopSellSubscriptions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subscriptions", s.Subscriptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StopSellSubscriptions.
func (s *StopSellSubscriptions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subscriptions":
			err = unpopulate(val, "Subscriptions", &s.Subscriptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Subscription.
func (s Subscription) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", s.DisplayName)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "state", s.State)
	populate(objectMap, "subscriptionId", s.SubscriptionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Subscription.
func (s *Subscription) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &s.DisplayName)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &s.State)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &s.SubscriptionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionsContextList.
func (s SubscriptionsContextList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "subscriptionsIds", s.SubscriptionsIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionsContextList.
func (s *SubscriptionsContextList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "subscriptionsIds":
			err = unpopulate(val, "SubscriptionsIDs", &s.SubscriptionsIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubscriptionsResponse.
func (s SubscriptionsResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", s.Count)
	populate(objectMap, "skipToken", s.SkipToken)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubscriptionsResponse.
func (s *SubscriptionsResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &s.Count)
			delete(rawMsg, key)
		case "skipToken":
			err = unpopulate(val, "SkipToken", &s.SkipToken)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferOffersDetails.
func (t TransferOffersDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "offerIdsList", t.OfferIDsList)
	populate(objectMap, "operation", t.Operation)
	populate(objectMap, "targetCollections", t.TargetCollections)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferOffersDetails.
func (t *TransferOffersDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "offerIdsList":
			err = unpopulate(val, "OfferIDsList", &t.OfferIDsList)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &t.Operation)
			delete(rawMsg, key)
		case "targetCollections":
			err = unpopulate(val, "TargetCollections", &t.TargetCollections)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferOffersProperties.
func (t TransferOffersProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", t.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferOffersProperties.
func (t *TransferOffersProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TransferOffersResponse.
func (t TransferOffersResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failed", t.Failed)
	populate(objectMap, "succeeded", t.Succeeded)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TransferOffersResponse.
func (t *TransferOffersResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failed":
			err = unpopulate(val, "Failed", &t.Failed)
			delete(rawMsg, key)
		case "succeeded":
			err = unpopulate(val, "Succeeded", &t.Succeeded)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserRequestDetails.
func (u UserRequestDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "date", u.Date)
	populate(objectMap, "justification", u.Justification)
	populate(objectMap, "subscriptionId", u.SubscriptionID)
	populate(objectMap, "subscriptionName", u.SubscriptionName)
	populate(objectMap, "user", u.User)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserRequestDetails.
func (u *UserRequestDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "date":
			err = unpopulate(val, "Date", &u.Date)
			delete(rawMsg, key)
		case "justification":
			err = unpopulate(val, "Justification", &u.Justification)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &u.SubscriptionID)
			delete(rawMsg, key)
		case "subscriptionName":
			err = unpopulate(val, "SubscriptionName", &u.SubscriptionName)
			delete(rawMsg, key)
		case "user":
			err = unpopulate(val, "User", &u.User)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WithdrawDetails.
func (w WithdrawDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "planId", w.PlanID)
	populate(objectMap, "publisherId", w.PublisherID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WithdrawDetails.
func (w *WithdrawDetails) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "planId":
			err = unpopulate(val, "PlanID", &w.PlanID)
			delete(rawMsg, key)
		case "publisherId":
			err = unpopulate(val, "PublisherID", &w.PublisherID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WithdrawProperties.
func (w WithdrawProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", w.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WithdrawProperties.
func (w *WithdrawProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
