+++
title = "Bar ripple"
weight = 20
+++

## Bar ripple

A ripple with a symmetric rectangular profile that is uniform in $x$-direction.

<img src="/img/draw/ff/3d/Box.png" width="30%" >
<img src="/img/draw/ff/2d/Box_xy.svg" width="30%">
<img src="/img/draw/ff/2d/Box_xz.svg" width="30%">

#### Constructors

```python
Box(L, W, H)
BarGauss(L, W, H)
BarLorentz(L, W, H)
```

Parameters:
- L, length
- W, width
- H, height

Bar with rectangular longitudinal profile is equvalent to [Box](/ref/sample/particle/ff/hard/box) particle.

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "Bar" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormfactor" %}}.


Form factor is computed as

$$  F(\mathbf{q}) = f_\parallel(q_x) f_\bot(q_y,q_z), $$

where
$$  f_\bot(q_y,q_z) = WH \space \exp\Big(iq_{z}\dfrac{H}{2}\Big) \space \text{sinc}\Big(q_{y}\dfrac{W}{2}\Big) \space \text{sinc}\Big(q_{z}\dfrac{H}{2}\Big).$$

Corresponding factor $ f_\parallel(q_x) $ is chosen according to [longitudinal profile](/ref/sample/particle/ff/ripples/).

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormfactorBasicTest.cpp)
against
$$V=LWH.$$

#### Scattering

Scattering by uncorrelated, oriented "BarLorentz" ripples for horizontal incidence. Rotation around $z$ axis:

<img src="/img/auto/ff/BarLorentz.png">

Generated by {{% ref-ex "ff/BarLorentz.py" %}}.
