/** @file include/enum_house.h */

#ifndef ENUM_HOUSE_H
#define ENUM_HOUSE_H

enum HouseType {
	HOUSE_HARKONNEN = 0,
	HOUSE_ATREIDES  = 1,
	HOUSE_ORDOS     = 2,
	HOUSE_FREMEN    = 3,
	HOUSE_SARDAUKAR = 4,
	HOUSE_MERCENARY = 5,

	HOUSE_NEUTRAL   = 6,
	HOUSE_MAX       = 7,
	HOUSE_INVALID   = 0xFF
};

enum HouseFlag {
	FLAG_HOUSE_HARKONNEN    = 1 << HOUSE_HARKONNEN, /* 0x01 */
	FLAG_HOUSE_ATREIDES     = 1 << HOUSE_ATREIDES,  /* 0x02 */
	FLAG_HOUSE_ORDOS        = 1 << HOUSE_ORDOS,     /* 0x04 */
	FLAG_HOUSE_FREMEN       = 1 << HOUSE_FREMEN,    /* 0x08 */
	FLAG_HOUSE_SARDAUKAR    = 1 << HOUSE_SARDAUKAR, /* 0x10 */
	FLAG_HOUSE_MERCENARY    = 1 << HOUSE_MERCENARY, /* 0x20 */

	FLAG_HOUSE_ALL
		= FLAG_HOUSE_HARKONNEN
		| FLAG_HOUSE_ATREIDES
		| FLAG_HOUSE_ORDOS
		| FLAG_HOUSE_FREMEN
		| FLAG_HOUSE_SARDAUKAR
		| FLAG_HOUSE_MERCENARY
};

#endif
