#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Dungeons & Lesbians
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250408.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='dungeons-and-lesbians'
GAME_NAME='Dungeons & Lesbians'

ARCHIVE_BASE_0_NAME='DungeonsAndLesbians-1.2-linux.tar.bz2'
ARCHIVE_BASE_0_MD5='31015bbbc250043dca3e77c96941655b'
ARCHIVE_BASE_0_SIZE='200000'
ARCHIVE_BASE_0_VERSION='1.2-itch1'
ARCHIVE_BASE_0_URL='https://noeybodys.itch.io/dungeonsandlesbians'

CONTENT_PATH_DEFAULT='DungeonsAndLesbians-1.2-linux/game'
CONTENT_FONTS_MAIN_FILES='
Hannotate.ttc
Neucha-Regular.ttf
ReenieBeanie-Regular.ttf'
CONTENT_GAME_MAIN_FILES='
cache
gui
tli
script_version.txt
*.jpg
*.mp3
*.ogg
*.png
*.rpy
*.rpyc
*.wav'

APP_MAIN_TYPE='renpy'
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_ICO APP_MAIN_ICON_PNG'
APP_MAIN_ICON_PNG='icon.png'
APP_MAIN_ICON_ICO='icon.ico'

## Ensure easy upgrades from packages generated with pre-20250408.1 game scripts
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:-}
dungeons-and-lesbians-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
