#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Near-Mage expansions:
# - Clothes & Hair Pack
# send your bug reports to vv221@dotslashplay.it
###

script_version=20250623.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='near-mage'
GAME_NAME='Near-Mage'

EXPANSION_ID_CLOTHESANDHAIR='clothes-and-hair'
EXPANSION_NAME_CLOTHESANDHAIR='Clothes & Hair Pack'

ARCHIVE_BASE_CLOTHESANDHAIR_3_NAME='near_mage_clothes_hair_pack_1_1_4_83077.sh'
ARCHIVE_BASE_CLOTHESANDHAIR_3_MD5='500cf750790e1e9d176fd1910d92f335'
ARCHIVE_BASE_CLOTHESANDHAIR_3_SIZE='45829'
ARCHIVE_BASE_CLOTHESANDHAIR_3_VERSION='1.1.4-gog83077'
ARCHIVE_BASE_CLOTHESANDHAIR_3_URL='https://www.gog.com/game/nearmage_clothes_hair_pack'

ARCHIVE_BASE_CLOTHESANDHAIR_1_NAME='near_mage_clothes_hair_pack_1_1_0c_82721.sh'
ARCHIVE_BASE_CLOTHESANDHAIR_1_MD5='8bf42f8553c5715fbc88a64a37d539e0'
ARCHIVE_BASE_CLOTHESANDHAIR_1_SIZE='45829'
ARCHIVE_BASE_CLOTHESANDHAIR_1_VERSION='1.1.0c-gog82721'

ARCHIVE_BASE_CLOTHESANDHAIR_0_NAME='near_mage_clothes_hair_pack_1_0_1_82443.sh'
ARCHIVE_BASE_CLOTHESANDHAIR_0_MD5='d0cebff002280f7292af44d5be4b72cb'
ARCHIVE_BASE_CLOTHESANDHAIR_0_SIZE='45829'
ARCHIVE_BASE_CLOTHESANDHAIR_0_VERSION='1.0.1-gog82443'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
Near-Mage_Data'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
