import { PathMapAllocator, PathMap, PathMapLens } from "./interface";
declare class PathMapNode<Step, Value> {
    value: Value | undefined;
    further: Map<Step, PathMapNode<Step, Value>>;
    entries(existing: Step[]): IterableIterator<[Step[], Value]>;
    postRootEntries(existing: Step[]): IterableIterator<[Step[], Value]>;
    values(): IterableIterator<Value>;
}
export declare class IndexAllocator implements PathMapAllocator<number> {
    private index;
    next(): number;
    get count(): number;
}
declare class PathMapLensImpl<Step, Value> implements PathMapLens<Step, Value> {
    private current;
    constructor(node: PathMapNode<Step, Value>);
    get(): Value | undefined;
    set(value: Value): void;
    getOrPut(value: Value): Value;
    getOrAlloc<R extends unknown[] = []>(alloc: PathMapAllocator<Value, R>, ...r: R): Value;
    advance(step: Step): boolean;
    focusGet(steps: Iterable<Step>): boolean;
    advanceCreate(step: Step): void;
    focus(steps: Iterable<Step>): void;
}
export declare class PathMapImpl<Step, Value> implements PathMap<Step, Value> {
    private root;
    createLens(): PathMapLensImpl<Step, Value>;
    get(steps: Iterable<Step>): Value | undefined;
    set(steps: Iterable<Step>, value: Value): void;
    entries(): IterableIterator<[Step[], Value]>;
    postRootEntries(): IterableIterator<[Step[], Value]>;
    values(): IterableIterator<Value>;
    static create<Step, Value>(iter?: Iterable<[ReadonlyArray<Step>, Value]>): PathMapImpl<Step, Value>;
}
export {};
//# sourceMappingURL=index.d.ts.map