import { Derivable } from "../derivable";
import { IVec2 } from "../point/interface";
export interface VectorSpace<T, X> {
    readonly neutral: T;
    addScale(x: T, s: X, y: T): T;
}
export interface InnerProductSpace<T, X> extends VectorSpace<T, X> {
    innerProduct(a: T, b: T): X;
}
export declare function vsQuadifyCurve<V>(vs: VectorSpace<V, number>, arc: Derivable<V>, n: number): V[];
export declare const vsNumber: VectorSpace<number, number>;
export declare const vsNumberVec2: InnerProductSpace<IVec2, number>;
export declare function ipsErrorFitsIn<T>(ips: InnerProductSpace<T, number>, c: Derivable<T>, offPoints: T[], squareError: number): boolean;
export declare function ipsAutoQuadify<T>(ips: InnerProductSpace<T, number>, c: Derivable<T>, allowError?: number, maxSegments?: number): T[] | null;
