//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmediaservices

import "time"

// AacAudio - Describes Advanced Audio Codec (AAC) audio encoding settings.
type AacAudio struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The bitrate, in bits per second, of the output encoded audio.
	Bitrate *int32

	// The number of channels in the audio.
	Channels *int32

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string

	// The encoding profile to be used when encoding audio with AAC.
	Profile *AacAudioProfile

	// The sampling rate to use for encoding in hertz.
	SamplingRate *int32
}

// GetAudio implements the AudioClassification interface for type AacAudio.
func (a *AacAudio) GetAudio() *Audio {
	return &Audio{
		Bitrate:      a.Bitrate,
		Channels:     a.Channels,
		Label:        a.Label,
		ODataType:    a.ODataType,
		SamplingRate: a.SamplingRate,
	}
}

// GetCodec implements the CodecClassification interface for type AacAudio.
func (a *AacAudio) GetCodec() *Codec {
	return &Codec{
		Label:     a.Label,
		ODataType: a.ODataType,
	}
}

// AbsoluteClipTime - Specifies the clip time as an absolute time position in the media file. The absolute time can point
// to a different position depending on whether the media file starts from a timestamp of zero or not.
type AbsoluteClipTime struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The time position on the timeline of the input media. It is usually specified as an ISO8601 period. e.g PT30S
	// for 30 seconds.
	Time *string
}

// GetClipTime implements the ClipTimeClassification interface for type AbsoluteClipTime.
func (a *AbsoluteClipTime) GetClipTime() *ClipTime {
	return &ClipTime{
		ODataType: a.ODataType,
	}
}

type AccessControl struct {
	// The behavior for IP access control in Key Delivery.
	DefaultAction *DefaultAction

	// The IP allow list for access control in Key Delivery. If the default action is set to 'Allow', the IP allow list must be
	// empty.
	IPAllowList []*string
}

type AccountEncryption struct {
	// REQUIRED; The type of key used to encrypt the Account Key.
	Type *AccountEncryptionKeyType

	// The Key Vault identity.
	Identity *ResourceIdentity

	// The properties of the key used to encrypt the account.
	KeyVaultProperties *KeyVaultProperties

	// READ-ONLY; The current status of the Key Vault mapping.
	Status *string
}

// AccountFilter - An Account Filter.
type AccountFilter struct {
	// The Media Filter properties.
	Properties *MediaFilterProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AccountFilterCollection - A collection of AccountFilter items.
type AccountFilterCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string

	// A collection of AccountFilter items.
	Value []*AccountFilter
}

// AkamaiAccessControl - Akamai access control
type AkamaiAccessControl struct {
	// authentication key list
	AkamaiSignatureHeaderAuthenticationKeyList []*AkamaiSignatureHeaderAuthenticationKey
}

// AkamaiSignatureHeaderAuthenticationKey - Akamai Signature Header authentication key.
type AkamaiSignatureHeaderAuthenticationKey struct {
	// authentication key
	Base64Key *string

	// The expiration time of the authentication key.
	Expiration *time.Time

	// identifier of the key
	Identifier *string
}

// ArmStreamingEndpointCapacity - The streaming endpoint sku capacity.
type ArmStreamingEndpointCapacity struct {
	// The streaming endpoint default capacity.
	Default *int32

	// The streaming endpoint maximum capacity.
	Maximum *int32

	// The streaming endpoint minimum capacity.
	Minimum *int32

	// READ-ONLY
	ScaleType *string
}

// ArmStreamingEndpointCurrentSKU - The streaming endpoint current sku.
type ArmStreamingEndpointCurrentSKU struct {
	// The streaming endpoint sku capacity.
	Capacity *int32

	// READ-ONLY; The streaming endpoint sku name.
	Name *string
}

// ArmStreamingEndpointSKU - The streaming endpoint sku.
type ArmStreamingEndpointSKU struct {
	// READ-ONLY; The streaming endpoint sku name.
	Name *string
}

type ArmStreamingEndpointSKUInfo struct {
	// The streaming endpoint sku capacity.
	Capacity     *ArmStreamingEndpointCapacity
	ResourceType *string

	// The streaming endpoint sku.
	SKU *ArmStreamingEndpointSKU
}

// Asset - An Asset.
type Asset struct {
	// The resource properties.
	Properties *AssetProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AssetCollection - A collection of Asset items.
type AssetCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string

	// A collection of Asset items.
	Value []*Asset
}

// AssetContainerSas - The Asset Storage container SAS URLs.
type AssetContainerSas struct {
	// The list of Asset container SAS URLs.
	AssetContainerSasUrls []*string
}

// AssetFileEncryptionMetadata - The Asset File Storage encryption metadata.
type AssetFileEncryptionMetadata struct {
	// REQUIRED; The Asset File Id.
	AssetFileID *string

	// The Asset File name.
	AssetFileName *string

	// The Asset File initialization vector.
	InitializationVector *string
}

// AssetFilter - An Asset Filter.
type AssetFilter struct {
	// The Media Filter properties.
	Properties *MediaFilterProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AssetFilterCollection - A collection of AssetFilter items.
type AssetFilterCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string

	// A collection of AssetFilter items.
	Value []*AssetFilter
}

// AssetProperties - The Asset properties.
type AssetProperties struct {
	// The alternate ID of the Asset.
	AlternateID *string

	// The name of the asset blob container.
	Container *string

	// The Asset description.
	Description *string

	// The name of the storage account.
	StorageAccountName *string

	// READ-ONLY; The Asset ID.
	AssetID *string

	// READ-ONLY; The creation date of the Asset.
	Created *time.Time

	// READ-ONLY; The last modified date of the Asset.
	LastModified *time.Time

	// READ-ONLY; The Asset encryption format. One of None or MediaStorageEncryption.
	StorageEncryptionFormat *AssetStorageEncryptionFormat
}

// AssetStreamingLocator - Properties of the Streaming Locator.
type AssetStreamingLocator struct {
	// READ-ONLY; Asset Name.
	AssetName *string

	// READ-ONLY; The creation time of the Streaming Locator.
	Created *time.Time

	// READ-ONLY; Name of the default ContentKeyPolicy used by this Streaming Locator.
	DefaultContentKeyPolicyName *string

	// READ-ONLY; The end time of the Streaming Locator.
	EndTime *time.Time

	// READ-ONLY; Streaming Locator name.
	Name *string

	// READ-ONLY; The start time of the Streaming Locator.
	StartTime *time.Time

	// READ-ONLY; StreamingLocatorId of the Streaming Locator.
	StreamingLocatorID *string

	// READ-ONLY; Name of the Streaming Policy used by this Streaming Locator.
	StreamingPolicyName *string
}

// AssetTrack - An Asset Track resource.
type AssetTrack struct {
	// The resource properties.
	Properties *AssetTrackProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AssetTrackCollection - A collection of AssetTrack items.
type AssetTrackCollection struct {
	// A collection of AssetTrack items.
	Value []*AssetTrack
}

// AssetTrackOperationStatus - Status of asset track operation.
type AssetTrackOperationStatus struct {
	// REQUIRED; Operation identifier.
	Name *string

	// REQUIRED; Operation status.
	Status *string

	// Operation end time.
	EndTime *time.Time

	// The error detail.
	Error *ErrorDetail

	// Operation resource ID.
	ID *string

	// Operation start time.
	StartTime *time.Time
}

// AssetTrackProperties - Properties of a video, audio or text track in the asset.
type AssetTrackProperties struct {
	// Detailed information about a track in the asset.
	Track TrackBaseClassification

	// READ-ONLY; Provisioning state of the asset track.
	ProvisioningState *ProvisioningState
}

// AsyncOperationResult - The status of an async operation.
type AsyncOperationResult struct {
	// The error object
	Error *ErrorDetail

	// Operation Id of the async operation.
	Name *string

	// Operation status of the async operation.
	Status *AsyncOperationStatus
}

// Audio - Defines the common properties for all audio codecs.
type Audio struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The bitrate, in bits per second, of the output encoded audio.
	Bitrate *int32

	// The number of channels in the audio.
	Channels *int32

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string

	// The sampling rate to use for encoding in hertz.
	SamplingRate *int32
}

// GetAudio implements the AudioClassification interface for type Audio.
func (a *Audio) GetAudio() *Audio { return a }

// GetCodec implements the CodecClassification interface for type Audio.
func (a *Audio) GetCodec() *Codec {
	return &Codec{
		Label:     a.Label,
		ODataType: a.ODataType,
	}
}

// AudioAnalyzerPreset - The Audio Analyzer preset applies a pre-defined set of AI-based analysis operations, including speech
// transcription. Currently, the preset supports processing of content with a single audio track.
type AudioAnalyzerPreset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US'). If you
	// know the language of your content, it is recommended that you specify it. The
	// language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included
	// in basic mode. If the language isn't specified or set to null, automatic language
	// detection will choose the first language detected and process with the selected language for the duration of the file.
	// It does not currently support dynamically switching between languages after the
	// first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If
	// automatic detection fails to find the language, transcription would fallback to
	// 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
	AudioLanguage *string

	// Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string

	// Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be
	// chosen.
	Mode *AudioAnalysisMode
}

// GetAudioAnalyzerPreset implements the AudioAnalyzerPresetClassification interface for type AudioAnalyzerPreset.
func (a *AudioAnalyzerPreset) GetAudioAnalyzerPreset() *AudioAnalyzerPreset { return a }

// GetPreset implements the PresetClassification interface for type AudioAnalyzerPreset.
func (a *AudioAnalyzerPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: a.ODataType,
	}
}

// AudioOverlay - Describes the properties of an audio overlay.
type AudioOverlay struct {
	// REQUIRED; The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can
	// specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV,
	// MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video
	// file formats.
	InputLabel *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
	AudioGainLevel *float64

	// The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format.
	// For example, PT30S to end the overlay at 30 seconds into the input video. If not
	// specified or the value is greater than the input video duration, the overlay will be applied until the end of the input
	// video if the overlay media duration is greater than the input video duration,
	// else the overlay will last as long as the overlay media duration.
	End *string

	// The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If
	// not specified the default behavior is to have no fade in (same as PT0S).
	FadeInDuration *string

	// The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not
	// specified the default behavior is to have no fade out (same as PT0S).
	FadeOutDuration *string

	// The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format.
	// For example, PT05S to start the overlay at 5 seconds into the input video.
	// If not specified the overlay starts from the beginning of the input video.
	Start *string
}

// GetOverlay implements the OverlayClassification interface for type AudioOverlay.
func (a *AudioOverlay) GetOverlay() *Overlay {
	return &Overlay{
		AudioGainLevel:  a.AudioGainLevel,
		End:             a.End,
		FadeInDuration:  a.FadeInDuration,
		FadeOutDuration: a.FadeOutDuration,
		InputLabel:      a.InputLabel,
		ODataType:       a.ODataType,
		Start:           a.Start,
	}
}

// AudioTrack - Represents an audio track in the asset.
type AudioTrack struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The DASH specific setting for the audio track.
	DashSettings *DashSettings

	// The display name of the audio track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
	DisplayName *string

	// The file name to the source file. This file is located in the storage container of the asset.
	FileName *string

	// The HLS specific setting for the audio track.
	HlsSettings *HlsSettings

	// The RFC5646 language code for the audio track.
	LanguageCode *string

	// The MPEG-4 audio track ID for the audio track.
	Mpeg4TrackID *int32

	// READ-ONLY; The stream bit rate for the audio track.
	BitRate *int32
}

// GetTrackBase implements the TrackBaseClassification interface for type AudioTrack.
func (a *AudioTrack) GetTrackBase() *TrackBase {
	return &TrackBase{
		ODataType: a.ODataType,
	}
}

// AudioTrackDescriptor - A TrackSelection to select audio tracks.
type AudioTrackDescriptor struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Optional designation for single channel audio tracks. Can be used to combine the tracks into stereo or multi-channel audio
	// tracks.
	ChannelMapping *ChannelMapping
}

// GetAudioTrackDescriptor implements the AudioTrackDescriptorClassification interface for type AudioTrackDescriptor.
func (a *AudioTrackDescriptor) GetAudioTrackDescriptor() *AudioTrackDescriptor { return a }

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type AudioTrackDescriptor.
func (a *AudioTrackDescriptor) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: a.ODataType,
	}
}

// BuiltInStandardEncoderPreset - Describes a built-in preset for encoding the input video with the Standard Encoder.
type BuiltInStandardEncoderPreset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The built-in preset to be used for encoding videos.
	PresetName *EncoderNamedPreset

	// Optional configuration settings for encoder. Configurations is only supported for ContentAwareEncoding and H265ContentAwareEncoding
	// BuiltInStandardEncoderPreset.
	Configurations *PresetConfigurations
}

// GetPreset implements the PresetClassification interface for type BuiltInStandardEncoderPreset.
func (b *BuiltInStandardEncoderPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: b.ODataType,
	}
}

// CbcsDrmConfiguration - Class to specify DRM configurations of CommonEncryptionCbcs scheme in Streaming Policy
type CbcsDrmConfiguration struct {
	// FairPlay configurations
	FairPlay *StreamingPolicyFairPlayConfiguration

	// PlayReady configurations
	PlayReady *StreamingPolicyPlayReadyConfiguration

	// Widevine configurations
	Widevine *StreamingPolicyWidevineConfiguration
}

// CencDrmConfiguration - Class to specify DRM configurations of CommonEncryptionCenc scheme in Streaming Policy
type CencDrmConfiguration struct {
	// PlayReady configurations
	PlayReady *StreamingPolicyPlayReadyConfiguration

	// Widevine configurations
	Widevine *StreamingPolicyWidevineConfiguration
}

// CheckNameAvailabilityInput - The input to the check name availability request.
type CheckNameAvailabilityInput struct {
	// The account name.
	Name *string

	// The account type. For a Media Services account, this should be 'MediaServices'.
	Type *string
}

// ClearKeyEncryptionConfiguration - Class to specify ClearKey configuration of common encryption schemes in Streaming Policy
type ClearKeyEncryptionConfiguration struct {
	// Template for the URL of the custom service delivering content keys to end user players. Not required when using Azure Media
	// Services for issuing licenses. The template supports replaceable tokens that
	// the service will update at runtime with the value specific to the request. The currently supported token value is {AlternativeMediaId},
	// which is replaced with the value of
	// StreamingLocatorId.AlternativeMediaId.
	CustomKeysAcquisitionURLTemplate *string
}

// ClipTime - Base class for specifying a clip time. Use sub classes of this class to specify the time position in the media.
type ClipTime struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetClipTime implements the ClipTimeClassification interface for type ClipTime.
func (c *ClipTime) GetClipTime() *ClipTime { return c }

// Codec - Describes the basic properties of all codecs.
type Codec struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string
}

// GetCodec implements the CodecClassification interface for type Codec.
func (c *Codec) GetCodec() *Codec { return c }

// CommonEncryptionCbcs - Class for CommonEncryptionCbcs encryption scheme
type CommonEncryptionCbcs struct {
	// Optional configuration supporting ClearKey in CommonEncryptionCbcs encryption scheme.
	ClearKeyEncryptionConfiguration *ClearKeyEncryptionConfiguration

	// Representing which tracks should not be encrypted
	ClearTracks []*TrackSelection

	// Representing default content key for each encryption scheme and separate content keys for specific tracks
	ContentKeys *StreamingPolicyContentKeys

	// Configuration of DRMs for current encryption scheme
	Drm *CbcsDrmConfiguration

	// Representing supported protocols
	EnabledProtocols *EnabledProtocols
}

// CommonEncryptionCenc - Class for envelope encryption scheme
type CommonEncryptionCenc struct {
	// Optional configuration supporting ClearKey in CommonEncryptionCenc encryption scheme.
	ClearKeyEncryptionConfiguration *ClearKeyEncryptionConfiguration

	// Representing which tracks should not be encrypted
	ClearTracks []*TrackSelection

	// Representing default content key for each encryption scheme and separate content keys for specific tracks
	ContentKeys *StreamingPolicyContentKeys

	// Configuration of DRMs for CommonEncryptionCenc encryption scheme
	Drm *CencDrmConfiguration

	// Representing supported protocols
	EnabledProtocols *EnabledProtocols
}

// ContentKeyPolicy - A Content Key Policy resource.
type ContentKeyPolicy struct {
	// The properties of the Content Key Policy.
	Properties *ContentKeyPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// ContentKeyPolicyClearKeyConfiguration - Represents a configuration for non-DRM keys.
type ContentKeyPolicyClearKeyConfiguration struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyClearKeyConfiguration.
func (c *ContentKeyPolicyClearKeyConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyCollection - A collection of ContentKeyPolicy items.
type ContentKeyPolicyCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string

	// A collection of ContentKeyPolicy items.
	Value []*ContentKeyPolicy
}

// ContentKeyPolicyConfiguration - Base class for Content Key Policy configuration. A derived class must be used to create
// a configuration.
type ContentKeyPolicyConfiguration struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyConfiguration.
func (c *ContentKeyPolicyConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return c
}

// ContentKeyPolicyFairPlayConfiguration - Specifies a configuration for FairPlay licenses.
type ContentKeyPolicyFairPlayConfiguration struct {
	// REQUIRED; The key that must be used as FairPlay Application Secret key. This needs to be base64 encoded.
	Ask []byte

	// REQUIRED; The Base64 representation of FairPlay certificate in PKCS 12 (pfx) format (including private key).
	FairPlayPfx *string

	// REQUIRED; The password encrypting FairPlay certificate in PKCS 12 (pfx) format.
	FairPlayPfxPassword *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The rental and lease key type.
	RentalAndLeaseKeyType *ContentKeyPolicyFairPlayRentalAndLeaseKeyType

	// REQUIRED; The rental duration. Must be greater than or equal to 0.
	RentalDuration *int64

	// Offline rental policy
	OfflineRentalConfiguration *ContentKeyPolicyFairPlayOfflineRentalConfiguration
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyFairPlayConfiguration.
func (c *ContentKeyPolicyFairPlayConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

type ContentKeyPolicyFairPlayOfflineRentalConfiguration struct {
	// REQUIRED; Playback duration
	PlaybackDurationSeconds *int64

	// REQUIRED; Storage duration
	StorageDurationSeconds *int64
}

// ContentKeyPolicyOpenRestriction - Represents an open restriction. License or key will be delivered on every request.
type ContentKeyPolicyOpenRestriction struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyRestriction implements the ContentKeyPolicyRestrictionClassification interface for type ContentKeyPolicyOpenRestriction.
func (c *ContentKeyPolicyOpenRestriction) GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction {
	return &ContentKeyPolicyRestriction{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyOption - Represents a policy option.
type ContentKeyPolicyOption struct {
	// REQUIRED; The key delivery configuration.
	Configuration ContentKeyPolicyConfigurationClassification

	// REQUIRED; The requirements that must be met to deliver keys with this configuration
	Restriction ContentKeyPolicyRestrictionClassification

	// The Policy Option description.
	Name *string

	// READ-ONLY; The legacy Policy Option ID.
	PolicyOptionID *string
}

// ContentKeyPolicyPlayReadyConfiguration - Specifies a configuration for PlayReady licenses.
type ContentKeyPolicyPlayReadyConfiguration struct {
	// REQUIRED; The PlayReady licenses.
	Licenses []*ContentKeyPolicyPlayReadyLicense

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The custom response data.
	ResponseCustomData *string
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyPlayReadyConfiguration.
func (c *ContentKeyPolicyPlayReadyConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader - Specifies that the content key ID is in the PlayReady header.
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyPlayReadyContentKeyLocation implements the ContentKeyPolicyPlayReadyContentKeyLocationClassification
// interface for type ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader.
func (c *ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader) GetContentKeyPolicyPlayReadyContentKeyLocation() *ContentKeyPolicyPlayReadyContentKeyLocation {
	return &ContentKeyPolicyPlayReadyContentKeyLocation{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier - Specifies that the content key ID is specified in the
// PlayReady configuration.
type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier struct {
	// REQUIRED; The content key ID.
	KeyID *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyPlayReadyContentKeyLocation implements the ContentKeyPolicyPlayReadyContentKeyLocationClassification
// interface for type ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier.
func (c *ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier) GetContentKeyPolicyPlayReadyContentKeyLocation() *ContentKeyPolicyPlayReadyContentKeyLocation {
	return &ContentKeyPolicyPlayReadyContentKeyLocation{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyPlayReadyContentKeyLocation - Base class for content key ID location. A derived class must be used to represent
// the location.
type ContentKeyPolicyPlayReadyContentKeyLocation struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyPlayReadyContentKeyLocation implements the ContentKeyPolicyPlayReadyContentKeyLocationClassification
// interface for type ContentKeyPolicyPlayReadyContentKeyLocation.
func (c *ContentKeyPolicyPlayReadyContentKeyLocation) GetContentKeyPolicyPlayReadyContentKeyLocation() *ContentKeyPolicyPlayReadyContentKeyLocation {
	return c
}

// ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction - Configures the Explicit Analog Television Output Restriction
// control bits. For further details see the PlayReady Compliance Rules.
type ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction struct {
	// REQUIRED; Indicates whether this restriction is enforced on a Best Effort basis.
	BestEffort *bool

	// REQUIRED; Configures the restriction control bits. Must be between 0 and 3 inclusive.
	ConfigurationData *int32
}

// ContentKeyPolicyPlayReadyLicense - The PlayReady license
type ContentKeyPolicyPlayReadyLicense struct {
	// REQUIRED; A flag indicating whether test devices can use the license.
	AllowTestDevices *bool

	// REQUIRED; The content key location.
	ContentKeyLocation ContentKeyPolicyPlayReadyContentKeyLocationClassification

	// REQUIRED; The PlayReady content type.
	ContentType *ContentKeyPolicyPlayReadyContentType

	// REQUIRED; The license type.
	LicenseType *ContentKeyPolicyPlayReadyLicenseType

	// The begin date of license
	BeginDate *time.Time

	// The expiration date of license.
	ExpirationDate *time.Time

	// The grace period of license.
	GracePeriod *string

	// The license PlayRight
	PlayRight *ContentKeyPolicyPlayReadyPlayRight

	// The relative begin date of license.
	RelativeBeginDate *string

	// The relative expiration date of license.
	RelativeExpirationDate *string

	// The security level.
	SecurityLevel *SecurityLevel
}

// ContentKeyPolicyPlayReadyPlayRight - Configures the Play Right in the PlayReady license.
type ContentKeyPolicyPlayReadyPlayRight struct {
	// REQUIRED; Configures Unknown output handling settings of the license.
	AllowPassingVideoContentToUnknownOutput *ContentKeyPolicyPlayReadyUnknownOutputPassingOption

	// REQUIRED; Enables the Image Constraint For Analog Component Video Restriction in the license.
	DigitalVideoOnlyContentRestriction *bool

	// REQUIRED; Enables the Image Constraint For Analog Component Video Restriction in the license.
	ImageConstraintForAnalogComponentVideoRestriction *bool

	// REQUIRED; Enables the Image Constraint For Analog Component Video Restriction in the license.
	ImageConstraintForAnalogComputerMonitorRestriction *bool

	// Configures Automatic Gain Control (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
	AgcAndColorStripeRestriction *int32

	// Specifies the output protection level for compressed digital audio.
	AnalogVideoOpl *int32

	// Specifies the output protection level for compressed digital audio.
	CompressedDigitalAudioOpl *int32

	// Specifies the output protection level for compressed digital video.
	CompressedDigitalVideoOpl *int32

	// Configures the Explicit Analog Television Output Restriction in the license. Configuration data must be between 0 and 3
	// inclusive.
	ExplicitAnalogTelevisionOutputRestriction *ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction

	// The amount of time that the license is valid after the license is first used to play content.
	FirstPlayExpiration *string

	// Configures the Serial Copy Management System (SCMS) in the license. Must be between 0 and 3 inclusive.
	ScmsRestriction *int32

	// Specifies the output protection level for uncompressed digital audio.
	UncompressedDigitalAudioOpl *int32

	// Specifies the output protection level for uncompressed digital video.
	UncompressedDigitalVideoOpl *int32
}

// ContentKeyPolicyProperties - The properties of the Content Key Policy.
type ContentKeyPolicyProperties struct {
	// REQUIRED; The Key Policy options.
	Options []*ContentKeyPolicyOption

	// A description for the Policy.
	Description *string

	// READ-ONLY; The creation date of the Policy
	Created *time.Time

	// READ-ONLY; The last modified date of the Policy
	LastModified *time.Time

	// READ-ONLY; The legacy Policy ID.
	PolicyID *string
}

// ContentKeyPolicyRestriction - Base class for Content Key Policy restrictions. A derived class must be used to create a
// restriction.
type ContentKeyPolicyRestriction struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyRestriction implements the ContentKeyPolicyRestrictionClassification interface for type ContentKeyPolicyRestriction.
func (c *ContentKeyPolicyRestriction) GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction {
	return c
}

// ContentKeyPolicyRestrictionTokenKey - Base class for Content Key Policy key for token validation. A derived class must
// be used to create a token key.
type ContentKeyPolicyRestrictionTokenKey struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyRestrictionTokenKey implements the ContentKeyPolicyRestrictionTokenKeyClassification interface for type
// ContentKeyPolicyRestrictionTokenKey.
func (c *ContentKeyPolicyRestrictionTokenKey) GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey {
	return c
}

// ContentKeyPolicyRsaTokenKey - Specifies a RSA key for token validation
type ContentKeyPolicyRsaTokenKey struct {
	// REQUIRED; The RSA Parameter exponent
	Exponent []byte

	// REQUIRED; The RSA Parameter modulus
	Modulus []byte

	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyRestrictionTokenKey implements the ContentKeyPolicyRestrictionTokenKeyClassification interface for type
// ContentKeyPolicyRsaTokenKey.
func (c *ContentKeyPolicyRsaTokenKey) GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey {
	return &ContentKeyPolicyRestrictionTokenKey{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicySymmetricTokenKey - Specifies a symmetric key for token validation.
type ContentKeyPolicySymmetricTokenKey struct {
	// REQUIRED; The key value of the key
	KeyValue []byte

	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyRestrictionTokenKey implements the ContentKeyPolicyRestrictionTokenKeyClassification interface for type
// ContentKeyPolicySymmetricTokenKey.
func (c *ContentKeyPolicySymmetricTokenKey) GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey {
	return &ContentKeyPolicyRestrictionTokenKey{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyTokenClaim - Represents a token claim.
type ContentKeyPolicyTokenClaim struct {
	// Token claim type.
	ClaimType *string

	// Token claim value.
	ClaimValue *string
}

// ContentKeyPolicyTokenRestriction - Represents a token restriction. Provided token must match these requirements for successful
// license or key delivery.
type ContentKeyPolicyTokenRestriction struct {
	// REQUIRED; The audience for the token.
	Audience *string

	// REQUIRED; The token issuer.
	Issuer *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The primary verification key.
	PrimaryVerificationKey ContentKeyPolicyRestrictionTokenKeyClassification

	// REQUIRED; The type of token.
	RestrictionTokenType *ContentKeyPolicyRestrictionTokenType

	// A list of alternative verification keys.
	AlternateVerificationKeys []ContentKeyPolicyRestrictionTokenKeyClassification

	// The OpenID connect discovery document.
	OpenIDConnectDiscoveryDocument *string

	// A list of required token claims.
	RequiredClaims []*ContentKeyPolicyTokenClaim
}

// GetContentKeyPolicyRestriction implements the ContentKeyPolicyRestrictionClassification interface for type ContentKeyPolicyTokenRestriction.
func (c *ContentKeyPolicyTokenRestriction) GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction {
	return &ContentKeyPolicyRestriction{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyUnknownConfiguration - Represents a ContentKeyPolicyConfiguration that is unavailable in the current API
// version.
type ContentKeyPolicyUnknownConfiguration struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyUnknownConfiguration.
func (c *ContentKeyPolicyUnknownConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyUnknownRestriction - Represents a ContentKeyPolicyRestriction that is unavailable in the current API version.
type ContentKeyPolicyUnknownRestriction struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetContentKeyPolicyRestriction implements the ContentKeyPolicyRestrictionClassification interface for type ContentKeyPolicyUnknownRestriction.
func (c *ContentKeyPolicyUnknownRestriction) GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction {
	return &ContentKeyPolicyRestriction{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyWidevineConfiguration - Specifies a configuration for Widevine licenses.
type ContentKeyPolicyWidevineConfiguration struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The Widevine template.
	WidevineTemplate *string
}

// GetContentKeyPolicyConfiguration implements the ContentKeyPolicyConfigurationClassification interface for type ContentKeyPolicyWidevineConfiguration.
func (c *ContentKeyPolicyWidevineConfiguration) GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration {
	return &ContentKeyPolicyConfiguration{
		ODataType: c.ODataType,
	}
}

// ContentKeyPolicyX509CertificateTokenKey - Specifies a certificate for token validation.
type ContentKeyPolicyX509CertificateTokenKey struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The raw data field of a certificate in PKCS 12 format (X509Certificate2 in .NET)
	RawBody []byte
}

// GetContentKeyPolicyRestrictionTokenKey implements the ContentKeyPolicyRestrictionTokenKeyClassification interface for type
// ContentKeyPolicyX509CertificateTokenKey.
func (c *ContentKeyPolicyX509CertificateTokenKey) GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey {
	return &ContentKeyPolicyRestrictionTokenKey{
		ODataType: c.ODataType,
	}
}

// CopyAudio - A codec flag, which tells the encoder to copy the input audio bitstream.
type CopyAudio struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string
}

// GetCodec implements the CodecClassification interface for type CopyAudio.
func (c *CopyAudio) GetCodec() *Codec {
	return &Codec{
		Label:     c.Label,
		ODataType: c.ODataType,
	}
}

// CopyVideo - A codec flag, which tells the encoder to copy the input video bitstream without re-encoding.
type CopyVideo struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string
}

// GetCodec implements the CodecClassification interface for type CopyVideo.
func (c *CopyVideo) GetCodec() *Codec {
	return &Codec{
		Label:     c.Label,
		ODataType: c.ODataType,
	}
}

// CrossSiteAccessPolicies - The client access policy.
type CrossSiteAccessPolicies struct {
	// The content of clientaccesspolicy.xml used by Silverlight.
	ClientAccessPolicy *string

	// The content of crossdomain.xml used by Silverlight.
	CrossDomainPolicy *string
}

// DDAudio - Describes Dolby Digital Audio Codec (AC3) audio encoding settings. The current implementation for Dolby Digital
// Audio support are: Audio channel numbers at 1((mono), 2(stereo), 6(5.1side); Audio
// sampling frequency rates at: 32K/44.1K/48K Hz; Audio bitrate values as AC3 specification supports: 32000, 40000, 48000,
// 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000,
// 320000, 384000, 448000, 512000, 576000, 640000 bps.
type DDAudio struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The bitrate, in bits per second, of the output encoded audio.
	Bitrate *int32

	// The number of channels in the audio.
	Channels *int32

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string

	// The sampling rate to use for encoding in hertz.
	SamplingRate *int32
}

// GetAudio implements the AudioClassification interface for type DDAudio.
func (d *DDAudio) GetAudio() *Audio {
	return &Audio{
		Bitrate:      d.Bitrate,
		Channels:     d.Channels,
		Label:        d.Label,
		ODataType:    d.ODataType,
		SamplingRate: d.SamplingRate,
	}
}

// GetCodec implements the CodecClassification interface for type DDAudio.
func (d *DDAudio) GetCodec() *Codec {
	return &Codec{
		Label:     d.Label,
		ODataType: d.ODataType,
	}
}

// DashSettings - The DASH setting for a track.
type DashSettings struct {
	// The role for the DASH setting.
	Role *string
}

// DefaultKey - Class to specify properties of default content key for each encryption scheme
type DefaultKey struct {
	// Label can be used to specify Content Key when creating a Streaming Locator
	Label *string

	// Policy used by Default Key
	PolicyName *string
}

// Deinterlace - Describes the de-interlacing settings.
type Deinterlace struct {
	// The deinterlacing mode. Defaults to AutoPixelAdaptive.
	Mode *DeinterlaceMode

	// The field parity for de-interlacing, defaults to Auto.
	Parity *DeinterlaceParity
}

type EdgePolicies struct {
	UsageDataCollectionPolicy *EdgeUsageDataCollectionPolicy
}

type EdgeUsageDataCollectionPolicy struct {
	// Usage data collection frequency in ISO 8601 duration format e.g. PT10M , PT5H.
	DataCollectionFrequency *string

	// Usage data reporting frequency in ISO 8601 duration format e.g. PT10M , PT5H.
	DataReportingFrequency *string

	// Details of Event Hub where the usage will be reported.
	EventHubDetails *EdgeUsageDataEventHub

	// Maximum time for which the functionality of the device will not be hampered for not reporting the usage data.
	MaxAllowedUnreportedUsageDuration *string
}

type EdgeUsageDataEventHub struct {
	// Name of the Event Hub where usage will be reported.
	Name *string

	// Namespace of the Event Hub where usage will be reported.
	Namespace *string

	// SAS token needed to interact with Event Hub.
	Token *string
}

// EnabledProtocols - Class to specify which protocols are enabled
type EnabledProtocols struct {
	// REQUIRED; Enable DASH protocol or not
	Dash *bool

	// REQUIRED; Enable Download protocol or not
	Download *bool

	// REQUIRED; Enable HLS protocol or not
	Hls *bool

	// REQUIRED; Enable SmoothStreaming protocol or not
	SmoothStreaming *bool
}

// EntityNameAvailabilityCheckOutput - The response from the check name availability request.
type EntityNameAvailabilityCheckOutput struct {
	// REQUIRED; Specifies if the name is available.
	NameAvailable *bool

	// Specifies the detailed reason if the name is not available.
	Message *string

	// Specifies the reason if the name is not available.
	Reason *string
}

// EnvelopeEncryption - Class for EnvelopeEncryption encryption scheme
type EnvelopeEncryption struct {
	// Representing which tracks should not be encrypted
	ClearTracks []*TrackSelection

	// Representing default content key for each encryption scheme and separate content keys for specific tracks
	ContentKeys *StreamingPolicyContentKeys

	// Template for the URL of the custom service delivering keys to end user players. Not required when using Azure Media Services
	// for issuing keys. The template supports replaceable tokens that the service
	// will update at runtime with the value specific to the request. The currently supported token values are {AlternativeMediaId},
	// which is replaced with the value of StreamingLocatorId.AlternativeMediaId,
	// and {ContentKeyId}, which is replaced with the value of identifier of the key being requested.
	CustomKeyAcquisitionURLTemplate *string

	// Representing supported protocols
	EnabledProtocols *EnabledProtocols
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail
}

// FaceDetectorPreset - Describes all the settings to be used when analyzing a video in order to detect (and optionally redact)
// all the faces present.
type FaceDetectorPreset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Blur type
	BlurType *BlurType

	// Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string

	// This mode provides the ability to choose between the following settings: 1) Analyze - For detection only.This mode generates
	// a metadata JSON file marking appearances of faces throughout the
	// video.Where possible, appearances of the same person are assigned the same ID. 2) Combined - Additionally redacts(blurs)
	// detected faces. 3) Redact - This enables a 2-pass process, allowing for
	// selective redaction of a subset of detected faces.It takes in the metadata file from a prior analyze pass, along with the
	// source video, and a user-selected subset of IDs that require redaction.
	Mode *FaceRedactorMode

	// Specifies the maximum resolution at which your video is analyzed. The default behavior is "SourceResolution," which will
	// keep the input video at its original resolution when analyzed. Using
	// "StandardDefinition" will resize input videos to standard definition while preserving the appropriate aspect ratio. It
	// will only resize if the video is of higher resolution. For example, a 1920x1080
	// input would be scaled to 640x360 before processing. Switching to "StandardDefinition" will reduce the time it takes to
	// process high resolution video. It may also reduce the cost of using this
	// component (see https://azure.microsoft.com/en-us/pricing/details/media-services/#analytics for details). However, faces
	// that end up being too small in the resized video may not be detected.
	Resolution *AnalysisResolution
}

// GetPreset implements the PresetClassification interface for type FaceDetectorPreset.
func (f *FaceDetectorPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: f.ODataType,
	}
}

// Fade - Describes the properties of a Fade effect applied to the input media.
type Fade struct {
	// REQUIRED; The Duration of the fade effect in the video. The value can be in ISO 8601 format (For example, PT05S to fade
	// In/Out a color during 5 seconds), or a frame count (For example, 10 to fade 10 frames from
	// the start time), or a relative value to stream duration (For example, 10% to fade 10% of stream duration)
	Duration *string

	// REQUIRED; The Color for the fade In/Out. it can be on the CSS Level1 colors https://developer.mozilla.org/en-US/docs/Web/CSS/colorvalue/colorkeywords
	// or an RGB/hex value: e.g: rgb(255,0,0), 0xFF0000 or #FF0000
	FadeColor *string

	// The position in the input video from where to start fade. The value can be in ISO 8601 format (For example, PT05S to start
	// at 5 seconds), or a frame count (For example, 10 to start at the 10th frame),
	// or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Default is 0
	Start *string
}

// FilterTrackPropertyCondition - The class to specify one track property condition.
type FilterTrackPropertyCondition struct {
	// REQUIRED; The track property condition operation.
	Operation *FilterTrackPropertyCompareOperation

	// REQUIRED; The track property type.
	Property *FilterTrackPropertyType

	// REQUIRED; The track property value.
	Value *string
}

// FilterTrackSelection - Representing a list of FilterTrackPropertyConditions to select a track. The filters are combined
// using a logical AND operation.
type FilterTrackSelection struct {
	// REQUIRED; The track selections.
	TrackSelections []*FilterTrackPropertyCondition
}

// Filters - Describes all the filtering operations, such as de-interlacing, rotation etc. that are to be applied to the input
// media before encoding.
type Filters struct {
	// The parameters for the rectangular window with which to crop the input video.
	Crop *Rectangle

	// The de-interlacing settings.
	Deinterlace *Deinterlace

	// Describes the properties of a Fade effect applied to the input media.
	FadeIn *Fade

	// Describes the properties of a Fade effect applied to the input media.
	FadeOut *Fade

	// The properties of overlays to be applied to the input video. These could be audio, image or video overlays.
	Overlays []OverlayClassification

	// The rotation, if any, to be applied to the input video, before it is encoded. Default is Auto
	Rotation *Rotation
}

// FirstQuality - Filter First Quality
type FirstQuality struct {
	// REQUIRED; The first quality bitrate.
	Bitrate *int32
}

// Format - Base class for output.
type Format struct {
	// REQUIRED; The file naming pattern used for the creation of output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus
	// audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted
	// macros will be collapsed and removed from the filename.
	FilenamePattern *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetFormat implements the FormatClassification interface for type Format.
func (f *Format) GetFormat() *Format { return f }

// FromAllInputFile - An InputDefinition that looks across all of the files provided to select tracks specified by the IncludedTracks
// property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to
// allow selection of a single track across a set of input files.
type FromAllInputFile struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks []TrackDescriptorClassification
}

// GetInputDefinition implements the InputDefinitionClassification interface for type FromAllInputFile.
func (f *FromAllInputFile) GetInputDefinition() *InputDefinition {
	return &InputDefinition{
		IncludedTracks: f.IncludedTracks,
		ODataType:      f.ODataType,
	}
}

// FromEachInputFile - An InputDefinition that looks at each input file provided to select tracks specified by the IncludedTracks
// property. Generally used with the AudioTrackByAttribute and VideoTrackByAttribute to select
// tracks from each file given.
type FromEachInputFile struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks []TrackDescriptorClassification
}

// GetInputDefinition implements the InputDefinitionClassification interface for type FromEachInputFile.
func (f *FromEachInputFile) GetInputDefinition() *InputDefinition {
	return &InputDefinition{
		IncludedTracks: f.IncludedTracks,
		ODataType:      f.ODataType,
	}
}

// H264Layer - Describes the settings to be used when encoding the input video into a desired output bitrate layer with the
// H.264 video codec.
type H264Layer struct {
	// REQUIRED; The average bitrate in bits per second at which to encode the input video when generating this layer. This is
	// a required field.
	Bitrate *int32

	// Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on
	// whenever the video profile permits its use.
	AdaptiveBFrame *bool

	// The number of B-frames to be used when encoding this layer. If not specified, the encoder chooses an appropriate number
	// based on the video profile and level.
	BFrames *int32

	// The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds.
	// The default is 5 seconds (for example, PT5S).
	BufferWindow *string

	// The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is
	// set at CRF mode. The range of CRF value is between 0 and 51, where lower values
	// would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point
	// quality degradation will be noticed. Default value is 23.
	Crf *float32

	// The entropy mode to be used for this layer. If not specified, the encoder chooses the mode that is appropriate for the
	// profile and level.
	EntropyMode *EntropyMode

	// The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N
	// are integers (For example, 30000/1001), or in the form of a number (For example,
	// 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified,
	// the encoder will use the same frame rate as the input video.
	FrameRate *string

	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string

	// We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.264 profile. If not specified,
	// the default is Auto, which lets the encoder choose the Level that is
	// appropriate for this layer.
	Level *string

	// The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults
	// to the same value as bitrate.
	MaxBitrate *int32

	// We currently support Baseline, Main, High, High422, High444. Default is Auto.
	Profile *H264VideoProfile

	// The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate
	// number based on the encoder complexity setting.
	ReferenceFrames *int32

	// The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will
	// use a single slice for each frame.
	Slices *int32

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string
}

// H264Video - Describes all the properties for encoding a video with the H.264 codec.
type H264Video struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Tells the encoder how to choose its encoding settings. The default value is Balanced.
	Complexity *H264Complexity

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string

	// The collection of output H.264 layers to be produced by the encoder.
	Layers []*H264Layer

	// The video rate control mode
	RateControlMode *H264RateControlMode

	// Whether or not the encoder should insert key frames at scene changes. If not specified, the default is false. This flag
	// should be set to true only when the encoder is being configured to produce a
	// single output video.
	SceneChangeDetection *bool

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode

	// The Video Sync Mode
	SyncMode *VideoSyncMode
}

// GetCodec implements the CodecClassification interface for type H264Video.
func (h *H264Video) GetCodec() *Codec {
	return &Codec{
		Label:     h.Label,
		ODataType: h.ODataType,
	}
}

// GetVideo implements the VideoClassification interface for type H264Video.
func (h *H264Video) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: h.KeyFrameInterval,
		Label:            h.Label,
		ODataType:        h.ODataType,
		StretchMode:      h.StretchMode,
		SyncMode:         h.SyncMode,
	}
}

// H265Layer - Describes the settings to be used when encoding the input video into a desired output bitrate layer with the
// H.265 video codec.
type H265Layer struct {
	// REQUIRED; The average bitrate in bits per second at which to encode the input video when generating this layer. For example:
	// a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a
	// required field.
	Bitrate *int32

	// Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will
	// turn it on whenever the video profile permits its use.
	AdaptiveBFrame *bool

	// The number of B-frames to be used when encoding this layer. If not specified, the encoder chooses an appropriate number
	// based on the video profile and level.
	BFrames *int32

	// The VBV buffer window length. The value should be in ISO 8601 format. The value should be in the range [0.1-100] seconds.
	// The default is 5 seconds (for example, PT5S).
	BufferWindow *string

	// The value of CRF to be used when encoding this layer. This setting takes effect when RateControlMode of video codec is
	// set at CRF mode. The range of CRF value is between 0 and 51, where lower values
	// would result in better quality, at the expense of higher file sizes. Higher values mean more compression, but at some point
	// quality degradation will be noticed. Default value is 28.
	Crf *float32

	// The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N
	// are integers (For example, 30000/1001), or in the form of a number (For example,
	// 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified,
	// the encoder will use the same frame rate as the input video.
	FrameRate *string

	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string

	// We currently support Level up to 6.2. The value can be Auto, or a number that matches the H.265 profile. If not specified,
	// the default is Auto, which lets the encoder choose the Level that is
	// appropriate for this layer.
	Level *string

	// The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults
	// to the same value as bitrate.
	MaxBitrate *int32

	// We currently support Main. Default is Auto.
	Profile *H265VideoProfile

	// The number of reference frames to be used when encoding this layer. If not specified, the encoder determines an appropriate
	// number based on the encoder complexity setting.
	ReferenceFrames *int32

	// The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will
	// use a single slice for each frame.
	Slices *int32

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string
}

// H265Video - Describes all the properties for encoding a video with the H.265 codec.
type H265Video struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Tells the encoder how to choose its encoding settings. Quality will provide for a higher compression ratio but at a higher
	// cost and longer compute time. Speed will produce a relatively larger file but
	// is faster and more economical. The default value is Balanced.
	Complexity *H265Complexity

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string

	// The collection of output H.265 layers to be produced by the encoder.
	Layers []*H265Layer

	// Specifies whether or not the encoder should insert key frames at scene changes. If not specified, the default is false.
	// This flag should be set to true only when the encoder is being configured to
	// produce a single output video.
	SceneChangeDetection *bool

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode

	// The Video Sync Mode
	SyncMode *VideoSyncMode
}

// GetCodec implements the CodecClassification interface for type H265Video.
func (h *H265Video) GetCodec() *Codec {
	return &Codec{
		Label:     h.Label,
		ODataType: h.ODataType,
	}
}

// GetVideo implements the VideoClassification interface for type H265Video.
func (h *H265Video) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: h.KeyFrameInterval,
		Label:            h.Label,
		ODataType:        h.ODataType,
		StretchMode:      h.StretchMode,
		SyncMode:         h.SyncMode,
	}
}

// H265VideoLayer - Describes the settings to be used when encoding the input video into a desired output bitrate layer.
type H265VideoLayer struct {
	// REQUIRED; The average bitrate in bits per second at which to encode the input video when generating this layer. For example:
	// a target bitrate of 3000Kbps or 3Mbps means this value should be 3000000 This is a
	// required field.
	Bitrate *int32

	// Specifies whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will
	// turn it on whenever the video profile permits its use.
	AdaptiveBFrame *bool

	// The number of B-frames to be used when encoding this layer. If not specified, the encoder chooses an appropriate number
	// based on the video profile and level.
	BFrames *int32

	// The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N
	// are integers (For example, 30000/1001), or in the form of a number (For example,
	// 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified,
	// the encoder will use the same frame rate as the input video.
	FrameRate *string

	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string

	// The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults
	// to the same value as bitrate.
	MaxBitrate *int32

	// The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will
	// use a single slice for each frame.
	Slices *int32

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string
}

// Hls - HTTP Live Streaming (HLS) packing setting for the live output.
type Hls struct {
	// The number of fragments in an HTTP Live Streaming (HLS) TS segment in the output of the live event. This value does not
	// affect the packing ratio for HLS CMAF output.
	FragmentsPerTsSegment *int32
}

// HlsSettings - The HLS setting for a track.
type HlsSettings struct {
	// The characteristics for the HLS setting.
	Characteristics *string

	// The default for the HLS setting.
	Default *bool

	// The forced for the HLS setting.
	Forced *bool
}

// IPAccessControl - The IP access control.
type IPAccessControl struct {
	// The IP allow list.
	Allow []*IPRange
}

// IPRange - The IP address range in the CIDR scheme.
type IPRange struct {
	// The IP address.
	Address *string

	// The friendly name for the IP address range.
	Name *string

	// The subnet mask prefix length (see CIDR notation).
	SubnetPrefixLength *int32
}

// Image - Describes the basic properties for generating thumbnails from the input video
type Image struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format
	// (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at
	// the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports
	// a macro {Best}, which tells the encoder to select the best thumbnail from
	// the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and
	// Range. The default value is macro {Best}.
	Start *string

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string

	// The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value
	// can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30
	// seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If
	// this value is 1, it means only producing one thumbnail at start time), or a
	// relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default
	// value is 100%, which means to stop at the end of the stream.
	Range *string

	// The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image
	// every 5 seconds), or a frame count (For example, 30 for one image every 30
	// frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step
	// value will affect the first generated thumbnail, which may not be exactly the
	// one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between
	// start time and Step position from start time as the first output. As the
	// default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one
	// specified at start time. Try to select reasonable value for Step if the first
	// thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
	Step *string

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode

	// The Video Sync Mode
	SyncMode *VideoSyncMode
}

// GetCodec implements the CodecClassification interface for type Image.
func (i *Image) GetCodec() *Codec {
	return &Codec{
		Label:     i.Label,
		ODataType: i.ODataType,
	}
}

// GetImage implements the ImageClassification interface for type Image.
func (i *Image) GetImage() *Image { return i }

// GetVideo implements the VideoClassification interface for type Image.
func (i *Image) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: i.KeyFrameInterval,
		Label:            i.Label,
		ODataType:        i.ODataType,
		StretchMode:      i.StretchMode,
		SyncMode:         i.SyncMode,
	}
}

// ImageFormat - Describes the properties for an output image file.
type ImageFormat struct {
	// REQUIRED; The file naming pattern used for the creation of output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus
	// audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted
	// macros will be collapsed and removed from the filename.
	FilenamePattern *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetFormat implements the FormatClassification interface for type ImageFormat.
func (i *ImageFormat) GetFormat() *Format {
	return &Format{
		FilenamePattern: i.FilenamePattern,
		ODataType:       i.ODataType,
	}
}

// GetImageFormat implements the ImageFormatClassification interface for type ImageFormat.
func (i *ImageFormat) GetImageFormat() *ImageFormat { return i }

// InputDefinition - Base class for defining an input. Use sub classes of this class to specify tracks selections and related
// metadata.
type InputDefinition struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks []TrackDescriptorClassification
}

// GetInputDefinition implements the InputDefinitionClassification interface for type InputDefinition.
func (i *InputDefinition) GetInputDefinition() *InputDefinition { return i }

// InputFile - An InputDefinition for a single file. TrackSelections are scoped to the file specified.
type InputFile struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Name of the file that this input definition applies to.
	Filename *string

	// The list of TrackDescriptors which define the metadata and selection of tracks in the input.
	IncludedTracks []TrackDescriptorClassification
}

// GetInputDefinition implements the InputDefinitionClassification interface for type InputFile.
func (i *InputFile) GetInputDefinition() *InputDefinition {
	return &InputDefinition{
		IncludedTracks: i.IncludedTracks,
		ODataType:      i.ODataType,
	}
}

// Job - A Job resource type. The progress and state can be obtained by polling a Job or subscribing to events using EventGrid.
type Job struct {
	// The resource properties.
	Properties *JobProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// JobCollection - A collection of Job items.
type JobCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string

	// A collection of Job items.
	Value []*Job
}

// JobError - Details of JobOutput errors.
type JobError struct {
	// READ-ONLY; Helps with categorization of errors.
	Category *JobErrorCategory

	// READ-ONLY; Error code describing the error.
	Code *JobErrorCode

	// READ-ONLY; An array of details about specific errors that led to this reported error.
	Details []*JobErrorDetail

	// READ-ONLY; A human-readable language-dependent representation of the error.
	Message *string

	// READ-ONLY; Indicates that it may be possible to retry the Job. If retry is unsuccessful, please contact Azure support via
	// Azure Portal.
	Retry *JobRetry
}

// JobErrorDetail - Details of JobOutput errors.
type JobErrorDetail struct {
	// READ-ONLY; Code describing the error detail.
	Code *string

	// READ-ONLY; A human-readable representation of the error.
	Message *string
}

// JobInput - Base class for inputs to a Job.
type JobInput struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetJobInput implements the JobInputClassification interface for type JobInput.
func (j *JobInput) GetJobInput() *JobInput { return j }

// JobInputAsset - Represents an Asset for input into a Job.
type JobInputAsset struct {
	// REQUIRED; The name of the input Asset.
	AssetName *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
	End ClipTimeClassification

	// List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service
	// responses to prevent sensitive data exposure.
	Files []*string

	// Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
	InputDefinitions []InputDefinitionClassification

	// A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform
	// can be authored so as to take an image file with the label 'xyz' and
	// apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should
	// be the image file, and it should have the label 'xyz'.
	Label *string

	// Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input
	// media.
	Start ClipTimeClassification
}

// GetJobInput implements the JobInputClassification interface for type JobInputAsset.
func (j *JobInputAsset) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// GetJobInputClip implements the JobInputClipClassification interface for type JobInputAsset.
func (j *JobInputAsset) GetJobInputClip() *JobInputClip {
	return &JobInputClip{
		End:              j.End,
		Files:            j.Files,
		InputDefinitions: j.InputDefinitions,
		Label:            j.Label,
		ODataType:        j.ODataType,
		Start:            j.Start,
	}
}

// JobInputClip - Represents input files for a Job.
type JobInputClip struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
	End ClipTimeClassification

	// List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service
	// responses to prevent sensitive data exposure.
	Files []*string

	// Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
	InputDefinitions []InputDefinitionClassification

	// A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform
	// can be authored so as to take an image file with the label 'xyz' and
	// apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should
	// be the image file, and it should have the label 'xyz'.
	Label *string

	// Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input
	// media.
	Start ClipTimeClassification
}

// GetJobInput implements the JobInputClassification interface for type JobInputClip.
func (j *JobInputClip) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// GetJobInputClip implements the JobInputClipClassification interface for type JobInputClip.
func (j *JobInputClip) GetJobInputClip() *JobInputClip { return j }

// JobInputHTTP - Represents HTTPS job input.
type JobInputHTTP struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Base URI for HTTPS job input. It will be concatenated with provided file names. If no base uri is given, then the provided
	// file list is assumed to be fully qualified uris. Maximum length of 4000
	// characters. The query strings will not be returned in service responses to prevent sensitive data exposure.
	BaseURI *string

	// Defines a point on the timeline of the input media at which processing will end. Defaults to the end of the input media.
	End ClipTimeClassification

	// List of files. Required for JobInputHttp. Maximum of 4000 characters each. Query strings will not be returned in service
	// responses to prevent sensitive data exposure.
	Files []*string

	// Defines a list of InputDefinitions. For each InputDefinition, it defines a list of track selections and related metadata.
	InputDefinitions []InputDefinitionClassification

	// A label that is assigned to a JobInputClip, that is used to satisfy a reference used in the Transform. For example, a Transform
	// can be authored so as to take an image file with the label 'xyz' and
	// apply it as an overlay onto the input video before it is encoded. When submitting a Job, exactly one of the JobInputs should
	// be the image file, and it should have the label 'xyz'.
	Label *string

	// Defines a point on the timeline of the input media at which processing will start. Defaults to the beginning of the input
	// media.
	Start ClipTimeClassification
}

// GetJobInput implements the JobInputClassification interface for type JobInputHTTP.
func (j *JobInputHTTP) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// GetJobInputClip implements the JobInputClipClassification interface for type JobInputHTTP.
func (j *JobInputHTTP) GetJobInputClip() *JobInputClip {
	return &JobInputClip{
		End:              j.End,
		Files:            j.Files,
		InputDefinitions: j.InputDefinitions,
		Label:            j.Label,
		ODataType:        j.ODataType,
		Start:            j.Start,
	}
}

// JobInputSequence - A Sequence contains an ordered list of Clips where each clip is a JobInput. The Sequence will be treated
// as a single input.
type JobInputSequence struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// JobInputs that make up the timeline.
	Inputs []JobInputClipClassification
}

// GetJobInput implements the JobInputClassification interface for type JobInputSequence.
func (j *JobInputSequence) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// JobInputs - Describes a list of inputs to a Job.
type JobInputs struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// List of inputs to a Job.
	Inputs []JobInputClassification
}

// GetJobInput implements the JobInputClassification interface for type JobInputs.
func (j *JobInputs) GetJobInput() *JobInput {
	return &JobInput{
		ODataType: j.ODataType,
	}
}

// JobOutput - Describes all the properties of a JobOutput.
type JobOutput struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more
	// than one TransformOutput, whereby your Job has more than one JobOutput. In
	// such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the
	// Transform. Subsequently, when you retrieve the Job, either through events or on a
	// GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}'
	// will be used, where the preset name is the name of the
	// preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the
	// Job. Note that this index is the same as the relative index of the corresponding
	// TransformOutput within its Transform.
	Label *string

	// A preset used to override the preset in the corresponding transform output.
	PresetOverride PresetClassification

	// READ-ONLY; The UTC date and time at which this Job Output finished processing.
	EndTime *time.Time

	// READ-ONLY; If the JobOutput is in the Error state, it contains the details of the error.
	Error *JobError

	// READ-ONLY; If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate
	// and not intended to be used to predict Job completion times. To determine if the
	// JobOutput is complete, use the State property.
	Progress *int32

	// READ-ONLY; The UTC date and time at which this Job Output began processing.
	StartTime *time.Time

	// READ-ONLY; Describes the state of the JobOutput.
	State *JobState
}

// GetJobOutput implements the JobOutputClassification interface for type JobOutput.
func (j *JobOutput) GetJobOutput() *JobOutput { return j }

// JobOutputAsset - Represents an Asset used as a JobOutput.
type JobOutputAsset struct {
	// REQUIRED; The name of the output Asset.
	AssetName *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// A label that is assigned to a JobOutput in order to help uniquely identify it. This is useful when your Transform has more
	// than one TransformOutput, whereby your Job has more than one JobOutput. In
	// such cases, when you submit the Job, you will add two or more JobOutputs, in the same order as TransformOutputs in the
	// Transform. Subsequently, when you retrieve the Job, either through events or on a
	// GET request, you can use the label to easily identify the JobOutput. If a label is not provided, a default value of '{presetName}_{outputIndex}'
	// will be used, where the preset name is the name of the
	// preset in the corresponding TransformOutput and the output index is the relative index of the this JobOutput within the
	// Job. Note that this index is the same as the relative index of the corresponding
	// TransformOutput within its Transform.
	Label *string

	// A preset used to override the preset in the corresponding transform output.
	PresetOverride PresetClassification

	// READ-ONLY; The UTC date and time at which this Job Output finished processing.
	EndTime *time.Time

	// READ-ONLY; If the JobOutput is in the Error state, it contains the details of the error.
	Error *JobError

	// READ-ONLY; If the JobOutput is in a Processing state, this contains the Job completion percentage. The value is an estimate
	// and not intended to be used to predict Job completion times. To determine if the
	// JobOutput is complete, use the State property.
	Progress *int32

	// READ-ONLY; The UTC date and time at which this Job Output began processing.
	StartTime *time.Time

	// READ-ONLY; Describes the state of the JobOutput.
	State *JobState
}

// GetJobOutput implements the JobOutputClassification interface for type JobOutputAsset.
func (j *JobOutputAsset) GetJobOutput() *JobOutput {
	return &JobOutput{
		EndTime:        j.EndTime,
		Error:          j.Error,
		Label:          j.Label,
		ODataType:      j.ODataType,
		PresetOverride: j.PresetOverride,
		Progress:       j.Progress,
		StartTime:      j.StartTime,
		State:          j.State,
	}
}

// JobProperties - Properties of the Job.
type JobProperties struct {
	// REQUIRED; The inputs for the Job.
	Input JobInputClassification

	// REQUIRED; The outputs for the Job.
	Outputs []JobOutputClassification

	// Customer provided key, value pairs that will be returned in Job and JobOutput state events.
	CorrelationData map[string]*string

	// Optional customer supplied description of the Job.
	Description *string

	// Priority with which the job should be processed. Higher priority jobs are processed before lower priority jobs. If not
	// set, the default is normal.
	Priority *Priority

	// READ-ONLY; The UTC date and time when the customer has created the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
	Created *time.Time

	// READ-ONLY; The UTC date and time at which this Job finished processing.
	EndTime *time.Time

	// READ-ONLY; The UTC date and time when the customer has last updated the Job, in 'YYYY-MM-DDThh:mm:ssZ' format.
	LastModified *time.Time

	// READ-ONLY; The UTC date and time at which this Job began processing.
	StartTime *time.Time

	// READ-ONLY; The current state of the job.
	State *JobState
}

// JpgFormat - Describes the settings for producing JPEG thumbnails.
type JpgFormat struct {
	// REQUIRED; The file naming pattern used for the creation of output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus
	// audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted
	// macros will be collapsed and removed from the filename.
	FilenamePattern *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetFormat implements the FormatClassification interface for type JpgFormat.
func (j *JpgFormat) GetFormat() *Format {
	return &Format{
		FilenamePattern: j.FilenamePattern,
		ODataType:       j.ODataType,
	}
}

// GetImageFormat implements the ImageFormatClassification interface for type JpgFormat.
func (j *JpgFormat) GetImageFormat() *ImageFormat {
	return &ImageFormat{
		FilenamePattern: j.FilenamePattern,
		ODataType:       j.ODataType,
	}
}

// JpgImage - Describes the properties for producing a series of JPEG images from the input video.
type JpgImage struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format
	// (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at
	// the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports
	// a macro {Best}, which tells the encoder to select the best thumbnail from
	// the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and
	// Range. The default value is macro {Best}.
	Start *string

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string

	// A collection of output JPEG image layers to be produced by the encoder.
	Layers []*JpgLayer

	// The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value
	// can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30
	// seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If
	// this value is 1, it means only producing one thumbnail at start time), or a
	// relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default
	// value is 100%, which means to stop at the end of the stream.
	Range *string

	// Sets the number of columns used in thumbnail sprite image. The number of rows are automatically calculated and a VTT file
	// is generated with the coordinate mappings for each thumbnail in the sprite.
	// Note: this value should be a positive integer and a proper value is recommended so that the output image resolution will
	// not go beyond JPEG maximum pixel resolution limit 65535x65535.
	SpriteColumn *int32

	// The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image
	// every 5 seconds), or a frame count (For example, 30 for one image every 30
	// frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step
	// value will affect the first generated thumbnail, which may not be exactly the
	// one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between
	// start time and Step position from start time as the first output. As the
	// default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one
	// specified at start time. Try to select reasonable value for Step if the first
	// thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
	Step *string

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode

	// The Video Sync Mode
	SyncMode *VideoSyncMode
}

// GetCodec implements the CodecClassification interface for type JpgImage.
func (j *JpgImage) GetCodec() *Codec {
	return &Codec{
		Label:     j.Label,
		ODataType: j.ODataType,
	}
}

// GetImage implements the ImageClassification interface for type JpgImage.
func (j *JpgImage) GetImage() *Image {
	return &Image{
		KeyFrameInterval: j.KeyFrameInterval,
		Label:            j.Label,
		ODataType:        j.ODataType,
		Range:            j.Range,
		Start:            j.Start,
		Step:             j.Step,
		StretchMode:      j.StretchMode,
		SyncMode:         j.SyncMode,
	}
}

// GetVideo implements the VideoClassification interface for type JpgImage.
func (j *JpgImage) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: j.KeyFrameInterval,
		Label:            j.Label,
		ODataType:        j.ODataType,
		StretchMode:      j.StretchMode,
		SyncMode:         j.SyncMode,
	}
}

// JpgLayer - Describes the settings to produce a JPEG image from the input video.
type JpgLayer struct {
	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string

	// The compression quality of the JPEG output. Range is from 0-100 and the default is 70.
	Quality *int32

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string
}

type KeyDelivery struct {
	// The access control properties for Key Delivery.
	AccessControl *AccessControl
}

type KeyVaultProperties struct {
	// The URL of the Key Vault key used to encrypt the account. The key may either be versioned (for example https://vault/keys/mykey/version1)
	// or reference a key without a version (for example
	// https://vault/keys/mykey).
	KeyIdentifier *string

	// READ-ONLY; The current key used to encrypt the Media Services account, including the key version.
	CurrentKeyIdentifier *string
}

// Layer - The encoder can be configured to produce video and/or images (thumbnails) at different resolutions, by specifying
// a layer for each desired resolution. A layer represents the properties for the video
// or image at a resolution.
type Layer struct {
	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string
}

// ListContainerSasInput - The parameters to the list SAS request.
type ListContainerSasInput struct {
	// The SAS URL expiration time. This must be less than 24 hours from the current time.
	ExpiryTime *time.Time

	// The permissions to set on the SAS URL.
	Permissions *AssetContainerPermission
}

// ListContentKeysResponse - Class of response for listContentKeys action
type ListContentKeysResponse struct {
	// ContentKeys used by current Streaming Locator
	ContentKeys []*StreamingLocatorContentKey
}

type ListEdgePoliciesInput struct {
	// Unique identifier of the edge device.
	DeviceID *string
}

// ListPathsResponse - Class of response for listPaths action
type ListPathsResponse struct {
	// Download Paths supported by current Streaming Locator
	DownloadPaths []*string

	// Streaming Paths supported by current Streaming Locator
	StreamingPaths []*StreamingPath
}

// ListStreamingLocatorsResponse - The Streaming Locators associated with this Asset.
type ListStreamingLocatorsResponse struct {
	// READ-ONLY; The list of Streaming Locators.
	StreamingLocators []*AssetStreamingLocator
}

// LiveEvent - The live event.
type LiveEvent struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The live event properties.
	Properties *LiveEventProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LiveEventActionInput - The LiveEvent action input parameter definition.
type LiveEventActionInput struct {
	// The flag indicates whether live outputs are automatically deleted when live event is being stopped. Deleting live outputs
	// do not delete the underlying assets.
	RemoveOutputsOnStop *bool
}

// LiveEventEncoding - Specifies the live event type and optional encoding settings for encoding live events.
type LiveEventEncoding struct {
	// Live event type. When encodingType is set to PassthroughBasic or PassthroughStandard, the service simply passes through
	// the incoming video and audio layer(s) to the output. When encodingType is set to
	// Standard or Premium1080p, a live encoder transcodes the incoming stream into multiple bitrates or layers. See https://go.microsoft.com/fwlink/?linkid=2095101
	// for more information. This property cannot
	// be modified after the live event is created.
	EncodingType *LiveEventEncodingType

	// Use an ISO 8601 time value between 0.5 to 20 seconds to specify the output fragment length for the video and audio tracks
	// of an encoding live event. For example, use PT2S to indicate 2 seconds. For
	// the video track it also defines the key frame interval, or the length of a GoP (group of pictures). If this value is not
	// set for an encoding live event, the fragment duration defaults to 2 seconds.
	// The value cannot be set for pass-through live events.
	KeyFrameInterval *string

	// The optional encoding preset name, used when encodingType is not None. This value is specified at creation time and cannot
	// be updated. If the encodingType is set to Standard, then the default preset
	// name is ‘Default720p’. Else if the encodingType is set to Premium1080p, the default preset is ‘Default1080p’.
	PresetName *string

	// Specifies how the input video will be resized to fit the desired output resolution(s). Default is None
	StretchMode *StretchMode
}

// LiveEventEndpoint - The live event endpoint.
type LiveEventEndpoint struct {
	// The endpoint protocol.
	Protocol *string

	// The endpoint URL.
	URL *string
}

// LiveEventInput - The live event input.
type LiveEventInput struct {
	// REQUIRED; The input protocol for the live event. This is specified at creation time and cannot be updated.
	StreamingProtocol *LiveEventInputProtocol

	// Access control for live event input.
	AccessControl *LiveEventInputAccessControl

	// A UUID in string form to uniquely identify the stream. This can be specified at creation time but cannot be updated. If
	// omitted, the service will generate a unique value.
	AccessToken *string

	// The input endpoints for the live event.
	Endpoints []*LiveEventEndpoint

	// ISO 8601 time duration of the key frame interval duration of the input. This value sets the EXT-X-TARGETDURATION property
	// in the HLS output. For example, use PT2S to indicate 2 seconds. Leave the
	// value empty for encoding live events.
	KeyFrameIntervalDuration *string
}

// LiveEventInputAccessControl - The IP access control for live event input.
type LiveEventInputAccessControl struct {
	// The IP access control properties.
	IP *IPAccessControl
}

// LiveEventInputTrackSelection - A track selection condition. This property is reserved for future use, any value set on
// this property will be ignored.
type LiveEventInputTrackSelection struct {
	// Comparing operation. This property is reserved for future use, any value set on this property will be ignored.
	Operation *string

	// Property name to select. This property is reserved for future use, any value set on this property will be ignored.
	Property *string

	// Property value to select. This property is reserved for future use, any value set on this property will be ignored.
	Value *string
}

// LiveEventListResult - The LiveEvent list result.
type LiveEventListResult struct {
	// The number of result.
	ODataCount *int32

	// The link to the next set of results. Not empty if value contains incomplete list of live outputs.
	ODataNextLink *string

	// The result of the List Live Event operation.
	Value []*LiveEvent
}

// LiveEventOutputTranscriptionTrack - Describes a transcription track in the output of a live event, generated using speech-to-text
// transcription. This property is reserved for future use, any value set on this property will be ignored.
type LiveEventOutputTranscriptionTrack struct {
	// REQUIRED; The output track name. This property is reserved for future use, any value set on this property will be ignored.
	TrackName *string
}

// LiveEventPreview - Live event preview settings.
type LiveEventPreview struct {
	// The access control for live event preview.
	AccessControl *LiveEventPreviewAccessControl

	// An alternative media identifier associated with the streaming locator created for the preview. This value is specified
	// at creation time and cannot be updated. The identifier can be used in the
	// CustomLicenseAcquisitionUrlTemplate or the CustomKeyAcquisitionUrlTemplate of the StreamingPolicy specified in the StreamingPolicyName
	// field.
	AlternativeMediaID *string

	// The endpoints for preview. Do not share the preview URL with the live event audience.
	Endpoints []*LiveEventEndpoint

	// The identifier of the preview locator in Guid format. Specifying this at creation time allows the caller to know the preview
	// locator url before the event is created. If omitted, the service will
	// generate a random identifier. This value cannot be updated once the live event is created.
	PreviewLocator *string

	// The name of streaming policy used for the live event preview. This value is specified at creation time and cannot be updated.
	StreamingPolicyName *string
}

// LiveEventPreviewAccessControl - The IP access control for the live event preview endpoint.
type LiveEventPreviewAccessControl struct {
	// The IP access control properties.
	IP *IPAccessControl
}

// LiveEventProperties - The live event properties.
type LiveEventProperties struct {
	// REQUIRED; Live event input settings. It defines how the live event receives input from a contribution encoder.
	Input *LiveEventInput

	// Live event cross site access policies.
	CrossSiteAccessPolicies *CrossSiteAccessPolicies

	// A description for the live event.
	Description *string

	// Encoding settings for the live event. It configures whether a live encoder is used for the live event and settings for
	// the live encoder if it is used.
	Encoding *LiveEventEncoding

	// When useStaticHostname is set to true, the hostnamePrefix specifies the first part of the hostname assigned to the live
	// event preview and ingest endpoints. The final hostname would be a combination of
	// this prefix, the media service account name and a short code for the Azure Media Services data center.
	HostnamePrefix *string

	// Live event preview settings. Preview allows live event producers to preview the live streaming content without creating
	// any live output.
	Preview *LiveEventPreview

	// The options to use for the LiveEvent. This value is specified at creation time and cannot be updated. The valid values
	// for the array entry values are 'Default' and 'LowLatency'.
	StreamOptions []*StreamOptionsFlag

	// Live transcription settings for the live event. See https://go.microsoft.com/fwlink/?linkid=2133742 for more information
	// about the live transcription feature.
	Transcriptions []*LiveEventTranscription

	// Specifies whether a static hostname would be assigned to the live event preview and ingest endpoints. This value can only
	// be updated if the live event is in Standby state
	UseStaticHostname *bool

	// READ-ONLY; The creation time for the live event
	Created *time.Time

	// READ-ONLY; The last modified time of the live event.
	LastModified *time.Time

	// READ-ONLY; The provisioning state of the live event.
	ProvisioningState *string

	// READ-ONLY; The resource state of the live event. See https://go.microsoft.com/fwlink/?linkid=2139012 for more information.
	ResourceState *LiveEventResourceState
}

// LiveEventTranscription - Describes the transcription tracks in the output of a live event, generated using speech-to-text
// transcription. This property is reserved for future use, any value set on this property will be
// ignored.
type LiveEventTranscription struct {
	// Provides a mechanism to select the audio track in the input live feed, to which speech-to-text transcription is applied.
	// This property is reserved for future use, any value set on this property will
	// be ignored.
	InputTrackSelection []*LiveEventInputTrackSelection

	// Specifies the language (locale) to be used for speech-to-text transcription – it should match the spoken language in the
	// audio track. The value should be in BCP-47 format (e.g: 'en-US'). See
	// https://go.microsoft.com/fwlink/?linkid=2133742 for more information about the live transcription feature and the list
	// of supported languages.
	Language *string

	// Describes a transcription track in the output of a live event, generated using speech-to-text transcription. This property
	// is reserved for future use, any value set on this property will be ignored.
	OutputTranscriptionTrack *LiveEventOutputTranscriptionTrack
}

// LiveOutput - The Live Output.
type LiveOutput struct {
	// Live output properties.
	Properties *LiveOutputProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// LiveOutputListResult - The LiveOutput list result.
type LiveOutputListResult struct {
	// The number of result.
	ODataCount *int32

	// The link to the next set of results. Not empty if value contains incomplete list of live outputs.
	ODataNextLink *string

	// The result of the List LiveOutput operation.
	Value []*LiveOutput
}

// LiveOutputProperties - The JSON object that contains the properties required to create a live output.
type LiveOutputProperties struct {
	// REQUIRED; ISO 8601 time between 1 minute to 25 hours to indicate the maximum content length that can be archived in the
	// asset for this live output. This also sets the maximum content length for the rewind
	// window. For example, use PT1H30M to indicate 1 hour and 30 minutes of archive window.
	ArchiveWindowLength *string

	// REQUIRED; The asset that the live output will write to.
	AssetName *string

	// The description of the live output.
	Description *string

	// HTTP Live Streaming (HLS) packing setting for the live output.
	Hls *Hls

	// The manifest file name. If not provided, the service will generate one automatically.
	ManifestName *string

	// The initial timestamp that the live output will start at, any content before this value will not be archived.
	OutputSnapTime *int64

	// ISO 8601 time between 1 minute to the duration of archiveWindowLength to control seek-able window length during Live. The
	// service won't use this property once LiveOutput stops. The archived VOD will
	// have full content with original ArchiveWindowLength. For example, use PT1H30M to indicate 1 hour and 30 minutes of rewind
	// window length. Service will use implicit default value 30m only if Live Event
	// enables LL.
	RewindWindowLength *string

	// READ-ONLY; The creation time the live output.
	Created *time.Time

	// READ-ONLY; The time the live output was last modified.
	LastModified *time.Time

	// READ-ONLY; The provisioning state of the live output.
	ProvisioningState *string

	// READ-ONLY; The resource state of the live output.
	ResourceState *LiveOutputResourceState
}

// LogSpecification - A diagnostic log emitted by service.
type LogSpecification struct {
	// READ-ONLY; The time range for requests in each blob.
	BlobDuration *string

	// READ-ONLY; The diagnostic log category display name.
	DisplayName *string

	// READ-ONLY; The diagnostic log category name.
	Name *string
}

// MediaFilterProperties - The Media Filter properties.
type MediaFilterProperties struct {
	// The first quality.
	FirstQuality *FirstQuality

	// The presentation time range.
	PresentationTimeRange *PresentationTimeRange

	// The tracks selection conditions.
	Tracks []*FilterTrackSelection
}

// MediaService - A Media Services account.
type MediaService struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The Managed Identity for the Media Services account.
	Identity *MediaServiceIdentity

	// The resource properties.
	Properties *MediaServiceProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// MediaServiceCollection - A collection of MediaService items.
type MediaServiceCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string

	// A collection of MediaService items.
	Value []*MediaService
}

type MediaServiceIdentity struct {
	// REQUIRED; The identity type.
	Type *string

	// The user assigned managed identities.
	UserAssignedIdentities map[string]*UserAssignedManagedIdentity

	// READ-ONLY; The Principal ID of the identity.
	PrincipalID *string

	// READ-ONLY; The Tenant ID of the identity.
	TenantID *string
}

// MediaServiceOperationStatus - Status of media service operation.
type MediaServiceOperationStatus struct {
	// REQUIRED; Operation identifier.
	Name *string

	// REQUIRED; Operation status.
	Status *string

	// Operation end time.
	EndTime *time.Time

	// The error detail.
	Error *ErrorDetail

	// Operation resource ID.
	ID *string

	// Operation start time.
	StartTime *time.Time
}

// MediaServiceProperties - Properties of the Media Services account.
type MediaServiceProperties struct {
	// The account encryption properties.
	Encryption *AccountEncryption

	// The Key Delivery properties for Media Services account.
	KeyDelivery *KeyDelivery

	// Whether or not public network access is allowed for resources under the Media Services account.
	PublicNetworkAccess *PublicNetworkAccess

	// The storage accounts for this resource.
	StorageAccounts       []*StorageAccount
	StorageAuthentication *StorageAuthentication

	// READ-ONLY; The Media Services account ID.
	MediaServiceID *string

	// READ-ONLY; The Private Endpoint Connections created for the Media Service account.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Provisioning state of the Media Services account.
	ProvisioningState *ProvisioningState
}

// MediaServiceUpdate - A Media Services account update.
type MediaServiceUpdate struct {
	// The Managed Identity for the Media Services account.
	Identity *MediaServiceIdentity

	// The resource properties.
	Properties *MediaServiceProperties

	// Resource tags.
	Tags map[string]*string
}

// MetricDimension - A metric dimension.
type MetricDimension struct {
	// READ-ONLY; The display name for the dimension.
	DisplayName *string

	// READ-ONLY; The metric dimension name.
	Name *string

	// READ-ONLY; Whether to export metric to shoebox.
	ToBeExportedForShoebox *bool
}

// MetricSpecification - A metric emitted by service.
type MetricSpecification struct {
	// Supported aggregation types.
	SupportedAggregationTypes []*string

	// READ-ONLY; The metric aggregation type
	AggregationType *MetricAggregationType

	// READ-ONLY; The metric dimensions.
	Dimensions []*MetricDimension

	// READ-ONLY; The metric display description.
	DisplayDescription *string

	// READ-ONLY; The metric display name.
	DisplayName *string

	// READ-ONLY; Indicates whether regional MDM account is enabled.
	EnableRegionalMdmAccount *bool

	// READ-ONLY; The metric lock aggregation type
	LockAggregationType *MetricAggregationType

	// READ-ONLY; The metric name.
	Name *string

	// READ-ONLY; The source MDM account.
	SourceMdmAccount *string

	// READ-ONLY; The source MDM namespace.
	SourceMdmNamespace *string

	// READ-ONLY; The supported time grain types.
	SupportedTimeGrainTypes []*string

	// READ-ONLY; The metric unit
	Unit *MetricUnit
}

// Mp4Format - Describes the properties for an output ISO MP4 file.
type Mp4Format struct {
	// REQUIRED; The file naming pattern used for the creation of output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus
	// audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted
	// macros will be collapsed and removed from the filename.
	FilenamePattern *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The list of output files to produce. Each entry in the list is a set of audio and video layer labels to be muxed together
	// .
	OutputFiles []*OutputFile
}

// GetFormat implements the FormatClassification interface for type Mp4Format.
func (m *Mp4Format) GetFormat() *Format {
	return &Format{
		FilenamePattern: m.FilenamePattern,
		ODataType:       m.ODataType,
	}
}

// GetMultiBitrateFormat implements the MultiBitrateFormatClassification interface for type Mp4Format.
func (m *Mp4Format) GetMultiBitrateFormat() *MultiBitrateFormat {
	return &MultiBitrateFormat{
		FilenamePattern: m.FilenamePattern,
		ODataType:       m.ODataType,
		OutputFiles:     m.OutputFiles,
	}
}

// MultiBitrateFormat - Describes the properties for producing a collection of GOP aligned multi-bitrate files. The default
// behavior is to produce one output file for each video layer which is muxed together with all the
// audios. The exact output files produced can be controlled by specifying the outputFiles collection.
type MultiBitrateFormat struct {
	// REQUIRED; The file naming pattern used for the creation of output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus
	// audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted
	// macros will be collapsed and removed from the filename.
	FilenamePattern *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The list of output files to produce. Each entry in the list is a set of audio and video layer labels to be muxed together
	// .
	OutputFiles []*OutputFile
}

// GetFormat implements the FormatClassification interface for type MultiBitrateFormat.
func (m *MultiBitrateFormat) GetFormat() *Format {
	return &Format{
		FilenamePattern: m.FilenamePattern,
		ODataType:       m.ODataType,
	}
}

// GetMultiBitrateFormat implements the MultiBitrateFormatClassification interface for type MultiBitrateFormat.
func (m *MultiBitrateFormat) GetMultiBitrateFormat() *MultiBitrateFormat { return m }

// NoEncryption - Class for NoEncryption scheme
type NoEncryption struct {
	// Representing supported protocols
	EnabledProtocols *EnabledProtocols
}

// Operation - An operation.
type Operation struct {
	// REQUIRED; The operation name.
	Name *string

	// Indicates the action type.
	ActionType *ActionType

	// The operation display name.
	Display *OperationDisplay

	// Whether the operation applies to data-plane.
	IsDataAction *bool

	// Origin of the operation.
	Origin *string

	// Operation properties format.
	Properties *Properties
}

// OperationCollection - A collection of Operation items.
type OperationCollection struct {
	// A collection of Operation items.
	Value []*Operation
}

// OperationDisplay - Operation details.
type OperationDisplay struct {
	// The operation description.
	Description *string

	// The operation type.
	Operation *string

	// The service provider.
	Provider *string

	// Resource on which the operation is performed.
	Resource *string
}

// OutputFile - Represents an output file produced.
type OutputFile struct {
	// REQUIRED; The list of labels that describe how the encoder should multiplex video and audio into an output file. For example,
	// if the encoder is producing two video layers with labels v1 and v2, and one audio
	// layer with label a1, then an array like '[v1, a1]' tells the encoder to produce an output file with the video track represented
	// by v1 and the audio track represented by a1.
	Labels []*string
}

// Overlay - Base type for all overlays - image, audio or video.
type Overlay struct {
	// REQUIRED; The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can
	// specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV,
	// MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video
	// file formats.
	InputLabel *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
	AudioGainLevel *float64

	// The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format.
	// For example, PT30S to end the overlay at 30 seconds into the input video. If not
	// specified or the value is greater than the input video duration, the overlay will be applied until the end of the input
	// video if the overlay media duration is greater than the input video duration,
	// else the overlay will last as long as the overlay media duration.
	End *string

	// The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If
	// not specified the default behavior is to have no fade in (same as PT0S).
	FadeInDuration *string

	// The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not
	// specified the default behavior is to have no fade out (same as PT0S).
	FadeOutDuration *string

	// The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format.
	// For example, PT05S to start the overlay at 5 seconds into the input video.
	// If not specified the overlay starts from the beginning of the input video.
	Start *string
}

// GetOverlay implements the OverlayClassification interface for type Overlay.
func (o *Overlay) GetOverlay() *Overlay { return o }

// PNGFormat - Describes the settings for producing PNG thumbnails.
type PNGFormat struct {
	// REQUIRED; The file naming pattern used for the creation of output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus
	// audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted
	// macros will be collapsed and removed from the filename.
	FilenamePattern *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetFormat implements the FormatClassification interface for type PNGFormat.
func (p *PNGFormat) GetFormat() *Format {
	return &Format{
		FilenamePattern: p.FilenamePattern,
		ODataType:       p.ODataType,
	}
}

// GetImageFormat implements the ImageFormatClassification interface for type PNGFormat.
func (p *PNGFormat) GetImageFormat() *ImageFormat {
	return &ImageFormat{
		FilenamePattern: p.FilenamePattern,
		ODataType:       p.ODataType,
	}
}

// PNGImage - Describes the properties for producing a series of PNG images from the input video.
type PNGImage struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The position in the input video from where to start generating thumbnails. The value can be in ISO 8601 format
	// (For example, PT05S to start at 5 seconds), or a frame count (For example, 10 to start at
	// the 10th frame), or a relative value to stream duration (For example, 10% to start at 10% of stream duration). Also supports
	// a macro {Best}, which tells the encoder to select the best thumbnail from
	// the first few seconds of the video and will only produce one thumbnail, no matter what other settings are for Step and
	// Range. The default value is macro {Best}.
	Start *string

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string

	// A collection of output PNG image layers to be produced by the encoder.
	Layers []*PNGLayer

	// The position relative to transform preset start time in the input video at which to stop generating thumbnails. The value
	// can be in ISO 8601 format (For example, PT5M30S to stop at 5 minutes and 30
	// seconds from start time), or a frame count (For example, 300 to stop at the 300th frame from the frame at start time. If
	// this value is 1, it means only producing one thumbnail at start time), or a
	// relative value to the stream duration (For example, 50% to stop at half of stream duration from start time). The default
	// value is 100%, which means to stop at the end of the stream.
	Range *string

	// The intervals at which thumbnails are generated. The value can be in ISO 8601 format (For example, PT05S for one image
	// every 5 seconds), or a frame count (For example, 30 for one image every 30
	// frames), or a relative value to stream duration (For example, 10% for one image every 10% of stream duration). Note: Step
	// value will affect the first generated thumbnail, which may not be exactly the
	// one specified at transform preset start time. This is due to the encoder, which tries to select the best thumbnail between
	// start time and Step position from start time as the first output. As the
	// default value is 10%, it means if stream has long duration, the first generated thumbnail might be far away from the one
	// specified at start time. Try to select reasonable value for Step if the first
	// thumbnail is expected close to start time, or set Range value at 1 if only one thumbnail is needed at start time.
	Step *string

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode

	// The Video Sync Mode
	SyncMode *VideoSyncMode
}

// GetCodec implements the CodecClassification interface for type PNGImage.
func (p *PNGImage) GetCodec() *Codec {
	return &Codec{
		Label:     p.Label,
		ODataType: p.ODataType,
	}
}

// GetImage implements the ImageClassification interface for type PNGImage.
func (p *PNGImage) GetImage() *Image {
	return &Image{
		KeyFrameInterval: p.KeyFrameInterval,
		Label:            p.Label,
		ODataType:        p.ODataType,
		Range:            p.Range,
		Start:            p.Start,
		Step:             p.Step,
		StretchMode:      p.StretchMode,
		SyncMode:         p.SyncMode,
	}
}

// GetVideo implements the VideoClassification interface for type PNGImage.
func (p *PNGImage) GetVideo() *Video {
	return &Video{
		KeyFrameInterval: p.KeyFrameInterval,
		Label:            p.Label,
		ODataType:        p.ODataType,
		StretchMode:      p.StretchMode,
		SyncMode:         p.SyncMode,
	}
}

// PNGLayer - Describes the settings to produce a PNG image from the input video.
type PNGLayer struct {
	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string
}

// PresentationTimeRange - The presentation time range, this is asset related and not recommended for Account Filter.
type PresentationTimeRange struct {
	// The absolute end time boundary.
	EndTimestamp *int64

	// The indicator of forcing existing of end time stamp.
	ForceEndTimestamp *bool

	// The relative to end right edge.
	LiveBackoffDuration *int64

	// The relative to end sliding window.
	PresentationWindowDuration *int64

	// The absolute start time boundary.
	StartTimestamp *int64

	// The time scale of time stamps.
	Timescale *int64
}

// Preset - Base type for all Presets, which define the recipe or instructions on how the input media files should be processed.
type Preset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetPreset implements the PresetClassification interface for type Preset.
func (p *Preset) GetPreset() *Preset { return p }

// PresetConfigurations - An object of optional configuration settings for encoder.
type PresetConfigurations struct {
	// Allows you to configure the encoder settings to control the balance between speed and quality. Example: set Complexity
	// as Speed for faster encoding but less compression efficiency.
	Complexity *Complexity

	// Sets the interleave mode of the output to control how audio and video are stored in the container format. Example: set
	// InterleavedOutput as NonInterleavedOutput to produce audio-only and video-only
	// outputs in separate MP4 files.
	InterleaveOutput *InterleaveOutput

	// The key frame interval in seconds. Example: set KeyFrameIntervalInSeconds as 2 to reduce the playback buffering for some
	// players.
	KeyFrameIntervalInSeconds *float32

	// The maximum bitrate in bits per second (threshold for the top video layer). Example: set MaxBitrateBps as 6000000 to avoid
	// producing very high bitrate outputs for contents with high complexity.
	MaxBitrateBps *int32

	// The maximum height of output video layers. Example: set MaxHeight as 720 to produce output layers up to 720P even if the
	// input is 4K.
	MaxHeight *int32

	// The maximum number of output video layers. Example: set MaxLayers as 4 to make sure at most 4 output layers are produced
	// to control the overall cost of the encoding job.
	MaxLayers *int32

	// The minimum bitrate in bits per second (threshold for the bottom video layer). Example: set MinBitrateBps as 200000 to
	// have a bottom layer that covers users with low network bandwidth.
	MinBitrateBps *int32

	// The minimum height of output video layers. Example: set MinHeight as 360 to avoid output layers of smaller resolutions
	// like 180P.
	MinHeight *int32
}

// PrivateEndpoint - The Private Endpoint resource.
type PrivateEndpoint struct {
	// READ-ONLY; The ARM identifier for Private Endpoint
	ID *string
}

// PrivateEndpointConnection - The Private Endpoint Connection resource.
type PrivateEndpointConnection struct {
	// Resource properties.
	Properties *PrivateEndpointConnectionProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateEndpointConnectionListResult - List of private endpoint connection associated with the specified storage account
type PrivateEndpointConnectionListResult struct {
	// Array of private endpoint connections
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Properties of the PrivateEndpointConnectProperties.
type PrivateEndpointConnectionProperties struct {
	// REQUIRED; A collection of information about the state of the connection between service consumer and provider.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// The resource of private end point.
	PrivateEndpoint *PrivateEndpoint

	// READ-ONLY; The provisioning state of the private endpoint connection resource.
	ProvisioningState *PrivateEndpointConnectionProvisioningState
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// The private link resource Private link DNS zone name.
	RequiredZoneNames []*string

	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string
}

// PrivateLinkServiceConnectionState - A collection of information about the state of the connection between service consumer
// and provider.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string

	// The reason for approval/rejection of the connection.
	Description *string

	// Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
	Status *PrivateEndpointServiceConnectionStatus
}

// Properties - The service specification property.
type Properties struct {
	// READ-ONLY; The service specifications.
	ServiceSpecification *ServiceSpecification
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Rectangle - Describes the properties of a rectangular window applied to the input media before processing it.
type Rectangle struct {
	// The height of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of
	// the video (For example, 50%).
	Height *string

	// The number of pixels from the left-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video
	// (For example, 50%).
	Left *string

	// The number of pixels from the top-margin. This can be absolute pixel value (e.g 100), or relative to the size of the video
	// (For example, 50%).
	Top *string

	// The width of the rectangular region in pixels. This can be absolute pixel value (e.g 100), or relative to the size of the
	// video (For example, 50%).
	Width *string
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

type ResourceIdentity struct {
	// REQUIRED; Indicates whether to use System Assigned Managed Identity. Mutual exclusive with User Assigned Managed Identity.
	UseSystemAssignedIdentity *bool

	// The user assigned managed identity's ARM ID to use when accessing a resource.
	UserAssignedIdentity *string
}

// SelectAudioTrackByAttribute - Select audio tracks from the input by specifying an attribute and an attribute filter.
type SelectAudioTrackByAttribute struct {
	// REQUIRED; The TrackAttribute to filter the tracks by.
	Attribute *TrackAttribute

	// REQUIRED; The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
	Filter *AttributeFilter

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Optional designation for single channel audio tracks. Can be used to combine the tracks into stereo or multi-channel audio
	// tracks.
	ChannelMapping *ChannelMapping

	// The value to filter the tracks by. Only used when AttributeFilter.ValueEquals is specified for the Filter property.
	FilterValue *string
}

// GetAudioTrackDescriptor implements the AudioTrackDescriptorClassification interface for type SelectAudioTrackByAttribute.
func (s *SelectAudioTrackByAttribute) GetAudioTrackDescriptor() *AudioTrackDescriptor {
	return &AudioTrackDescriptor{
		ChannelMapping: s.ChannelMapping,
		ODataType:      s.ODataType,
	}
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type SelectAudioTrackByAttribute.
func (s *SelectAudioTrackByAttribute) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: s.ODataType,
	}
}

// SelectAudioTrackByID - Select audio tracks from the input by specifying a track identifier.
type SelectAudioTrackByID struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; Track identifier to select
	TrackID *int64

	// Optional designation for single channel audio tracks. Can be used to combine the tracks into stereo or multi-channel audio
	// tracks.
	ChannelMapping *ChannelMapping
}

// GetAudioTrackDescriptor implements the AudioTrackDescriptorClassification interface for type SelectAudioTrackByID.
func (s *SelectAudioTrackByID) GetAudioTrackDescriptor() *AudioTrackDescriptor {
	return &AudioTrackDescriptor{
		ChannelMapping: s.ChannelMapping,
		ODataType:      s.ODataType,
	}
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type SelectAudioTrackByID.
func (s *SelectAudioTrackByID) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: s.ODataType,
	}
}

// SelectVideoTrackByAttribute - Select video tracks from the input by specifying an attribute and an attribute filter.
type SelectVideoTrackByAttribute struct {
	// REQUIRED; The TrackAttribute to filter the tracks by.
	Attribute *TrackAttribute

	// REQUIRED; The type of AttributeFilter to apply to the TrackAttribute in order to select the tracks.
	Filter *AttributeFilter

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The value to filter the tracks by. Only used when AttributeFilter.ValueEquals is specified for the Filter property. For
	// TrackAttribute.Bitrate, this should be an integer value in bits per second (e.g:
	// '1500000'). The TrackAttribute.Language is not supported for video tracks.
	FilterValue *string
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type SelectVideoTrackByAttribute.
func (s *SelectVideoTrackByAttribute) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: s.ODataType,
	}
}

// GetVideoTrackDescriptor implements the VideoTrackDescriptorClassification interface for type SelectVideoTrackByAttribute.
func (s *SelectVideoTrackByAttribute) GetVideoTrackDescriptor() *VideoTrackDescriptor {
	return &VideoTrackDescriptor{
		ODataType: s.ODataType,
	}
}

// SelectVideoTrackByID - Select video tracks from the input by specifying a track identifier.
type SelectVideoTrackByID struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; Track identifier to select
	TrackID *int64
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type SelectVideoTrackByID.
func (s *SelectVideoTrackByID) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: s.ODataType,
	}
}

// GetVideoTrackDescriptor implements the VideoTrackDescriptorClassification interface for type SelectVideoTrackByID.
func (s *SelectVideoTrackByID) GetVideoTrackDescriptor() *VideoTrackDescriptor {
	return &VideoTrackDescriptor{
		ODataType: s.ODataType,
	}
}

// ServiceSpecification - The service metric specifications.
type ServiceSpecification struct {
	// READ-ONLY; List of log specifications.
	LogSpecifications []*LogSpecification

	// READ-ONLY; List of metric specifications.
	MetricSpecifications []*MetricSpecification
}

// StandardEncoderPreset - Describes all the settings to be used when encoding the input video with the Standard Encoder.
type StandardEncoderPreset struct {
	// REQUIRED; The list of codecs to be used when encoding the input video.
	Codecs []CodecClassification

	// REQUIRED; The list of outputs to be produced by the encoder.
	Formats []FormatClassification

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string

	// One or more filtering operations that are applied to the input media before encoding.
	Filters *Filters
}

// GetPreset implements the PresetClassification interface for type StandardEncoderPreset.
func (s *StandardEncoderPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: s.ODataType,
	}
}

// StorageAccount - The storage account details.
type StorageAccount struct {
	// REQUIRED; The type of the storage account.
	Type *StorageAccountType

	// The ID of the storage account resource. Media Services relies on tables and queues as well as blobs, so the primary storage
	// account must be a Standard Storage account (either Microsoft.ClassicStorage
	// or Microsoft.Storage). Blob only storage accounts can be added as secondary storage accounts.
	ID *string

	// The storage account identity.
	Identity *ResourceIdentity

	// READ-ONLY; The current status of the storage account mapping.
	Status *string
}

// StorageEncryptedAssetDecryptionData - Data needed to decrypt asset files encrypted with legacy storage encryption.
type StorageEncryptedAssetDecryptionData struct {
	// Asset File encryption metadata.
	AssetFileEncryptionMetadata []*AssetFileEncryptionMetadata

	// The Asset File storage encryption key.
	Key []byte
}

// StreamingEndpoint - The streaming endpoint.
type StreamingEndpoint struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The streaming endpoint properties.
	Properties *StreamingEndpointProperties

	// The streaming endpoint sku.
	SKU *ArmStreamingEndpointCurrentSKU

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// StreamingEndpointAccessControl - Streaming endpoint access control definition.
type StreamingEndpointAccessControl struct {
	// The access control of Akamai
	Akamai *AkamaiAccessControl

	// The IP access control of the streaming endpoint.
	IP *IPAccessControl
}

// StreamingEndpointListResult - The streaming endpoint list result.
type StreamingEndpointListResult struct {
	// The number of result.
	ODataCount *int32

	// The link to the next set of results. Not empty if value contains incomplete list of streaming endpoints.
	ODataNextLink *string

	// The result of the List StreamingEndpoint operation.
	Value []*StreamingEndpoint
}

// StreamingEndpointProperties - The streaming endpoint properties.
type StreamingEndpointProperties struct {
	// REQUIRED; The number of scale units. Use the Scale operation to adjust this value.
	ScaleUnits *int32

	// The access control definition of the streaming endpoint.
	AccessControl *StreamingEndpointAccessControl

	// This feature is deprecated, do not set a value for this property.
	AvailabilitySetName *string

	// The CDN enabled flag.
	CdnEnabled *bool

	// The CDN profile name.
	CdnProfile *string

	// The CDN provider name.
	CdnProvider *string

	// The streaming endpoint access policies.
	CrossSiteAccessPolicies *CrossSiteAccessPolicies

	// The custom host names of the streaming endpoint
	CustomHostNames []*string

	// The streaming endpoint description.
	Description *string

	// Max cache age
	MaxCacheAge *int64

	// READ-ONLY; The exact time the streaming endpoint was created.
	Created *time.Time

	// READ-ONLY; The free trial expiration time.
	FreeTrialEndTime *time.Time

	// READ-ONLY; The streaming endpoint host name.
	HostName *string

	// READ-ONLY; The exact time the streaming endpoint was last modified.
	LastModified *time.Time

	// READ-ONLY; The provisioning state of the streaming endpoint.
	ProvisioningState *string

	// READ-ONLY; The resource state of the streaming endpoint.
	ResourceState *StreamingEndpointResourceState
}

type StreamingEndpointSKUInfoListResult struct {
	// The result of the List StreamingEndpoint skus.
	Value []*ArmStreamingEndpointSKUInfo
}

// StreamingEntityScaleUnit - scale units definition
type StreamingEntityScaleUnit struct {
	// The scale unit number of the streaming endpoint.
	ScaleUnit *int32
}

// StreamingLocator - A Streaming Locator resource
type StreamingLocator struct {
	// Properties of the Streaming Locator.
	Properties *StreamingLocatorProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// StreamingLocatorCollection - A collection of StreamingLocator items.
type StreamingLocatorCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string

	// A collection of StreamingLocator items.
	Value []*StreamingLocator
}

// StreamingLocatorContentKey - Class for content key in Streaming Locator
type StreamingLocatorContentKey struct {
	// REQUIRED; ID of Content Key
	ID *string

	// Label of Content Key as specified in the Streaming Policy
	LabelReferenceInStreamingPolicy *string

	// Value of Content Key
	Value *string

	// READ-ONLY; ContentKeyPolicy used by Content Key
	PolicyName *string

	// READ-ONLY; Tracks which use this Content Key
	Tracks []*TrackSelection

	// READ-ONLY; Encryption type of Content Key
	Type *StreamingLocatorContentKeyType
}

// StreamingLocatorProperties - Properties of the Streaming Locator.
type StreamingLocatorProperties struct {
	// REQUIRED; Asset Name
	AssetName *string

	// REQUIRED; Name of the Streaming Policy used by this Streaming Locator. Either specify the name of Streaming Policy you
	// created or use one of the predefined Streaming Policies. The predefined Streaming Policies
	// available are: 'PredefinedDownloadOnly', 'PredefinedClearStreamingOnly', 'PredefinedDownloadAndClearStreaming', 'PredefinedClearKey',
	// 'PredefinedMultiDrmCencStreaming' and 'Predefined
	// MultiDrmStreaming'
	StreamingPolicyName *string

	// Alternative Media ID of this Streaming Locator
	AlternativeMediaID *string

	// The ContentKeys used by this Streaming Locator.
	ContentKeys []*StreamingLocatorContentKey

	// Name of the default ContentKeyPolicy used by this Streaming Locator.
	DefaultContentKeyPolicyName *string

	// The end time of the Streaming Locator.
	EndTime *time.Time

	// A list of asset or account filters which apply to this streaming locator
	Filters []*string

	// The start time of the Streaming Locator.
	StartTime *time.Time

	// The StreamingLocatorId of the Streaming Locator.
	StreamingLocatorID *string

	// READ-ONLY; The creation time of the Streaming Locator.
	Created *time.Time
}

// StreamingPath - Class of paths for streaming
type StreamingPath struct {
	// REQUIRED; Encryption scheme
	EncryptionScheme *EncryptionScheme

	// REQUIRED; Streaming protocol
	StreamingProtocol *StreamingPolicyStreamingProtocol

	// Streaming paths for each protocol and encryptionScheme pair
	Paths []*string
}

// StreamingPolicy - A Streaming Policy resource
type StreamingPolicy struct {
	// Class to specify properties of Streaming Policy
	Properties *StreamingPolicyProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// StreamingPolicyCollection - A collection of StreamingPolicy items.
type StreamingPolicyCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string

	// A collection of StreamingPolicy items.
	Value []*StreamingPolicy
}

// StreamingPolicyContentKey - Class to specify properties of content key
type StreamingPolicyContentKey struct {
	// Label can be used to specify Content Key when creating a Streaming Locator
	Label *string

	// Policy used by Content Key
	PolicyName *string

	// Tracks which use this content key
	Tracks []*TrackSelection
}

// StreamingPolicyContentKeys - Class to specify properties of all content keys in Streaming Policy
type StreamingPolicyContentKeys struct {
	// Default content key for an encryption scheme
	DefaultKey *DefaultKey

	// Representing tracks needs separate content key
	KeyToTrackMappings []*StreamingPolicyContentKey
}

// StreamingPolicyFairPlayConfiguration - Class to specify configurations of FairPlay in Streaming Policy
type StreamingPolicyFairPlayConfiguration struct {
	// REQUIRED; All license to be persistent or not
	AllowPersistentLicense *bool

	// Template for the URL of the custom service delivering licenses to end user players. Not required when using Azure Media
	// Services for issuing licenses. The template supports replaceable tokens that the
	// service will update at runtime with the value specific to the request. The currently supported token values are {AlternativeMediaId},
	// which is replaced with the value of
	// StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being
	// requested.
	CustomLicenseAcquisitionURLTemplate *string
}

// StreamingPolicyPlayReadyConfiguration - Class to specify configurations of PlayReady in Streaming Policy
type StreamingPolicyPlayReadyConfiguration struct {
	// Template for the URL of the custom service delivering licenses to end user players. Not required when using Azure Media
	// Services for issuing licenses. The template supports replaceable tokens that the
	// service will update at runtime with the value specific to the request. The currently supported token values are {AlternativeMediaId},
	// which is replaced with the value of
	// StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being
	// requested.
	CustomLicenseAcquisitionURLTemplate *string

	// Custom attributes for PlayReady
	PlayReadyCustomAttributes *string
}

// StreamingPolicyProperties - Class to specify properties of Streaming Policy
type StreamingPolicyProperties struct {
	// Configuration of CommonEncryptionCbcs
	CommonEncryptionCbcs *CommonEncryptionCbcs

	// Configuration of CommonEncryptionCenc
	CommonEncryptionCenc *CommonEncryptionCenc

	// Default ContentKey used by current Streaming Policy
	DefaultContentKeyPolicyName *string

	// Configuration of EnvelopeEncryption
	EnvelopeEncryption *EnvelopeEncryption

	// Configurations of NoEncryption
	NoEncryption *NoEncryption

	// READ-ONLY; Creation time of Streaming Policy
	Created *time.Time
}

// StreamingPolicyWidevineConfiguration - Class to specify configurations of Widevine in Streaming Policy
type StreamingPolicyWidevineConfiguration struct {
	// Template for the URL of the custom service delivering licenses to end user players. Not required when using Azure Media
	// Services for issuing licenses. The template supports replaceable tokens that the
	// service will update at runtime with the value specific to the request. The currently supported token values are {AlternativeMediaId},
	// which is replaced with the value of
	// StreamingLocatorId.AlternativeMediaId, and {ContentKeyId}, which is replaced with the value of identifier of the key being
	// requested.
	CustomLicenseAcquisitionURLTemplate *string
}

// SyncStorageKeysInput - The input to the sync storage keys request.
type SyncStorageKeysInput struct {
	// The ID of the storage account resource.
	ID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// TextTrack - Represents a text track in an asset. A text track is usually used for sparse data related to the audio or video
// tracks.
type TextTrack struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The display name of the text track on a video player. In HLS, this maps to the NAME attribute of EXT-X-MEDIA.
	DisplayName *string

	// The file name to the source file. This file is located in the storage container of the asset.
	FileName *string

	// The HLS specific setting for the text track.
	HlsSettings *HlsSettings

	// When PlayerVisibility is set to "Visible", the text track will be present in the DASH manifest or HLS playlist when requested
	// by a client. When the PlayerVisibility is set to "Hidden", the text will
	// not be available to the client. The default value is "Visible".
	PlayerVisibility *Visibility

	// READ-ONLY; The RFC5646 language code for the text track.
	LanguageCode *string
}

// GetTrackBase implements the TrackBaseClassification interface for type TextTrack.
func (t *TextTrack) GetTrackBase() *TrackBase {
	return &TrackBase{
		ODataType: t.ODataType,
	}
}

// TrackBase - Base type for concrete track types. A derived type must be used to represent the Track.
type TrackBase struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetTrackBase implements the TrackBaseClassification interface for type TrackBase.
func (t *TrackBase) GetTrackBase() *TrackBase { return t }

// TrackDescriptor - Base type for all TrackDescriptor types, which define the metadata and selection for tracks that should
// be processed by a Job
type TrackDescriptor struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type TrackDescriptor.
func (t *TrackDescriptor) GetTrackDescriptor() *TrackDescriptor { return t }

// TrackPropertyCondition - Class to specify one track property condition
type TrackPropertyCondition struct {
	// REQUIRED; Track property condition operation
	Operation *TrackPropertyCompareOperation

	// REQUIRED; Track property type
	Property *TrackPropertyType

	// Track property value
	Value *string
}

// TrackSelection - Class to select a track
type TrackSelection struct {
	// TrackSelections is a track property condition list which can specify track(s)
	TrackSelections []*TrackPropertyCondition
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Transform - A Transform encapsulates the rules or instructions for generating desired outputs from input media, such as
// by transcoding or by extracting insights. After the Transform is created, it can be applied
// to input media by creating Jobs.
type Transform struct {
	// The resource properties.
	Properties *TransformProperties

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The system metadata relating to this resource.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// TransformCollection - A collection of Transform items.
type TransformCollection struct {
	// A link to the next page of the collection (when the collection contains too many results to return in one response).
	ODataNextLink *string

	// A collection of Transform items.
	Value []*Transform
}

// TransformOutput - Describes the properties of a TransformOutput, which are the rules to be applied while generating the
// desired output.
type TransformOutput struct {
	// REQUIRED; Preset that describes the operations that will be used to modify, transcode, or extract insights from the source
	// file to generate the output.
	Preset PresetClassification

	// A Transform can define more than one outputs. This property defines what the service should do when one output fails -
	// either continue to produce other outputs, or, stop the other outputs. The overall
	// Job state will not reflect failures of outputs that are specified with 'ContinueJob'. The default is 'StopProcessingJob'.
	OnError *OnErrorType

	// Sets the relative priority of the TransformOutputs within a Transform. This sets the priority that the service uses for
	// processing TransformOutputs. The default priority is Normal.
	RelativePriority *Priority
}

// TransformProperties - A Transform.
type TransformProperties struct {
	// REQUIRED; An array of one or more TransformOutputs that the Transform should generate.
	Outputs []*TransformOutput

	// An optional verbose description of the Transform.
	Description *string

	// READ-ONLY; The UTC date and time when the Transform was created, in 'YYYY-MM-DDThh:mm:ssZ' format.
	Created *time.Time

	// READ-ONLY; The UTC date and time when the Transform was last updated, in 'YYYY-MM-DDThh:mm:ssZ' format.
	LastModified *time.Time
}

// TransportStreamFormat - Describes the properties for generating an MPEG-2 Transport Stream (ISO/IEC 13818-1) output video
// file(s).
type TransportStreamFormat struct {
	// REQUIRED; The file naming pattern used for the creation of output files. The following macros are supported in the file
	// name: {Basename} - An expansion macro that will use the name of the input video file. If
	// the base name(the file suffix is not included) of the input video file is less than 32 characters long, the base name of
	// input video files will be used. If the length of base name of the input video
	// file exceeds 32 characters, the base name is truncated to the first 32 characters in total length. {Extension} - The appropriate
	// extension for this format. {Label} - The label assigned to the
	// codec/layer. {Index} - A unique index for thumbnails. Only applicable to thumbnails. {AudioStream} - string "Audio" plus
	// audio stream number(start from 1). {Bitrate} - The audio/video bitrate in kbps.
	// Not applicable to thumbnails. {Codec} - The type of the audio/video codec. {Resolution} - The video resolution. Any unsubstituted
	// macros will be collapsed and removed from the filename.
	FilenamePattern *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The list of output files to produce. Each entry in the list is a set of audio and video layer labels to be muxed together
	// .
	OutputFiles []*OutputFile
}

// GetFormat implements the FormatClassification interface for type TransportStreamFormat.
func (t *TransportStreamFormat) GetFormat() *Format {
	return &Format{
		FilenamePattern: t.FilenamePattern,
		ODataType:       t.ODataType,
	}
}

// GetMultiBitrateFormat implements the MultiBitrateFormatClassification interface for type TransportStreamFormat.
func (t *TransportStreamFormat) GetMultiBitrateFormat() *MultiBitrateFormat {
	return &MultiBitrateFormat{
		FilenamePattern: t.FilenamePattern,
		ODataType:       t.ODataType,
		OutputFiles:     t.OutputFiles,
	}
}

// UTCClipTime - Specifies the clip time as a Utc time position in the media file. The Utc time can point to a different position
// depending on whether the media file starts from a timestamp of zero or not.
type UTCClipTime struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// REQUIRED; The time position on the timeline of the input media based on Utc time.
	Time *time.Time
}

// GetClipTime implements the ClipTimeClassification interface for type UTCClipTime.
func (u *UTCClipTime) GetClipTime() *ClipTime {
	return &ClipTime{
		ODataType: u.ODataType,
	}
}

type UserAssignedManagedIdentity struct {
	// READ-ONLY; The client ID.
	ClientID *string

	// READ-ONLY; The principal ID.
	PrincipalID *string
}

// Video - Describes the basic properties for encoding the input video.
type Video struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The distance between two key frames. The value should be non-zero in the range [0.5, 20] seconds, specified in ISO 8601
	// format. The default is 2 seconds(PT2S). Note that this setting is ignored if
	// VideoSyncMode.Passthrough is set, where the KeyFrameInterval value will follow the input source setting.
	KeyFrameInterval *string

	// An optional label for the codec. The label can be used to control muxing behavior.
	Label *string

	// The resizing mode - how the input video will be resized to fit the desired output resolution(s). Default is AutoSize
	StretchMode *StretchMode

	// The Video Sync Mode
	SyncMode *VideoSyncMode
}

// GetCodec implements the CodecClassification interface for type Video.
func (v *Video) GetCodec() *Codec {
	return &Codec{
		Label:     v.Label,
		ODataType: v.ODataType,
	}
}

// GetVideo implements the VideoClassification interface for type Video.
func (v *Video) GetVideo() *Video { return v }

// VideoAnalyzerPreset - A video analyzer preset that extracts insights (rich metadata) from both audio and video, and outputs
// a JSON format file.
type VideoAnalyzerPreset struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The language for the audio payload in the input using the BCP-47 format of 'language tag-region' (e.g: 'en-US'). If you
	// know the language of your content, it is recommended that you specify it. The
	// language must be specified explicitly for AudioAnalysisMode::Basic, since automatic language detection is not included
	// in basic mode. If the language isn't specified or set to null, automatic language
	// detection will choose the first language detected and process with the selected language for the duration of the file.
	// It does not currently support dynamically switching between languages after the
	// first language is detected. The automatic detection works best with audio recordings with clearly discernable speech. If
	// automatic detection fails to find the language, transcription would fallback to
	// 'en-US'." The list of supported languages is available here: https://go.microsoft.com/fwlink/?linkid=2109463
	AudioLanguage *string

	// Dictionary containing key value pairs for parameters not exposed in the preset itself
	ExperimentalOptions map[string]*string

	// Defines the type of insights that you want the service to generate. The allowed values are 'AudioInsightsOnly', 'VideoInsightsOnly',
	// and 'AllInsights'. The default is AllInsights. If you set this to
	// AllInsights and the input is audio only, then only audio insights are generated. Similarly if the input is video only,
	// then only video insights are generated. It is recommended that you not use
	// AudioInsightsOnly if you expect some of your inputs to be video only; or use VideoInsightsOnly if you expect some of your
	// inputs to be audio only. Your Jobs in such conditions would error out.
	InsightsToExtract *InsightsType

	// Determines the set of audio analysis operations to be performed. If unspecified, the Standard AudioAnalysisMode would be
	// chosen.
	Mode *AudioAnalysisMode
}

// GetAudioAnalyzerPreset implements the AudioAnalyzerPresetClassification interface for type VideoAnalyzerPreset.
func (v *VideoAnalyzerPreset) GetAudioAnalyzerPreset() *AudioAnalyzerPreset {
	return &AudioAnalyzerPreset{
		AudioLanguage:       v.AudioLanguage,
		ExperimentalOptions: v.ExperimentalOptions,
		Mode:                v.Mode,
		ODataType:           v.ODataType,
	}
}

// GetPreset implements the PresetClassification interface for type VideoAnalyzerPreset.
func (v *VideoAnalyzerPreset) GetPreset() *Preset {
	return &Preset{
		ODataType: v.ODataType,
	}
}

// VideoLayer - Describes the settings to be used when encoding the input video into a desired output bitrate layer.
type VideoLayer struct {
	// REQUIRED; The average bitrate in bits per second at which to encode the input video when generating this layer. This is
	// a required field.
	Bitrate *int32

	// Whether or not adaptive B-frames are to be used when encoding this layer. If not specified, the encoder will turn it on
	// whenever the video profile permits its use.
	AdaptiveBFrame *bool

	// The number of B-frames to be used when encoding this layer. If not specified, the encoder chooses an appropriate number
	// based on the video profile and level.
	BFrames *int32

	// The frame rate (in frames per second) at which to encode this layer. The value can be in the form of M/N where M and N
	// are integers (For example, 30000/1001), or in the form of a number (For example,
	// 30, or 29.97). The encoder enforces constraints on allowed frame rates based on the profile and level. If it is not specified,
	// the encoder will use the same frame rate as the input video.
	FrameRate *string

	// The height of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in height as the input.
	Height *string

	// The alphanumeric label for this layer, which can be used in multiplexing different video and audio layers, or in naming
	// the output file.
	Label *string

	// The maximum bitrate (in bits per second), at which the VBV buffer should be assumed to refill. If not specified, defaults
	// to the same value as bitrate.
	MaxBitrate *int32

	// The number of slices to be used when encoding this layer. If not specified, default is zero, which means that encoder will
	// use a single slice for each frame.
	Slices *int32

	// The width of the output video for this layer. The value can be absolute (in pixels) or relative (in percentage). For example
	// 50% means the output video has half as many pixels in width as the input.
	Width *string
}

// VideoOverlay - Describes the properties of a video overlay.
type VideoOverlay struct {
	// REQUIRED; The label of the job input which is to be used as an overlay. The Input must specify exactly one file. You can
	// specify an image file in JPG, PNG, GIF or BMP format, or an audio file (such as a WAV,
	// MP3, WMA or M4A file), or a video file. See https://aka.ms/mesformats for the complete list of supported audio and video
	// file formats.
	InputLabel *string

	// REQUIRED; The discriminator for derived types.
	ODataType *string

	// The gain level of audio in the overlay. The value should be in the range [0, 1.0]. The default is 1.0.
	AudioGainLevel *float64

	// An optional rectangular window used to crop the overlay image or video.
	CropRectangle *Rectangle

	// The end position, with reference to the input video, at which the overlay ends. The value should be in ISO 8601 format.
	// For example, PT30S to end the overlay at 30 seconds into the input video. If not
	// specified or the value is greater than the input video duration, the overlay will be applied until the end of the input
	// video if the overlay media duration is greater than the input video duration,
	// else the overlay will last as long as the overlay media duration.
	End *string

	// The duration over which the overlay fades in onto the input video. The value should be in ISO 8601 duration format. If
	// not specified the default behavior is to have no fade in (same as PT0S).
	FadeInDuration *string

	// The duration over which the overlay fades out of the input video. The value should be in ISO 8601 duration format. If not
	// specified the default behavior is to have no fade out (same as PT0S).
	FadeOutDuration *string

	// The opacity of the overlay. This is a value in the range [0 - 1.0]. Default is 1.0 which mean the overlay is opaque.
	Opacity *float64

	// The location in the input video where the overlay is applied.
	Position *Rectangle

	// The start position, with reference to the input video, at which the overlay starts. The value should be in ISO 8601 format.
	// For example, PT05S to start the overlay at 5 seconds into the input video.
	// If not specified the overlay starts from the beginning of the input video.
	Start *string
}

// GetOverlay implements the OverlayClassification interface for type VideoOverlay.
func (v *VideoOverlay) GetOverlay() *Overlay {
	return &Overlay{
		AudioGainLevel:  v.AudioGainLevel,
		End:             v.End,
		FadeInDuration:  v.FadeInDuration,
		FadeOutDuration: v.FadeOutDuration,
		InputLabel:      v.InputLabel,
		ODataType:       v.ODataType,
		Start:           v.Start,
	}
}

// VideoTrack - Represents a video track in the asset.
type VideoTrack struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetTrackBase implements the TrackBaseClassification interface for type VideoTrack.
func (v *VideoTrack) GetTrackBase() *TrackBase {
	return &TrackBase{
		ODataType: v.ODataType,
	}
}

// VideoTrackDescriptor - A TrackSelection to select video tracks.
type VideoTrackDescriptor struct {
	// REQUIRED; The discriminator for derived types.
	ODataType *string
}

// GetTrackDescriptor implements the TrackDescriptorClassification interface for type VideoTrackDescriptor.
func (v *VideoTrackDescriptor) GetTrackDescriptor() *TrackDescriptor {
	return &TrackDescriptor{
		ODataType: v.ODataType,
	}
}

// GetVideoTrackDescriptor implements the VideoTrackDescriptorClassification interface for type VideoTrackDescriptor.
func (v *VideoTrackDescriptor) GetVideoTrackDescriptor() *VideoTrackDescriptor { return v }
