//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicessiterecovery/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ReplicationMigrationItemsServer is a fake server for instances of the armrecoveryservicessiterecovery.ReplicationMigrationItemsClient type.
type ReplicationMigrationItemsServer struct {
	// BeginCreate is the fake for method ReplicationMigrationItemsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, input armrecoveryservicessiterecovery.EnableMigrationInput, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginCreateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ReplicationMigrationItemsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginDeleteOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ReplicationMigrationItemsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientGetOptions) (resp azfake.Responder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ReplicationMigrationItemsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceName string, resourceGroupName string, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListResponse])

	// NewListByReplicationProtectionContainersPager is the fake for method ReplicationMigrationItemsClient.NewListByReplicationProtectionContainersPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByReplicationProtectionContainersPager func(resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListByReplicationProtectionContainersOptions) (resp azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListByReplicationProtectionContainersResponse])

	// BeginMigrate is the fake for method ReplicationMigrationItemsClient.BeginMigrate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, migrateInput armrecoveryservicessiterecovery.MigrateInput, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginMigrateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientMigrateResponse], errResp azfake.ErrorResponder)

	// BeginPauseReplication is the fake for method ReplicationMigrationItemsClient.BeginPauseReplication
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginPauseReplication func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, pauseReplicationInput armrecoveryservicessiterecovery.PauseReplicationInput, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginPauseReplicationOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientPauseReplicationResponse], errResp azfake.ErrorResponder)

	// BeginResumeReplication is the fake for method ReplicationMigrationItemsClient.BeginResumeReplication
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResumeReplication func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, resumeReplicationInput armrecoveryservicessiterecovery.ResumeReplicationInput, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginResumeReplicationOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientResumeReplicationResponse], errResp azfake.ErrorResponder)

	// BeginResync is the fake for method ReplicationMigrationItemsClient.BeginResync
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginResync func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, input armrecoveryservicessiterecovery.ResyncInput, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginResyncOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientResyncResponse], errResp azfake.ErrorResponder)

	// BeginTestMigrate is the fake for method ReplicationMigrationItemsClient.BeginTestMigrate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTestMigrate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, testMigrateInput armrecoveryservicessiterecovery.TestMigrateInput, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginTestMigrateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientTestMigrateResponse], errResp azfake.ErrorResponder)

	// BeginTestMigrateCleanup is the fake for method ReplicationMigrationItemsClient.BeginTestMigrateCleanup
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginTestMigrateCleanup func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, testMigrateCleanupInput armrecoveryservicessiterecovery.TestMigrateCleanupInput, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginTestMigrateCleanupOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientTestMigrateCleanupResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ReplicationMigrationItemsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceName string, resourceGroupName string, fabricName string, protectionContainerName string, migrationItemName string, input armrecoveryservicessiterecovery.UpdateMigrationItemInput, options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginUpdateOptions) (resp azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewReplicationMigrationItemsServerTransport creates a new instance of ReplicationMigrationItemsServerTransport with the provided implementation.
// The returned ReplicationMigrationItemsServerTransport instance is connected to an instance of armrecoveryservicessiterecovery.ReplicationMigrationItemsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewReplicationMigrationItemsServerTransport(srv *ReplicationMigrationItemsServer) *ReplicationMigrationItemsServerTransport {
	return &ReplicationMigrationItemsServerTransport{
		srv:          srv,
		beginCreate:  newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientCreateResponse]](),
		beginDelete:  newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientDeleteResponse]](),
		newListPager: newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListResponse]](),
		newListByReplicationProtectionContainersPager: newTracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListByReplicationProtectionContainersResponse]](),
		beginMigrate:            newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientMigrateResponse]](),
		beginPauseReplication:   newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientPauseReplicationResponse]](),
		beginResumeReplication:  newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientResumeReplicationResponse]](),
		beginResync:             newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientResyncResponse]](),
		beginTestMigrate:        newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientTestMigrateResponse]](),
		beginTestMigrateCleanup: newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientTestMigrateCleanupResponse]](),
		beginUpdate:             newTracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientUpdateResponse]](),
	}
}

// ReplicationMigrationItemsServerTransport connects instances of armrecoveryservicessiterecovery.ReplicationMigrationItemsClient to instances of ReplicationMigrationItemsServer.
// Don't use this type directly, use NewReplicationMigrationItemsServerTransport instead.
type ReplicationMigrationItemsServerTransport struct {
	srv                                           *ReplicationMigrationItemsServer
	beginCreate                                   *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientCreateResponse]]
	beginDelete                                   *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientDeleteResponse]]
	newListPager                                  *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListResponse]]
	newListByReplicationProtectionContainersPager *tracker[azfake.PagerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListByReplicationProtectionContainersResponse]]
	beginMigrate                                  *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientMigrateResponse]]
	beginPauseReplication                         *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientPauseReplicationResponse]]
	beginResumeReplication                        *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientResumeReplicationResponse]]
	beginResync                                   *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientResyncResponse]]
	beginTestMigrate                              *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientTestMigrateResponse]]
	beginTestMigrateCleanup                       *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientTestMigrateCleanupResponse]]
	beginUpdate                                   *tracker[azfake.PollerResponder[armrecoveryservicessiterecovery.ReplicationMigrationItemsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ReplicationMigrationItemsServerTransport.
func (r *ReplicationMigrationItemsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ReplicationMigrationItemsClient.BeginCreate":
		resp, err = r.dispatchBeginCreate(req)
	case "ReplicationMigrationItemsClient.BeginDelete":
		resp, err = r.dispatchBeginDelete(req)
	case "ReplicationMigrationItemsClient.Get":
		resp, err = r.dispatchGet(req)
	case "ReplicationMigrationItemsClient.NewListPager":
		resp, err = r.dispatchNewListPager(req)
	case "ReplicationMigrationItemsClient.NewListByReplicationProtectionContainersPager":
		resp, err = r.dispatchNewListByReplicationProtectionContainersPager(req)
	case "ReplicationMigrationItemsClient.BeginMigrate":
		resp, err = r.dispatchBeginMigrate(req)
	case "ReplicationMigrationItemsClient.BeginPauseReplication":
		resp, err = r.dispatchBeginPauseReplication(req)
	case "ReplicationMigrationItemsClient.BeginResumeReplication":
		resp, err = r.dispatchBeginResumeReplication(req)
	case "ReplicationMigrationItemsClient.BeginResync":
		resp, err = r.dispatchBeginResync(req)
	case "ReplicationMigrationItemsClient.BeginTestMigrate":
		resp, err = r.dispatchBeginTestMigrate(req)
	case "ReplicationMigrationItemsClient.BeginTestMigrateCleanup":
		resp, err = r.dispatchBeginTestMigrateCleanup(req)
	case "ReplicationMigrationItemsClient.BeginUpdate":
		resp, err = r.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := r.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.EnableMigrationInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginCreate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		r.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		r.beginCreate.remove(req)
	}

	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if r.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := r.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		deleteOptionUnescaped, err := url.QueryUnescape(qp.Get("deleteOption"))
		if err != nil {
			return nil, err
		}
		deleteOptionParam := getOptional(deleteOptionUnescaped)
		var options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginDeleteOptions
		if deleteOptionParam != nil {
			options = &armrecoveryservicessiterecovery.ReplicationMigrationItemsClientBeginDeleteOptions{
				DeleteOption: deleteOptionParam,
			}
		}
		respr, errRespr := r.srv.BeginDelete(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		r.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		r.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		r.beginDelete.remove(req)
	}

	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if r.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
	if err != nil {
		return nil, err
	}
	protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
	if err != nil {
		return nil, err
	}
	migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := r.srv.Get(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MigrationItem, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := r.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		takeTokenUnescaped, err := url.QueryUnescape(qp.Get("takeToken"))
		if err != nil {
			return nil, err
		}
		takeTokenParam := getOptional(takeTokenUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListOptions
		if skipTokenParam != nil || takeTokenParam != nil || filterParam != nil {
			options = &armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListOptions{
				SkipToken: skipTokenParam,
				TakeToken: takeTokenParam,
				Filter:    filterParam,
			}
		}
		resp := r.srv.NewListPager(resourceNameParam, resourceGroupNameParam, options)
		newListPager = &resp
		r.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		r.newListPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchNewListByReplicationProtectionContainersPager(req *http.Request) (*http.Response, error) {
	if r.srv.NewListByReplicationProtectionContainersPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByReplicationProtectionContainersPager not implemented")}
	}
	newListByReplicationProtectionContainersPager := r.newListByReplicationProtectionContainersPager.get(req)
	if newListByReplicationProtectionContainersPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		takeTokenUnescaped, err := url.QueryUnescape(qp.Get("takeToken"))
		if err != nil {
			return nil, err
		}
		takeTokenParam := getOptional(takeTokenUnescaped)
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		var options *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListByReplicationProtectionContainersOptions
		if skipTokenParam != nil || takeTokenParam != nil || filterParam != nil {
			options = &armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListByReplicationProtectionContainersOptions{
				SkipToken: skipTokenParam,
				TakeToken: takeTokenParam,
				Filter:    filterParam,
			}
		}
		resp := r.srv.NewListByReplicationProtectionContainersPager(resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, options)
		newListByReplicationProtectionContainersPager = &resp
		r.newListByReplicationProtectionContainersPager.add(req, newListByReplicationProtectionContainersPager)
		server.PagerResponderInjectNextLinks(newListByReplicationProtectionContainersPager, req, func(page *armrecoveryservicessiterecovery.ReplicationMigrationItemsClientListByReplicationProtectionContainersResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByReplicationProtectionContainersPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		r.newListByReplicationProtectionContainersPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByReplicationProtectionContainersPager) {
		r.newListByReplicationProtectionContainersPager.remove(req)
	}
	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchBeginMigrate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginMigrate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrate not implemented")}
	}
	beginMigrate := r.beginMigrate.get(req)
	if beginMigrate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/migrate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.MigrateInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginMigrate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrate = &respr
		r.beginMigrate.add(req, beginMigrate)
	}

	resp, err := server.PollerResponderNext(beginMigrate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginMigrate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrate) {
		r.beginMigrate.remove(req)
	}

	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchBeginPauseReplication(req *http.Request) (*http.Response, error) {
	if r.srv.BeginPauseReplication == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPauseReplication not implemented")}
	}
	beginPauseReplication := r.beginPauseReplication.get(req)
	if beginPauseReplication == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/pauseReplication`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.PauseReplicationInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginPauseReplication(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPauseReplication = &respr
		r.beginPauseReplication.add(req, beginPauseReplication)
	}

	resp, err := server.PollerResponderNext(beginPauseReplication, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginPauseReplication.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPauseReplication) {
		r.beginPauseReplication.remove(req)
	}

	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchBeginResumeReplication(req *http.Request) (*http.Response, error) {
	if r.srv.BeginResumeReplication == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResumeReplication not implemented")}
	}
	beginResumeReplication := r.beginResumeReplication.get(req)
	if beginResumeReplication == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resumeReplication`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.ResumeReplicationInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginResumeReplication(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResumeReplication = &respr
		r.beginResumeReplication.add(req, beginResumeReplication)
	}

	resp, err := server.PollerResponderNext(beginResumeReplication, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginResumeReplication.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResumeReplication) {
		r.beginResumeReplication.remove(req)
	}

	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchBeginResync(req *http.Request) (*http.Response, error) {
	if r.srv.BeginResync == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginResync not implemented")}
	}
	beginResync := r.beginResync.get(req)
	if beginResync == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resync`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.ResyncInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginResync(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginResync = &respr
		r.beginResync.add(req, beginResync)
	}

	resp, err := server.PollerResponderNext(beginResync, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginResync.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginResync) {
		r.beginResync.remove(req)
	}

	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchBeginTestMigrate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginTestMigrate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTestMigrate not implemented")}
	}
	beginTestMigrate := r.beginTestMigrate.get(req)
	if beginTestMigrate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testMigrate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.TestMigrateInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginTestMigrate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTestMigrate = &respr
		r.beginTestMigrate.add(req, beginTestMigrate)
	}

	resp, err := server.PollerResponderNext(beginTestMigrate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginTestMigrate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTestMigrate) {
		r.beginTestMigrate.remove(req)
	}

	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchBeginTestMigrateCleanup(req *http.Request) (*http.Response, error) {
	if r.srv.BeginTestMigrateCleanup == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginTestMigrateCleanup not implemented")}
	}
	beginTestMigrateCleanup := r.beginTestMigrateCleanup.get(req)
	if beginTestMigrateCleanup == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/testMigrateCleanup`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.TestMigrateCleanupInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginTestMigrateCleanup(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginTestMigrateCleanup = &respr
		r.beginTestMigrateCleanup.add(req, beginTestMigrateCleanup)
	}

	resp, err := server.PollerResponderNext(beginTestMigrateCleanup, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginTestMigrateCleanup.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginTestMigrateCleanup) {
		r.beginTestMigrateCleanup.remove(req)
	}

	return resp, nil
}

func (r *ReplicationMigrationItemsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if r.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := r.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/vaults/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationFabrics/(?P<fabricName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationProtectionContainers/(?P<protectionContainerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replicationMigrationItems/(?P<migrationItemName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armrecoveryservicessiterecovery.UpdateMigrationItemInput](req)
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		fabricNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("fabricName")])
		if err != nil {
			return nil, err
		}
		protectionContainerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("protectionContainerName")])
		if err != nil {
			return nil, err
		}
		migrationItemNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("migrationItemName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := r.srv.BeginUpdate(req.Context(), resourceNameParam, resourceGroupNameParam, fabricNameParam, protectionContainerNameParam, migrationItemNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		r.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		r.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		r.beginUpdate.remove(req)
	}

	return resp, nil
}
