//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// SolutionsReferenceDataServer is a fake server for instances of the armsecurity.SolutionsReferenceDataClient type.
type SolutionsReferenceDataServer struct {
	// List is the fake for method SolutionsReferenceDataClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, options *armsecurity.SolutionsReferenceDataClientListOptions) (resp azfake.Responder[armsecurity.SolutionsReferenceDataClientListResponse], errResp azfake.ErrorResponder)

	// ListByHomeRegion is the fake for method SolutionsReferenceDataClient.ListByHomeRegion
	// HTTP status codes to indicate success: http.StatusOK
	ListByHomeRegion func(ctx context.Context, ascLocation string, options *armsecurity.SolutionsReferenceDataClientListByHomeRegionOptions) (resp azfake.Responder[armsecurity.SolutionsReferenceDataClientListByHomeRegionResponse], errResp azfake.ErrorResponder)
}

// NewSolutionsReferenceDataServerTransport creates a new instance of SolutionsReferenceDataServerTransport with the provided implementation.
// The returned SolutionsReferenceDataServerTransport instance is connected to an instance of armsecurity.SolutionsReferenceDataClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSolutionsReferenceDataServerTransport(srv *SolutionsReferenceDataServer) *SolutionsReferenceDataServerTransport {
	return &SolutionsReferenceDataServerTransport{srv: srv}
}

// SolutionsReferenceDataServerTransport connects instances of armsecurity.SolutionsReferenceDataClient to instances of SolutionsReferenceDataServer.
// Don't use this type directly, use NewSolutionsReferenceDataServerTransport instead.
type SolutionsReferenceDataServerTransport struct {
	srv *SolutionsReferenceDataServer
}

// Do implements the policy.Transporter interface for SolutionsReferenceDataServerTransport.
func (s *SolutionsReferenceDataServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SolutionsReferenceDataClient.List":
		resp, err = s.dispatchList(req)
	case "SolutionsReferenceDataClient.ListByHomeRegion":
		resp, err = s.dispatchListByHomeRegion(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SolutionsReferenceDataServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/securitySolutionsReferenceData`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := s.srv.List(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SolutionsReferenceDataList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SolutionsReferenceDataServerTransport) dispatchListByHomeRegion(req *http.Request) (*http.Response, error) {
	if s.srv.ListByHomeRegion == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByHomeRegion not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/securitySolutionsReferenceData`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListByHomeRegion(req.Context(), ascLocationParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SolutionsReferenceDataList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
