// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/config/v1/config.proto

package configpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enum values to control quota checks for resources in terraform
// configuration files.
type QuotaValidation int32

const (
	// The default value.
	// QuotaValidation on terraform configuration files will be disabled in
	// this case.
	QuotaValidation_QUOTA_VALIDATION_UNSPECIFIED QuotaValidation = 0
	// Enable computing quotas for resources in terraform configuration files to
	// get visibility on resources with insufficient quotas.
	QuotaValidation_ENABLED QuotaValidation = 1
	// Enforce quota checks so deployment fails if there isn't sufficient quotas
	// available to deploy resources in terraform configuration files.
	QuotaValidation_ENFORCED QuotaValidation = 2
)

// Enum value maps for QuotaValidation.
var (
	QuotaValidation_name = map[int32]string{
		0: "QUOTA_VALIDATION_UNSPECIFIED",
		1: "ENABLED",
		2: "ENFORCED",
	}
	QuotaValidation_value = map[string]int32{
		"QUOTA_VALIDATION_UNSPECIFIED": 0,
		"ENABLED":                      1,
		"ENFORCED":                     2,
	}
)

func (x QuotaValidation) Enum() *QuotaValidation {
	p := new(QuotaValidation)
	*p = x
	return p
}

func (x QuotaValidation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (QuotaValidation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[0].Descriptor()
}

func (QuotaValidation) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[0]
}

func (x QuotaValidation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use QuotaValidation.Descriptor instead.
func (QuotaValidation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{0}
}

// Possible states of a deployment.
type Deployment_State int32

const (
	// The default value. This value is used if the state is omitted.
	Deployment_STATE_UNSPECIFIED Deployment_State = 0
	// The deployment is being created.
	Deployment_CREATING Deployment_State = 1
	// The deployment is healthy.
	Deployment_ACTIVE Deployment_State = 2
	// The deployment is being updated.
	Deployment_UPDATING Deployment_State = 3
	// The deployment is being deleted.
	Deployment_DELETING Deployment_State = 4
	// The deployment has encountered an unexpected error.
	Deployment_FAILED Deployment_State = 5
	// The deployment is no longer being actively reconciled.
	// This may be the result of recovering the project after deletion.
	Deployment_SUSPENDED Deployment_State = 6
	// The deployment has been deleted.
	Deployment_DELETED Deployment_State = 7
)

// Enum value maps for Deployment_State.
var (
	Deployment_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "ACTIVE",
		3: "UPDATING",
		4: "DELETING",
		5: "FAILED",
		6: "SUSPENDED",
		7: "DELETED",
	}
	Deployment_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"ACTIVE":            2,
		"UPDATING":          3,
		"DELETING":          4,
		"FAILED":            5,
		"SUSPENDED":         6,
		"DELETED":           7,
	}
)

func (x Deployment_State) Enum() *Deployment_State {
	p := new(Deployment_State)
	*p = x
	return p
}

func (x Deployment_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Deployment_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[1].Descriptor()
}

func (Deployment_State) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[1]
}

func (x Deployment_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Deployment_State.Descriptor instead.
func (Deployment_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{0, 0}
}

// Possible errors that can occur with deployments.
type Deployment_ErrorCode int32

const (
	// No error code was specified.
	Deployment_ERROR_CODE_UNSPECIFIED Deployment_ErrorCode = 0
	// The revision failed. See Revision for more details.
	Deployment_REVISION_FAILED Deployment_ErrorCode = 1
	// Cloud Build failed due to a permission issue.
	Deployment_CLOUD_BUILD_PERMISSION_DENIED Deployment_ErrorCode = 3
	// Cloud Build job associated with a deployment deletion could not be
	// started.
	Deployment_DELETE_BUILD_API_FAILED Deployment_ErrorCode = 5
	// Cloud Build job associated with a deployment deletion was started but
	// failed.
	Deployment_DELETE_BUILD_RUN_FAILED Deployment_ErrorCode = 6
	// Cloud Storage bucket creation failed due to a permission issue.
	Deployment_BUCKET_CREATION_PERMISSION_DENIED Deployment_ErrorCode = 7
	// Cloud Storage bucket creation failed due to an issue unrelated to
	// permissions.
	Deployment_BUCKET_CREATION_FAILED Deployment_ErrorCode = 8
)

// Enum value maps for Deployment_ErrorCode.
var (
	Deployment_ErrorCode_name = map[int32]string{
		0: "ERROR_CODE_UNSPECIFIED",
		1: "REVISION_FAILED",
		3: "CLOUD_BUILD_PERMISSION_DENIED",
		5: "DELETE_BUILD_API_FAILED",
		6: "DELETE_BUILD_RUN_FAILED",
		7: "BUCKET_CREATION_PERMISSION_DENIED",
		8: "BUCKET_CREATION_FAILED",
	}
	Deployment_ErrorCode_value = map[string]int32{
		"ERROR_CODE_UNSPECIFIED":            0,
		"REVISION_FAILED":                   1,
		"CLOUD_BUILD_PERMISSION_DENIED":     3,
		"DELETE_BUILD_API_FAILED":           5,
		"DELETE_BUILD_RUN_FAILED":           6,
		"BUCKET_CREATION_PERMISSION_DENIED": 7,
		"BUCKET_CREATION_FAILED":            8,
	}
)

func (x Deployment_ErrorCode) Enum() *Deployment_ErrorCode {
	p := new(Deployment_ErrorCode)
	*p = x
	return p
}

func (x Deployment_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Deployment_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[2].Descriptor()
}

func (Deployment_ErrorCode) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[2]
}

func (x Deployment_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Deployment_ErrorCode.Descriptor instead.
func (Deployment_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{0, 1}
}

// Possible lock states of a deployment.
type Deployment_LockState int32

const (
	// The default value. This value is used if the lock state is omitted.
	Deployment_LOCK_STATE_UNSPECIFIED Deployment_LockState = 0
	// The deployment is locked.
	Deployment_LOCKED Deployment_LockState = 1
	// The deployment is unlocked.
	Deployment_UNLOCKED Deployment_LockState = 2
	// The deployment is being locked.
	Deployment_LOCKING Deployment_LockState = 3
	// The deployment is being unlocked.
	Deployment_UNLOCKING Deployment_LockState = 4
	// The deployment has failed to lock.
	Deployment_LOCK_FAILED Deployment_LockState = 5
	// The deployment has failed to unlock.
	Deployment_UNLOCK_FAILED Deployment_LockState = 6
)

// Enum value maps for Deployment_LockState.
var (
	Deployment_LockState_name = map[int32]string{
		0: "LOCK_STATE_UNSPECIFIED",
		1: "LOCKED",
		2: "UNLOCKED",
		3: "LOCKING",
		4: "UNLOCKING",
		5: "LOCK_FAILED",
		6: "UNLOCK_FAILED",
	}
	Deployment_LockState_value = map[string]int32{
		"LOCK_STATE_UNSPECIFIED": 0,
		"LOCKED":                 1,
		"UNLOCKED":               2,
		"LOCKING":                3,
		"UNLOCKING":              4,
		"LOCK_FAILED":            5,
		"UNLOCK_FAILED":          6,
	}
)

func (x Deployment_LockState) Enum() *Deployment_LockState {
	p := new(Deployment_LockState)
	*p = x
	return p
}

func (x Deployment_LockState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Deployment_LockState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[3].Descriptor()
}

func (Deployment_LockState) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[3]
}

func (x Deployment_LockState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Deployment_LockState.Descriptor instead.
func (Deployment_LockState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{0, 2}
}

// Policy on how resources actuated by the deployment should be deleted.
type DeleteDeploymentRequest_DeletePolicy int32

const (
	// Unspecified policy, resources will be deleted.
	DeleteDeploymentRequest_DELETE_POLICY_UNSPECIFIED DeleteDeploymentRequest_DeletePolicy = 0
	// Deletes resources actuated by the deployment.
	DeleteDeploymentRequest_DELETE DeleteDeploymentRequest_DeletePolicy = 1
	// Abandons resources and only deletes the deployment and its metadata.
	DeleteDeploymentRequest_ABANDON DeleteDeploymentRequest_DeletePolicy = 2
)

// Enum value maps for DeleteDeploymentRequest_DeletePolicy.
var (
	DeleteDeploymentRequest_DeletePolicy_name = map[int32]string{
		0: "DELETE_POLICY_UNSPECIFIED",
		1: "DELETE",
		2: "ABANDON",
	}
	DeleteDeploymentRequest_DeletePolicy_value = map[string]int32{
		"DELETE_POLICY_UNSPECIFIED": 0,
		"DELETE":                    1,
		"ABANDON":                   2,
	}
)

func (x DeleteDeploymentRequest_DeletePolicy) Enum() *DeleteDeploymentRequest_DeletePolicy {
	p := new(DeleteDeploymentRequest_DeletePolicy)
	*p = x
	return p
}

func (x DeleteDeploymentRequest_DeletePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeleteDeploymentRequest_DeletePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[4].Descriptor()
}

func (DeleteDeploymentRequest_DeletePolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[4]
}

func (x DeleteDeploymentRequest_DeletePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeleteDeploymentRequest_DeletePolicy.Descriptor instead.
func (DeleteDeploymentRequest_DeletePolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{13, 0}
}

// Actions that generate a revision.
type Revision_Action int32

const (
	// The default value. This value is used if the action is omitted.
	Revision_ACTION_UNSPECIFIED Revision_Action = 0
	// The revision was generated by creating a deployment.
	Revision_CREATE Revision_Action = 1
	// The revision was generated by updating a deployment.
	Revision_UPDATE Revision_Action = 2
	// The revision was deleted.
	Revision_DELETE Revision_Action = 3
)

// Enum value maps for Revision_Action.
var (
	Revision_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "CREATE",
		2: "UPDATE",
		3: "DELETE",
	}
	Revision_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"CREATE":             1,
		"UPDATE":             2,
		"DELETE":             3,
	}
)

func (x Revision_Action) Enum() *Revision_Action {
	p := new(Revision_Action)
	*p = x
	return p
}

func (x Revision_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Revision_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[5].Descriptor()
}

func (Revision_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[5]
}

func (x Revision_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Revision_Action.Descriptor instead.
func (Revision_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{15, 0}
}

// Possible states of a revision.
type Revision_State int32

const (
	// The default value. This value is used if the state is omitted.
	Revision_STATE_UNSPECIFIED Revision_State = 0
	// The revision is being applied.
	Revision_APPLYING Revision_State = 1
	// The revision was applied successfully.
	Revision_APPLIED Revision_State = 2
	// The revision could not be applied successfully.
	Revision_FAILED Revision_State = 3
)

// Enum value maps for Revision_State.
var (
	Revision_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "APPLYING",
		2: "APPLIED",
		3: "FAILED",
	}
	Revision_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"APPLYING":          1,
		"APPLIED":           2,
		"FAILED":            3,
	}
)

func (x Revision_State) Enum() *Revision_State {
	p := new(Revision_State)
	*p = x
	return p
}

func (x Revision_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Revision_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[6].Descriptor()
}

func (Revision_State) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[6]
}

func (x Revision_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Revision_State.Descriptor instead.
func (Revision_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{15, 1}
}

// Possible errors if Revision could not be created or updated successfully.
type Revision_ErrorCode int32

const (
	// No error code was specified.
	Revision_ERROR_CODE_UNSPECIFIED Revision_ErrorCode = 0
	// Cloud Build failed due to a permission issue.
	Revision_CLOUD_BUILD_PERMISSION_DENIED Revision_ErrorCode = 1
	// Cloud Build job associated with creating or updating a deployment could
	// not be started.
	Revision_APPLY_BUILD_API_FAILED Revision_ErrorCode = 4
	// Cloud Build job associated with creating or updating a deployment was
	// started but failed.
	Revision_APPLY_BUILD_RUN_FAILED Revision_ErrorCode = 5
	// quota validation failed for one or more resources in terraform
	// configuration files.
	Revision_QUOTA_VALIDATION_FAILED Revision_ErrorCode = 7
)

// Enum value maps for Revision_ErrorCode.
var (
	Revision_ErrorCode_name = map[int32]string{
		0: "ERROR_CODE_UNSPECIFIED",
		1: "CLOUD_BUILD_PERMISSION_DENIED",
		4: "APPLY_BUILD_API_FAILED",
		5: "APPLY_BUILD_RUN_FAILED",
		7: "QUOTA_VALIDATION_FAILED",
	}
	Revision_ErrorCode_value = map[string]int32{
		"ERROR_CODE_UNSPECIFIED":        0,
		"CLOUD_BUILD_PERMISSION_DENIED": 1,
		"APPLY_BUILD_API_FAILED":        4,
		"APPLY_BUILD_RUN_FAILED":        5,
		"QUOTA_VALIDATION_FAILED":       7,
	}
)

func (x Revision_ErrorCode) Enum() *Revision_ErrorCode {
	p := new(Revision_ErrorCode)
	*p = x
	return p
}

func (x Revision_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Revision_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[7].Descriptor()
}

func (Revision_ErrorCode) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[7]
}

func (x Revision_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Revision_ErrorCode.Descriptor instead.
func (Revision_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{15, 2}
}

// The possible steps a deployment may be running.
type DeploymentOperationMetadata_DeploymentStep int32

const (
	// Unspecified deployment step
	DeploymentOperationMetadata_DEPLOYMENT_STEP_UNSPECIFIED DeploymentOperationMetadata_DeploymentStep = 0
	// Infra Manager is creating a Google Cloud Storage bucket to store
	// artifacts and metadata about the deployment and revision
	DeploymentOperationMetadata_PREPARING_STORAGE_BUCKET DeploymentOperationMetadata_DeploymentStep = 1
	// Downloading the blueprint onto the Google Cloud Storage bucket
	DeploymentOperationMetadata_DOWNLOADING_BLUEPRINT DeploymentOperationMetadata_DeploymentStep = 2
	// Initializing Terraform using `terraform init`
	DeploymentOperationMetadata_RUNNING_TF_INIT DeploymentOperationMetadata_DeploymentStep = 3
	// Running `terraform plan`
	DeploymentOperationMetadata_RUNNING_TF_PLAN DeploymentOperationMetadata_DeploymentStep = 4
	// Actuating resources using Terraform using `terraform apply`
	DeploymentOperationMetadata_RUNNING_TF_APPLY DeploymentOperationMetadata_DeploymentStep = 5
	// Destroying resources using Terraform using `terraform destroy`
	DeploymentOperationMetadata_RUNNING_TF_DESTROY DeploymentOperationMetadata_DeploymentStep = 6
	// Validating the uploaded TF state file when unlocking a deployment
	DeploymentOperationMetadata_RUNNING_TF_VALIDATE DeploymentOperationMetadata_DeploymentStep = 7
	// Unlocking a deployment
	DeploymentOperationMetadata_UNLOCKING_DEPLOYMENT DeploymentOperationMetadata_DeploymentStep = 8
	// Operation was successful
	DeploymentOperationMetadata_SUCCEEDED DeploymentOperationMetadata_DeploymentStep = 9
	// Operation failed
	DeploymentOperationMetadata_FAILED DeploymentOperationMetadata_DeploymentStep = 10
	// Validating the provided repository.
	DeploymentOperationMetadata_VALIDATING_REPOSITORY DeploymentOperationMetadata_DeploymentStep = 11
	// Running quota validation
	DeploymentOperationMetadata_RUNNING_QUOTA_VALIDATION DeploymentOperationMetadata_DeploymentStep = 12
)

// Enum value maps for DeploymentOperationMetadata_DeploymentStep.
var (
	DeploymentOperationMetadata_DeploymentStep_name = map[int32]string{
		0:  "DEPLOYMENT_STEP_UNSPECIFIED",
		1:  "PREPARING_STORAGE_BUCKET",
		2:  "DOWNLOADING_BLUEPRINT",
		3:  "RUNNING_TF_INIT",
		4:  "RUNNING_TF_PLAN",
		5:  "RUNNING_TF_APPLY",
		6:  "RUNNING_TF_DESTROY",
		7:  "RUNNING_TF_VALIDATE",
		8:  "UNLOCKING_DEPLOYMENT",
		9:  "SUCCEEDED",
		10: "FAILED",
		11: "VALIDATING_REPOSITORY",
		12: "RUNNING_QUOTA_VALIDATION",
	}
	DeploymentOperationMetadata_DeploymentStep_value = map[string]int32{
		"DEPLOYMENT_STEP_UNSPECIFIED": 0,
		"PREPARING_STORAGE_BUCKET":    1,
		"DOWNLOADING_BLUEPRINT":       2,
		"RUNNING_TF_INIT":             3,
		"RUNNING_TF_PLAN":             4,
		"RUNNING_TF_APPLY":            5,
		"RUNNING_TF_DESTROY":          6,
		"RUNNING_TF_VALIDATE":         7,
		"UNLOCKING_DEPLOYMENT":        8,
		"SUCCEEDED":                   9,
		"FAILED":                      10,
		"VALIDATING_REPOSITORY":       11,
		"RUNNING_QUOTA_VALIDATION":    12,
	}
)

func (x DeploymentOperationMetadata_DeploymentStep) Enum() *DeploymentOperationMetadata_DeploymentStep {
	p := new(DeploymentOperationMetadata_DeploymentStep)
	*p = x
	return p
}

func (x DeploymentOperationMetadata_DeploymentStep) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DeploymentOperationMetadata_DeploymentStep) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[8].Descriptor()
}

func (DeploymentOperationMetadata_DeploymentStep) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[8]
}

func (x DeploymentOperationMetadata_DeploymentStep) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DeploymentOperationMetadata_DeploymentStep.Descriptor instead.
func (DeploymentOperationMetadata_DeploymentStep) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{18, 0}
}

// Possible intent of the resource.
type Resource_Intent int32

const (
	// The default value. This value is used if the intent is omitted.
	Resource_INTENT_UNSPECIFIED Resource_Intent = 0
	// Infra Manager will create this Resource.
	Resource_CREATE Resource_Intent = 1
	// Infra Manager will update this Resource.
	Resource_UPDATE Resource_Intent = 2
	// Infra Manager will delete this Resource.
	Resource_DELETE Resource_Intent = 3
	// Infra Manager will destroy and recreate this Resource.
	Resource_RECREATE Resource_Intent = 4
	// Infra Manager will leave this Resource untouched.
	Resource_UNCHANGED Resource_Intent = 5
)

// Enum value maps for Resource_Intent.
var (
	Resource_Intent_name = map[int32]string{
		0: "INTENT_UNSPECIFIED",
		1: "CREATE",
		2: "UPDATE",
		3: "DELETE",
		4: "RECREATE",
		5: "UNCHANGED",
	}
	Resource_Intent_value = map[string]int32{
		"INTENT_UNSPECIFIED": 0,
		"CREATE":             1,
		"UPDATE":             2,
		"DELETE":             3,
		"RECREATE":           4,
		"UNCHANGED":          5,
	}
)

func (x Resource_Intent) Enum() *Resource_Intent {
	p := new(Resource_Intent)
	*p = x
	return p
}

func (x Resource_Intent) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Resource_Intent) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[9].Descriptor()
}

func (Resource_Intent) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[9]
}

func (x Resource_Intent) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Resource_Intent.Descriptor instead.
func (Resource_Intent) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{19, 0}
}

// Possible states of a resource.
type Resource_State int32

const (
	// The default value. This value is used if the state is omitted.
	Resource_STATE_UNSPECIFIED Resource_State = 0
	// Resource has been planned for reconcile.
	Resource_PLANNED Resource_State = 1
	// Resource is actively reconciling into the intended state.
	Resource_IN_PROGRESS Resource_State = 2
	// Resource has reconciled to intended state.
	Resource_RECONCILED Resource_State = 3
	// Resource failed to reconcile.
	Resource_FAILED Resource_State = 4
)

// Enum value maps for Resource_State.
var (
	Resource_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PLANNED",
		2: "IN_PROGRESS",
		3: "RECONCILED",
		4: "FAILED",
	}
	Resource_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PLANNED":           1,
		"IN_PROGRESS":       2,
		"RECONCILED":        3,
		"FAILED":            4,
	}
)

func (x Resource_State) Enum() *Resource_State {
	p := new(Resource_State)
	*p = x
	return p
}

func (x Resource_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Resource_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[10].Descriptor()
}

func (Resource_State) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[10]
}

func (x Resource_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Resource_State.Descriptor instead.
func (Resource_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{19, 1}
}

// Possible states of a preview.
type Preview_State int32

const (
	// The default value. This value is used if the state is unknown.
	Preview_STATE_UNSPECIFIED Preview_State = 0
	// The preview is being created.
	Preview_CREATING Preview_State = 1
	// The preview has succeeded.
	Preview_SUCCEEDED Preview_State = 2
	// The preview is being applied.
	Preview_APPLYING Preview_State = 3
	// The preview is stale. A preview can become stale if a revision has been
	// applied after this preview was created.
	Preview_STALE Preview_State = 4
	// The preview is being deleted.
	Preview_DELETING Preview_State = 5
	// The preview has encountered an unexpected error.
	Preview_FAILED Preview_State = 6
	// The preview has been deleted.
	Preview_DELETED Preview_State = 7
)

// Enum value maps for Preview_State.
var (
	Preview_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "SUCCEEDED",
		3: "APPLYING",
		4: "STALE",
		5: "DELETING",
		6: "FAILED",
		7: "DELETED",
	}
	Preview_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"SUCCEEDED":         2,
		"APPLYING":          3,
		"STALE":             4,
		"DELETING":          5,
		"FAILED":            6,
		"DELETED":           7,
	}
)

func (x Preview_State) Enum() *Preview_State {
	p := new(Preview_State)
	*p = x
	return p
}

func (x Preview_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Preview_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[11].Descriptor()
}

func (Preview_State) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[11]
}

func (x Preview_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Preview_State.Descriptor instead.
func (Preview_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{34, 0}
}

// Preview mode provides options for customizing preview operations.
type Preview_PreviewMode int32

const (
	// Unspecified policy, default mode will be used.
	Preview_PREVIEW_MODE_UNSPECIFIED Preview_PreviewMode = 0
	// DEFAULT mode generates an execution plan for reconciling current resource
	// state into expected resource state.
	Preview_DEFAULT Preview_PreviewMode = 1
	// DELETE mode generates as execution plan for destroying current resources.
	Preview_DELETE Preview_PreviewMode = 2
)

// Enum value maps for Preview_PreviewMode.
var (
	Preview_PreviewMode_name = map[int32]string{
		0: "PREVIEW_MODE_UNSPECIFIED",
		1: "DEFAULT",
		2: "DELETE",
	}
	Preview_PreviewMode_value = map[string]int32{
		"PREVIEW_MODE_UNSPECIFIED": 0,
		"DEFAULT":                  1,
		"DELETE":                   2,
	}
)

func (x Preview_PreviewMode) Enum() *Preview_PreviewMode {
	p := new(Preview_PreviewMode)
	*p = x
	return p
}

func (x Preview_PreviewMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Preview_PreviewMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[12].Descriptor()
}

func (Preview_PreviewMode) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[12]
}

func (x Preview_PreviewMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Preview_PreviewMode.Descriptor instead.
func (Preview_PreviewMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{34, 1}
}

// Possible errors that can occur with previews.
type Preview_ErrorCode int32

const (
	// No error code was specified.
	Preview_ERROR_CODE_UNSPECIFIED Preview_ErrorCode = 0
	// Cloud Build failed due to a permissions issue.
	Preview_CLOUD_BUILD_PERMISSION_DENIED Preview_ErrorCode = 1
	// Cloud Storage bucket failed to create due to a permissions issue.
	Preview_BUCKET_CREATION_PERMISSION_DENIED Preview_ErrorCode = 2
	// Cloud Storage bucket failed for a non-permissions-related issue.
	Preview_BUCKET_CREATION_FAILED Preview_ErrorCode = 3
	// Acquiring lock on provided deployment reference failed.
	Preview_DEPLOYMENT_LOCK_ACQUIRE_FAILED Preview_ErrorCode = 4
	// Preview encountered an error when trying to access Cloud Build API.
	Preview_PREVIEW_BUILD_API_FAILED Preview_ErrorCode = 5
	// Preview created a build but build failed and logs were generated.
	Preview_PREVIEW_BUILD_RUN_FAILED Preview_ErrorCode = 6
)

// Enum value maps for Preview_ErrorCode.
var (
	Preview_ErrorCode_name = map[int32]string{
		0: "ERROR_CODE_UNSPECIFIED",
		1: "CLOUD_BUILD_PERMISSION_DENIED",
		2: "BUCKET_CREATION_PERMISSION_DENIED",
		3: "BUCKET_CREATION_FAILED",
		4: "DEPLOYMENT_LOCK_ACQUIRE_FAILED",
		5: "PREVIEW_BUILD_API_FAILED",
		6: "PREVIEW_BUILD_RUN_FAILED",
	}
	Preview_ErrorCode_value = map[string]int32{
		"ERROR_CODE_UNSPECIFIED":            0,
		"CLOUD_BUILD_PERMISSION_DENIED":     1,
		"BUCKET_CREATION_PERMISSION_DENIED": 2,
		"BUCKET_CREATION_FAILED":            3,
		"DEPLOYMENT_LOCK_ACQUIRE_FAILED":    4,
		"PREVIEW_BUILD_API_FAILED":          5,
		"PREVIEW_BUILD_RUN_FAILED":          6,
	}
)

func (x Preview_ErrorCode) Enum() *Preview_ErrorCode {
	p := new(Preview_ErrorCode)
	*p = x
	return p
}

func (x Preview_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Preview_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[13].Descriptor()
}

func (Preview_ErrorCode) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[13]
}

func (x Preview_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Preview_ErrorCode.Descriptor instead.
func (Preview_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{34, 2}
}

// The possible steps a preview may be running.
type PreviewOperationMetadata_PreviewStep int32

const (
	// Unspecified preview step.
	PreviewOperationMetadata_PREVIEW_STEP_UNSPECIFIED PreviewOperationMetadata_PreviewStep = 0
	// Infra Manager is creating a Google Cloud Storage bucket to store
	// artifacts and metadata about the preview.
	PreviewOperationMetadata_PREPARING_STORAGE_BUCKET PreviewOperationMetadata_PreviewStep = 1
	// Downloading the blueprint onto the Google Cloud Storage bucket.
	PreviewOperationMetadata_DOWNLOADING_BLUEPRINT PreviewOperationMetadata_PreviewStep = 2
	// Initializing Terraform using `terraform init`.
	PreviewOperationMetadata_RUNNING_TF_INIT PreviewOperationMetadata_PreviewStep = 3
	// Running `terraform plan`.
	PreviewOperationMetadata_RUNNING_TF_PLAN PreviewOperationMetadata_PreviewStep = 4
	// Fetching a deployment.
	PreviewOperationMetadata_FETCHING_DEPLOYMENT PreviewOperationMetadata_PreviewStep = 5
	// Locking a deployment.
	PreviewOperationMetadata_LOCKING_DEPLOYMENT PreviewOperationMetadata_PreviewStep = 6
	// Unlocking a deployment.
	PreviewOperationMetadata_UNLOCKING_DEPLOYMENT PreviewOperationMetadata_PreviewStep = 7
	// Operation was successful.
	PreviewOperationMetadata_SUCCEEDED PreviewOperationMetadata_PreviewStep = 8
	// Operation failed.
	PreviewOperationMetadata_FAILED PreviewOperationMetadata_PreviewStep = 9
	// Validating the provided repository.
	PreviewOperationMetadata_VALIDATING_REPOSITORY PreviewOperationMetadata_PreviewStep = 10
)

// Enum value maps for PreviewOperationMetadata_PreviewStep.
var (
	PreviewOperationMetadata_PreviewStep_name = map[int32]string{
		0:  "PREVIEW_STEP_UNSPECIFIED",
		1:  "PREPARING_STORAGE_BUCKET",
		2:  "DOWNLOADING_BLUEPRINT",
		3:  "RUNNING_TF_INIT",
		4:  "RUNNING_TF_PLAN",
		5:  "FETCHING_DEPLOYMENT",
		6:  "LOCKING_DEPLOYMENT",
		7:  "UNLOCKING_DEPLOYMENT",
		8:  "SUCCEEDED",
		9:  "FAILED",
		10: "VALIDATING_REPOSITORY",
	}
	PreviewOperationMetadata_PreviewStep_value = map[string]int32{
		"PREVIEW_STEP_UNSPECIFIED": 0,
		"PREPARING_STORAGE_BUCKET": 1,
		"DOWNLOADING_BLUEPRINT":    2,
		"RUNNING_TF_INIT":          3,
		"RUNNING_TF_PLAN":          4,
		"FETCHING_DEPLOYMENT":      5,
		"LOCKING_DEPLOYMENT":       6,
		"UNLOCKING_DEPLOYMENT":     7,
		"SUCCEEDED":                8,
		"FAILED":                   9,
		"VALIDATING_REPOSITORY":    10,
	}
)

func (x PreviewOperationMetadata_PreviewStep) Enum() *PreviewOperationMetadata_PreviewStep {
	p := new(PreviewOperationMetadata_PreviewStep)
	*p = x
	return p
}

func (x PreviewOperationMetadata_PreviewStep) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PreviewOperationMetadata_PreviewStep) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[14].Descriptor()
}

func (PreviewOperationMetadata_PreviewStep) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[14]
}

func (x PreviewOperationMetadata_PreviewStep) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PreviewOperationMetadata_PreviewStep.Descriptor instead.
func (PreviewOperationMetadata_PreviewStep) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{35, 0}
}

// Possible states of a TerraformVersion.
type TerraformVersion_State int32

const (
	// The default value. This value is used if the state is omitted.
	TerraformVersion_STATE_UNSPECIFIED TerraformVersion_State = 0
	// The version is actively supported.
	TerraformVersion_ACTIVE TerraformVersion_State = 1
	// The version is deprecated.
	TerraformVersion_DEPRECATED TerraformVersion_State = 2
	// The version is obsolete.
	TerraformVersion_OBSOLETE TerraformVersion_State = 3
)

// Enum value maps for TerraformVersion_State.
var (
	TerraformVersion_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "ACTIVE",
		2: "DEPRECATED",
		3: "OBSOLETE",
	}
	TerraformVersion_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"ACTIVE":            1,
		"DEPRECATED":        2,
		"OBSOLETE":          3,
	}
)

func (x TerraformVersion_State) Enum() *TerraformVersion_State {
	p := new(TerraformVersion_State)
	*p = x
	return p
}

func (x TerraformVersion_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TerraformVersion_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_config_v1_config_proto_enumTypes[15].Descriptor()
}

func (TerraformVersion_State) Type() protoreflect.EnumType {
	return &file_google_cloud_config_v1_config_proto_enumTypes[15]
}

func (x TerraformVersion_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TerraformVersion_State.Descriptor instead.
func (TerraformVersion_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{48, 0}
}

// A Deployment is a group of resources and configs managed and provisioned by
// Infra Manager.
type Deployment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Blueprint to deploy.
	//
	// Types that are assignable to Blueprint:
	//
	//	*Deployment_TerraformBlueprint
	Blueprint isDeployment_Blueprint `protobuf_oneof:"blueprint"`
	// Resource name of the deployment.
	// Format: `projects/{project}/locations/{location}/deployments/{deployment}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when the deployment was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the deployment was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-defined metadata for the deployment.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Current state of the deployment.
	State Deployment_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.config.v1.Deployment_State" json:"state,omitempty"`
	// Output only. Revision name that was most recently applied.
	// Format: `projects/{project}/locations/{location}/deployments/{deployment}/
	// revisions/{revision}`
	LatestRevision string `protobuf:"bytes,7,opt,name=latest_revision,json=latestRevision,proto3" json:"latest_revision,omitempty"`
	// Output only. Additional information regarding the current state.
	StateDetail string `protobuf:"bytes,9,opt,name=state_detail,json=stateDetail,proto3" json:"state_detail,omitempty"`
	// Output only. Error code describing errors that may have occurred.
	ErrorCode Deployment_ErrorCode `protobuf:"varint,10,opt,name=error_code,json=errorCode,proto3,enum=google.cloud.config.v1.Deployment_ErrorCode" json:"error_code,omitempty"`
	// Output only. Location of artifacts from a DeleteDeployment operation.
	DeleteResults *ApplyResults `protobuf:"bytes,8,opt,name=delete_results,json=deleteResults,proto3" json:"delete_results,omitempty"`
	// Output only. Cloud Build instance UUID associated with deleting this
	// deployment.
	DeleteBuild string `protobuf:"bytes,11,opt,name=delete_build,json=deleteBuild,proto3" json:"delete_build,omitempty"`
	// Output only. Location of Cloud Build logs in Google Cloud Storage,
	// populated when deleting this deployment. Format: `gs://{bucket}/{object}`.
	DeleteLogs string `protobuf:"bytes,12,opt,name=delete_logs,json=deleteLogs,proto3" json:"delete_logs,omitempty"`
	// Output only. Errors encountered when deleting this deployment.
	// Errors are truncated to 10 entries, see `delete_results` and `error_logs`
	// for full details.
	TfErrors []*TerraformError `protobuf:"bytes,13,rep,name=tf_errors,json=tfErrors,proto3" json:"tf_errors,omitempty"`
	// Output only. Location of Terraform error logs in Google Cloud Storage.
	// Format: `gs://{bucket}/{object}`.
	ErrorLogs string `protobuf:"bytes,14,opt,name=error_logs,json=errorLogs,proto3" json:"error_logs,omitempty"`
	// Optional. User-defined location of Cloud Build logs and artifacts in Google
	// Cloud Storage. Format: `gs://{bucket}/{folder}`
	//
	// A default bucket will be bootstrapped if the field is not set or empty.
	// Default bucket format: `gs://<project number>-<region>-blueprint-config`
	// Constraints:
	// - The bucket needs to be in the same project as the deployment
	// - The path cannot be within the path of `gcs_source`
	// - The field cannot be updated, including changing its presence
	ArtifactsGcsBucket *string `protobuf:"bytes,15,opt,name=artifacts_gcs_bucket,json=artifactsGcsBucket,proto3,oneof" json:"artifacts_gcs_bucket,omitempty"`
	// Optional. User-specified Service Account (SA) credentials to be used when
	// actuating resources.
	// Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
	ServiceAccount *string `protobuf:"bytes,16,opt,name=service_account,json=serviceAccount,proto3,oneof" json:"service_account,omitempty"`
	// By default, Infra Manager will return a failure when
	// Terraform encounters a 409 code (resource conflict error) during actuation.
	// If this flag is set to true, Infra Manager will instead
	// attempt to automatically import the resource into the Terraform state (for
	// supported resource types) and continue actuation.
	//
	// Not all resource types are supported, refer to documentation.
	ImportExistingResources *bool `protobuf:"varint,17,opt,name=import_existing_resources,json=importExistingResources,proto3,oneof" json:"import_existing_resources,omitempty"`
	// Optional. The user-specified Cloud Build worker pool resource in which the
	// Cloud Build job will execute. Format:
	// `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
	// If this field is unspecified, the default Cloud Build worker pool will be
	// used.
	WorkerPool *string `protobuf:"bytes,19,opt,name=worker_pool,json=workerPool,proto3,oneof" json:"worker_pool,omitempty"`
	// Output only. Current lock state of the deployment.
	LockState Deployment_LockState `protobuf:"varint,20,opt,name=lock_state,json=lockState,proto3,enum=google.cloud.config.v1.Deployment_LockState" json:"lock_state,omitempty"`
	// Optional. The user-specified Terraform version constraint.
	// Example: "=1.3.10".
	TfVersionConstraint *string `protobuf:"bytes,21,opt,name=tf_version_constraint,json=tfVersionConstraint,proto3,oneof" json:"tf_version_constraint,omitempty"`
	// Output only. The current Terraform version set on the deployment.
	// It is in the format of "Major.Minor.Patch", for example, "1.3.10".
	TfVersion string `protobuf:"bytes,22,opt,name=tf_version,json=tfVersion,proto3" json:"tf_version,omitempty"`
	// Optional. Input to control quota checks for resources in terraform
	// configuration files. There are limited resources on which quota validation
	// applies.
	QuotaValidation QuotaValidation `protobuf:"varint,23,opt,name=quota_validation,json=quotaValidation,proto3,enum=google.cloud.config.v1.QuotaValidation" json:"quota_validation,omitempty"`
	// Optional. Arbitrary key-value metadata storage e.g. to help client tools
	// identify deployments during automation. See
	// https://google.aip.dev/148#annotations for details on format and size
	// limitations.
	Annotations map[string]string `protobuf:"bytes,24,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Deployment) Reset() {
	*x = Deployment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Deployment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Deployment) ProtoMessage() {}

func (x *Deployment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Deployment.ProtoReflect.Descriptor instead.
func (*Deployment) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{0}
}

func (m *Deployment) GetBlueprint() isDeployment_Blueprint {
	if m != nil {
		return m.Blueprint
	}
	return nil
}

func (x *Deployment) GetTerraformBlueprint() *TerraformBlueprint {
	if x, ok := x.GetBlueprint().(*Deployment_TerraformBlueprint); ok {
		return x.TerraformBlueprint
	}
	return nil
}

func (x *Deployment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Deployment) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Deployment) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Deployment) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Deployment) GetState() Deployment_State {
	if x != nil {
		return x.State
	}
	return Deployment_STATE_UNSPECIFIED
}

func (x *Deployment) GetLatestRevision() string {
	if x != nil {
		return x.LatestRevision
	}
	return ""
}

func (x *Deployment) GetStateDetail() string {
	if x != nil {
		return x.StateDetail
	}
	return ""
}

func (x *Deployment) GetErrorCode() Deployment_ErrorCode {
	if x != nil {
		return x.ErrorCode
	}
	return Deployment_ERROR_CODE_UNSPECIFIED
}

func (x *Deployment) GetDeleteResults() *ApplyResults {
	if x != nil {
		return x.DeleteResults
	}
	return nil
}

func (x *Deployment) GetDeleteBuild() string {
	if x != nil {
		return x.DeleteBuild
	}
	return ""
}

func (x *Deployment) GetDeleteLogs() string {
	if x != nil {
		return x.DeleteLogs
	}
	return ""
}

func (x *Deployment) GetTfErrors() []*TerraformError {
	if x != nil {
		return x.TfErrors
	}
	return nil
}

func (x *Deployment) GetErrorLogs() string {
	if x != nil {
		return x.ErrorLogs
	}
	return ""
}

func (x *Deployment) GetArtifactsGcsBucket() string {
	if x != nil && x.ArtifactsGcsBucket != nil {
		return *x.ArtifactsGcsBucket
	}
	return ""
}

func (x *Deployment) GetServiceAccount() string {
	if x != nil && x.ServiceAccount != nil {
		return *x.ServiceAccount
	}
	return ""
}

func (x *Deployment) GetImportExistingResources() bool {
	if x != nil && x.ImportExistingResources != nil {
		return *x.ImportExistingResources
	}
	return false
}

func (x *Deployment) GetWorkerPool() string {
	if x != nil && x.WorkerPool != nil {
		return *x.WorkerPool
	}
	return ""
}

func (x *Deployment) GetLockState() Deployment_LockState {
	if x != nil {
		return x.LockState
	}
	return Deployment_LOCK_STATE_UNSPECIFIED
}

func (x *Deployment) GetTfVersionConstraint() string {
	if x != nil && x.TfVersionConstraint != nil {
		return *x.TfVersionConstraint
	}
	return ""
}

func (x *Deployment) GetTfVersion() string {
	if x != nil {
		return x.TfVersion
	}
	return ""
}

func (x *Deployment) GetQuotaValidation() QuotaValidation {
	if x != nil {
		return x.QuotaValidation
	}
	return QuotaValidation_QUOTA_VALIDATION_UNSPECIFIED
}

func (x *Deployment) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

type isDeployment_Blueprint interface {
	isDeployment_Blueprint()
}

type Deployment_TerraformBlueprint struct {
	// A blueprint described using Terraform's HashiCorp Configuration Language
	// as a root module.
	TerraformBlueprint *TerraformBlueprint `protobuf:"bytes,6,opt,name=terraform_blueprint,json=terraformBlueprint,proto3,oneof"`
}

func (*Deployment_TerraformBlueprint) isDeployment_Blueprint() {}

// TerraformBlueprint describes the source of a Terraform root module which
// describes the resources and configs to be deployed.
type TerraformBlueprint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of the source configs.
	//
	// Types that are assignable to Source:
	//
	//	*TerraformBlueprint_GcsSource
	//	*TerraformBlueprint_GitSource
	Source isTerraformBlueprint_Source `protobuf_oneof:"source"`
	// Input variable values for the Terraform blueprint.
	InputValues map[string]*TerraformVariable `protobuf:"bytes,4,rep,name=input_values,json=inputValues,proto3" json:"input_values,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TerraformBlueprint) Reset() {
	*x = TerraformBlueprint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TerraformBlueprint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TerraformBlueprint) ProtoMessage() {}

func (x *TerraformBlueprint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TerraformBlueprint.ProtoReflect.Descriptor instead.
func (*TerraformBlueprint) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{1}
}

func (m *TerraformBlueprint) GetSource() isTerraformBlueprint_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *TerraformBlueprint) GetGcsSource() string {
	if x, ok := x.GetSource().(*TerraformBlueprint_GcsSource); ok {
		return x.GcsSource
	}
	return ""
}

func (x *TerraformBlueprint) GetGitSource() *GitSource {
	if x, ok := x.GetSource().(*TerraformBlueprint_GitSource); ok {
		return x.GitSource
	}
	return nil
}

func (x *TerraformBlueprint) GetInputValues() map[string]*TerraformVariable {
	if x != nil {
		return x.InputValues
	}
	return nil
}

type isTerraformBlueprint_Source interface {
	isTerraformBlueprint_Source()
}

type TerraformBlueprint_GcsSource struct {
	// Required. URI of an object in Google Cloud Storage.
	// Format: `gs://{bucket}/{object}`
	//
	// URI may also specify an object version for zipped objects.
	// Format: `gs://{bucket}/{object}#{version}`
	GcsSource string `protobuf:"bytes,1,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type TerraformBlueprint_GitSource struct {
	// Required. URI of a public Git repo.
	GitSource *GitSource `protobuf:"bytes,2,opt,name=git_source,json=gitSource,proto3,oneof"`
}

func (*TerraformBlueprint_GcsSource) isTerraformBlueprint_Source() {}

func (*TerraformBlueprint_GitSource) isTerraformBlueprint_Source() {}

// A Terraform input variable.
type TerraformVariable struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Input variable value.
	InputValue *structpb.Value `protobuf:"bytes,5,opt,name=input_value,json=inputValue,proto3" json:"input_value,omitempty"`
}

func (x *TerraformVariable) Reset() {
	*x = TerraformVariable{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TerraformVariable) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TerraformVariable) ProtoMessage() {}

func (x *TerraformVariable) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TerraformVariable.ProtoReflect.Descriptor instead.
func (*TerraformVariable) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{2}
}

func (x *TerraformVariable) GetInputValue() *structpb.Value {
	if x != nil {
		return x.InputValue
	}
	return nil
}

// Outputs and artifacts from applying a deployment.
type ApplyResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Location of a blueprint copy and other manifests in Google Cloud Storage.
	// Format: `gs://{bucket}/{object}`
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Location of artifacts (e.g. logs) in Google Cloud Storage.
	// Format: `gs://{bucket}/{object}`
	Artifacts string `protobuf:"bytes,2,opt,name=artifacts,proto3" json:"artifacts,omitempty"`
	// Map of output name to output info.
	Outputs map[string]*TerraformOutput `protobuf:"bytes,3,rep,name=outputs,proto3" json:"outputs,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ApplyResults) Reset() {
	*x = ApplyResults{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyResults) ProtoMessage() {}

func (x *ApplyResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyResults.ProtoReflect.Descriptor instead.
func (*ApplyResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{3}
}

func (x *ApplyResults) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *ApplyResults) GetArtifacts() string {
	if x != nil {
		return x.Artifacts
	}
	return ""
}

func (x *ApplyResults) GetOutputs() map[string]*TerraformOutput {
	if x != nil {
		return x.Outputs
	}
	return nil
}

// Describes a Terraform output.
type TerraformOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifies whether Terraform has set this output as a potential
	// sensitive value.
	Sensitive bool `protobuf:"varint,1,opt,name=sensitive,proto3" json:"sensitive,omitempty"`
	// Value of output.
	Value *structpb.Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *TerraformOutput) Reset() {
	*x = TerraformOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TerraformOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TerraformOutput) ProtoMessage() {}

func (x *TerraformOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TerraformOutput.ProtoReflect.Descriptor instead.
func (*TerraformOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{4}
}

func (x *TerraformOutput) GetSensitive() bool {
	if x != nil {
		return x.Sensitive
	}
	return false
}

func (x *TerraformOutput) GetValue() *structpb.Value {
	if x != nil {
		return x.Value
	}
	return nil
}

type ListDeploymentsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the Deployments are listed. The
	// parent value is in the format:
	// 'projects/{project_id}/locations/{location}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// When requesting a page of resources, 'page_size' specifies number of
	// resources to return. If unspecified, at most 500 will be returned. The
	// maximum value is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token returned by previous call to 'ListDeployments' which specifies the
	// position in the list from where to continue listing the resources.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Lists the Deployments that match the filter expression. A filter
	// expression filters the resources listed in the response. The expression
	// must be of the form '{field} {operator} {value}' where operators: '<', '>',
	// '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
	// operator which is roughly synonymous with equality). {field} can refer to a
	// proto or JSON field, or a synthetic field. Field names can be camelCase or
	// snake_case.
	//
	// Examples:
	//   - Filter by name:
	//     name = "projects/foo/locations/us-central1/deployments/bar
	//
	// - Filter by labels:
	//   - Resources that have a key called 'foo'
	//     labels.foo:*
	//   - Resources that have a key called 'foo' whose value is 'bar'
	//     labels.foo = bar
	//
	// - Filter by state:
	//   - Deployments in CREATING state.
	//     state=CREATING
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDeploymentsRequest) Reset() {
	*x = ListDeploymentsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeploymentsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentsRequest) ProtoMessage() {}

func (x *ListDeploymentsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentsRequest.ProtoReflect.Descriptor instead.
func (*ListDeploymentsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{5}
}

func (x *ListDeploymentsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDeploymentsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDeploymentsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDeploymentsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDeploymentsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

type ListDeploymentsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of [Deployment][google.cloud.config.v1.Deployment]s.
	Deployments []*Deployment `protobuf:"bytes,1,rep,name=deployments,proto3" json:"deployments,omitempty"`
	// Token to be supplied to the next ListDeployments request via `page_token`
	// to obtain the next set of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDeploymentsResponse) Reset() {
	*x = ListDeploymentsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDeploymentsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDeploymentsResponse) ProtoMessage() {}

func (x *ListDeploymentsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDeploymentsResponse.ProtoReflect.Descriptor instead.
func (*ListDeploymentsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{6}
}

func (x *ListDeploymentsResponse) GetDeployments() []*Deployment {
	if x != nil {
		return x.Deployments
	}
	return nil
}

func (x *ListDeploymentsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDeploymentsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

type GetDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment. Format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDeploymentRequest) Reset() {
	*x = GetDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDeploymentRequest) ProtoMessage() {}

func (x *GetDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDeploymentRequest.ProtoReflect.Descriptor instead.
func (*GetDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{7}
}

func (x *GetDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to list Revisions passed to a 'ListRevisions' call.
type ListRevisionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the Revisions are listed. The parent
	// value is in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// When requesting a page of resources, `page_size` specifies number of
	// resources to return. If unspecified, at most 500 will be returned. The
	// maximum value is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token returned by previous call to 'ListRevisions' which specifies the
	// position in the list from where to continue listing the resources.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Lists the Revisions that match the filter expression. A filter
	// expression filters the resources listed in the response. The expression
	// must be of the form '{field} {operator} {value}' where operators: '<', '>',
	// '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
	// operator which is roughly synonymous with equality). {field} can refer to a
	// proto or JSON field, or a synthetic field. Field names can be camelCase or
	// snake_case.
	//
	// Examples:
	//   - Filter by name:
	//     name = "projects/foo/locations/us-central1/deployments/dep/revisions/bar
	//
	// - Filter by labels:
	//   - Resources that have a key called 'foo'
	//     labels.foo:*
	//   - Resources that have a key called 'foo' whose value is 'bar'
	//     labels.foo = bar
	//
	// - Filter by state:
	//   - Revisions in CREATING state.
	//     state=CREATING
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListRevisionsRequest) Reset() {
	*x = ListRevisionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRevisionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRevisionsRequest) ProtoMessage() {}

func (x *ListRevisionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRevisionsRequest.ProtoReflect.Descriptor instead.
func (*ListRevisionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{8}
}

func (x *ListRevisionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListRevisionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRevisionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRevisionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListRevisionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// A response to a 'ListRevisions' call. Contains a list of Revisions.
type ListRevisionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of [Revision][google.cloud.config.v1.Revision]s.
	Revisions []*Revision `protobuf:"bytes,1,rep,name=revisions,proto3" json:"revisions,omitempty"`
	// A token to request the next page of resources from the 'ListRevisions'
	// method. The value of an empty string means that there are no more resources
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListRevisionsResponse) Reset() {
	*x = ListRevisionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRevisionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRevisionsResponse) ProtoMessage() {}

func (x *ListRevisionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRevisionsResponse.ProtoReflect.Descriptor instead.
func (*ListRevisionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{9}
}

func (x *ListRevisionsResponse) GetRevisions() []*Revision {
	if x != nil {
		return x.Revisions
	}
	return nil
}

func (x *ListRevisionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListRevisionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A request to get a Revision from a 'GetRevision' call.
type GetRevisionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Revision in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}/revisions/{revision}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRevisionRequest) Reset() {
	*x = GetRevisionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRevisionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRevisionRequest) ProtoMessage() {}

func (x *GetRevisionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRevisionRequest.ProtoReflect.Descriptor instead.
func (*GetRevisionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{10}
}

func (x *GetRevisionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

type CreateDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the Deployment is created. The parent
	// value is in the format: 'projects/{project_id}/locations/{location}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Deployment ID.
	DeploymentId string `protobuf:"bytes,2,opt,name=deployment_id,json=deploymentId,proto3" json:"deployment_id,omitempty"`
	// Required. [Deployment][google.cloud.config.v1.Deployment] resource to be
	// created.
	Deployment *Deployment `protobuf:"bytes,3,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateDeploymentRequest) Reset() {
	*x = CreateDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDeploymentRequest) ProtoMessage() {}

func (x *CreateDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDeploymentRequest.ProtoReflect.Descriptor instead.
func (*CreateDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{11}
}

func (x *CreateDeploymentRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDeploymentRequest) GetDeploymentId() string {
	if x != nil {
		return x.DeploymentId
	}
	return ""
}

func (x *CreateDeploymentRequest) GetDeployment() *Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

func (x *CreateDeploymentRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

type UpdateDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask used to specify the fields to be overwritten in the
	// Deployment resource by the update.
	//
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. [Deployment][google.cloud.config.v1.Deployment] to update.
	//
	// The deployment's `name` field is used to identify the resource to be
	// updated. Format:
	// `projects/{project}/locations/{location}/deployments/{deployment}`
	Deployment *Deployment `protobuf:"bytes,2,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateDeploymentRequest) Reset() {
	*x = UpdateDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDeploymentRequest) ProtoMessage() {}

func (x *UpdateDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDeploymentRequest.ProtoReflect.Descriptor instead.
func (*UpdateDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{12}
}

func (x *UpdateDeploymentRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDeploymentRequest) GetDeployment() *Deployment {
	if x != nil {
		return x.Deployment
	}
	return nil
}

func (x *UpdateDeploymentRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

type DeleteDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Deployment in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, any revisions for this deployment will also be
	// deleted. (Otherwise, the request will only work if the deployment has no
	// revisions.)
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
	// Optional. Policy on how resources actuated by the deployment should be
	// deleted. If unspecified, the default behavior is to delete the underlying
	// resources.
	DeletePolicy DeleteDeploymentRequest_DeletePolicy `protobuf:"varint,4,opt,name=delete_policy,json=deletePolicy,proto3,enum=google.cloud.config.v1.DeleteDeploymentRequest_DeletePolicy" json:"delete_policy,omitempty"`
}

func (x *DeleteDeploymentRequest) Reset() {
	*x = DeleteDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDeploymentRequest) ProtoMessage() {}

func (x *DeleteDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDeploymentRequest.ProtoReflect.Descriptor instead.
func (*DeleteDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDeploymentRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteDeploymentRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

func (x *DeleteDeploymentRequest) GetDeletePolicy() DeleteDeploymentRequest_DeletePolicy {
	if x != nil {
		return x.DeletePolicy
	}
	return DeleteDeploymentRequest_DELETE_POLICY_UNSPECIFIED
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ephemeral metadata about the state of an operation for a particular
	// resource.
	//
	// Types that are assignable to ResourceMetadata:
	//
	//	*OperationMetadata_DeploymentMetadata
	//	*OperationMetadata_PreviewMetadata
	ResourceMetadata isOperationMetadata_ResourceMetadata `protobuf_oneof:"resource_metadata"`
	// Output only. Time when the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation of the
	// operation. Operations that have successfully been cancelled have
	// [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{14}
}

func (m *OperationMetadata) GetResourceMetadata() isOperationMetadata_ResourceMetadata {
	if m != nil {
		return m.ResourceMetadata
	}
	return nil
}

func (x *OperationMetadata) GetDeploymentMetadata() *DeploymentOperationMetadata {
	if x, ok := x.GetResourceMetadata().(*OperationMetadata_DeploymentMetadata); ok {
		return x.DeploymentMetadata
	}
	return nil
}

func (x *OperationMetadata) GetPreviewMetadata() *PreviewOperationMetadata {
	if x, ok := x.GetResourceMetadata().(*OperationMetadata_PreviewMetadata); ok {
		return x.PreviewMetadata
	}
	return nil
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

type isOperationMetadata_ResourceMetadata interface {
	isOperationMetadata_ResourceMetadata()
}

type OperationMetadata_DeploymentMetadata struct {
	// Output only. Metadata about the deployment operation state.
	DeploymentMetadata *DeploymentOperationMetadata `protobuf:"bytes,8,opt,name=deployment_metadata,json=deploymentMetadata,proto3,oneof"`
}

type OperationMetadata_PreviewMetadata struct {
	// Output only. Metadata about the preview operation state.
	PreviewMetadata *PreviewOperationMetadata `protobuf:"bytes,9,opt,name=preview_metadata,json=previewMetadata,proto3,oneof"`
}

func (*OperationMetadata_DeploymentMetadata) isOperationMetadata_ResourceMetadata() {}

func (*OperationMetadata_PreviewMetadata) isOperationMetadata_ResourceMetadata() {}

// A child resource of a Deployment generated by a 'CreateDeployment' or
// 'UpdateDeployment' call. Each Revision contains metadata pertaining to a
// snapshot of a particular Deployment.
type Revision struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Blueprint that was deployed.
	//
	// Types that are assignable to Blueprint:
	//
	//	*Revision_TerraformBlueprint
	Blueprint isRevision_Blueprint `protobuf_oneof:"blueprint"`
	// Revision name. Format:
	// `projects/{project}/locations/{location}/deployments/{deployment}/
	// revisions/{revision}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time when the revision was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the revision was last modified.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The action which created this revision
	Action Revision_Action `protobuf:"varint,4,opt,name=action,proto3,enum=google.cloud.config.v1.Revision_Action" json:"action,omitempty"`
	// Output only. Current state of the revision.
	State Revision_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.config.v1.Revision_State" json:"state,omitempty"`
	// Output only. Outputs and artifacts from applying a deployment.
	ApplyResults *ApplyResults `protobuf:"bytes,7,opt,name=apply_results,json=applyResults,proto3" json:"apply_results,omitempty"`
	// Output only. Additional info regarding the current state.
	StateDetail string `protobuf:"bytes,8,opt,name=state_detail,json=stateDetail,proto3" json:"state_detail,omitempty"`
	// Output only. Code describing any errors that may have occurred.
	ErrorCode Revision_ErrorCode `protobuf:"varint,9,opt,name=error_code,json=errorCode,proto3,enum=google.cloud.config.v1.Revision_ErrorCode" json:"error_code,omitempty"`
	// Output only. Cloud Build instance UUID associated with this revision.
	Build string `protobuf:"bytes,10,opt,name=build,proto3" json:"build,omitempty"`
	// Output only. Location of Revision operation logs in
	// `gs://{bucket}/{object}` format.
	Logs string `protobuf:"bytes,11,opt,name=logs,proto3" json:"logs,omitempty"`
	// Output only. Errors encountered when creating or updating this deployment.
	// Errors are truncated to 10 entries, see `delete_results` and `error_logs`
	// for full details.
	TfErrors []*TerraformError `protobuf:"bytes,12,rep,name=tf_errors,json=tfErrors,proto3" json:"tf_errors,omitempty"`
	// Output only. Location of Terraform error logs in Google Cloud Storage.
	// Format: `gs://{bucket}/{object}`.
	ErrorLogs string `protobuf:"bytes,13,opt,name=error_logs,json=errorLogs,proto3" json:"error_logs,omitempty"`
	// Output only. User-specified Service Account (SA) to be used as credential
	// to manage resources. Format:
	// `projects/{projectID}/serviceAccounts/{serviceAccount}`
	ServiceAccount string `protobuf:"bytes,14,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output only. By default, Infra Manager will return a failure when
	// Terraform encounters a 409 code (resource conflict error) during actuation.
	// If this flag is set to true, Infra Manager will instead
	// attempt to automatically import the resource into the Terraform state (for
	// supported resource types) and continue actuation.
	//
	// Not all resource types are supported, refer to documentation.
	ImportExistingResources bool `protobuf:"varint,15,opt,name=import_existing_resources,json=importExistingResources,proto3" json:"import_existing_resources,omitempty"`
	// Output only. The user-specified Cloud Build worker pool resource in which
	// the Cloud Build job will execute. Format:
	// `projects/{project}/locations/{location}/workerPools/{workerPoolId}`.
	// If this field is unspecified, the default Cloud Build worker pool will be
	// used.
	WorkerPool string `protobuf:"bytes,17,opt,name=worker_pool,json=workerPool,proto3" json:"worker_pool,omitempty"`
	// Output only. The user-specified Terraform version constraint.
	// Example: "=1.3.10".
	TfVersionConstraint string `protobuf:"bytes,18,opt,name=tf_version_constraint,json=tfVersionConstraint,proto3" json:"tf_version_constraint,omitempty"`
	// Output only. The version of Terraform used to create the Revision.
	// It is in the format of "Major.Minor.Patch", for example, "1.3.10".
	TfVersion string `protobuf:"bytes,19,opt,name=tf_version,json=tfVersion,proto3" json:"tf_version,omitempty"`
	// Output only. Cloud Storage path containing quota validation results. This
	// field is set when a user sets Deployment.quota_validation field to ENABLED
	// or ENFORCED. Format: `gs://{bucket}/{object}`.
	QuotaValidationResults string `protobuf:"bytes,29,opt,name=quota_validation_results,json=quotaValidationResults,proto3" json:"quota_validation_results,omitempty"`
	// Optional. Input to control quota checks for resources in terraform
	// configuration files. There are limited resources on which quota validation
	// applies.
	QuotaValidation QuotaValidation `protobuf:"varint,20,opt,name=quota_validation,json=quotaValidation,proto3,enum=google.cloud.config.v1.QuotaValidation" json:"quota_validation,omitempty"`
}

func (x *Revision) Reset() {
	*x = Revision{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Revision) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Revision) ProtoMessage() {}

func (x *Revision) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Revision.ProtoReflect.Descriptor instead.
func (*Revision) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{15}
}

func (m *Revision) GetBlueprint() isRevision_Blueprint {
	if m != nil {
		return m.Blueprint
	}
	return nil
}

func (x *Revision) GetTerraformBlueprint() *TerraformBlueprint {
	if x, ok := x.GetBlueprint().(*Revision_TerraformBlueprint); ok {
		return x.TerraformBlueprint
	}
	return nil
}

func (x *Revision) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Revision) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Revision) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Revision) GetAction() Revision_Action {
	if x != nil {
		return x.Action
	}
	return Revision_ACTION_UNSPECIFIED
}

func (x *Revision) GetState() Revision_State {
	if x != nil {
		return x.State
	}
	return Revision_STATE_UNSPECIFIED
}

func (x *Revision) GetApplyResults() *ApplyResults {
	if x != nil {
		return x.ApplyResults
	}
	return nil
}

func (x *Revision) GetStateDetail() string {
	if x != nil {
		return x.StateDetail
	}
	return ""
}

func (x *Revision) GetErrorCode() Revision_ErrorCode {
	if x != nil {
		return x.ErrorCode
	}
	return Revision_ERROR_CODE_UNSPECIFIED
}

func (x *Revision) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *Revision) GetLogs() string {
	if x != nil {
		return x.Logs
	}
	return ""
}

func (x *Revision) GetTfErrors() []*TerraformError {
	if x != nil {
		return x.TfErrors
	}
	return nil
}

func (x *Revision) GetErrorLogs() string {
	if x != nil {
		return x.ErrorLogs
	}
	return ""
}

func (x *Revision) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Revision) GetImportExistingResources() bool {
	if x != nil {
		return x.ImportExistingResources
	}
	return false
}

func (x *Revision) GetWorkerPool() string {
	if x != nil {
		return x.WorkerPool
	}
	return ""
}

func (x *Revision) GetTfVersionConstraint() string {
	if x != nil {
		return x.TfVersionConstraint
	}
	return ""
}

func (x *Revision) GetTfVersion() string {
	if x != nil {
		return x.TfVersion
	}
	return ""
}

func (x *Revision) GetQuotaValidationResults() string {
	if x != nil {
		return x.QuotaValidationResults
	}
	return ""
}

func (x *Revision) GetQuotaValidation() QuotaValidation {
	if x != nil {
		return x.QuotaValidation
	}
	return QuotaValidation_QUOTA_VALIDATION_UNSPECIFIED
}

type isRevision_Blueprint interface {
	isRevision_Blueprint()
}

type Revision_TerraformBlueprint struct {
	// Output only. A blueprint described using Terraform's HashiCorp
	// Configuration Language as a root module.
	TerraformBlueprint *TerraformBlueprint `protobuf:"bytes,6,opt,name=terraform_blueprint,json=terraformBlueprint,proto3,oneof"`
}

func (*Revision_TerraformBlueprint) isRevision_Blueprint() {}

// Errors encountered during actuation using Terraform
type TerraformError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Address of the resource associated with the error,
	// e.g. `google_compute_network.vpc_network`.
	ResourceAddress string `protobuf:"bytes,1,opt,name=resource_address,json=resourceAddress,proto3" json:"resource_address,omitempty"`
	// HTTP response code returned from Google Cloud Platform APIs when Terraform
	// fails to provision the resource. If unset or 0, no HTTP response code was
	// returned by Terraform.
	HttpResponseCode int32 `protobuf:"varint,2,opt,name=http_response_code,json=httpResponseCode,proto3" json:"http_response_code,omitempty"`
	// A human-readable error description.
	ErrorDescription string `protobuf:"bytes,3,opt,name=error_description,json=errorDescription,proto3" json:"error_description,omitempty"`
	// Original error response from underlying Google API, if available.
	Error *status.Status `protobuf:"bytes,4,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *TerraformError) Reset() {
	*x = TerraformError{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TerraformError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TerraformError) ProtoMessage() {}

func (x *TerraformError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TerraformError.ProtoReflect.Descriptor instead.
func (*TerraformError) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{16}
}

func (x *TerraformError) GetResourceAddress() string {
	if x != nil {
		return x.ResourceAddress
	}
	return ""
}

func (x *TerraformError) GetHttpResponseCode() int32 {
	if x != nil {
		return x.HttpResponseCode
	}
	return 0
}

func (x *TerraformError) GetErrorDescription() string {
	if x != nil {
		return x.ErrorDescription
	}
	return ""
}

func (x *TerraformError) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// A set of files in a Git repository.
type GitSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Repository URL.
	// Example: 'https://github.com/kubernetes/examples.git'
	Repo *string `protobuf:"bytes,1,opt,name=repo,proto3,oneof" json:"repo,omitempty"`
	// Optional. Subdirectory inside the repository.
	// Example: 'staging/my-package'
	Directory *string `protobuf:"bytes,2,opt,name=directory,proto3,oneof" json:"directory,omitempty"`
	// Optional. Git reference (e.g. branch or tag).
	Ref *string `protobuf:"bytes,3,opt,name=ref,proto3,oneof" json:"ref,omitempty"`
}

func (x *GitSource) Reset() {
	*x = GitSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GitSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GitSource) ProtoMessage() {}

func (x *GitSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GitSource.ProtoReflect.Descriptor instead.
func (*GitSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{17}
}

func (x *GitSource) GetRepo() string {
	if x != nil && x.Repo != nil {
		return *x.Repo
	}
	return ""
}

func (x *GitSource) GetDirectory() string {
	if x != nil && x.Directory != nil {
		return *x.Directory
	}
	return ""
}

func (x *GitSource) GetRef() string {
	if x != nil && x.Ref != nil {
		return *x.Ref
	}
	return ""
}

// Ephemeral metadata content describing the state of a deployment operation.
type DeploymentOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current step the deployment operation is running.
	Step DeploymentOperationMetadata_DeploymentStep `protobuf:"varint,1,opt,name=step,proto3,enum=google.cloud.config.v1.DeploymentOperationMetadata_DeploymentStep" json:"step,omitempty"`
	// Outputs and artifacts from applying a deployment.
	ApplyResults *ApplyResults `protobuf:"bytes,2,opt,name=apply_results,json=applyResults,proto3" json:"apply_results,omitempty"`
	// Output only. Cloud Build instance UUID associated with this operation.
	Build string `protobuf:"bytes,3,opt,name=build,proto3" json:"build,omitempty"`
	// Output only. Location of Deployment operations logs in
	// `gs://{bucket}/{object}` format.
	Logs string `protobuf:"bytes,4,opt,name=logs,proto3" json:"logs,omitempty"`
}

func (x *DeploymentOperationMetadata) Reset() {
	*x = DeploymentOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeploymentOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeploymentOperationMetadata) ProtoMessage() {}

func (x *DeploymentOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeploymentOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeploymentOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{18}
}

func (x *DeploymentOperationMetadata) GetStep() DeploymentOperationMetadata_DeploymentStep {
	if x != nil {
		return x.Step
	}
	return DeploymentOperationMetadata_DEPLOYMENT_STEP_UNSPECIFIED
}

func (x *DeploymentOperationMetadata) GetApplyResults() *ApplyResults {
	if x != nil {
		return x.ApplyResults
	}
	return nil
}

func (x *DeploymentOperationMetadata) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *DeploymentOperationMetadata) GetLogs() string {
	if x != nil {
		return x.Logs
	}
	return ""
}

// Resource represents a Google Cloud Platform resource actuated by IM.
// Resources are child resources of Revisions.
type Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name.
	// Format:
	// `projects/{project}/locations/{location}/deployments/{deployment}/revisions/{revision}/resources/{resource}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Terraform-specific info if this resource was created using
	// Terraform.
	TerraformInfo *ResourceTerraformInfo `protobuf:"bytes,2,opt,name=terraform_info,json=terraformInfo,proto3" json:"terraform_info,omitempty"`
	// Output only. Map of Cloud Asset Inventory (CAI) type to CAI info (e.g. CAI
	// ID). CAI type format follows
	// https://cloud.google.com/asset-inventory/docs/supported-asset-types
	CaiAssets map[string]*ResourceCAIInfo `protobuf:"bytes,3,rep,name=cai_assets,json=caiAssets,proto3" json:"cai_assets,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Intent of the resource.
	Intent Resource_Intent `protobuf:"varint,4,opt,name=intent,proto3,enum=google.cloud.config.v1.Resource_Intent" json:"intent,omitempty"`
	// Output only. Current state of the resource.
	State Resource_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.config.v1.Resource_State" json:"state,omitempty"`
}

func (x *Resource) Reset() {
	*x = Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Resource) ProtoMessage() {}

func (x *Resource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Resource.ProtoReflect.Descriptor instead.
func (*Resource) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{19}
}

func (x *Resource) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Resource) GetTerraformInfo() *ResourceTerraformInfo {
	if x != nil {
		return x.TerraformInfo
	}
	return nil
}

func (x *Resource) GetCaiAssets() map[string]*ResourceCAIInfo {
	if x != nil {
		return x.CaiAssets
	}
	return nil
}

func (x *Resource) GetIntent() Resource_Intent {
	if x != nil {
		return x.Intent
	}
	return Resource_INTENT_UNSPECIFIED
}

func (x *Resource) GetState() Resource_State {
	if x != nil {
		return x.State
	}
	return Resource_STATE_UNSPECIFIED
}

// Terraform info of a Resource.
type ResourceTerraformInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// TF resource address that uniquely identifies this resource within this
	// deployment.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// TF resource type
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// ID attribute of the TF resource
	Id string `protobuf:"bytes,3,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ResourceTerraformInfo) Reset() {
	*x = ResourceTerraformInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceTerraformInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceTerraformInfo) ProtoMessage() {}

func (x *ResourceTerraformInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceTerraformInfo.ProtoReflect.Descriptor instead.
func (*ResourceTerraformInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{20}
}

func (x *ResourceTerraformInfo) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *ResourceTerraformInfo) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *ResourceTerraformInfo) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// CAI info of a Resource.
type ResourceCAIInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// CAI resource name in the format following
	// https://cloud.google.com/apis/design/resource_names#full_resource_name
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
}

func (x *ResourceCAIInfo) Reset() {
	*x = ResourceCAIInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceCAIInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceCAIInfo) ProtoMessage() {}

func (x *ResourceCAIInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceCAIInfo.ProtoReflect.Descriptor instead.
func (*ResourceCAIInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{21}
}

func (x *ResourceCAIInfo) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

// A request to get a Resource from a 'GetResource' call.
type GetResourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Resource in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}/revisions/{revision}/resource/{resource}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetResourceRequest) Reset() {
	*x = GetResourceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetResourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetResourceRequest) ProtoMessage() {}

func (x *GetResourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetResourceRequest.ProtoReflect.Descriptor instead.
func (*GetResourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{22}
}

func (x *GetResourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to list Resources passed to a 'ListResources' call.
type ListResourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the Resources are listed. The parent
	// value is in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}/revisions/{revision}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// When requesting a page of resources, 'page_size' specifies number of
	// resources to return. If unspecified, at most 500 will be returned. The
	// maximum value is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Token returned by previous call to 'ListResources' which specifies the
	// position in the list from where to continue listing the resources.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Lists the Resources that match the filter expression. A filter
	// expression filters the resources listed in the response. The expression
	// must be of the form '{field} {operator} {value}' where operators: '<', '>',
	// '<=',
	// '>=',
	// '!=', '=', ':' are supported (colon ':' represents a HAS operator which is
	// roughly synonymous with equality). {field} can refer to a proto or JSON
	// field, or a synthetic field. Field names can be camelCase or snake_case.
	//
	// Examples:
	//   - Filter by name:
	//     name =
	//     "projects/foo/locations/us-central1/deployments/dep/revisions/bar/resources/baz
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListResourcesRequest) Reset() {
	*x = ListResourcesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListResourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourcesRequest) ProtoMessage() {}

func (x *ListResourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourcesRequest.ProtoReflect.Descriptor instead.
func (*ListResourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{23}
}

func (x *ListResourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListResourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListResourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListResourcesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListResourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// A response to a 'ListResources' call. Contains a list of Resources.
type ListResourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of [Resources][]s.
	Resources []*Resource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// A token to request the next page of resources from the 'ListResources'
	// method. The value of an empty string means that there are no more resources
	// to return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListResourcesResponse) Reset() {
	*x = ListResourcesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListResourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListResourcesResponse) ProtoMessage() {}

func (x *ListResourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListResourcesResponse.ProtoReflect.Descriptor instead.
func (*ListResourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{24}
}

func (x *ListResourcesResponse) GetResources() []*Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ListResourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListResourcesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Contains info about a Terraform state file
type Statefile struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Cloud Storage signed URI used for downloading or uploading the
	// state file.
	SignedUri string `protobuf:"bytes,1,opt,name=signed_uri,json=signedUri,proto3" json:"signed_uri,omitempty"`
}

func (x *Statefile) Reset() {
	*x = Statefile{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Statefile) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Statefile) ProtoMessage() {}

func (x *Statefile) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Statefile.ProtoReflect.Descriptor instead.
func (*Statefile) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{25}
}

func (x *Statefile) GetSignedUri() string {
	if x != nil {
		return x.SignedUri
	}
	return ""
}

// A request to export a state file passed to a 'ExportDeploymentStatefile'
// call.
type ExportDeploymentStatefileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the statefile is listed. The parent
	// value is in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. If this flag is set to true, the exported deployment state file
	// will be the draft state. This will enable the draft file to be validated
	// before copying it over to the working state on unlock.
	Draft bool `protobuf:"varint,3,opt,name=draft,proto3" json:"draft,omitempty"`
}

func (x *ExportDeploymentStatefileRequest) Reset() {
	*x = ExportDeploymentStatefileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportDeploymentStatefileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportDeploymentStatefileRequest) ProtoMessage() {}

func (x *ExportDeploymentStatefileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportDeploymentStatefileRequest.ProtoReflect.Descriptor instead.
func (*ExportDeploymentStatefileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{26}
}

func (x *ExportDeploymentStatefileRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ExportDeploymentStatefileRequest) GetDraft() bool {
	if x != nil {
		return x.Draft
	}
	return false
}

// A request to export a state file passed to a 'ExportRevisionStatefile'
// call.
type ExportRevisionStatefileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the statefile is listed. The parent
	// value is in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}/revisions/{revision}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ExportRevisionStatefileRequest) Reset() {
	*x = ExportRevisionStatefileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportRevisionStatefileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportRevisionStatefileRequest) ProtoMessage() {}

func (x *ExportRevisionStatefileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportRevisionStatefileRequest.ProtoReflect.Descriptor instead.
func (*ExportRevisionStatefileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{27}
}

func (x *ExportRevisionStatefileRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// A request to import a state file passed to a 'ImportStatefile' call.
type ImportStatefileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the statefile is listed. The parent
	// value is in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Lock ID of the lock file to verify that the user who is importing
	// the state file previously locked the Deployment.
	LockId int64 `protobuf:"varint,2,opt,name=lock_id,json=lockId,proto3" json:"lock_id,omitempty"`
	// Optional.
	SkipDraft bool `protobuf:"varint,3,opt,name=skip_draft,json=skipDraft,proto3" json:"skip_draft,omitempty"`
}

func (x *ImportStatefileRequest) Reset() {
	*x = ImportStatefileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportStatefileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportStatefileRequest) ProtoMessage() {}

func (x *ImportStatefileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportStatefileRequest.ProtoReflect.Descriptor instead.
func (*ImportStatefileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{28}
}

func (x *ImportStatefileRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ImportStatefileRequest) GetLockId() int64 {
	if x != nil {
		return x.LockId
	}
	return 0
}

func (x *ImportStatefileRequest) GetSkipDraft() bool {
	if x != nil {
		return x.SkipDraft
	}
	return false
}

// A request to delete a state file passed to a 'DeleteStatefile' call.
type DeleteStatefileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Lock ID of the lock file to verify that the user who is deleting
	// the state file previously locked the Deployment.
	LockId int64 `protobuf:"varint,2,opt,name=lock_id,json=lockId,proto3" json:"lock_id,omitempty"`
}

func (x *DeleteStatefileRequest) Reset() {
	*x = DeleteStatefileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteStatefileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteStatefileRequest) ProtoMessage() {}

func (x *DeleteStatefileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteStatefileRequest.ProtoReflect.Descriptor instead.
func (*DeleteStatefileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{29}
}

func (x *DeleteStatefileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteStatefileRequest) GetLockId() int64 {
	if x != nil {
		return x.LockId
	}
	return 0
}

// A request to lock a deployment passed to a 'LockDeployment' call.
type LockDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *LockDeploymentRequest) Reset() {
	*x = LockDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LockDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LockDeploymentRequest) ProtoMessage() {}

func (x *LockDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LockDeploymentRequest.ProtoReflect.Descriptor instead.
func (*LockDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{30}
}

func (x *LockDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to unlock a state file passed to a 'UnlockDeployment' call.
type UnlockDeploymentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Lock ID of the lock file to be unlocked.
	LockId int64 `protobuf:"varint,2,opt,name=lock_id,json=lockId,proto3" json:"lock_id,omitempty"`
}

func (x *UnlockDeploymentRequest) Reset() {
	*x = UnlockDeploymentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnlockDeploymentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnlockDeploymentRequest) ProtoMessage() {}

func (x *UnlockDeploymentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnlockDeploymentRequest.ProtoReflect.Descriptor instead.
func (*UnlockDeploymentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{31}
}

func (x *UnlockDeploymentRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UnlockDeploymentRequest) GetLockId() int64 {
	if x != nil {
		return x.LockId
	}
	return 0
}

// A request to get a state file lock info passed to a 'ExportLockInfo' call.
type ExportLockInfoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the deployment in the format:
	// 'projects/{project_id}/locations/{location}/deployments/{deployment}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ExportLockInfoRequest) Reset() {
	*x = ExportLockInfoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportLockInfoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportLockInfoRequest) ProtoMessage() {}

func (x *ExportLockInfoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportLockInfoRequest.ProtoReflect.Descriptor instead.
func (*ExportLockInfoRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{32}
}

func (x *ExportLockInfoRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Details about the lock which locked the deployment.
type LockInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique ID for the lock to be overridden with generation ID in the backend.
	LockId int64 `protobuf:"varint,1,opt,name=lock_id,json=lockId,proto3" json:"lock_id,omitempty"`
	// Terraform operation, provided by the caller.
	Operation string `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	// Extra information to store with the lock, provided by the caller.
	Info string `protobuf:"bytes,3,opt,name=info,proto3" json:"info,omitempty"`
	// user@hostname when available
	Who string `protobuf:"bytes,4,opt,name=who,proto3" json:"who,omitempty"`
	// Terraform version
	Version string `protobuf:"bytes,5,opt,name=version,proto3" json:"version,omitempty"`
	// Time that the lock was taken.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
}

func (x *LockInfo) Reset() {
	*x = LockInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LockInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LockInfo) ProtoMessage() {}

func (x *LockInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LockInfo.ProtoReflect.Descriptor instead.
func (*LockInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{33}
}

func (x *LockInfo) GetLockId() int64 {
	if x != nil {
		return x.LockId
	}
	return 0
}

func (x *LockInfo) GetOperation() string {
	if x != nil {
		return x.Operation
	}
	return ""
}

func (x *LockInfo) GetInfo() string {
	if x != nil {
		return x.Info
	}
	return ""
}

func (x *LockInfo) GetWho() string {
	if x != nil {
		return x.Who
	}
	return ""
}

func (x *LockInfo) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *LockInfo) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

// A preview represents a set of actions Infra Manager would perform
// to move the resources towards the desired state as specified in the
// configuration.
type Preview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Blueprint to preview.
	//
	// Types that are assignable to Blueprint:
	//
	//	*Preview_TerraformBlueprint
	Blueprint isPreview_Blueprint `protobuf_oneof:"blueprint"`
	// Identifier. Resource name of the preview. Resource name can be user
	// provided or server generated ID if unspecified. Format:
	// `projects/{project}/locations/{location}/previews/{preview}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Time the preview was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. User-defined labels for the preview.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Current state of the preview.
	State Preview_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.config.v1.Preview_State" json:"state,omitempty"`
	// Optional. Optional deployment reference. If specified, the preview will be
	// performed using the provided deployment's current state and use any
	// relevant fields from the deployment unless explicitly specified in the
	// preview create request.
	Deployment string `protobuf:"bytes,5,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// Optional. Current mode of preview.
	PreviewMode Preview_PreviewMode `protobuf:"varint,15,opt,name=preview_mode,json=previewMode,proto3,enum=google.cloud.config.v1.Preview_PreviewMode" json:"preview_mode,omitempty"`
	// Optional. User-specified Service Account (SA) credentials to be used when
	// previewing resources.
	// Format: `projects/{projectID}/serviceAccounts/{serviceAccount}`
	ServiceAccount string `protobuf:"bytes,7,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. User-defined location of Cloud Build logs, artifacts, and
	// in Google Cloud Storage.
	// Format: `gs://{bucket}/{folder}`
	// A default bucket will be bootstrapped if the field is not set or empty
	// Default Bucket Format: `gs://<project number>-<region>-blueprint-config`
	// Constraints:
	// - The bucket needs to be in the same project as the deployment
	// - The path cannot be within the path of `gcs_source`
	// If omitted and deployment resource ref provided has artifacts_gcs_bucket
	// defined, that artifact bucket is used.
	ArtifactsGcsBucket *string `protobuf:"bytes,8,opt,name=artifacts_gcs_bucket,json=artifactsGcsBucket,proto3,oneof" json:"artifacts_gcs_bucket,omitempty"`
	// Optional. The user-specified Worker Pool resource in which the Cloud Build
	// job will execute. Format
	// projects/{project}/locations/{location}/workerPools/{workerPoolId} If this
	// field is unspecified, the default Cloud Build worker pool will be used. If
	// omitted and deployment resource ref provided has worker_pool defined, that
	// worker pool is used.
	WorkerPool *string `protobuf:"bytes,9,opt,name=worker_pool,json=workerPool,proto3,oneof" json:"worker_pool,omitempty"`
	// Output only. Code describing any errors that may have occurred.
	ErrorCode Preview_ErrorCode `protobuf:"varint,10,opt,name=error_code,json=errorCode,proto3,enum=google.cloud.config.v1.Preview_ErrorCode" json:"error_code,omitempty"`
	// Output only. Additional information regarding the current state.
	ErrorStatus *status.Status `protobuf:"bytes,11,opt,name=error_status,json=errorStatus,proto3" json:"error_status,omitempty"`
	// Output only. Cloud Build instance UUID associated with this preview.
	Build string `protobuf:"bytes,12,opt,name=build,proto3" json:"build,omitempty"`
	// Output only. Summary of errors encountered during Terraform preview.
	// It has a size limit of 10, i.e. only top 10 errors will be summarized here.
	TfErrors []*TerraformError `protobuf:"bytes,13,rep,name=tf_errors,json=tfErrors,proto3" json:"tf_errors,omitempty"`
	// Output only. Link to tf-error.ndjson file, which contains the full list of
	// the errors encountered during a Terraform preview.
	// Format: `gs://{bucket}/{object}`.
	ErrorLogs string `protobuf:"bytes,14,opt,name=error_logs,json=errorLogs,proto3" json:"error_logs,omitempty"`
	// Output only. Artifacts from preview.
	PreviewArtifacts *PreviewArtifacts `protobuf:"bytes,16,opt,name=preview_artifacts,json=previewArtifacts,proto3" json:"preview_artifacts,omitempty"`
	// Output only. Location of preview logs in `gs://{bucket}/{object}` format.
	Logs string `protobuf:"bytes,17,opt,name=logs,proto3" json:"logs,omitempty"`
	// Output only. The current Terraform version set on the preview.
	// It is in the format of "Major.Minor.Patch", for example, "1.3.10".
	TfVersion string `protobuf:"bytes,18,opt,name=tf_version,json=tfVersion,proto3" json:"tf_version,omitempty"`
	// Optional. The user-specified Terraform version constraint.
	// Example: "=1.3.10".
	TfVersionConstraint *string `protobuf:"bytes,19,opt,name=tf_version_constraint,json=tfVersionConstraint,proto3,oneof" json:"tf_version_constraint,omitempty"`
}

func (x *Preview) Reset() {
	*x = Preview{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Preview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Preview) ProtoMessage() {}

func (x *Preview) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Preview.ProtoReflect.Descriptor instead.
func (*Preview) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{34}
}

func (m *Preview) GetBlueprint() isPreview_Blueprint {
	if m != nil {
		return m.Blueprint
	}
	return nil
}

func (x *Preview) GetTerraformBlueprint() *TerraformBlueprint {
	if x, ok := x.GetBlueprint().(*Preview_TerraformBlueprint); ok {
		return x.TerraformBlueprint
	}
	return nil
}

func (x *Preview) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Preview) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Preview) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Preview) GetState() Preview_State {
	if x != nil {
		return x.State
	}
	return Preview_STATE_UNSPECIFIED
}

func (x *Preview) GetDeployment() string {
	if x != nil {
		return x.Deployment
	}
	return ""
}

func (x *Preview) GetPreviewMode() Preview_PreviewMode {
	if x != nil {
		return x.PreviewMode
	}
	return Preview_PREVIEW_MODE_UNSPECIFIED
}

func (x *Preview) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Preview) GetArtifactsGcsBucket() string {
	if x != nil && x.ArtifactsGcsBucket != nil {
		return *x.ArtifactsGcsBucket
	}
	return ""
}

func (x *Preview) GetWorkerPool() string {
	if x != nil && x.WorkerPool != nil {
		return *x.WorkerPool
	}
	return ""
}

func (x *Preview) GetErrorCode() Preview_ErrorCode {
	if x != nil {
		return x.ErrorCode
	}
	return Preview_ERROR_CODE_UNSPECIFIED
}

func (x *Preview) GetErrorStatus() *status.Status {
	if x != nil {
		return x.ErrorStatus
	}
	return nil
}

func (x *Preview) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

func (x *Preview) GetTfErrors() []*TerraformError {
	if x != nil {
		return x.TfErrors
	}
	return nil
}

func (x *Preview) GetErrorLogs() string {
	if x != nil {
		return x.ErrorLogs
	}
	return ""
}

func (x *Preview) GetPreviewArtifacts() *PreviewArtifacts {
	if x != nil {
		return x.PreviewArtifacts
	}
	return nil
}

func (x *Preview) GetLogs() string {
	if x != nil {
		return x.Logs
	}
	return ""
}

func (x *Preview) GetTfVersion() string {
	if x != nil {
		return x.TfVersion
	}
	return ""
}

func (x *Preview) GetTfVersionConstraint() string {
	if x != nil && x.TfVersionConstraint != nil {
		return *x.TfVersionConstraint
	}
	return ""
}

type isPreview_Blueprint interface {
	isPreview_Blueprint()
}

type Preview_TerraformBlueprint struct {
	// The terraform blueprint to preview.
	TerraformBlueprint *TerraformBlueprint `protobuf:"bytes,6,opt,name=terraform_blueprint,json=terraformBlueprint,proto3,oneof"`
}

func (*Preview_TerraformBlueprint) isPreview_Blueprint() {}

// Ephemeral metadata content describing the state of a preview operation.
type PreviewOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current step the preview operation is running.
	Step PreviewOperationMetadata_PreviewStep `protobuf:"varint,1,opt,name=step,proto3,enum=google.cloud.config.v1.PreviewOperationMetadata_PreviewStep" json:"step,omitempty"`
	// Artifacts from preview.
	PreviewArtifacts *PreviewArtifacts `protobuf:"bytes,2,opt,name=preview_artifacts,json=previewArtifacts,proto3" json:"preview_artifacts,omitempty"`
	// Output only. Location of preview logs in `gs://{bucket}/{object}` format.
	Logs string `protobuf:"bytes,3,opt,name=logs,proto3" json:"logs,omitempty"`
	// Output only. Cloud Build instance UUID associated with this preview.
	Build string `protobuf:"bytes,4,opt,name=build,proto3" json:"build,omitempty"`
}

func (x *PreviewOperationMetadata) Reset() {
	*x = PreviewOperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewOperationMetadata) ProtoMessage() {}

func (x *PreviewOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewOperationMetadata.ProtoReflect.Descriptor instead.
func (*PreviewOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{35}
}

func (x *PreviewOperationMetadata) GetStep() PreviewOperationMetadata_PreviewStep {
	if x != nil {
		return x.Step
	}
	return PreviewOperationMetadata_PREVIEW_STEP_UNSPECIFIED
}

func (x *PreviewOperationMetadata) GetPreviewArtifacts() *PreviewArtifacts {
	if x != nil {
		return x.PreviewArtifacts
	}
	return nil
}

func (x *PreviewOperationMetadata) GetLogs() string {
	if x != nil {
		return x.Logs
	}
	return ""
}

func (x *PreviewOperationMetadata) GetBuild() string {
	if x != nil {
		return x.Build
	}
	return ""
}

// Artifacts created by preview.
type PreviewArtifacts struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Location of a blueprint copy and other content in Google Cloud
	// Storage. Format: `gs://{bucket}/{object}`
	Content string `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Output only. Location of artifacts in Google Cloud Storage.
	// Format: `gs://{bucket}/{object}`
	Artifacts string `protobuf:"bytes,2,opt,name=artifacts,proto3" json:"artifacts,omitempty"`
}

func (x *PreviewArtifacts) Reset() {
	*x = PreviewArtifacts{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewArtifacts) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewArtifacts) ProtoMessage() {}

func (x *PreviewArtifacts) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewArtifacts.ProtoReflect.Descriptor instead.
func (*PreviewArtifacts) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{36}
}

func (x *PreviewArtifacts) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *PreviewArtifacts) GetArtifacts() string {
	if x != nil {
		return x.Artifacts
	}
	return ""
}

// A request to create a preview.
type CreatePreviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the Preview is created. The parent
	// value is in the format: 'projects/{project_id}/locations/{location}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The preview ID.
	PreviewId string `protobuf:"bytes,2,opt,name=preview_id,json=previewId,proto3" json:"preview_id,omitempty"`
	// Required. [Preview][google.cloud.config.v1.Preview] resource to be created.
	Preview *Preview `protobuf:"bytes,3,opt,name=preview,proto3" json:"preview,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreatePreviewRequest) Reset() {
	*x = CreatePreviewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[37]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreatePreviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePreviewRequest) ProtoMessage() {}

func (x *CreatePreviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[37]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePreviewRequest.ProtoReflect.Descriptor instead.
func (*CreatePreviewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{37}
}

func (x *CreatePreviewRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePreviewRequest) GetPreviewId() string {
	if x != nil {
		return x.PreviewId
	}
	return ""
}

func (x *CreatePreviewRequest) GetPreview() *Preview {
	if x != nil {
		return x.Preview
	}
	return nil
}

func (x *CreatePreviewRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to get details about a preview.
type GetPreviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the preview. Format:
	// 'projects/{project_id}/locations/{location}/previews/{preview}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPreviewRequest) Reset() {
	*x = GetPreviewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[38]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetPreviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPreviewRequest) ProtoMessage() {}

func (x *GetPreviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[38]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPreviewRequest.ProtoReflect.Descriptor instead.
func (*GetPreviewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{38}
}

func (x *GetPreviewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A request to list all previews for a given project and location.
type ListPreviewsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the Previews are listed. The parent
	// value is in the format: 'projects/{project_id}/locations/{location}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. When requesting a page of resources, 'page_size' specifies number
	// of resources to return. If unspecified, at most 500 will be returned. The
	// maximum value is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Token returned by previous call to 'ListDeployments' which
	// specifies the position in the list from where to continue listing the
	// resources.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Lists the Deployments that match the filter expression. A filter
	// expression filters the resources listed in the response. The expression
	// must be of the form '{field} {operator} {value}' where operators: '<', '>',
	// '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
	// operator which is roughly synonymous with equality). {field} can refer to a
	// proto or JSON field, or a synthetic field. Field names can be camelCase or
	// snake_case.
	//
	// Examples:
	//   - Filter by name:
	//     name = "projects/foo/locations/us-central1/deployments/bar
	//
	// - Filter by labels:
	//   - Resources that have a key called 'foo'
	//     labels.foo:*
	//   - Resources that have a key called 'foo' whose value is 'bar'
	//     labels.foo = bar
	//
	// - Filter by state:
	//   - Deployments in CREATING state.
	//     state=CREATING
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListPreviewsRequest) Reset() {
	*x = ListPreviewsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[39]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPreviewsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPreviewsRequest) ProtoMessage() {}

func (x *ListPreviewsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[39]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPreviewsRequest.ProtoReflect.Descriptor instead.
func (*ListPreviewsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{39}
}

func (x *ListPreviewsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPreviewsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPreviewsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPreviewsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPreviewsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// A response to a `ListPreviews` call. Contains a list of Previews.
type ListPreviewsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of [Previews][]s.
	Previews []*Preview `protobuf:"bytes,1,rep,name=previews,proto3" json:"previews,omitempty"`
	// Token to be supplied to the next ListPreviews request via `page_token`
	// to obtain the next set of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListPreviewsResponse) Reset() {
	*x = ListPreviewsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[40]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListPreviewsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPreviewsResponse) ProtoMessage() {}

func (x *ListPreviewsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[40]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPreviewsResponse.ProtoReflect.Descriptor instead.
func (*ListPreviewsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{40}
}

func (x *ListPreviewsResponse) GetPreviews() []*Preview {
	if x != nil {
		return x.Previews
	}
	return nil
}

func (x *ListPreviewsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListPreviewsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A request to delete a preview.
type DeletePreviewRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Preview in the format:
	// 'projects/{project_id}/locations/{location}/previews/{preview}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server will know to
	// ignore the request if it has already been completed. The server will
	// guarantee that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request ID,
	// the server can check if original operation with the same request ID was
	// received, and if so, will ignore the second request. This prevents clients
	// from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeletePreviewRequest) Reset() {
	*x = DeletePreviewRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[41]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeletePreviewRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePreviewRequest) ProtoMessage() {}

func (x *DeletePreviewRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[41]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePreviewRequest.ProtoReflect.Descriptor instead.
func (*DeletePreviewRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{41}
}

func (x *DeletePreviewRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePreviewRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// A request to export preview results.
type ExportPreviewResultRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The preview whose results should be exported. The preview value
	// is in the format:
	// 'projects/{project_id}/locations/{location}/previews/{preview}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ExportPreviewResultRequest) Reset() {
	*x = ExportPreviewResultRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[42]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportPreviewResultRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportPreviewResultRequest) ProtoMessage() {}

func (x *ExportPreviewResultRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[42]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportPreviewResultRequest.ProtoReflect.Descriptor instead.
func (*ExportPreviewResultRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{42}
}

func (x *ExportPreviewResultRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// A response to `ExportPreviewResult` call. Contains preview results.
type ExportPreviewResultResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Signed URLs for accessing the plan files.
	Result *PreviewResult `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ExportPreviewResultResponse) Reset() {
	*x = ExportPreviewResultResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[43]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportPreviewResultResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportPreviewResultResponse) ProtoMessage() {}

func (x *ExportPreviewResultResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[43]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportPreviewResultResponse.ProtoReflect.Descriptor instead.
func (*ExportPreviewResultResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{43}
}

func (x *ExportPreviewResultResponse) GetResult() *PreviewResult {
	if x != nil {
		return x.Result
	}
	return nil
}

// Contains a signed Cloud Storage URLs.
type PreviewResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Plan binary signed URL
	BinarySignedUri string `protobuf:"bytes,1,opt,name=binary_signed_uri,json=binarySignedUri,proto3" json:"binary_signed_uri,omitempty"`
	// Output only. Plan JSON signed URL
	JsonSignedUri string `protobuf:"bytes,2,opt,name=json_signed_uri,json=jsonSignedUri,proto3" json:"json_signed_uri,omitempty"`
}

func (x *PreviewResult) Reset() {
	*x = PreviewResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[44]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PreviewResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreviewResult) ProtoMessage() {}

func (x *PreviewResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[44]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreviewResult.ProtoReflect.Descriptor instead.
func (*PreviewResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{44}
}

func (x *PreviewResult) GetBinarySignedUri() string {
	if x != nil {
		return x.BinarySignedUri
	}
	return ""
}

func (x *PreviewResult) GetJsonSignedUri() string {
	if x != nil {
		return x.JsonSignedUri
	}
	return ""
}

// The request message for the GetTerraformVersion method.
type GetTerraformVersionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the TerraformVersion. Format:
	// 'projects/{project_id}/locations/{location}/terraformVersions/{terraform_version}'
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTerraformVersionRequest) Reset() {
	*x = GetTerraformVersionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[45]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTerraformVersionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTerraformVersionRequest) ProtoMessage() {}

func (x *GetTerraformVersionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[45]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTerraformVersionRequest.ProtoReflect.Descriptor instead.
func (*GetTerraformVersionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{45}
}

func (x *GetTerraformVersionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for the ListTerraformVersions method.
type ListTerraformVersionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent in whose context the TerraformVersions are listed. The
	// parent value is in the format:
	// 'projects/{project_id}/locations/{location}'.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. When requesting a page of resources, 'page_size' specifies number
	// of resources to return. If unspecified, at most 500 will be returned. The
	// maximum value is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. Token returned by previous call to 'ListTerraformVersions' which
	// specifies the position in the list from where to continue listing the
	// resources.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Lists the TerraformVersions that match the filter expression. A
	// filter expression filters the resources listed in the response. The
	// expression must be of the form '{field} {operator} {value}' where
	// operators: '<', '>',
	// '<=', '>=', '!=', '=', ':' are supported (colon ':' represents a HAS
	// operator which is roughly synonymous with equality). {field} can refer to a
	// proto or JSON field, or a synthetic field. Field names can be camelCase or
	// snake_case.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Field to use to sort the list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListTerraformVersionsRequest) Reset() {
	*x = ListTerraformVersionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[46]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTerraformVersionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTerraformVersionsRequest) ProtoMessage() {}

func (x *ListTerraformVersionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[46]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTerraformVersionsRequest.ProtoReflect.Descriptor instead.
func (*ListTerraformVersionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{46}
}

func (x *ListTerraformVersionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTerraformVersionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTerraformVersionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTerraformVersionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTerraformVersionsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// The response message for the `ListTerraformVersions` method.
type ListTerraformVersionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of [TerraformVersion][google.cloud.config.v1.TerraformVersion]s.
	TerraformVersions []*TerraformVersion `protobuf:"bytes,1,rep,name=terraform_versions,json=terraformVersions,proto3" json:"terraform_versions,omitempty"`
	// Token to be supplied to the next ListTerraformVersions request via
	// `page_token` to obtain the next set of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Unreachable resources, if any.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListTerraformVersionsResponse) Reset() {
	*x = ListTerraformVersionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[47]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTerraformVersionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTerraformVersionsResponse) ProtoMessage() {}

func (x *ListTerraformVersionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[47]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTerraformVersionsResponse.ProtoReflect.Descriptor instead.
func (*ListTerraformVersionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{47}
}

func (x *ListTerraformVersionsResponse) GetTerraformVersions() []*TerraformVersion {
	if x != nil {
		return x.TerraformVersions
	}
	return nil
}

func (x *ListTerraformVersionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTerraformVersionsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A TerraformVersion represents the support state the corresponding
// Terraform version.
type TerraformVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The version name is in the format:
	// 'projects/{project_id}/locations/{location}/terraformVersions/{terraform_version}'.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The state of the version, ACTIVE, DEPRECATED or OBSOLETE.
	State TerraformVersion_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.config.v1.TerraformVersion_State" json:"state,omitempty"`
	// Output only. When the version is supported.
	SupportTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=support_time,json=supportTime,proto3" json:"support_time,omitempty"`
	// Output only. When the version is deprecated.
	DeprecateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=deprecate_time,json=deprecateTime,proto3,oneof" json:"deprecate_time,omitempty"`
	// Output only. When the version is obsolete.
	ObsoleteTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=obsolete_time,json=obsoleteTime,proto3,oneof" json:"obsolete_time,omitempty"`
}

func (x *TerraformVersion) Reset() {
	*x = TerraformVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_config_v1_config_proto_msgTypes[48]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TerraformVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TerraformVersion) ProtoMessage() {}

func (x *TerraformVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_config_v1_config_proto_msgTypes[48]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TerraformVersion.ProtoReflect.Descriptor instead.
func (*TerraformVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_config_v1_config_proto_rawDescGZIP(), []int{48}
}

func (x *TerraformVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TerraformVersion) GetState() TerraformVersion_State {
	if x != nil {
		return x.State
	}
	return TerraformVersion_STATE_UNSPECIFIED
}

func (x *TerraformVersion) GetSupportTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SupportTime
	}
	return nil
}

func (x *TerraformVersion) GetDeprecateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.DeprecateTime
	}
	return nil
}

func (x *TerraformVersion) GetObsoleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ObsoleteTime
	}
	return nil
}

var File_google_cloud_config_v1_config_proto protoreflect.FileDescriptor

var file_google_cloud_config_v1_config_proto_rawDesc = []byte{
	0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xa0, 0x12, 0x0a, 0x0a, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x5d, 0x0a, 0x13, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x48, 0x00, 0x52, 0x12, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x0f,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x12, 0x50, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x50, 0x0a, 0x0e, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x5f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x24,
	0x0a, 0x0b, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x4c, 0x6f, 0x67, 0x73, 0x12, 0x48, 0x0a, 0x09, 0x74, 0x66, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x74, 0x66, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x22,
	0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4c, 0x6f,
	0x67, 0x73, 0x12, 0x3a, 0x0a, 0x14, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x5f,
	0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x12, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63,
	0x74, 0x73, 0x47, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x88, 0x01, 0x01, 0x12, 0x57,
	0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x48, 0x02, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x3f, 0x0a, 0x19, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x48, 0x03, 0x52, 0x17, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x48, 0x04, 0x52, 0x0a, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x50, 0x0a, 0x0a,
	0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x4c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x6c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3c,
	0x0a, 0x15, 0x74, 0x66, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x05, 0x52, 0x13, 0x74, 0x66, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a,
	0x74, 0x66, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x74, 0x66, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x57, 0x0a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x0b, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x7c, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41,
	0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50,
	0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10,
	0x06, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x07, 0x22, 0xdc,
	0x01, 0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1a, 0x0a, 0x16,
	0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x45, 0x56, 0x49,
	0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x21, 0x0a,
	0x1d, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x50, 0x45, 0x52,
	0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x1b, 0x0a, 0x17, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44,
	0x5f, 0x41, 0x50, 0x49, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x1b, 0x0a,
	0x17, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x52, 0x55,
	0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x25, 0x0a, 0x21, 0x42, 0x55,
	0x43, 0x4b, 0x45, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x50, 0x45,
	0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10,
	0x07, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x08, 0x22, 0x81, 0x01,
	0x0a, 0x09, 0x4c, 0x6f, 0x63, 0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4c,
	0x4f, 0x43, 0x4b, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x4c, 0x4f, 0x43, 0x4b, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x4e, 0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x0b, 0x0a, 0x07, 0x4c, 0x4f, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d,
	0x0a, 0x09, 0x55, 0x4e, 0x4c, 0x4f, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0f, 0x0a,
	0x0b, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x11,
	0x0a, 0x0d, 0x55, 0x4e, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x06, 0x3a, 0x67, 0xea, 0x41, 0x64, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x42, 0x0b, 0x0a, 0x09, 0x62, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x42, 0x12, 0x0a, 0x10, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x42, 0x1c, 0x0a, 0x1a, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x74, 0x66, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x22, 0xd8, 0x02, 0x0a,
	0x12, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x09,
	0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x67, 0x69, 0x74,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x69, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x09, 0x67, 0x69, 0x74, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x5e, 0x0a, 0x0c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6c, 0x75, 0x65, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x73, 0x1a, 0x69, 0x0a, 0x10, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3f, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x08, 0x0a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x4c, 0x0a, 0x11, 0x54, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x56, 0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x37, 0x0a, 0x0b,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xf8, 0x01, 0x0a, 0x0c, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x1c, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x4b,
	0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x1a, 0x63, 0x0a, 0x0c, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x5d, 0x0a, 0x0f, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22,
	0xca, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa9, 0x01, 0x0a,
	0x17, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x0b, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63,
	0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x54, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc7,
	0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a,
	0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xa1, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x3e, 0x0a, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x50, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xf3,
	0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a,
	0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x49, 0x64, 0x22, 0xc8, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x12, 0x47, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0xc6, 0x02, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a,
	0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x12, 0x66, 0x0a, 0x0d, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0x46, 0x0a, 0x0c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x1d, 0x0a, 0x19, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43,
	0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x41,
	0x42, 0x41, 0x4e, 0x44, 0x4f, 0x4e, 0x10, 0x02, 0x22, 0xbb, 0x04, 0x0a, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x6b,
	0x0a, 0x13, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x12, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x62, 0x0a, 0x10, 0x70,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65,
	0x72, 0x62, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76,
	0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61,
	0x70, 0x69, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x42, 0x13, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8a, 0x0d, 0x0a, 0x08, 0x52, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x13, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x5f, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x00, 0x52, 0x12, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6c,
	0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x44, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4e, 0x0a, 0x0d, 0x61, 0x70, 0x70, 0x6c,
	0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x6c,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x12, 0x4e, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x19, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6c,
	0x6f, 0x67, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6c, 0x6f, 0x67, 0x73, 0x12, 0x48, 0x0a, 0x09, 0x74, 0x66, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x74, 0x66, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x22,
	0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4c, 0x6f,
	0x67, 0x73, 0x12, 0x52, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x19, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17,
	0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x45, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x57, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x37, 0x0a, 0x15, 0x74, 0x66, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x74, 0x66, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x12,
	0x22, 0x0a, 0x0a, 0x74, 0x66, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x74, 0x66, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x3d, 0x0a, 0x18, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x1d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x12, 0x57, 0x0a, 0x10, 0x71, 0x75, 0x6f, 0x74, 0x61, 0x5f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x71, 0x75, 0x6f, 0x74,
	0x61, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0x0a, 0x06, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a,
	0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44,
	0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10,
	0x03, 0x22, 0x45, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12,
	0x0b, 0x0a, 0x07, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x22, 0x9f, 0x01, 0x0a, 0x09, 0x45, 0x72, 0x72,
	0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f,
	0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c,
	0x44, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e,
	0x49, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f, 0x42,
	0x55, 0x49, 0x4c, 0x44, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x04, 0x12, 0x1a, 0x0a, 0x16, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44,
	0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x1b, 0x0a,
	0x17, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x3a, 0x7a, 0xea, 0x41, 0x77, 0x0a,
	0x1e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x55, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x7d, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x42, 0x0b, 0x0a, 0x09, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x22, 0xc0, 0x01, 0x0a, 0x0e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x2c, 0x0a, 0x12, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x68,
	0x74, 0x74, 0x70, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x22, 0x8c, 0x01, 0x0a, 0x09, 0x47, 0x69, 0x74, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x12, 0x1c, 0x0a, 0x04, 0x72, 0x65, 0x70, 0x6f, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x72, 0x65, 0x70, 0x6f, 0x88,
	0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x64, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x88, 0x01, 0x01, 0x12, 0x1a, 0x0a, 0x03, 0x72, 0x65,
	0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x03,
	0x72, 0x65, 0x66, 0x88, 0x01, 0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x42,
	0x0c, 0x0a, 0x0a, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x06, 0x0a,
	0x04, 0x5f, 0x72, 0x65, 0x66, 0x22, 0xc0, 0x04, 0x0a, 0x1b, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x56, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x74, 0x65, 0x70, 0x52, 0x04, 0x73, 0x74, 0x65, 0x70, 0x12, 0x49, 0x0a,
	0x0d, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x6c,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c,
	0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6c, 0x6f, 0x67, 0x73, 0x22, 0xc9, 0x02, 0x0a,
	0x0e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x65, 0x70, 0x12,
	0x1f, 0x0a, 0x1b, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x53, 0x54,
	0x45, 0x50, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52, 0x45, 0x50, 0x41, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54,
	0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x01, 0x12, 0x19,
	0x0a, 0x15, 0x44, 0x4f, 0x57, 0x4e, 0x4c, 0x4f, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x42, 0x4c,
	0x55, 0x45, 0x50, 0x52, 0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x46, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x10, 0x03, 0x12, 0x13,
	0x0a, 0x0f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x46, 0x5f, 0x50, 0x4c, 0x41,
	0x4e, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x54,
	0x46, 0x5f, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x55, 0x4e,
	0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x46, 0x5f, 0x44, 0x45, 0x53, 0x54, 0x52, 0x4f, 0x59, 0x10,
	0x06, 0x12, 0x17, 0x0a, 0x13, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x46, 0x5f,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x45, 0x10, 0x07, 0x12, 0x18, 0x0a, 0x14, 0x55, 0x4e,
	0x4c, 0x4f, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45,
	0x4e, 0x54, 0x10, 0x08, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x0a, 0x12,
	0x19, 0x0a, 0x15, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45,
	0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x0b, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f, 0x56, 0x41, 0x4c, 0x49,
	0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x0c, 0x22, 0x93, 0x06, 0x0a, 0x08, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x59,
	0x0a, 0x0e, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72,
	0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x53, 0x0a, 0x0a, 0x63, 0x61, 0x69,
	0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x43, 0x61, 0x69, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x61, 0x69, 0x41, 0x73, 0x73, 0x65, 0x74, 0x73, 0x12, 0x44,
	0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x65, 0x0a, 0x0e, 0x43, 0x61, 0x69, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x41, 0x49, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x61,
	0x0a, 0x06, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x4e, 0x54, 0x45,
	0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x55, 0x4e, 0x43, 0x48, 0x41, 0x4e, 0x47, 0x45, 0x44, 0x10,
	0x05, 0x22, 0x58, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x4c, 0x41, 0x4e, 0x4e, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0f,
	0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45, 0x53, 0x53, 0x10, 0x02, 0x12,
	0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x43, 0x4f, 0x4e, 0x43, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x3a, 0x90, 0x01, 0xea, 0x41,
	0x8c, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x6a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x22, 0x55,
	0x0a, 0x15, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x18, 0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x3f, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x43, 0x41, 0x49, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x50, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc5, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xa1, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x22, 0x2f, 0x0a, 0x09, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69, 0x6c,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x5f, 0x75, 0x72, 0x69, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e,
	0x65, 0x64, 0x55, 0x72, 0x69, 0x22, 0x7f, 0x0a, 0x20, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x64,
	0x72, 0x61, 0x66, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x05, 0x64, 0x72, 0x61, 0x66, 0x74, 0x22, 0x60, 0x0a, 0x1e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69, 0x6c,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x9c, 0x01, 0x0a, 0x16, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1c, 0x0a, 0x07, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6c, 0x6f, 0x63,
	0x6b, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0a, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x64, 0x72, 0x61, 0x66,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x73, 0x6b,
	0x69, 0x70, 0x44, 0x72, 0x61, 0x66, 0x74, 0x22, 0x74, 0x0a, 0x16, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1c, 0x0a, 0x07, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x64, 0x22, 0x55, 0x0a,
	0x15, 0x4c, 0x6f, 0x63, 0x6b, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x75, 0x0a, 0x17, 0x55, 0x6e, 0x6c, 0x6f, 0x63, 0x6b, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a,
	0x07, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x64, 0x22, 0x55, 0x0a, 0x15, 0x45,
	0x78, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xbe, 0x01, 0x0a, 0x08, 0x4c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x17, 0x0a, 0x07, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x06, 0x6c, 0x6f, 0x63, 0x6b, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x77, 0x68,
	0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x77, 0x68, 0x6f, 0x12, 0x18, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0xee, 0x0e, 0x0a, 0x07, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12,
	0x5d, 0x0a, 0x13, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x62, 0x6c, 0x75,
	0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x42,
	0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x12, 0x74, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x48, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d,
	0x65, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x53, 0x0a, 0x0c, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x0f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4d, 0x6f,
	0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x52, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x14, 0x61, 0x72, 0x74, 0x69,
	0x66, 0x61, 0x63, 0x74, 0x73, 0x5f, 0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x12, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x47, 0x63, 0x73, 0x42, 0x75, 0x63, 0x6b, 0x65,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x0b, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70,
	0x6f, 0x6f, 0x6c, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2c, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x26, 0x0a, 0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72,
	0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x48, 0x02, 0x52, 0x0a, 0x77, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x4d, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x2e, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x3a, 0x0a, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x12, 0x48,
	0x0a, 0x09, 0x74, 0x66, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x74, 0x66, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x22, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x5f, 0x6c, 0x6f, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4c, 0x6f, 0x67, 0x73, 0x12, 0x5a, 0x0a, 0x11,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6c, 0x6f, 0x67, 0x73,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6c, 0x6f, 0x67,
	0x73, 0x12, 0x22, 0x0a, 0x0a, 0x74, 0x66, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x12, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x74, 0x66, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x0a, 0x15, 0x74, 0x66, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x13, 0x74, 0x66, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x74,
	0x88, 0x01, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7b,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x41,
	0x50, 0x50, 0x4c, 0x59, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x53, 0x54, 0x41,
	0x4c, 0x45, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0b,
	0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x07, 0x22, 0x44, 0x0a, 0x0b, 0x50,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52,
	0x45, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x46, 0x41,
	0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10,
	0x02, 0x22, 0xed, 0x01, 0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x43,
	0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49,
	0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x01, 0x12, 0x25,
	0x0a, 0x21, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4f,
	0x4e, 0x5f, 0x50, 0x45, 0x52, 0x4d, 0x49, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x44, 0x45, 0x4e,
	0x49, 0x45, 0x44, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x5f,
	0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x22, 0x0a, 0x1e, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x5f,
	0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x41, 0x43, 0x51, 0x55, 0x49, 0x52, 0x45, 0x5f, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57,
	0x5f, 0x42, 0x55, 0x49, 0x4c, 0x44, 0x5f, 0x41, 0x50, 0x49, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x05, 0x12, 0x1c, 0x0a, 0x18, 0x50, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42,
	0x55, 0x49, 0x4c, 0x44, 0x5f, 0x52, 0x55, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x06, 0x3a, 0x71, 0xea, 0x41, 0x6e, 0x0a, 0x1d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x7d, 0x2a, 0x08, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x32, 0x07, 0x70, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x42, 0x0b, 0x0a, 0x09, 0x62, 0x6c, 0x75, 0x65, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x5f,
	0x67, 0x63, 0x73, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x74,
	0x66, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72,
	0x61, 0x69, 0x6e, 0x74, 0x22, 0x89, 0x04, 0x0a, 0x18, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x50, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x65, 0x70, 0x52, 0x04, 0x73,
	0x74, 0x65, 0x70, 0x12, 0x55, 0x0a, 0x11, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x61,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x41,
	0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x52, 0x10, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x6c, 0x6f,
	0x67, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6c,
	0x6f, 0x67, 0x73, 0x12, 0x19, 0x0a, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x22, 0x8f,
	0x02, 0x0a, 0x0b, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x74, 0x65, 0x70, 0x12, 0x1c,
	0x0a, 0x18, 0x50, 0x52, 0x45, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x53, 0x54, 0x45, 0x50, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18,
	0x50, 0x52, 0x45, 0x50, 0x41, 0x52, 0x49, 0x4e, 0x47, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47,
	0x45, 0x5f, 0x42, 0x55, 0x43, 0x4b, 0x45, 0x54, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x44, 0x4f,
	0x57, 0x4e, 0x4c, 0x4f, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x42, 0x4c, 0x55, 0x45, 0x50, 0x52,
	0x49, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47,
	0x5f, 0x54, 0x46, 0x5f, 0x49, 0x4e, 0x49, 0x54, 0x10, 0x03, 0x12, 0x13, 0x0a, 0x0f, 0x52, 0x55,
	0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x54, 0x46, 0x5f, 0x50, 0x4c, 0x41, 0x4e, 0x10, 0x04, 0x12,
	0x17, 0x0a, 0x13, 0x46, 0x45, 0x54, 0x43, 0x48, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x50, 0x4c,
	0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x05, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x4f, 0x43, 0x4b,
	0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45, 0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x06,
	0x12, 0x18, 0x0a, 0x14, 0x55, 0x4e, 0x4c, 0x4f, 0x43, 0x4b, 0x49, 0x4e, 0x47, 0x5f, 0x44, 0x45,
	0x50, 0x4c, 0x4f, 0x59, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x08, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x09, 0x12, 0x19, 0x0a, 0x15, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x53, 0x49, 0x54, 0x4f, 0x52, 0x59, 0x10, 0x0a,
	0x22, 0x54, 0x0a, 0x10, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x73, 0x12, 0x1d, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x73, 0x22, 0xe9, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x07, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x70,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2,
	0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x4e, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xdb, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0x9d, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x0a, 0x08, 0x70, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x08, 0x70, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20,
	0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x7d, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7,
	0x08, 0x02, 0x08, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0x5b, 0x0a, 0x1a, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1f, 0x0a, 0x1d, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0x61, 0x0a, 0x1b,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x06, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22,
	0x6d, 0x0a, 0x0d, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x2f, 0x0a, 0x11, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x55, 0x72,
	0x69, 0x12, 0x2b, 0x0a, 0x0f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x6a, 0x73, 0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x55, 0x72, 0x69, 0x22, 0x60,
	0x0a, 0x1a, 0x47, 0x65, 0x74, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x28, 0x0a, 0x26, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xe4, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f,
	0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc2, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x12, 0x74, 0x65, 0x72,
	0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x11, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xe4, 0x04, 0x0a,
	0x10, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x42, 0x0a, 0x0c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x0e, 0x64, 0x65, 0x70,
	0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x49, 0x0a, 0x0d, 0x6f, 0x62, 0x73, 0x6f, 0x6c, 0x65,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x0c, 0x6f, 0x62, 0x73, 0x6f, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x88, 0x01,
	0x01, 0x22, 0x48, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a,
	0x0a, 0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0c, 0x0a,
	0x08, 0x4f, 0x42, 0x53, 0x4f, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x03, 0x3a, 0xa0, 0x01, 0xea, 0x41,
	0x9c, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66,
	0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x2a, 0x11, 0x74, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x32, 0x10, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x11,
	0x0a, 0x0f, 0x5f, 0x64, 0x65, 0x70, 0x72, 0x65, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6f, 0x62, 0x73, 0x6f, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x2a, 0x4e, 0x0a, 0x0f, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x51, 0x55, 0x4f, 0x54, 0x41, 0x5f,
	0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x41, 0x42,
	0x4c, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45,
	0x44, 0x10, 0x02, 0x32, 0xa7, 0x23, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xb4,
	0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x40, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xa1, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xec, 0x01, 0x0a, 0x10, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87,
	0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x1f, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x3a, 0x0a, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0xee, 0x01, 0x0a, 0x10, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01,
	0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x16, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x48, 0x3a, 0x0a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x3a, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc4, 0x01, 0x0a, 0x10, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x60,
	0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x2a,
	0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xba, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x4c, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d,
	0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xa7, 0x01,
	0x0a, 0x0b, 0x47, 0x65, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x4a, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x12, 0x3b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb3, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x56, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc6, 0x01,
	0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x58, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0xc2, 0x01, 0x0a, 0x19, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69, 0x6c,
	0x65, 0x22, 0x48, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0xca, 0x01, 0x0a, 0x17,
	0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69,
	0x6c, 0x65, 0x22, 0x54, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x01, 0x2a, 0x22, 0x49, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0xbf, 0x01, 0x0a, 0x0f, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x22,
	0x59, 0xda, 0x41, 0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6c, 0x6f, 0x63, 0x6b, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0xa8, 0x01, 0x0a, 0x0f, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x4d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x01, 0x2a, 0x22, 0x3b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0xc8, 0x01, 0x0a, 0x0e, 0x4c, 0x6f, 0x63, 0x6b, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x6b, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x68, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x44, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x01, 0x2a, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70,
	0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6c, 0x6f, 0x63, 0x6b,
	0x12, 0xd6, 0x01, 0x0a, 0x10, 0x55, 0x6e, 0x6c, 0x6f, 0x63, 0x6b, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x6e, 0x6c, 0x6f, 0x63, 0x6b, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0c, 0x6e, 0x61, 0x6d, 0x65,
	0x2c, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x3a, 0x01,
	0x2a, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x75, 0x6e, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0xac, 0x01, 0x0a, 0x0e, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4c, 0x6f, 0x63, 0x6b,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x20, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0x49, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x4c, 0x6f, 0x63, 0x6b, 0x12, 0xcb, 0x01, 0x0a, 0x0d, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x50, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0e, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x2c, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a,
	0x07, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x22, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x95, 0x01, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x50, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x22, 0x3b, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e,
	0x12, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa8,
	0x01, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65,
	0x76, 0x69, 0x65, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3d, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x12, 0x2c, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0xb8, 0x01, 0x0a, 0x0d, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x65, 0x76, 0x69,
	0x65, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5a, 0xca, 0x41, 0x1c, 0x0a, 0x07, 0x50,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2e, 0x2a, 0x2c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc0, 0x01, 0x0a, 0x13, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50,
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72, 0x65, 0x76,
	0x69, 0x65, 0x77, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a,
	0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xcc, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12,
	0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x65, 0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xb9, 0x01, 0x0a, 0x13, 0x47, 0x65, 0x74, 0x54, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x65, 0x72, 0x72, 0x61,
	0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x72, 0x72,
	0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x44, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x65,
	0x72, 0x72, 0x61, 0x66, 0x6f, 0x72, 0x6d, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x1a, 0x49, 0xca, 0x41, 0x15, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xfc, 0x02,
	0xea, 0x41, 0x59, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x7d, 0xea, 0x41, 0x69, 0x0a,
	0x24, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x65,
	0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77,
	0x6f, 0x72, 0x6b, 0x65, 0x72, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b,
	0x65, 0x72, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f, 0x74,
	0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x70, 0x62, 0x3b, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x31,
	0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_config_v1_config_proto_rawDescOnce sync.Once
	file_google_cloud_config_v1_config_proto_rawDescData = file_google_cloud_config_v1_config_proto_rawDesc
)

func file_google_cloud_config_v1_config_proto_rawDescGZIP() []byte {
	file_google_cloud_config_v1_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_config_v1_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_config_v1_config_proto_rawDescData)
	})
	return file_google_cloud_config_v1_config_proto_rawDescData
}

var file_google_cloud_config_v1_config_proto_enumTypes = make([]protoimpl.EnumInfo, 16)
var file_google_cloud_config_v1_config_proto_msgTypes = make([]protoimpl.MessageInfo, 55)
var file_google_cloud_config_v1_config_proto_goTypes = []interface{}{
	(QuotaValidation)(0),                            // 0: google.cloud.config.v1.QuotaValidation
	(Deployment_State)(0),                           // 1: google.cloud.config.v1.Deployment.State
	(Deployment_ErrorCode)(0),                       // 2: google.cloud.config.v1.Deployment.ErrorCode
	(Deployment_LockState)(0),                       // 3: google.cloud.config.v1.Deployment.LockState
	(DeleteDeploymentRequest_DeletePolicy)(0),       // 4: google.cloud.config.v1.DeleteDeploymentRequest.DeletePolicy
	(Revision_Action)(0),                            // 5: google.cloud.config.v1.Revision.Action
	(Revision_State)(0),                             // 6: google.cloud.config.v1.Revision.State
	(Revision_ErrorCode)(0),                         // 7: google.cloud.config.v1.Revision.ErrorCode
	(DeploymentOperationMetadata_DeploymentStep)(0), // 8: google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep
	(Resource_Intent)(0),                            // 9: google.cloud.config.v1.Resource.Intent
	(Resource_State)(0),                             // 10: google.cloud.config.v1.Resource.State
	(Preview_State)(0),                              // 11: google.cloud.config.v1.Preview.State
	(Preview_PreviewMode)(0),                        // 12: google.cloud.config.v1.Preview.PreviewMode
	(Preview_ErrorCode)(0),                          // 13: google.cloud.config.v1.Preview.ErrorCode
	(PreviewOperationMetadata_PreviewStep)(0),       // 14: google.cloud.config.v1.PreviewOperationMetadata.PreviewStep
	(TerraformVersion_State)(0),                     // 15: google.cloud.config.v1.TerraformVersion.State
	(*Deployment)(nil),                              // 16: google.cloud.config.v1.Deployment
	(*TerraformBlueprint)(nil),                      // 17: google.cloud.config.v1.TerraformBlueprint
	(*TerraformVariable)(nil),                       // 18: google.cloud.config.v1.TerraformVariable
	(*ApplyResults)(nil),                            // 19: google.cloud.config.v1.ApplyResults
	(*TerraformOutput)(nil),                         // 20: google.cloud.config.v1.TerraformOutput
	(*ListDeploymentsRequest)(nil),                  // 21: google.cloud.config.v1.ListDeploymentsRequest
	(*ListDeploymentsResponse)(nil),                 // 22: google.cloud.config.v1.ListDeploymentsResponse
	(*GetDeploymentRequest)(nil),                    // 23: google.cloud.config.v1.GetDeploymentRequest
	(*ListRevisionsRequest)(nil),                    // 24: google.cloud.config.v1.ListRevisionsRequest
	(*ListRevisionsResponse)(nil),                   // 25: google.cloud.config.v1.ListRevisionsResponse
	(*GetRevisionRequest)(nil),                      // 26: google.cloud.config.v1.GetRevisionRequest
	(*CreateDeploymentRequest)(nil),                 // 27: google.cloud.config.v1.CreateDeploymentRequest
	(*UpdateDeploymentRequest)(nil),                 // 28: google.cloud.config.v1.UpdateDeploymentRequest
	(*DeleteDeploymentRequest)(nil),                 // 29: google.cloud.config.v1.DeleteDeploymentRequest
	(*OperationMetadata)(nil),                       // 30: google.cloud.config.v1.OperationMetadata
	(*Revision)(nil),                                // 31: google.cloud.config.v1.Revision
	(*TerraformError)(nil),                          // 32: google.cloud.config.v1.TerraformError
	(*GitSource)(nil),                               // 33: google.cloud.config.v1.GitSource
	(*DeploymentOperationMetadata)(nil),             // 34: google.cloud.config.v1.DeploymentOperationMetadata
	(*Resource)(nil),                                // 35: google.cloud.config.v1.Resource
	(*ResourceTerraformInfo)(nil),                   // 36: google.cloud.config.v1.ResourceTerraformInfo
	(*ResourceCAIInfo)(nil),                         // 37: google.cloud.config.v1.ResourceCAIInfo
	(*GetResourceRequest)(nil),                      // 38: google.cloud.config.v1.GetResourceRequest
	(*ListResourcesRequest)(nil),                    // 39: google.cloud.config.v1.ListResourcesRequest
	(*ListResourcesResponse)(nil),                   // 40: google.cloud.config.v1.ListResourcesResponse
	(*Statefile)(nil),                               // 41: google.cloud.config.v1.Statefile
	(*ExportDeploymentStatefileRequest)(nil),        // 42: google.cloud.config.v1.ExportDeploymentStatefileRequest
	(*ExportRevisionStatefileRequest)(nil),          // 43: google.cloud.config.v1.ExportRevisionStatefileRequest
	(*ImportStatefileRequest)(nil),                  // 44: google.cloud.config.v1.ImportStatefileRequest
	(*DeleteStatefileRequest)(nil),                  // 45: google.cloud.config.v1.DeleteStatefileRequest
	(*LockDeploymentRequest)(nil),                   // 46: google.cloud.config.v1.LockDeploymentRequest
	(*UnlockDeploymentRequest)(nil),                 // 47: google.cloud.config.v1.UnlockDeploymentRequest
	(*ExportLockInfoRequest)(nil),                   // 48: google.cloud.config.v1.ExportLockInfoRequest
	(*LockInfo)(nil),                                // 49: google.cloud.config.v1.LockInfo
	(*Preview)(nil),                                 // 50: google.cloud.config.v1.Preview
	(*PreviewOperationMetadata)(nil),                // 51: google.cloud.config.v1.PreviewOperationMetadata
	(*PreviewArtifacts)(nil),                        // 52: google.cloud.config.v1.PreviewArtifacts
	(*CreatePreviewRequest)(nil),                    // 53: google.cloud.config.v1.CreatePreviewRequest
	(*GetPreviewRequest)(nil),                       // 54: google.cloud.config.v1.GetPreviewRequest
	(*ListPreviewsRequest)(nil),                     // 55: google.cloud.config.v1.ListPreviewsRequest
	(*ListPreviewsResponse)(nil),                    // 56: google.cloud.config.v1.ListPreviewsResponse
	(*DeletePreviewRequest)(nil),                    // 57: google.cloud.config.v1.DeletePreviewRequest
	(*ExportPreviewResultRequest)(nil),              // 58: google.cloud.config.v1.ExportPreviewResultRequest
	(*ExportPreviewResultResponse)(nil),             // 59: google.cloud.config.v1.ExportPreviewResultResponse
	(*PreviewResult)(nil),                           // 60: google.cloud.config.v1.PreviewResult
	(*GetTerraformVersionRequest)(nil),              // 61: google.cloud.config.v1.GetTerraformVersionRequest
	(*ListTerraformVersionsRequest)(nil),            // 62: google.cloud.config.v1.ListTerraformVersionsRequest
	(*ListTerraformVersionsResponse)(nil),           // 63: google.cloud.config.v1.ListTerraformVersionsResponse
	(*TerraformVersion)(nil),                        // 64: google.cloud.config.v1.TerraformVersion
	nil,                                             // 65: google.cloud.config.v1.Deployment.LabelsEntry
	nil,                                             // 66: google.cloud.config.v1.Deployment.AnnotationsEntry
	nil,                                             // 67: google.cloud.config.v1.TerraformBlueprint.InputValuesEntry
	nil,                                             // 68: google.cloud.config.v1.ApplyResults.OutputsEntry
	nil,                                             // 69: google.cloud.config.v1.Resource.CaiAssetsEntry
	nil,                                             // 70: google.cloud.config.v1.Preview.LabelsEntry
	(*timestamppb.Timestamp)(nil),                   // 71: google.protobuf.Timestamp
	(*structpb.Value)(nil),                          // 72: google.protobuf.Value
	(*fieldmaskpb.FieldMask)(nil),                   // 73: google.protobuf.FieldMask
	(*status.Status)(nil),                           // 74: google.rpc.Status
	(*longrunningpb.Operation)(nil),                 // 75: google.longrunning.Operation
	(*emptypb.Empty)(nil),                           // 76: google.protobuf.Empty
}
var file_google_cloud_config_v1_config_proto_depIdxs = []int32{
	17, // 0: google.cloud.config.v1.Deployment.terraform_blueprint:type_name -> google.cloud.config.v1.TerraformBlueprint
	71, // 1: google.cloud.config.v1.Deployment.create_time:type_name -> google.protobuf.Timestamp
	71, // 2: google.cloud.config.v1.Deployment.update_time:type_name -> google.protobuf.Timestamp
	65, // 3: google.cloud.config.v1.Deployment.labels:type_name -> google.cloud.config.v1.Deployment.LabelsEntry
	1,  // 4: google.cloud.config.v1.Deployment.state:type_name -> google.cloud.config.v1.Deployment.State
	2,  // 5: google.cloud.config.v1.Deployment.error_code:type_name -> google.cloud.config.v1.Deployment.ErrorCode
	19, // 6: google.cloud.config.v1.Deployment.delete_results:type_name -> google.cloud.config.v1.ApplyResults
	32, // 7: google.cloud.config.v1.Deployment.tf_errors:type_name -> google.cloud.config.v1.TerraformError
	3,  // 8: google.cloud.config.v1.Deployment.lock_state:type_name -> google.cloud.config.v1.Deployment.LockState
	0,  // 9: google.cloud.config.v1.Deployment.quota_validation:type_name -> google.cloud.config.v1.QuotaValidation
	66, // 10: google.cloud.config.v1.Deployment.annotations:type_name -> google.cloud.config.v1.Deployment.AnnotationsEntry
	33, // 11: google.cloud.config.v1.TerraformBlueprint.git_source:type_name -> google.cloud.config.v1.GitSource
	67, // 12: google.cloud.config.v1.TerraformBlueprint.input_values:type_name -> google.cloud.config.v1.TerraformBlueprint.InputValuesEntry
	72, // 13: google.cloud.config.v1.TerraformVariable.input_value:type_name -> google.protobuf.Value
	68, // 14: google.cloud.config.v1.ApplyResults.outputs:type_name -> google.cloud.config.v1.ApplyResults.OutputsEntry
	72, // 15: google.cloud.config.v1.TerraformOutput.value:type_name -> google.protobuf.Value
	16, // 16: google.cloud.config.v1.ListDeploymentsResponse.deployments:type_name -> google.cloud.config.v1.Deployment
	31, // 17: google.cloud.config.v1.ListRevisionsResponse.revisions:type_name -> google.cloud.config.v1.Revision
	16, // 18: google.cloud.config.v1.CreateDeploymentRequest.deployment:type_name -> google.cloud.config.v1.Deployment
	73, // 19: google.cloud.config.v1.UpdateDeploymentRequest.update_mask:type_name -> google.protobuf.FieldMask
	16, // 20: google.cloud.config.v1.UpdateDeploymentRequest.deployment:type_name -> google.cloud.config.v1.Deployment
	4,  // 21: google.cloud.config.v1.DeleteDeploymentRequest.delete_policy:type_name -> google.cloud.config.v1.DeleteDeploymentRequest.DeletePolicy
	34, // 22: google.cloud.config.v1.OperationMetadata.deployment_metadata:type_name -> google.cloud.config.v1.DeploymentOperationMetadata
	51, // 23: google.cloud.config.v1.OperationMetadata.preview_metadata:type_name -> google.cloud.config.v1.PreviewOperationMetadata
	71, // 24: google.cloud.config.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	71, // 25: google.cloud.config.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	17, // 26: google.cloud.config.v1.Revision.terraform_blueprint:type_name -> google.cloud.config.v1.TerraformBlueprint
	71, // 27: google.cloud.config.v1.Revision.create_time:type_name -> google.protobuf.Timestamp
	71, // 28: google.cloud.config.v1.Revision.update_time:type_name -> google.protobuf.Timestamp
	5,  // 29: google.cloud.config.v1.Revision.action:type_name -> google.cloud.config.v1.Revision.Action
	6,  // 30: google.cloud.config.v1.Revision.state:type_name -> google.cloud.config.v1.Revision.State
	19, // 31: google.cloud.config.v1.Revision.apply_results:type_name -> google.cloud.config.v1.ApplyResults
	7,  // 32: google.cloud.config.v1.Revision.error_code:type_name -> google.cloud.config.v1.Revision.ErrorCode
	32, // 33: google.cloud.config.v1.Revision.tf_errors:type_name -> google.cloud.config.v1.TerraformError
	0,  // 34: google.cloud.config.v1.Revision.quota_validation:type_name -> google.cloud.config.v1.QuotaValidation
	74, // 35: google.cloud.config.v1.TerraformError.error:type_name -> google.rpc.Status
	8,  // 36: google.cloud.config.v1.DeploymentOperationMetadata.step:type_name -> google.cloud.config.v1.DeploymentOperationMetadata.DeploymentStep
	19, // 37: google.cloud.config.v1.DeploymentOperationMetadata.apply_results:type_name -> google.cloud.config.v1.ApplyResults
	36, // 38: google.cloud.config.v1.Resource.terraform_info:type_name -> google.cloud.config.v1.ResourceTerraformInfo
	69, // 39: google.cloud.config.v1.Resource.cai_assets:type_name -> google.cloud.config.v1.Resource.CaiAssetsEntry
	9,  // 40: google.cloud.config.v1.Resource.intent:type_name -> google.cloud.config.v1.Resource.Intent
	10, // 41: google.cloud.config.v1.Resource.state:type_name -> google.cloud.config.v1.Resource.State
	35, // 42: google.cloud.config.v1.ListResourcesResponse.resources:type_name -> google.cloud.config.v1.Resource
	71, // 43: google.cloud.config.v1.LockInfo.create_time:type_name -> google.protobuf.Timestamp
	17, // 44: google.cloud.config.v1.Preview.terraform_blueprint:type_name -> google.cloud.config.v1.TerraformBlueprint
	71, // 45: google.cloud.config.v1.Preview.create_time:type_name -> google.protobuf.Timestamp
	70, // 46: google.cloud.config.v1.Preview.labels:type_name -> google.cloud.config.v1.Preview.LabelsEntry
	11, // 47: google.cloud.config.v1.Preview.state:type_name -> google.cloud.config.v1.Preview.State
	12, // 48: google.cloud.config.v1.Preview.preview_mode:type_name -> google.cloud.config.v1.Preview.PreviewMode
	13, // 49: google.cloud.config.v1.Preview.error_code:type_name -> google.cloud.config.v1.Preview.ErrorCode
	74, // 50: google.cloud.config.v1.Preview.error_status:type_name -> google.rpc.Status
	32, // 51: google.cloud.config.v1.Preview.tf_errors:type_name -> google.cloud.config.v1.TerraformError
	52, // 52: google.cloud.config.v1.Preview.preview_artifacts:type_name -> google.cloud.config.v1.PreviewArtifacts
	14, // 53: google.cloud.config.v1.PreviewOperationMetadata.step:type_name -> google.cloud.config.v1.PreviewOperationMetadata.PreviewStep
	52, // 54: google.cloud.config.v1.PreviewOperationMetadata.preview_artifacts:type_name -> google.cloud.config.v1.PreviewArtifacts
	50, // 55: google.cloud.config.v1.CreatePreviewRequest.preview:type_name -> google.cloud.config.v1.Preview
	50, // 56: google.cloud.config.v1.ListPreviewsResponse.previews:type_name -> google.cloud.config.v1.Preview
	60, // 57: google.cloud.config.v1.ExportPreviewResultResponse.result:type_name -> google.cloud.config.v1.PreviewResult
	64, // 58: google.cloud.config.v1.ListTerraformVersionsResponse.terraform_versions:type_name -> google.cloud.config.v1.TerraformVersion
	15, // 59: google.cloud.config.v1.TerraformVersion.state:type_name -> google.cloud.config.v1.TerraformVersion.State
	71, // 60: google.cloud.config.v1.TerraformVersion.support_time:type_name -> google.protobuf.Timestamp
	71, // 61: google.cloud.config.v1.TerraformVersion.deprecate_time:type_name -> google.protobuf.Timestamp
	71, // 62: google.cloud.config.v1.TerraformVersion.obsolete_time:type_name -> google.protobuf.Timestamp
	18, // 63: google.cloud.config.v1.TerraformBlueprint.InputValuesEntry.value:type_name -> google.cloud.config.v1.TerraformVariable
	20, // 64: google.cloud.config.v1.ApplyResults.OutputsEntry.value:type_name -> google.cloud.config.v1.TerraformOutput
	37, // 65: google.cloud.config.v1.Resource.CaiAssetsEntry.value:type_name -> google.cloud.config.v1.ResourceCAIInfo
	21, // 66: google.cloud.config.v1.Config.ListDeployments:input_type -> google.cloud.config.v1.ListDeploymentsRequest
	23, // 67: google.cloud.config.v1.Config.GetDeployment:input_type -> google.cloud.config.v1.GetDeploymentRequest
	27, // 68: google.cloud.config.v1.Config.CreateDeployment:input_type -> google.cloud.config.v1.CreateDeploymentRequest
	28, // 69: google.cloud.config.v1.Config.UpdateDeployment:input_type -> google.cloud.config.v1.UpdateDeploymentRequest
	29, // 70: google.cloud.config.v1.Config.DeleteDeployment:input_type -> google.cloud.config.v1.DeleteDeploymentRequest
	24, // 71: google.cloud.config.v1.Config.ListRevisions:input_type -> google.cloud.config.v1.ListRevisionsRequest
	26, // 72: google.cloud.config.v1.Config.GetRevision:input_type -> google.cloud.config.v1.GetRevisionRequest
	38, // 73: google.cloud.config.v1.Config.GetResource:input_type -> google.cloud.config.v1.GetResourceRequest
	39, // 74: google.cloud.config.v1.Config.ListResources:input_type -> google.cloud.config.v1.ListResourcesRequest
	42, // 75: google.cloud.config.v1.Config.ExportDeploymentStatefile:input_type -> google.cloud.config.v1.ExportDeploymentStatefileRequest
	43, // 76: google.cloud.config.v1.Config.ExportRevisionStatefile:input_type -> google.cloud.config.v1.ExportRevisionStatefileRequest
	44, // 77: google.cloud.config.v1.Config.ImportStatefile:input_type -> google.cloud.config.v1.ImportStatefileRequest
	45, // 78: google.cloud.config.v1.Config.DeleteStatefile:input_type -> google.cloud.config.v1.DeleteStatefileRequest
	46, // 79: google.cloud.config.v1.Config.LockDeployment:input_type -> google.cloud.config.v1.LockDeploymentRequest
	47, // 80: google.cloud.config.v1.Config.UnlockDeployment:input_type -> google.cloud.config.v1.UnlockDeploymentRequest
	48, // 81: google.cloud.config.v1.Config.ExportLockInfo:input_type -> google.cloud.config.v1.ExportLockInfoRequest
	53, // 82: google.cloud.config.v1.Config.CreatePreview:input_type -> google.cloud.config.v1.CreatePreviewRequest
	54, // 83: google.cloud.config.v1.Config.GetPreview:input_type -> google.cloud.config.v1.GetPreviewRequest
	55, // 84: google.cloud.config.v1.Config.ListPreviews:input_type -> google.cloud.config.v1.ListPreviewsRequest
	57, // 85: google.cloud.config.v1.Config.DeletePreview:input_type -> google.cloud.config.v1.DeletePreviewRequest
	58, // 86: google.cloud.config.v1.Config.ExportPreviewResult:input_type -> google.cloud.config.v1.ExportPreviewResultRequest
	62, // 87: google.cloud.config.v1.Config.ListTerraformVersions:input_type -> google.cloud.config.v1.ListTerraformVersionsRequest
	61, // 88: google.cloud.config.v1.Config.GetTerraformVersion:input_type -> google.cloud.config.v1.GetTerraformVersionRequest
	22, // 89: google.cloud.config.v1.Config.ListDeployments:output_type -> google.cloud.config.v1.ListDeploymentsResponse
	16, // 90: google.cloud.config.v1.Config.GetDeployment:output_type -> google.cloud.config.v1.Deployment
	75, // 91: google.cloud.config.v1.Config.CreateDeployment:output_type -> google.longrunning.Operation
	75, // 92: google.cloud.config.v1.Config.UpdateDeployment:output_type -> google.longrunning.Operation
	75, // 93: google.cloud.config.v1.Config.DeleteDeployment:output_type -> google.longrunning.Operation
	25, // 94: google.cloud.config.v1.Config.ListRevisions:output_type -> google.cloud.config.v1.ListRevisionsResponse
	31, // 95: google.cloud.config.v1.Config.GetRevision:output_type -> google.cloud.config.v1.Revision
	35, // 96: google.cloud.config.v1.Config.GetResource:output_type -> google.cloud.config.v1.Resource
	40, // 97: google.cloud.config.v1.Config.ListResources:output_type -> google.cloud.config.v1.ListResourcesResponse
	41, // 98: google.cloud.config.v1.Config.ExportDeploymentStatefile:output_type -> google.cloud.config.v1.Statefile
	41, // 99: google.cloud.config.v1.Config.ExportRevisionStatefile:output_type -> google.cloud.config.v1.Statefile
	41, // 100: google.cloud.config.v1.Config.ImportStatefile:output_type -> google.cloud.config.v1.Statefile
	76, // 101: google.cloud.config.v1.Config.DeleteStatefile:output_type -> google.protobuf.Empty
	75, // 102: google.cloud.config.v1.Config.LockDeployment:output_type -> google.longrunning.Operation
	75, // 103: google.cloud.config.v1.Config.UnlockDeployment:output_type -> google.longrunning.Operation
	49, // 104: google.cloud.config.v1.Config.ExportLockInfo:output_type -> google.cloud.config.v1.LockInfo
	75, // 105: google.cloud.config.v1.Config.CreatePreview:output_type -> google.longrunning.Operation
	50, // 106: google.cloud.config.v1.Config.GetPreview:output_type -> google.cloud.config.v1.Preview
	56, // 107: google.cloud.config.v1.Config.ListPreviews:output_type -> google.cloud.config.v1.ListPreviewsResponse
	75, // 108: google.cloud.config.v1.Config.DeletePreview:output_type -> google.longrunning.Operation
	59, // 109: google.cloud.config.v1.Config.ExportPreviewResult:output_type -> google.cloud.config.v1.ExportPreviewResultResponse
	63, // 110: google.cloud.config.v1.Config.ListTerraformVersions:output_type -> google.cloud.config.v1.ListTerraformVersionsResponse
	64, // 111: google.cloud.config.v1.Config.GetTerraformVersion:output_type -> google.cloud.config.v1.TerraformVersion
	89, // [89:112] is the sub-list for method output_type
	66, // [66:89] is the sub-list for method input_type
	66, // [66:66] is the sub-list for extension type_name
	66, // [66:66] is the sub-list for extension extendee
	0,  // [0:66] is the sub-list for field type_name
}

func init() { file_google_cloud_config_v1_config_proto_init() }
func file_google_cloud_config_v1_config_proto_init() {
	if File_google_cloud_config_v1_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_config_v1_config_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Deployment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TerraformBlueprint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TerraformVariable); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyResults); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TerraformOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeploymentsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDeploymentsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRevisionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRevisionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRevisionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Revision); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TerraformError); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GitSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeploymentOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceTerraformInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceCAIInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetResourceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListResourcesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListResourcesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Statefile); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportDeploymentStatefileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportRevisionStatefileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportStatefileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteStatefileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LockDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnlockDeploymentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportLockInfoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LockInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Preview); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewOperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewArtifacts); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[37].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreatePreviewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[38].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetPreviewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[39].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPreviewsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[40].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListPreviewsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[41].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeletePreviewRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[42].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportPreviewResultRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[43].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportPreviewResultResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[44].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PreviewResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[45].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTerraformVersionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[46].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTerraformVersionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[47].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTerraformVersionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_config_v1_config_proto_msgTypes[48].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TerraformVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_config_v1_config_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Deployment_TerraformBlueprint)(nil),
	}
	file_google_cloud_config_v1_config_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*TerraformBlueprint_GcsSource)(nil),
		(*TerraformBlueprint_GitSource)(nil),
	}
	file_google_cloud_config_v1_config_proto_msgTypes[14].OneofWrappers = []interface{}{
		(*OperationMetadata_DeploymentMetadata)(nil),
		(*OperationMetadata_PreviewMetadata)(nil),
	}
	file_google_cloud_config_v1_config_proto_msgTypes[15].OneofWrappers = []interface{}{
		(*Revision_TerraformBlueprint)(nil),
	}
	file_google_cloud_config_v1_config_proto_msgTypes[17].OneofWrappers = []interface{}{}
	file_google_cloud_config_v1_config_proto_msgTypes[34].OneofWrappers = []interface{}{
		(*Preview_TerraformBlueprint)(nil),
	}
	file_google_cloud_config_v1_config_proto_msgTypes[48].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_config_v1_config_proto_rawDesc,
			NumEnums:      16,
			NumMessages:   55,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_config_v1_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_config_v1_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_config_v1_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_config_v1_config_proto_msgTypes,
	}.Build()
	File_google_cloud_config_v1_config_proto = out.File
	file_google_cloud_config_v1_config_proto_rawDesc = nil
	file_google_cloud_config_v1_config_proto_goTypes = nil
	file_google_cloud_config_v1_config_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// ConfigClient is the client API for Config service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ConfigClient interface {
	// Lists [Deployment][google.cloud.config.v1.Deployment]s in a given project
	// and location.
	ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error)
	// Gets details about a [Deployment][google.cloud.config.v1.Deployment].
	GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error)
	// Creates a [Deployment][google.cloud.config.v1.Deployment].
	CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a [Deployment][google.cloud.config.v1.Deployment].
	UpdateDeployment(ctx context.Context, in *UpdateDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a [Deployment][google.cloud.config.v1.Deployment].
	DeleteDeployment(ctx context.Context, in *DeleteDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists [Revision][google.cloud.config.v1.Revision]s of a deployment.
	ListRevisions(ctx context.Context, in *ListRevisionsRequest, opts ...grpc.CallOption) (*ListRevisionsResponse, error)
	// Gets details about a [Revision][google.cloud.config.v1.Revision].
	GetRevision(ctx context.Context, in *GetRevisionRequest, opts ...grpc.CallOption) (*Revision, error)
	// Gets details about a [Resource][google.cloud.config.v1.Resource] deployed
	// by Infra Manager.
	GetResource(ctx context.Context, in *GetResourceRequest, opts ...grpc.CallOption) (*Resource, error)
	// Lists [Resource][google.cloud.config.v1.Resource]s in a given revision.
	ListResources(ctx context.Context, in *ListResourcesRequest, opts ...grpc.CallOption) (*ListResourcesResponse, error)
	// Exports Terraform state file from a given deployment.
	ExportDeploymentStatefile(ctx context.Context, in *ExportDeploymentStatefileRequest, opts ...grpc.CallOption) (*Statefile, error)
	// Exports Terraform state file from a given revision.
	ExportRevisionStatefile(ctx context.Context, in *ExportRevisionStatefileRequest, opts ...grpc.CallOption) (*Statefile, error)
	// Imports Terraform state file in a given deployment. The state file does not
	// take effect until the Deployment has been unlocked.
	ImportStatefile(ctx context.Context, in *ImportStatefileRequest, opts ...grpc.CallOption) (*Statefile, error)
	// Deletes Terraform state file in a given deployment.
	DeleteStatefile(ctx context.Context, in *DeleteStatefileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Locks a deployment.
	LockDeployment(ctx context.Context, in *LockDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Unlocks a locked deployment.
	UnlockDeployment(ctx context.Context, in *UnlockDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports the lock info on a locked deployment.
	ExportLockInfo(ctx context.Context, in *ExportLockInfoRequest, opts ...grpc.CallOption) (*LockInfo, error)
	// Creates a [Preview][google.cloud.config.v1.Preview].
	CreatePreview(ctx context.Context, in *CreatePreviewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details about a [Preview][google.cloud.config.v1.Preview].
	GetPreview(ctx context.Context, in *GetPreviewRequest, opts ...grpc.CallOption) (*Preview, error)
	// Lists [Preview][google.cloud.config.v1.Preview]s in a given project and
	// location.
	ListPreviews(ctx context.Context, in *ListPreviewsRequest, opts ...grpc.CallOption) (*ListPreviewsResponse, error)
	// Deletes a [Preview][google.cloud.config.v1.Preview].
	DeletePreview(ctx context.Context, in *DeletePreviewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Export [Preview][google.cloud.config.v1.Preview] results.
	ExportPreviewResult(ctx context.Context, in *ExportPreviewResultRequest, opts ...grpc.CallOption) (*ExportPreviewResultResponse, error)
	// Lists [TerraformVersion][google.cloud.config.v1.TerraformVersion]s in a
	// given project and location.
	ListTerraformVersions(ctx context.Context, in *ListTerraformVersionsRequest, opts ...grpc.CallOption) (*ListTerraformVersionsResponse, error)
	// Gets details about a
	// [TerraformVersion][google.cloud.config.v1.TerraformVersion].
	GetTerraformVersion(ctx context.Context, in *GetTerraformVersionRequest, opts ...grpc.CallOption) (*TerraformVersion, error)
}

type configClient struct {
	cc grpc.ClientConnInterface
}

func NewConfigClient(cc grpc.ClientConnInterface) ConfigClient {
	return &configClient{cc}
}

func (c *configClient) ListDeployments(ctx context.Context, in *ListDeploymentsRequest, opts ...grpc.CallOption) (*ListDeploymentsResponse, error) {
	out := new(ListDeploymentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ListDeployments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) GetDeployment(ctx context.Context, in *GetDeploymentRequest, opts ...grpc.CallOption) (*Deployment, error) {
	out := new(Deployment)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/GetDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) CreateDeployment(ctx context.Context, in *CreateDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/CreateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) UpdateDeployment(ctx context.Context, in *UpdateDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/UpdateDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) DeleteDeployment(ctx context.Context, in *DeleteDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/DeleteDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) ListRevisions(ctx context.Context, in *ListRevisionsRequest, opts ...grpc.CallOption) (*ListRevisionsResponse, error) {
	out := new(ListRevisionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ListRevisions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) GetRevision(ctx context.Context, in *GetRevisionRequest, opts ...grpc.CallOption) (*Revision, error) {
	out := new(Revision)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/GetRevision", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) GetResource(ctx context.Context, in *GetResourceRequest, opts ...grpc.CallOption) (*Resource, error) {
	out := new(Resource)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/GetResource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) ListResources(ctx context.Context, in *ListResourcesRequest, opts ...grpc.CallOption) (*ListResourcesResponse, error) {
	out := new(ListResourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ListResources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) ExportDeploymentStatefile(ctx context.Context, in *ExportDeploymentStatefileRequest, opts ...grpc.CallOption) (*Statefile, error) {
	out := new(Statefile)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ExportDeploymentStatefile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) ExportRevisionStatefile(ctx context.Context, in *ExportRevisionStatefileRequest, opts ...grpc.CallOption) (*Statefile, error) {
	out := new(Statefile)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ExportRevisionStatefile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) ImportStatefile(ctx context.Context, in *ImportStatefileRequest, opts ...grpc.CallOption) (*Statefile, error) {
	out := new(Statefile)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ImportStatefile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) DeleteStatefile(ctx context.Context, in *DeleteStatefileRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/DeleteStatefile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) LockDeployment(ctx context.Context, in *LockDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/LockDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) UnlockDeployment(ctx context.Context, in *UnlockDeploymentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/UnlockDeployment", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) ExportLockInfo(ctx context.Context, in *ExportLockInfoRequest, opts ...grpc.CallOption) (*LockInfo, error) {
	out := new(LockInfo)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ExportLockInfo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) CreatePreview(ctx context.Context, in *CreatePreviewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/CreatePreview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) GetPreview(ctx context.Context, in *GetPreviewRequest, opts ...grpc.CallOption) (*Preview, error) {
	out := new(Preview)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/GetPreview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) ListPreviews(ctx context.Context, in *ListPreviewsRequest, opts ...grpc.CallOption) (*ListPreviewsResponse, error) {
	out := new(ListPreviewsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ListPreviews", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) DeletePreview(ctx context.Context, in *DeletePreviewRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/DeletePreview", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) ExportPreviewResult(ctx context.Context, in *ExportPreviewResultRequest, opts ...grpc.CallOption) (*ExportPreviewResultResponse, error) {
	out := new(ExportPreviewResultResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ExportPreviewResult", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) ListTerraformVersions(ctx context.Context, in *ListTerraformVersionsRequest, opts ...grpc.CallOption) (*ListTerraformVersionsResponse, error) {
	out := new(ListTerraformVersionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/ListTerraformVersions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *configClient) GetTerraformVersion(ctx context.Context, in *GetTerraformVersionRequest, opts ...grpc.CallOption) (*TerraformVersion, error) {
	out := new(TerraformVersion)
	err := c.cc.Invoke(ctx, "/google.cloud.config.v1.Config/GetTerraformVersion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConfigServer is the server API for Config service.
type ConfigServer interface {
	// Lists [Deployment][google.cloud.config.v1.Deployment]s in a given project
	// and location.
	ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error)
	// Gets details about a [Deployment][google.cloud.config.v1.Deployment].
	GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error)
	// Creates a [Deployment][google.cloud.config.v1.Deployment].
	CreateDeployment(context.Context, *CreateDeploymentRequest) (*longrunningpb.Operation, error)
	// Updates a [Deployment][google.cloud.config.v1.Deployment].
	UpdateDeployment(context.Context, *UpdateDeploymentRequest) (*longrunningpb.Operation, error)
	// Deletes a [Deployment][google.cloud.config.v1.Deployment].
	DeleteDeployment(context.Context, *DeleteDeploymentRequest) (*longrunningpb.Operation, error)
	// Lists [Revision][google.cloud.config.v1.Revision]s of a deployment.
	ListRevisions(context.Context, *ListRevisionsRequest) (*ListRevisionsResponse, error)
	// Gets details about a [Revision][google.cloud.config.v1.Revision].
	GetRevision(context.Context, *GetRevisionRequest) (*Revision, error)
	// Gets details about a [Resource][google.cloud.config.v1.Resource] deployed
	// by Infra Manager.
	GetResource(context.Context, *GetResourceRequest) (*Resource, error)
	// Lists [Resource][google.cloud.config.v1.Resource]s in a given revision.
	ListResources(context.Context, *ListResourcesRequest) (*ListResourcesResponse, error)
	// Exports Terraform state file from a given deployment.
	ExportDeploymentStatefile(context.Context, *ExportDeploymentStatefileRequest) (*Statefile, error)
	// Exports Terraform state file from a given revision.
	ExportRevisionStatefile(context.Context, *ExportRevisionStatefileRequest) (*Statefile, error)
	// Imports Terraform state file in a given deployment. The state file does not
	// take effect until the Deployment has been unlocked.
	ImportStatefile(context.Context, *ImportStatefileRequest) (*Statefile, error)
	// Deletes Terraform state file in a given deployment.
	DeleteStatefile(context.Context, *DeleteStatefileRequest) (*emptypb.Empty, error)
	// Locks a deployment.
	LockDeployment(context.Context, *LockDeploymentRequest) (*longrunningpb.Operation, error)
	// Unlocks a locked deployment.
	UnlockDeployment(context.Context, *UnlockDeploymentRequest) (*longrunningpb.Operation, error)
	// Exports the lock info on a locked deployment.
	ExportLockInfo(context.Context, *ExportLockInfoRequest) (*LockInfo, error)
	// Creates a [Preview][google.cloud.config.v1.Preview].
	CreatePreview(context.Context, *CreatePreviewRequest) (*longrunningpb.Operation, error)
	// Gets details about a [Preview][google.cloud.config.v1.Preview].
	GetPreview(context.Context, *GetPreviewRequest) (*Preview, error)
	// Lists [Preview][google.cloud.config.v1.Preview]s in a given project and
	// location.
	ListPreviews(context.Context, *ListPreviewsRequest) (*ListPreviewsResponse, error)
	// Deletes a [Preview][google.cloud.config.v1.Preview].
	DeletePreview(context.Context, *DeletePreviewRequest) (*longrunningpb.Operation, error)
	// Export [Preview][google.cloud.config.v1.Preview] results.
	ExportPreviewResult(context.Context, *ExportPreviewResultRequest) (*ExportPreviewResultResponse, error)
	// Lists [TerraformVersion][google.cloud.config.v1.TerraformVersion]s in a
	// given project and location.
	ListTerraformVersions(context.Context, *ListTerraformVersionsRequest) (*ListTerraformVersionsResponse, error)
	// Gets details about a
	// [TerraformVersion][google.cloud.config.v1.TerraformVersion].
	GetTerraformVersion(context.Context, *GetTerraformVersionRequest) (*TerraformVersion, error)
}

// UnimplementedConfigServer can be embedded to have forward compatible implementations.
type UnimplementedConfigServer struct {
}

func (*UnimplementedConfigServer) ListDeployments(context.Context, *ListDeploymentsRequest) (*ListDeploymentsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListDeployments not implemented")
}
func (*UnimplementedConfigServer) GetDeployment(context.Context, *GetDeploymentRequest) (*Deployment, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetDeployment not implemented")
}
func (*UnimplementedConfigServer) CreateDeployment(context.Context, *CreateDeploymentRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateDeployment not implemented")
}
func (*UnimplementedConfigServer) UpdateDeployment(context.Context, *UpdateDeploymentRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateDeployment not implemented")
}
func (*UnimplementedConfigServer) DeleteDeployment(context.Context, *DeleteDeploymentRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteDeployment not implemented")
}
func (*UnimplementedConfigServer) ListRevisions(context.Context, *ListRevisionsRequest) (*ListRevisionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListRevisions not implemented")
}
func (*UnimplementedConfigServer) GetRevision(context.Context, *GetRevisionRequest) (*Revision, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetRevision not implemented")
}
func (*UnimplementedConfigServer) GetResource(context.Context, *GetResourceRequest) (*Resource, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetResource not implemented")
}
func (*UnimplementedConfigServer) ListResources(context.Context, *ListResourcesRequest) (*ListResourcesResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListResources not implemented")
}
func (*UnimplementedConfigServer) ExportDeploymentStatefile(context.Context, *ExportDeploymentStatefileRequest) (*Statefile, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExportDeploymentStatefile not implemented")
}
func (*UnimplementedConfigServer) ExportRevisionStatefile(context.Context, *ExportRevisionStatefileRequest) (*Statefile, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExportRevisionStatefile not implemented")
}
func (*UnimplementedConfigServer) ImportStatefile(context.Context, *ImportStatefileRequest) (*Statefile, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ImportStatefile not implemented")
}
func (*UnimplementedConfigServer) DeleteStatefile(context.Context, *DeleteStatefileRequest) (*emptypb.Empty, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteStatefile not implemented")
}
func (*UnimplementedConfigServer) LockDeployment(context.Context, *LockDeploymentRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method LockDeployment not implemented")
}
func (*UnimplementedConfigServer) UnlockDeployment(context.Context, *UnlockDeploymentRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UnlockDeployment not implemented")
}
func (*UnimplementedConfigServer) ExportLockInfo(context.Context, *ExportLockInfoRequest) (*LockInfo, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExportLockInfo not implemented")
}
func (*UnimplementedConfigServer) CreatePreview(context.Context, *CreatePreviewRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreatePreview not implemented")
}
func (*UnimplementedConfigServer) GetPreview(context.Context, *GetPreviewRequest) (*Preview, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetPreview not implemented")
}
func (*UnimplementedConfigServer) ListPreviews(context.Context, *ListPreviewsRequest) (*ListPreviewsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListPreviews not implemented")
}
func (*UnimplementedConfigServer) DeletePreview(context.Context, *DeletePreviewRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeletePreview not implemented")
}
func (*UnimplementedConfigServer) ExportPreviewResult(context.Context, *ExportPreviewResultRequest) (*ExportPreviewResultResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ExportPreviewResult not implemented")
}
func (*UnimplementedConfigServer) ListTerraformVersions(context.Context, *ListTerraformVersionsRequest) (*ListTerraformVersionsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListTerraformVersions not implemented")
}
func (*UnimplementedConfigServer) GetTerraformVersion(context.Context, *GetTerraformVersionRequest) (*TerraformVersion, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetTerraformVersion not implemented")
}

func RegisterConfigServer(s *grpc.Server, srv ConfigServer) {
	s.RegisterService(&_Config_serviceDesc, srv)
}

func _Config_ListDeployments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDeploymentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ListDeployments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ListDeployments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ListDeployments(ctx, req.(*ListDeploymentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_GetDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).GetDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/GetDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).GetDeployment(ctx, req.(*GetDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_CreateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).CreateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/CreateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).CreateDeployment(ctx, req.(*CreateDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_UpdateDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).UpdateDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/UpdateDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).UpdateDeployment(ctx, req.(*UpdateDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_DeleteDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).DeleteDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/DeleteDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).DeleteDeployment(ctx, req.(*DeleteDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_ListRevisions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRevisionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ListRevisions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ListRevisions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ListRevisions(ctx, req.(*ListRevisionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_GetRevision_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRevisionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).GetRevision(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/GetRevision",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).GetRevision(ctx, req.(*GetRevisionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_GetResource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetResourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).GetResource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/GetResource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).GetResource(ctx, req.(*GetResourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_ListResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ListResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ListResources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ListResources(ctx, req.(*ListResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_ExportDeploymentStatefile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDeploymentStatefileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ExportDeploymentStatefile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ExportDeploymentStatefile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ExportDeploymentStatefile(ctx, req.(*ExportDeploymentStatefileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_ExportRevisionStatefile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportRevisionStatefileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ExportRevisionStatefile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ExportRevisionStatefile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ExportRevisionStatefile(ctx, req.(*ExportRevisionStatefileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_ImportStatefile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportStatefileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ImportStatefile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ImportStatefile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ImportStatefile(ctx, req.(*ImportStatefileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_DeleteStatefile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteStatefileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).DeleteStatefile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/DeleteStatefile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).DeleteStatefile(ctx, req.(*DeleteStatefileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_LockDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LockDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).LockDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/LockDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).LockDeployment(ctx, req.(*LockDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_UnlockDeployment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnlockDeploymentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).UnlockDeployment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/UnlockDeployment",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).UnlockDeployment(ctx, req.(*UnlockDeploymentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_ExportLockInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportLockInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ExportLockInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ExportLockInfo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ExportLockInfo(ctx, req.(*ExportLockInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_CreatePreview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePreviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).CreatePreview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/CreatePreview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).CreatePreview(ctx, req.(*CreatePreviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_GetPreview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPreviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).GetPreview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/GetPreview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).GetPreview(ctx, req.(*GetPreviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_ListPreviews_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPreviewsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ListPreviews(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ListPreviews",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ListPreviews(ctx, req.(*ListPreviewsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_DeletePreview_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePreviewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).DeletePreview(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/DeletePreview",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).DeletePreview(ctx, req.(*DeletePreviewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_ExportPreviewResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportPreviewResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ExportPreviewResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ExportPreviewResult",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ExportPreviewResult(ctx, req.(*ExportPreviewResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_ListTerraformVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTerraformVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).ListTerraformVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/ListTerraformVersions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).ListTerraformVersions(ctx, req.(*ListTerraformVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Config_GetTerraformVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTerraformVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConfigServer).GetTerraformVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.config.v1.Config/GetTerraformVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConfigServer).GetTerraformVersion(ctx, req.(*GetTerraformVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Config_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.config.v1.Config",
	HandlerType: (*ConfigServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListDeployments",
			Handler:    _Config_ListDeployments_Handler,
		},
		{
			MethodName: "GetDeployment",
			Handler:    _Config_GetDeployment_Handler,
		},
		{
			MethodName: "CreateDeployment",
			Handler:    _Config_CreateDeployment_Handler,
		},
		{
			MethodName: "UpdateDeployment",
			Handler:    _Config_UpdateDeployment_Handler,
		},
		{
			MethodName: "DeleteDeployment",
			Handler:    _Config_DeleteDeployment_Handler,
		},
		{
			MethodName: "ListRevisions",
			Handler:    _Config_ListRevisions_Handler,
		},
		{
			MethodName: "GetRevision",
			Handler:    _Config_GetRevision_Handler,
		},
		{
			MethodName: "GetResource",
			Handler:    _Config_GetResource_Handler,
		},
		{
			MethodName: "ListResources",
			Handler:    _Config_ListResources_Handler,
		},
		{
			MethodName: "ExportDeploymentStatefile",
			Handler:    _Config_ExportDeploymentStatefile_Handler,
		},
		{
			MethodName: "ExportRevisionStatefile",
			Handler:    _Config_ExportRevisionStatefile_Handler,
		},
		{
			MethodName: "ImportStatefile",
			Handler:    _Config_ImportStatefile_Handler,
		},
		{
			MethodName: "DeleteStatefile",
			Handler:    _Config_DeleteStatefile_Handler,
		},
		{
			MethodName: "LockDeployment",
			Handler:    _Config_LockDeployment_Handler,
		},
		{
			MethodName: "UnlockDeployment",
			Handler:    _Config_UnlockDeployment_Handler,
		},
		{
			MethodName: "ExportLockInfo",
			Handler:    _Config_ExportLockInfo_Handler,
		},
		{
			MethodName: "CreatePreview",
			Handler:    _Config_CreatePreview_Handler,
		},
		{
			MethodName: "GetPreview",
			Handler:    _Config_GetPreview_Handler,
		},
		{
			MethodName: "ListPreviews",
			Handler:    _Config_ListPreviews_Handler,
		},
		{
			MethodName: "DeletePreview",
			Handler:    _Config_DeletePreview_Handler,
		},
		{
			MethodName: "ExportPreviewResult",
			Handler:    _Config_ExportPreviewResult_Handler,
		},
		{
			MethodName: "ListTerraformVersions",
			Handler:    _Config_ListTerraformVersions_Handler,
		},
		{
			MethodName: "GetTerraformVersion",
			Handler:    _Config_GetTerraformVersion_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/config/v1/config.proto",
}
