(****************************************************************************)
(*                           the diy toolsuite                              *)
(*                                                                          *)
(* Jade Alglave, University College London, UK.                             *)
(* Luc Maranget, INRIA Paris-Rocquencourt, France.                          *)
(*                                                                          *)
(* Copyright 2022-present Institut National de Recherche en Informatique et *)
(* en Automatique and the authors. All rights reserved.                     *)
(*                                                                          *)
(* This software is governed by the CeCILL-B license under French law and   *)
(* abiding by the rules of distribution of free software. You can use,      *)
(* modify and/ or redistribute the software under the terms of the CeCILL-B *)
(* license as circulated by CEA, CNRS and INRIA at the following URL        *)
(* "http://www.cecill.info". We also give a copy in LICENSE.txt.            *)
(****************************************************************************)

(** Entry to models for arch that support the CAV12 model  *)

module type Config = sig
  val model : Model.t
  include Model.Config
end

module Make
    (O:Config)
    (S:Sem.Semantics)
 :
    XXXMem.S with module S = S
    =
  struct

    open Model

    module S = S

    let model = O.model
    module ModelConfig = (O : Model.Config)

    let check_event_structure test = match O.model with
    | CAV12 opt ->
        let module X =
          CAV12.Make
            (struct
              let opt = opt
              include ModelConfig
            end)
            (S) in
        X.check_event_structure test
    | Generic (fname,m) ->
        let module X =
          MachModelChecker.Make
            (struct
              let fname = fname
              let m = m
              let bell_model_info = None
              let wide_po = false
              include ModelConfig
             end)(S) in
        X.check_event_structure test
    | File _ -> assert false
  end
