# GTK-2 to GTK-3 Migration Notes for HexChat

## Completed Changes

### 1. Build System (meson.build)
- ✅ Updated GTK dependency from `gtk+-2.0` (>= 2.24.0) to `gtk+-3.0` (>= 3.10.0)
- ✅ Updated deprecated compile flags (GTK_DISABLE_DEPRECATED → GDK_DISABLE_DEPRECATED)

### 2. Color System (palette.c, palette.h)
- ✅ Converted `GdkColor` to `GdkRGBA` throughout
- ✅ Updated color array initialization to use floating-point values (0.0-1.0) with alpha channel
- ✅ Updated `palette_load()` to convert from guint16 to GdkRGBA format
- ✅ Updated `palette_save()` to convert from GdkRGBA to guint16 format
- ✅ Removed `palette_alloc()` implementation (GdkRGBA doesn't need colormap allocation)

### 3. Style System (fe-gtk.c, maingui.c, setup.c)
- ✅ Removed `GtkStyle` usage
- ✅ Replaced `gtk_rc_parse_string()` with GTK-3 CSS provider
- ✅ Changed `input_style` from `GtkStyle*` to `PangoFontDescription*` (now `input_font`)
- ✅ Updated `create_input_style()` to use `GtkCssProvider` for input box styling
- ✅ Replaced `gtk_widget_modify_*()` functions with `gtk_widget_override_*()` functions
- ✅ Updated color references in tab coloring system
- ✅ Replaced `GtkColorSelectionDialog` with `GtkColorChooserDialog`

### 4. Pixmaps (pixmaps.c, pixmaps.h)
- ✅ Removed `GdkPixmap` usage (deprecated in GTK-3)
- ✅ Removed `pixmap_load_from_file()` and related functions
- ✅ Removed `channelwin_pix` and `dialogwin_pix` global variables
- ✅ Removed `gtk_xtext_set_background()` function
- ✅ Background pixmap functionality removed (GTK-3 uses CSS for backgrounds)

### 5. Channel View (chanview.c, chanview.h, chanview-tree.c)
- ✅ Changed `chanview_new()` parameter from `GtkStyle*` to `PangoFontDescription*`
- ✅ Updated internal `style` member to `font` member
- ✅ Removed `gtk_widget_set_style()` calls

### 6. Main GUI (maingui.c, maingui.h)
- ✅ Updated `mg_attr_list_create()` to use `GdkRGBA` instead of `GdkColor`
- ✅ Updated `mg_apply_entry_style()` to use GTK-3 override functions
- ✅ Updated userlist and entry styling
- ✅ Replaced `gdk_pixbuf_get_from_drawable` with `gdk_pixbuf_get_from_window`
- ✅ Updated `mg_drag_motion_cb` to use Cairo instead of GdkGC for drag highlights

### 7. XText Widget (xtext.c, xtext.h) - FULLY CONVERTED
- ✅ Updated header to use `GdkRGBA` instead of `GdkColor`
- ✅ Removed all `GdkGC` members and usage
- ✅ Added `cairo_t *cr` member for drawing context
- ✅ Updated function signatures (`gtk_xtext_new`, `gtk_xtext_set_palette`)
- ✅ Converted all drawing operations to Cairo:
  - `gdk_draw_rectangle` → `cairo_rectangle` + `cairo_fill/stroke`
  - `gdk_draw_line` → `cairo_move_to/line_to` + `cairo_stroke`
  - GdkGC color setting → `gdk_cairo_set_source_rgba`
- ✅ Updated widget class to use GTK-3 APIs:
  - `expose_event` → `draw`
  - `size_request` → `get_preferred_width/height`
  - Removed deprecated `set_scroll_adjustments_signal`
- ✅ Replaced `gdk_drawable_get_size` with `gtk_widget_get_allocated_width/height`
- ✅ Replaced `gdk_window_get_pointer` with `gdk_window_get_device_position`
- ✅ Replaced direct `widget->window` access with `gtk_widget_get_window()`
- ✅ Replaced direct `widget->allocation` access with `gtk_widget_get_allocated_*()`
- ✅ Removed scroll blit optimization (GdkGC-based)
- ✅ Updated marker and separator drawing to use Cairo
- ✅ Updated text rendering to use Pango-Cairo

### 8. Tree Views (userlistgui.c, notifygui.c, dccgui.c)
- ✅ Changed column `foreground-gdk` to `foreground-rgba`
- ✅ Updated color column comments from GdkColor to GdkRGBA

### 9. Sexy Spell Entry (sexy-spell-entry.c)
- ✅ Converted `expose_event` handler to `draw` signal
- ✅ Removed direct `gtk_entry->preedit_length` access
- ✅ Updated function signature from `GdkEventExpose` to `cairo_t *cr`

### 10. Dialog and Font Selection (setup.c)
- ✅ Replaced `GtkFontSelectionDialog` with `GtkFontChooserDialog`
- ✅ Replaced `GtkColorSelectionDialog` with `GtkColorChooserDialog`
- ✅ Updated font selection callbacks

### 11. Deprecated Widget Constructors (all files)
- ✅ `gtk_vbox_new()` → `gtk_box_new(GTK_ORIENTATION_VERTICAL, ...)`
- ✅ `gtk_hbox_new()` → `gtk_box_new(GTK_ORIENTATION_HORIZONTAL, ...)`
- ✅ `gtk_vseparator_new()` → `gtk_separator_new(GTK_ORIENTATION_VERTICAL)`
- ✅ `gtk_hseparator_new()` → `gtk_separator_new(GTK_ORIENTATION_HORIZONTAL)`
- ✅ `gtk_vpaned_new()` → `gtk_paned_new(GTK_ORIENTATION_VERTICAL)`
- ✅ `gtk_hpaned_new()` → `gtk_paned_new(GTK_ORIENTATION_HORIZONTAL)`

### 12. Dialog API Updates (menu.c)
- ✅ `GTK_DIALOG(dialog)->vbox` → `gtk_dialog_get_content_area()`
- ✅ `GTK_ENTRY(entry)->editable` → `gtk_editable_set_editable()`
- ✅ Replaced GTK_STOCK_* with translatable strings

### 13. Adjustment API Updates
- ✅ Replaced deprecated `gtk_adjustment_changed()` with `g_object_notify()`

### 14. GTK_STOCK_* Deprecation (gtkutil.c, menu.c, maingui.c, servlistgui.c, and many others)
- ✅ Replaced all `GTK_STOCK_*` constants with freedesktop.org icon names:
  - `GTK_STOCK_CANCEL` → `_("_Cancel")` (translated string for buttons)
  - `GTK_STOCK_OK` → `_("_OK")` (translated string for buttons)
  - `GTK_STOCK_SAVE_AS` → `"document-save-as"`
  - `GTK_STOCK_FIND` → `"edit-find"`
  - `GTK_STOCK_CLOSE` → `"window-close"`
  - `GTK_STOCK_NEW` → `"document-new"`
  - `GTK_STOCK_DELETE` → `"edit-delete"`
  - `GTK_STOCK_ADD` → `"list-add"`
  - `GTK_STOCK_REMOVE` → `"list-remove"`
  - `GTK_STOCK_EDIT` → `"document-open"` (no direct edit icon)
  - `GTK_STOCK_PROPERTIES` → `"document-properties"`
  - `GTK_STOCK_REFRESH` → `"view-refresh"`
  - `GTK_STOCK_DIALOG_WARNING` → `"dialog-warning"`
  - `GTK_STOCK_NETWORK` → `"network-workgroup"`
  - `GTK_STOCK_COPY` → `"edit-copy"`
  - `GTK_STOCK_JUMP_TO` → `"go-jump"`
  - `GTK_STOCK_SORT_ASCENDING` → `"view-sort-ascending"`
  - `GTK_STOCK_SORT_DESCENDING` → `"view-sort-descending"`
  - `GTK_STOCK_APPLY` → `"emblem-ok-symbolic"` or `_("_Apply")`
  - `GTK_STOCK_CONNECT` → `NULL` (no standard equivalent)
  - `GTK_STOCK_QUIT` → `"application-exit"`
  - `GTK_STOCK_CLEAR` → `"edit-clear"`
  - `GTK_STOCK_GO_UP` → `"go-up"`
  - `GTK_STOCK_GO_DOWN` → `"go-down"`
  - `GTK_STOCK_STOP` → `"process-stop"`
  - `GTK_STOCK_EXECUTE` → `"system-run"`
  - `GTK_STOCK_PREFERENCES` → `"preferences-system"`
  - `GTK_STOCK_FILE` → `"text-x-generic"`
  - `GTK_STOCK_DIALOG_INFO` → `"dialog-information"`
  - `GTK_STOCK_DIRECTORY` → `"folder"`
- ✅ Updated `gtk_image_new_from_stock()` → `gtk_image_new_from_icon_name(..., GTK_ICON_SIZE_MENU)`
- ✅ Updated `gtk_entry_set_icon_from_stock()` → `gtk_entry_set_icon_from_icon_name()`

### 15. GtkImageMenuItem Deprecation (menu.c)
- ✅ Replaced `gtk_image_menu_item_new_with_mnemonic()` with standard menu items containing a box with image and label
- ✅ Replaced `gtk_image_menu_item_set_image()` with box-based approach
- ✅ Updated `create_icon_menu()` to create `GtkMenuItem` with `GtkBox` containing `GtkImage` + `GtkLabel`
- ✅ Updated `menu_quick_item()` similarly

### 16. Button Box Deprecations (servlistgui.c, textgui.c, editlist.c, dccgui.c, banlist.c, fkeys.c, notifygui.c, ignoregui.c, rawlog.c, plugingui.c, urlgrab.c, chanlist.c, joind.c)
- ✅ `gtk_hbutton_box_new()` → `gtk_button_box_new(GTK_ORIENTATION_HORIZONTAL)`
- ✅ `gtk_vbutton_box_new()` → `gtk_button_box_new(GTK_ORIENTATION_VERTICAL)`

### 17. gtk_button_new_from_stock Deprecation (servlistgui.c, gtkutil.c)
- ✅ Replaced with `gtk_button_new_with_mnemonic()` using translated strings

### 18. gtk_misc_set_alignment Deprecation (maingui.c, gtkutil.c)
- ✅ Replaced with `gtk_widget_set_halign()` and `gtk_widget_set_valign()`:
  - `gtk_misc_set_alignment(w, 0, 0.5)` → `gtk_widget_set_halign(w, GTK_ALIGN_START)`
  - `gtk_misc_set_alignment(w, 0.5, 0.5)` → `gtk_widget_set_halign(w, GTK_ALIGN_CENTER)`

### 19. Scrollbar Deprecation (maingui.c)
- ✅ `gtk_vscrollbar_new()` → `gtk_scrollbar_new(GTK_ORIENTATION_VERTICAL, ...)`

### 20. Wayland/X11 Compatibility Fixes (gtkutil.c, plugin-tray.c)
- ✅ Added runtime detection of X11 vs Wayland using `GDK_IS_X11_DISPLAY()`
- ✅ Skip `GtkStatusIcon` creation on Wayland (not supported)
- ✅ Guard `gdk_screen_get_number()` calls (X11-only)
- ✅ Guard `gtk_selection_add_targets()` timing for Wayland

### 21. Crash Fixes
- ✅ Fixed NULL pointer dereference in xtext rendering when cairo context unavailable
- ✅ Fixed `gtk_selection_add_targets()` being called before widget realization
- ✅ Added NULL checks for cairo context in drawing operations

### 22. gdk_screen_get_number() Deprecation (gtkutil.c)
- ✅ Replaced `gdk_screen_get_number()` → `gdk_x11_screen_get_screen_number()` for X11-specific code

### 23. Additional gtk_misc_set_alignment Fixes (servlistgui.c)
- ✅ Replaced 8 additional `gtk_misc_set_alignment()` calls with `gtk_widget_set_halign()`

### 24. gdk_cairo_create and gtk_widget_set_double_buffered (maingui.c, xtext.c)
- ✅ Replaced `gdk_cairo_create()` → `gdk_window_begin_draw_frame()`/`gdk_drawing_context_get_cairo_context()`
- ✅ Removed deprecated `gtk_widget_set_double_buffered()` call (GTK3 handles this automatically)

### 25. gdk_beep Deprecation (fe-gtk.c, chanlist.c, textgui.c)
- ✅ Replaced `gdk_beep()` → `gdk_display_beep(gdk_display_get_default())`

### 26. gtk_tree_view_get_vadjustment Deprecation (userlistgui.c)
- ✅ Replaced with `gtk_scrollable_get_vadjustment(GTK_SCROLLABLE(...))`

### 27. gtk_viewport_get_*adjustment Deprecation (chanview-tabs.c)
- ✅ Replaced `gtk_viewport_get_vadjustment()`/`gtk_viewport_get_hadjustment()` → `gtk_scrollable_get_*adjustment()`

### 28. gtk_arrow_new Deprecation (chanview-tabs.c)
- ✅ Replaced with `gtk_image_new_from_icon_name()` using symbolic arrow icons

### 29. gtk_tree_view_set_rules_hint Removal (multiple files)
- ✅ Removed all `gtk_tree_view_set_rules_hint()` calls (deprecated with no replacement, themes handle this via CSS)
- Files: fkeys.c, editlist.c, chanlist.c, textgui.c, ignoregui.c, plugingui.c, dccgui.c, setup.c

### 30. gtk_menu_popup Deprecation (maingui.c, banlist.c, chanlist.c, plugin-tray.c)
- ✅ Replaced `gtk_menu_popup()` → `gtk_menu_popup_at_pointer()`

### 31. gtk_window_set_opacity Deprecation (maingui.c, setup.c)
- ✅ Replaced `gtk_window_set_opacity()` → `gtk_widget_set_opacity()`

### 32. Extensive setup.c Deprecation Fixes
- ✅ Replaced all `gtk_misc_set_alignment()` → `gtk_widget_set_halign()`
- ✅ Replaced `gtk_alignment_new()` with proper widget alignment properties
- ✅ Replaced `gtk_hscale_new_with_range()` → `gtk_scale_new_with_range(GTK_ORIENTATION_HORIZONTAL, ...)`
- ✅ Replaced `gtk_widget_is_composited()` → `gdk_screen_is_composited()`
- ✅ Replaced `gtk_hbutton_box_new()` → `gtk_button_box_new(GTK_ORIENTATION_HORIZONTAL)`
- ✅ Replaced `gtk_button_new_from_stock()` → `gtk_button_new_with_mnemonic()` or `gtk_button_new_from_icon_name()`
- ✅ Replaced `gtk_misc_set_padding()` → `gtk_widget_set_margin_*()` properties
- ✅ Replaced `gtk_scrolled_window_add_with_viewport()` → `gtk_container_add()`

### 33. Additional dccgui.c Fixes
- ✅ Replaced `gtk_misc_set_alignment()` → `gtk_widget_set_halign()` (2 occurrences)

### 34. OpenSSL 3.0+ Compatibility (fishlim plugin - dh1080.c)
- ✅ Replaced deprecated `DH_*` API with `EVP_PKEY` API for OpenSSL 3.0+
- ✅ `dh1080_init()` → Uses `OSSL_PARAM_BLD` and `EVP_PKEY_fromdata()` for DH params
- ✅ `dh1080_deinit()` → Uses `EVP_PKEY_free()` instead of `DH_free()`
- ✅ `DH_verifyPubKey()` → Uses `EVP_PKEY_get_bn_param()` to extract p for verification
- ✅ `dh1080_generate_key()` → Uses `EVP_PKEY_keygen()` and `EVP_PKEY_get_bn_param()` for key extraction
- ✅ `dh1080_compute_key()` → Uses `EVP_PKEY_derive()` for shared secret computation
- ✅ Conditional compilation for OpenSSL 3.0+ vs older versions

### 35. OpenSSL 3.4+ Compatibility (server.c)
- ✅ Replaced `SSL_SESSION_get_time()` → `SSL_SESSION_get_time_ex()` for OpenSSL 3.4+ (Y2038-safe)

### 36. Additional GTK3 Deprecation Fixes
- ✅ chanlist.c: `gtk_widget_get_state()`/`gtk_widget_set_state()` → `gtk_widget_get_state_flags()`/`gtk_widget_set_state_flags()`
- ✅ custom-list.c: `g_qsort_with_data()` → `g_sort_array()` (GLib deprecation)
- ✅ fe-gtk.c: `gtk_show_uri()` → `gtk_show_uri_on_window()`
- ✅ sexy-spell-entry.c: `GtkImageMenuItem` → `gtk_menu_item_new_with_label()`
- ✅ sexy-spell-entry.c: Removed `gtk_image_new_from_stock()` with `GTK_STOCK_*` constants

### 37. Widget Expansion Fixes (maingui.c, chanview-tree.c)
- ✅ Fixed tiny GUI elements caused by `gtk_container_add()` not expanding widgets by default in GTK3
- ✅ Replaced `gtk_container_add()` with `gtk_box_pack_start(..., TRUE, TRUE, 0)` for:
  - Text area (chat log)
  - Topic bar entry
  - Chat input entry
  - User list
  - Channel list
  - Main center area (vertical expansion)
- ✅ Fixed channel tree view horizontal expansion in chanview-tree.c

### 38. About Dialog Fixes (menu.c)
- ✅ Removed custom "Credits" and "License" buttons (not present in GTK2 version)
- ✅ Simplified license handling using `GTK_LICENSE_GPL_2_0` constant
- ✅ Removed deprecated `gtk_about_dialog_set_url_hook()` call

### 39. Menu Separator Fixes (menu.c)
- ✅ Replaced `gtk_menu_item_new()` with `gtk_separator_menu_item_new()` for proper separator appearance
- ✅ Fixed separator styling to match GTK2 appearance

### 40. System Tray - AppIndicator Support (plugin-tray.c, meson.build, data/icons/meson.build)
- ✅ Added support for `libayatana-appindicator-glib` for system tray on Wayland
- ✅ Implemented GMenu-based API (new ayatana API uses GMenu instead of GtkMenu):
  - `app_indicator_set_menu()` now takes `GMenu*`
  - `app_indicator_set_icon()` takes additional description parameter
  - Added `GSimpleActionGroup` for action handling
  - Implemented action callbacks for menu items
- ✅ Added tray icon installation to hicolor icon theme for AppIndicator
- ✅ Updated `gtkutil_tray_icon_supported()` to return FALSE on Wayland without AppIndicator
- ✅ Fallback to GtkStatusIcon when AppIndicator is not available (X11)
- ✅ meson.build: Added `ayatana-appindicator-glib` dependency detection
- ✅ meson.build: Updated minimum meson version to 0.50.0

## Remaining Work

### GtkTable → GtkGrid Migration
- GtkTable is deprecated in GTK 3.4 (still works, not removed)
- Converting to GtkGrid requires significant refactoring
- Files affected: banlist.c, chanlist.c, dccgui.c, setup.c, servlistgui.c, and others
- Low priority since GtkTable still functions

### gtk_widget_override_* Functions (setup.c, maingui.c)
- These functions for styling (override_background_color, override_color, override_font) are deprecated
- Replacement requires CSS providers which is a more complex refactoring
- Low priority - the functions still work

## Build Status
- ✅ Compiles successfully
- ✅ Links successfully
- ✅ OpenSSL 3.0+ and 3.4+ deprecation warnings resolved
- ✅ Most GTK3 deprecation warnings resolved
- ✅ AppIndicator support for Wayland
- ⚠️ Remaining warnings: GtkStatusIcon (plugin-tray.c - fallback only), gtk_widget_override_* (setup.c, maingui.c)
- ℹ️ Note: Remaining deprecations require architectural changes for proper resolution
