# Generated by Django 2.2.26 on 2023-09-26 12:28

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [("lava_results_app", "0019_update_query_contenttype")]

    operations = [
        migrations.AlterField(
            model_name="chartqueryuser",
            name="chart_query",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                to="lava_results_app.ChartQuery",
            ),
        ),
        migrations.AlterField(
            model_name="query",
            name="owner",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AlterField(
            model_name="queryomitresult",
            name="query",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                to="lava_results_app.Query",
            ),
        ),
        migrations.AlterField(
            model_name="testset",
            name="suite",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="test_sets",
                to="lava_results_app.TestSuite",
            ),
        ),
        migrations.AlterField(
            model_name="testsuite",
            name="job",
            field=models.ForeignKey(
                db_index=False,
                on_delete=django.db.models.deletion.CASCADE,
                to="lava_scheduler_app.TestJob",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="chartqueryuser",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="query",
            unique_together=set(),
        ),
        migrations.AlterUniqueTogether(
            name="queryomitresult",
            unique_together=set(),
        ),
        migrations.AddConstraint(
            model_name="chartqueryuser",
            constraint=models.UniqueConstraint(
                fields=("chart_query", "user"),
                name="lava_results_app_chart_query_user_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="query",
            constraint=models.UniqueConstraint(
                fields=("owner", "name"), name="lava_results_app_query_owner_name_uniq"
            ),
        ),
        migrations.AddConstraint(
            model_name="queryomitresult",
            constraint=models.UniqueConstraint(
                fields=("query", "content_type", "object_id"),
                name="lava_results_app_query_omit_result_content_type_object_id_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="testcase",
            constraint=models.UniqueConstraint(
                condition=models.Q(name="job"),
                fields=("suite",),
                name="lava_results_app_testcase_job_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="testset",
            constraint=models.UniqueConstraint(
                fields=("suite", "name"),
                name="lava_results_app_testset_name_suite_uniq",
            ),
        ),
        migrations.AddConstraint(
            model_name="testsuite",
            constraint=models.UniqueConstraint(
                fields=("job", "name"), name="lava_results_app_testsuite_job_name_uniq"
            ),
        ),
    ]
