/**
 * \file pappsomspp/core/processing/cbor/mzcbor/scan.h
 * \date 03/02/2026
 * \author Olivier Langella
 * \brief PSI scan object for mzML/mzCBOR
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once
#include <QString>
#include "pappsomspp/core/processing/cbor/cborstreamreader.h"
#include "pappsomspp/core/processing/cbor/mzcbor/cvparammap.h"

namespace pappso
{
namespace cbor
{
namespace mzcbor
{

/**
 * @todo write docs
 */
struct Scan
{
  void fromCbor(CborStreamReader &reader);

  /** @brief write the structure to a JSON object
   * @result QJsonObject
   */
  QJsonObject toJsonObject() const;

  double getRtInSeconds() const;

  CvParamMap cvParamMap;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
