/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.core.commons;

import java.util.List;
import org.apache.custos.core.model.commons.OperationStatus;
import org.apache.custos.core.model.commons.StatusEntity;
import org.apache.custos.core.repo.commons.StatusUpdaterRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StatusUpdater {
    private final Logger LOGGER = LoggerFactory.getLogger(StatusUpdater.class);
    private final StatusUpdaterRepository repository;

    public StatusUpdater(StatusUpdaterRepository repository) {
        this.repository = repository;
    }

    public void updateStatus(String method, OperationStatus status, long traceId, String performedBy) {
        try {
            StatusEntity statusEntity = new StatusEntity();
            statusEntity.setEvent(method);
            statusEntity.setState(status.name());
            statusEntity.setTraceId(traceId);
            statusEntity.setPerformedBy(performedBy);
            this.repository.save(statusEntity);
        }
        catch (Exception ex) {
            this.LOGGER.error("Status update failed for event " + method + " and traceId " + traceId);
        }
    }

    public List<StatusEntity> getOperationStatus(long traceId) {
        return this.repository.findAllByTraceId(traceId);
    }
}

