/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.commons.util.UtilAutoConfiguration;
import org.springframework.cloud.vault.config.DiscoveryClientVaultServiceInstanceProvider;
import org.springframework.cloud.vault.config.VaultConfiguration;
import org.springframework.cloud.vault.config.VaultProperties;
import org.springframework.cloud.vault.config.VaultServiceInstanceProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.vault.client.VaultEndpointProvider;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.cloud.vault.discovery.enabled"})
@EnableConfigurationProperties(value={VaultProperties.class})
@Order(value=0x7FFFFFFD)
@EnableDiscoveryClient
@Import(value={UtilAutoConfiguration.class})
public class DiscoveryClientVaultBootstrapConfiguration {
    private final VaultProperties vaultProperties;
    private final VaultConfiguration configuration;

    public DiscoveryClientVaultBootstrapConfiguration(VaultProperties vaultProperties) {
        this.vaultProperties = vaultProperties;
        this.configuration = new VaultConfiguration(vaultProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
    public VaultServiceInstanceProvider vaultServerInstanceProvider(DiscoveryClient discoveryClient) {
        return new DiscoveryClientVaultServiceInstanceProvider(discoveryClient);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"spring.cloud.vault.enabled"}, matchIfMissing=true)
    public VaultEndpointProvider vaultEndpointProvider(VaultServiceInstanceProvider instanceProvider) {
        return () -> {
            String serviceId = this.vaultProperties.getDiscovery().getServiceId();
            ServiceInstance server = instanceProvider.getVaultServerInstance(serviceId);
            return this.configuration.createVaultEndpoint(server);
        };
    }
}

