/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.authentication;

import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class UsernamePasswordAuthenticationOptions {
    public static final String DEFAULT_USERPASS_AUTHENTICATION_PATH = "userpass";
    private final String path;
    private final String username;
    private final CharSequence password;
    @Nullable
    private final CharSequence totp;

    private UsernamePasswordAuthenticationOptions(String path, String username, CharSequence password, @Nullable CharSequence totp) {
        this.username = username;
        this.password = password;
        this.path = path;
        this.totp = totp;
    }

    public static UsernamePasswordAuthenticationBuilder builder() {
        return new UsernamePasswordAuthenticationBuilder();
    }

    public String getPath() {
        return this.path;
    }

    public String getUsername() {
        return this.username;
    }

    public CharSequence getPassword() {
        return this.password;
    }

    @Nullable
    public CharSequence getTotp() {
        return this.totp;
    }

    public static class UsernamePasswordAuthenticationBuilder {
        private String path = "userpass";
        @Nullable
        private String username;
        @Nullable
        private CharSequence password;
        @Nullable
        private CharSequence totp;

        UsernamePasswordAuthenticationBuilder() {
        }

        public UsernamePasswordAuthenticationBuilder username(String username) {
            Assert.hasText((String)username, (String)"Username must not be null and not be empty");
            this.username = username;
            return this;
        }

        public UsernamePasswordAuthenticationBuilder password(CharSequence password) {
            Assert.notNull((Object)password, (String)"Password must not be null");
            this.password = password;
            return this;
        }

        public UsernamePasswordAuthenticationBuilder totp(CharSequence totp) {
            Assert.notNull((Object)this.password, (String)"One-time token must not be null");
            this.totp = totp;
            return this;
        }

        public UsernamePasswordAuthenticationBuilder path(String path) {
            Assert.hasText((String)path, (String)"Path must not be empty");
            this.path = path;
            return this;
        }

        public UsernamePasswordAuthenticationOptions build() {
            Assert.hasText((String)this.username, (String)"Username must not be null and not be empty");
            Assert.notNull((Object)this.password, (String)"Password must not be null");
            return new UsernamePasswordAuthenticationOptions(this.path, this.username, this.password, this.totp);
        }
    }
}

