/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.repository.convert;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.vault.support.VaultResponse;

public class SecretDocument {
    @Nullable
    private String id;
    private final Map<String, Object> body;
    @Nullable
    private Integer version;

    public SecretDocument() {
        this(null, new LinkedHashMap<String, Object>());
    }

    public SecretDocument(Map<String, Object> body) {
        this(null, body);
    }

    public SecretDocument(@Nullable String id, Map<String, Object> body) {
        Assert.notNull(body, (String)"Body must not be null");
        this.id = id;
        this.body = body;
    }

    public SecretDocument(@Nullable String id, @Nullable Integer version, Map<String, Object> body) {
        Assert.notNull(body, (String)"Body must not be null");
        this.id = id;
        this.version = version;
        this.body = body;
    }

    public SecretDocument(String id) {
        this(id, new LinkedHashMap<String, Object>());
    }

    public static SecretDocument from(@Nullable String id, VaultResponse vaultResponse) {
        return new SecretDocument(id, (Map)vaultResponse.getData());
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public String getRequiredId() {
        String id = this.getId();
        if (id == null) {
            throw new IllegalStateException("Id is not set");
        }
        return id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable Integer version) {
        this.version = version;
    }

    public Map<String, Object> getBody() {
        return this.body;
    }

    @Nullable
    public Object get(String key) {
        return this.body.get(key);
    }

    public void put(String key, Object value) {
        this.body.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecretDocument)) {
            return false;
        }
        SecretDocument that = (SecretDocument)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.id, (Object)that.id)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.body, that.body)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.version, (Object)that.version);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.id);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.body);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.version);
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [id='").append(this.id).append('\'');
        sb.append(", body=").append(this.body);
        sb.append(", version=").append(this.version);
        sb.append(']');
        return sb.toString();
    }
}

