/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.thirdparty.com.google.common.base.Strings;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeAttributeKey;

public final class NodeLabelUtil {
    private static final int MAX_LABEL_LENGTH = 255;
    private static final Pattern LABEL_OR_VALUE_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_]*");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_\\.]*");
    private static final Pattern ATTRIBUTE_VALUE_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_.]*");
    private static final Pattern ATTRIBUTE_NAME_PATTERN = Pattern.compile("^[0-9a-zA-Z][0-9a-zA-Z-_]*");

    private NodeLabelUtil() {
    }

    public static void checkAndThrowLabelName(String label) throws IOException {
        if (label == null || label.isEmpty() || label.length() > 255) {
            throw new IOException("label added is empty or exceeds 255 character(s)");
        }
        boolean match = LABEL_OR_VALUE_PATTERN.matcher(label = label.trim()).matches();
        if (!match) {
            throw new IOException("label name should only contains {0-9, a-z, A-Z, -, _} and should not started with {-,_}, now it is= " + label);
        }
    }

    public static void checkAndThrowAttributeName(String attributeName) throws IOException {
        if (attributeName == null || attributeName.isEmpty() || attributeName.length() > 255) {
            throw new IOException("attribute name added is empty or exceeds 255 character(s)");
        }
        boolean match = ATTRIBUTE_NAME_PATTERN.matcher(attributeName = attributeName.trim()).matches();
        if (!match) {
            throw new IOException("attribute name should only contains {0-9, a-z, A-Z, -, _} and should not started with {-,_}, now it is= " + attributeName);
        }
    }

    public static void checkAndThrowAttributeValue(String value) throws IOException {
        if (value == null) {
            return;
        }
        if (value.trim().length() > 255) {
            throw new IOException("Attribute value added exceeds 255 character(s)");
        }
        if ((value = value.trim()).isEmpty()) {
            return;
        }
        boolean match = ATTRIBUTE_VALUE_PATTERN.matcher(value).matches();
        if (!match) {
            throw new IOException("attribute value should only contains {0-9, a-z, A-Z, -, _} and should not started with {-,_}, now it is= " + value);
        }
    }

    public static void checkAndThrowAttributePrefix(String prefix) throws IOException {
        if (prefix == null) {
            throw new IOException("Attribute prefix cannot be null.");
        }
        if (prefix.trim().length() > 255) {
            throw new IOException("Attribute value added exceeds 255 character(s)");
        }
        if ((prefix = prefix.trim()).isEmpty()) {
            return;
        }
        boolean match = PREFIX_PATTERN.matcher(prefix).matches();
        if (!match) {
            throw new IOException("attribute value should only contains {0-9, a-z, A-Z, -, _,.} and should not started with {-,_}, now it is= " + prefix);
        }
    }

    public static void validateNodeAttributes(Set<NodeAttribute> attributeSet) throws IOException {
        if (attributeSet != null && !attributeSet.isEmpty()) {
            for (NodeAttribute nodeAttribute : attributeSet) {
                NodeAttributeKey attributeKey = nodeAttribute.getAttributeKey();
                if (attributeKey == null) {
                    throw new IOException("AttributeKey  must be set");
                }
                String prefix = attributeKey.getAttributePrefix();
                if (Strings.isNullOrEmpty(prefix)) {
                    throw new IOException("Attribute prefix must be set");
                }
                NodeLabelUtil.checkAndThrowAttributePrefix(prefix);
                NodeLabelUtil.checkAndThrowAttributeName(attributeKey.getAttributeName());
                NodeLabelUtil.checkAndThrowAttributeValue(nodeAttribute.getAttributeValue());
            }
        }
    }

    public static Set<NodeAttribute> filterAttributesByPrefix(Set<NodeAttribute> attributeSet, String prefix) {
        if (Strings.isNullOrEmpty(prefix)) {
            return attributeSet;
        }
        return attributeSet.stream().filter(nodeAttribute -> prefix.equals(nodeAttribute.getAttributeKey().getAttributePrefix())).collect(Collectors.toSet());
    }

    public static boolean isNodeAttributesEquals(Set<NodeAttribute> leftNodeAttributes, Set<NodeAttribute> rightNodeAttributes) {
        if (leftNodeAttributes == null && rightNodeAttributes == null) {
            return true;
        }
        if (leftNodeAttributes == null || rightNodeAttributes == null || leftNodeAttributes.size() != rightNodeAttributes.size()) {
            return false;
        }
        return leftNodeAttributes.stream().allMatch(e -> NodeLabelUtil.isNodeAttributeIncludes(rightNodeAttributes, e));
    }

    private static boolean isNodeAttributeIncludes(Set<NodeAttribute> nodeAttributes, NodeAttribute checkNodeAttribute) {
        return nodeAttributes.stream().anyMatch(e -> e.equals(checkNodeAttribute) && Objects.equals(e.getAttributeValue(), checkNodeAttribute.getAttributeValue()));
    }
}

