/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.buildspec.Configuration;

public class ConfigurationFluent<A extends ConfigurationFluent<A>>
extends BaseFluent<A> {
    private Map<String, String> annotations;
    private String limitCPU;
    private String limitMemory;
    private Map<String, String> nodeSelector;
    private String operatorNamespace;
    private Configuration.OrderStrategy orderStrategy;
    private List<String> platforms;
    private String requestCPU;
    private String requestMemory;
    private Configuration.Strategy strategy;
    private String toolImage;

    public ConfigurationFluent() {
    }

    public ConfigurationFluent(Configuration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Configuration instance) {
        Configuration configuration = instance = instance != null ? instance : new Configuration();
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withLimitCPU(instance.getLimitCPU());
            this.withLimitMemory(instance.getLimitMemory());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOperatorNamespace(instance.getOperatorNamespace());
            this.withOrderStrategy(instance.getOrderStrategy());
            this.withPlatforms(instance.getPlatforms());
            this.withRequestCPU(instance.getRequestCPU());
            this.withRequestMemory(instance.getRequestMemory());
            this.withStrategy(instance.getStrategy());
            this.withToolImage(instance.getToolImage());
        }
    }

    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)((Object)this);
    }

    public boolean hasAnnotations() {
        return this.annotations != null;
    }

    public String getLimitCPU() {
        return this.limitCPU;
    }

    public A withLimitCPU(String limitCPU) {
        this.limitCPU = limitCPU;
        return (A)((Object)this);
    }

    public boolean hasLimitCPU() {
        return this.limitCPU != null;
    }

    public String getLimitMemory() {
        return this.limitMemory;
    }

    public A withLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
        return (A)((Object)this);
    }

    public boolean hasLimitMemory() {
        return this.limitMemory != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public String getOperatorNamespace() {
        return this.operatorNamespace;
    }

    public A withOperatorNamespace(String operatorNamespace) {
        this.operatorNamespace = operatorNamespace;
        return (A)((Object)this);
    }

    public boolean hasOperatorNamespace() {
        return this.operatorNamespace != null;
    }

    public Configuration.OrderStrategy getOrderStrategy() {
        return this.orderStrategy;
    }

    public A withOrderStrategy(Configuration.OrderStrategy orderStrategy) {
        this.orderStrategy = orderStrategy;
        return (A)((Object)this);
    }

    public boolean hasOrderStrategy() {
        return this.orderStrategy != null;
    }

    public A addToPlatforms(int index, String item) {
        if (this.platforms == null) {
            this.platforms = new ArrayList<String>();
        }
        this.platforms.add(index, item);
        return (A)((Object)this);
    }

    public A setToPlatforms(int index, String item) {
        if (this.platforms == null) {
            this.platforms = new ArrayList<String>();
        }
        this.platforms.set(index, item);
        return (A)((Object)this);
    }

    public A addToPlatforms(String ... items) {
        if (this.platforms == null) {
            this.platforms = new ArrayList<String>();
        }
        for (String item : items) {
            this.platforms.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPlatforms(Collection<String> items) {
        if (this.platforms == null) {
            this.platforms = new ArrayList<String>();
        }
        for (String item : items) {
            this.platforms.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPlatforms(String ... items) {
        if (this.platforms == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.platforms.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPlatforms(Collection<String> items) {
        if (this.platforms == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.platforms.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPlatforms() {
        return this.platforms;
    }

    public String getPlatform(int index) {
        return this.platforms.get(index);
    }

    public String getFirstPlatform() {
        return this.platforms.get(0);
    }

    public String getLastPlatform() {
        return this.platforms.get(this.platforms.size() - 1);
    }

    public String getMatchingPlatform(Predicate<String> predicate) {
        for (String item : this.platforms) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPlatform(Predicate<String> predicate) {
        for (String item : this.platforms) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPlatforms(List<String> platforms) {
        if (platforms != null) {
            this.platforms = new ArrayList<String>();
            for (String item : platforms) {
                this.addToPlatforms(item);
            }
        } else {
            this.platforms = null;
        }
        return (A)((Object)this);
    }

    public A withPlatforms(String ... platforms) {
        if (this.platforms != null) {
            this.platforms.clear();
            this._visitables.remove((Object)"platforms");
        }
        if (platforms != null) {
            for (String item : platforms) {
                this.addToPlatforms(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPlatforms() {
        return this.platforms != null && !this.platforms.isEmpty();
    }

    public String getRequestCPU() {
        return this.requestCPU;
    }

    public A withRequestCPU(String requestCPU) {
        this.requestCPU = requestCPU;
        return (A)((Object)this);
    }

    public boolean hasRequestCPU() {
        return this.requestCPU != null;
    }

    public String getRequestMemory() {
        return this.requestMemory;
    }

    public A withRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
        return (A)((Object)this);
    }

    public boolean hasRequestMemory() {
        return this.requestMemory != null;
    }

    public Configuration.Strategy getStrategy() {
        return this.strategy;
    }

    public A withStrategy(Configuration.Strategy strategy) {
        this.strategy = strategy;
        return (A)((Object)this);
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public String getToolImage() {
        return this.toolImage;
    }

    public A withToolImage(String toolImage) {
        this.toolImage = toolImage;
        return (A)((Object)this);
    }

    public boolean hasToolImage() {
        return this.toolImage != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigurationFluent that = (ConfigurationFluent)((Object)o);
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.limitCPU, that.limitCPU)) {
            return false;
        }
        if (!Objects.equals(this.limitMemory, that.limitMemory)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.operatorNamespace, that.operatorNamespace)) {
            return false;
        }
        if (!Objects.equals((Object)this.orderStrategy, (Object)that.orderStrategy)) {
            return false;
        }
        if (!Objects.equals(this.platforms, that.platforms)) {
            return false;
        }
        if (!Objects.equals(this.requestCPU, that.requestCPU)) {
            return false;
        }
        if (!Objects.equals(this.requestMemory, that.requestMemory)) {
            return false;
        }
        if (!Objects.equals((Object)this.strategy, (Object)that.strategy)) {
            return false;
        }
        return Objects.equals(this.toolImage, that.toolImage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.annotations, this.limitCPU, this.limitMemory, this.nodeSelector, this.operatorNamespace, this.orderStrategy, this.platforms, this.requestCPU, this.requestMemory, this.strategy, this.toolImage, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.limitCPU != null) {
            sb.append("limitCPU:");
            sb.append(this.limitCPU + ",");
        }
        if (this.limitMemory != null) {
            sb.append("limitMemory:");
            sb.append(this.limitMemory + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.operatorNamespace != null) {
            sb.append("operatorNamespace:");
            sb.append(this.operatorNamespace + ",");
        }
        if (this.orderStrategy != null) {
            sb.append("orderStrategy:");
            sb.append(this.orderStrategy + ",");
        }
        if (this.platforms != null && !this.platforms.isEmpty()) {
            sb.append("platforms:");
            sb.append(this.platforms + ",");
        }
        if (this.requestCPU != null) {
            sb.append("requestCPU:");
            sb.append(this.requestCPU + ",");
        }
        if (this.requestMemory != null) {
            sb.append("requestMemory:");
            sb.append(this.requestMemory + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.toolImage != null) {
            sb.append("toolImage:");
            sb.append(this.toolImage);
        }
        sb.append("}");
        return sb.toString();
    }
}

