/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.activemq.artemis.logs.ActiveMQUtilLogger;

public class Base64 {
    /*
     * Enabled aggressive exception aggregation
     */
    public static String encodeObject(Serializable serializableObject) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(serializableObject);
                string = java.util.Base64.getEncoder().encodeToString(baos.toByteArray());
            }
            return string;
        }
        catch (Exception e) {
            ActiveMQUtilLogger.LOGGER.failedToSerializeObject(e);
            return null;
        }
    }

    public static String encodeBytes(byte[] s) {
        return Base64.encodeBytes(s, false);
    }

    public static String encodeBytes(byte[] s, boolean urlSafe) {
        if (urlSafe) {
            return java.util.Base64.getUrlEncoder().encodeToString(s);
        }
        return java.util.Base64.getEncoder().encodeToString(s);
    }

    public static byte[] decode(String s) {
        return Base64.decode(s, false);
    }

    public static byte[] decode(String s, boolean urlSafe) {
        if (urlSafe) {
            return java.util.Base64.getUrlDecoder().decode(s);
        }
        return java.util.Base64.getDecoder().decode(s);
    }
}

