/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.web.filter;

import java.lang.reflect.Parameter;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.authorization.annotations.IcebergAuthorizationMetadata;
import org.apache.gravitino.server.web.filter.BaseMetadataAuthorizationMethodInterceptor;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.rest.RESTUtil;

public class LoadTableAuthzHandler
implements BaseMetadataAuthorizationMethodInterceptor.AuthorizationHandler {
    private final Parameter[] parameters;
    private final Object[] args;

    public LoadTableAuthzHandler(Parameter[] parameters, Object[] args) {
        this.parameters = parameters;
        this.args = args;
    }

    @Override
    public void process(Map<Entity.EntityType, NameIdentifier> nameIdentifierMap) {
        String tableName = null;
        Namespace namespace = null;
        for (int i = 0; i < this.parameters.length; ++i) {
            AuthorizationMetadata authMetadata;
            Parameter parameter = this.parameters[i];
            IcebergAuthorizationMetadata icebergMetadata = parameter.getAnnotation(IcebergAuthorizationMetadata.class);
            if (icebergMetadata != null && icebergMetadata.type() == IcebergAuthorizationMetadata.RequestType.LOAD_TABLE) {
                tableName = String.valueOf(this.args[i]);
            }
            if ((authMetadata = parameter.getAnnotation(AuthorizationMetadata.class)) == null || authMetadata.type() != Entity.EntityType.SCHEMA) continue;
            namespace = RESTUtil.decodeNamespace((String)String.valueOf(this.args[i]));
        }
        if (tableName == null || namespace == null) {
            throw new NoSuchTableException("Table not found - missing table name or namespace", new Object[0]);
        }
        if (this.isMetadataTable(tableName, namespace)) {
            throw new NoSuchTableException("Table %s not found", new Object[]{tableName});
        }
        NameIdentifier catalogId = nameIdentifierMap.get(Entity.EntityType.CATALOG);
        NameIdentifier schemaId = nameIdentifierMap.get(Entity.EntityType.SCHEMA);
        if (catalogId == null || schemaId == null) {
            throw new NoSuchTableException("Missing catalog or schema context for table authorization", new Object[0]);
        }
        String metalakeName = catalogId.namespace().level(0);
        String catalog = catalogId.name();
        String schema = schemaId.name();
        nameIdentifierMap.put(Entity.EntityType.TABLE, NameIdentifierUtil.ofTable((String)metalakeName, (String)catalog, (String)schema, (String)tableName));
    }

    @Override
    public boolean authorizationCompleted() {
        return false;
    }

    private boolean isMetadataTable(String tableName, Namespace namespace) {
        MetadataTableType metadataTableType = MetadataTableType.from((String)tableName);
        if (metadataTableType == null) {
            return false;
        }
        return namespace.levels().length > 1;
    }
}

