/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.job;

import java.util.List;
import java.util.Map;
import java.util.Objects;

public interface JobTemplateChange {
    public static JobTemplateChange rename(String newName) {
        return new RenameJobTemplate(newName);
    }

    public static JobTemplateChange updateComment(String newComment) {
        return new UpdateJobTemplateComment(newComment);
    }

    public static JobTemplateChange updateTemplate(TemplateUpdate templateUpdate) {
        return new UpdateJobTemplate(templateUpdate);
    }

    public static final class RenameJobTemplate
    implements JobTemplateChange {
        private final String newName;

        private RenameJobTemplate(String newName) {
            this.newName = newName;
        }

        public String getNewName() {
            return this.newName;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RenameJobTemplate that = (RenameJobTemplate)o;
            return Objects.equals(this.newName, that.newName);
        }

        public int hashCode() {
            return Objects.hash(this.newName);
        }

        public String toString() {
            return "RENAME JOB TEMPLATE " + this.newName;
        }
    }

    public static final class UpdateJobTemplateComment
    implements JobTemplateChange {
        private final String newComment;

        private UpdateJobTemplateComment(String newComment) {
            this.newComment = newComment;
        }

        public String getNewComment() {
            return this.newComment;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateJobTemplateComment that = (UpdateJobTemplateComment)o;
            return Objects.equals(this.newComment, that.newComment);
        }

        public int hashCode() {
            return Objects.hashCode(this.newComment);
        }

        public String toString() {
            return "UPDATE JOB TEMPLATE COMMENT " + this.newComment;
        }
    }

    public static final class UpdateJobTemplate
    implements JobTemplateChange {
        private final TemplateUpdate templateUpdate;

        private UpdateJobTemplate(TemplateUpdate templateUpdate) {
            this.templateUpdate = templateUpdate;
        }

        public TemplateUpdate getTemplateUpdate() {
            return this.templateUpdate;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UpdateJobTemplate that = (UpdateJobTemplate)o;
            return Objects.equals(this.templateUpdate, that.templateUpdate);
        }

        public int hashCode() {
            return Objects.hashCode(this.templateUpdate);
        }

        public String toString() {
            return "UPDATE JOB TEMPLATE " + this.templateUpdate.getClass().getSimpleName();
        }
    }

    public static abstract class TemplateUpdate {
        private final String newExecutable;
        private final List<String> newArguments;
        private final Map<String, String> newEnvironments;
        private final Map<String, String> newCustomFields;

        protected TemplateUpdate(BaseBuilder<?, ?> builder) {
            this.newExecutable = builder.newExecutable;
            this.newArguments = builder.newArguments;
            this.newEnvironments = builder.newEnvironments;
            this.newCustomFields = builder.newCustomFields;
        }

        public String getNewExecutable() {
            return this.newExecutable;
        }

        public List<String> getNewArguments() {
            return this.newArguments;
        }

        public Map<String, String> getNewEnvironments() {
            return this.newEnvironments;
        }

        public Map<String, String> getNewCustomFields() {
            return this.newCustomFields;
        }

        public boolean equals(Object o) {
            if (!(o instanceof TemplateUpdate)) {
                return false;
            }
            TemplateUpdate that = (TemplateUpdate)o;
            return Objects.equals(this.newExecutable, that.newExecutable) && Objects.equals(this.newArguments, that.newArguments) && Objects.equals(this.newEnvironments, that.newEnvironments) && Objects.equals(this.newCustomFields, that.newCustomFields);
        }

        public int hashCode() {
            return Objects.hash(this.newExecutable, this.newArguments, this.newEnvironments, this.newCustomFields);
        }

        protected static abstract class BaseBuilder<B extends BaseBuilder<B, P>, P extends TemplateUpdate> {
            private String newExecutable;
            private List<String> newArguments;
            private Map<String, String> newEnvironments;
            private Map<String, String> newCustomFields;

            protected BaseBuilder() {
            }

            protected abstract B self();

            public abstract P build();

            public B withNewExecutable(String newExecutable) {
                this.newExecutable = newExecutable;
                return this.self();
            }

            public B withNewArguments(List<String> newArguments) {
                this.newArguments = newArguments;
                return this.self();
            }

            public B withNewEnvironments(Map<String, String> newEnvironments) {
                this.newEnvironments = newEnvironments;
                return this.self();
            }

            public B withNewCustomFields(Map<String, String> newCustomFields) {
                this.newCustomFields = newCustomFields;
                return this.self();
            }
        }
    }

    public static final class SparkTemplateUpdate
    extends TemplateUpdate {
        private final String newClassName;
        private final List<String> newJars;
        private final List<String> newFiles;
        private final List<String> newArchives;
        private final Map<String, String> newConfigs;

        private SparkTemplateUpdate(Builder builder) {
            super(builder);
            this.newClassName = builder.newClassName;
            this.newJars = builder.newJars;
            this.newFiles = builder.newFiles;
            this.newArchives = builder.newArchives;
            this.newConfigs = builder.newConfigs;
        }

        public String getNewClassName() {
            return this.newClassName;
        }

        public List<String> getNewJars() {
            return this.newJars;
        }

        public List<String> getNewFiles() {
            return this.newFiles;
        }

        public List<String> getNewArchives() {
            return this.newArchives;
        }

        public Map<String, String> getNewConfigs() {
            return this.newConfigs;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SparkTemplateUpdate that = (SparkTemplateUpdate)o;
            return Objects.equals(this.newClassName, that.newClassName) && Objects.equals(this.newJars, that.newJars) && Objects.equals(this.newFiles, that.newFiles) && Objects.equals(this.newArchives, that.newArchives) && Objects.equals(this.newConfigs, that.newConfigs);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.newClassName, this.newJars, this.newFiles, this.newArchives, this.newConfigs);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends TemplateUpdate.BaseBuilder<Builder, SparkTemplateUpdate> {
            private String newClassName;
            private List<String> newJars;
            private List<String> newFiles;
            private List<String> newArchives;
            private Map<String, String> newConfigs;

            private Builder() {
            }

            public Builder withNewClassName(String newClassName) {
                this.newClassName = newClassName;
                return this;
            }

            public Builder withNewJars(List<String> newJars) {
                this.newJars = newJars;
                return this;
            }

            public Builder withNewFiles(List<String> newFiles) {
                this.newFiles = newFiles;
                return this;
            }

            public Builder withNewArchives(List<String> newArchives) {
                this.newArchives = newArchives;
                return this;
            }

            public Builder withNewConfigs(Map<String, String> newConfigs) {
                this.newConfigs = newConfigs;
                return this;
            }

            @Override
            public SparkTemplateUpdate build() {
                return new SparkTemplateUpdate(this);
            }

            @Override
            protected Builder self() {
                return this;
            }
        }
    }

    public static final class ShellTemplateUpdate
    extends TemplateUpdate {
        private final List<String> newScripts;

        private ShellTemplateUpdate(Builder builder) {
            super(builder);
            this.newScripts = builder.newScripts;
        }

        public List<String> getNewScripts() {
            return this.newScripts;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ShellTemplateUpdate that = (ShellTemplateUpdate)o;
            return Objects.equals(this.newScripts, that.newScripts);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.newScripts);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends TemplateUpdate.BaseBuilder<Builder, ShellTemplateUpdate> {
            private List<String> newScripts;

            private Builder() {
            }

            public Builder withNewScripts(List<String> newScripts) {
                this.newScripts = newScripts;
                return this;
            }

            @Override
            public ShellTemplateUpdate build() {
                return new ShellTemplateUpdate(this);
            }

            @Override
            protected Builder self() {
                return this;
            }
        }
    }
}

