/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.abs.fs;

import java.io.IOException;
import org.apache.gravitino.abs.fs.AzureStorageUtils;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.gravitino.catalog.hadoop.fs.GravitinoFileSystemCredentialsProvider;
import org.apache.gravitino.credential.ADLSTokenCredential;
import org.apache.gravitino.credential.Credential;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.azurebfs.extensions.SASTokenProvider;

public class AzureSasCredentialsProvider
implements SASTokenProvider,
Configurable {
    private Configuration configuration;
    private String sasToken;
    private GravitinoFileSystemCredentialsProvider gravitinoFileSystemCredentialsProvider;
    private long expirationTime = Long.MAX_VALUE;
    private static final double EXPIRATION_TIME_FACTOR = 0.5;

    public void setConf(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public void initialize(Configuration conf, String accountName) throws IOException {
        this.configuration = conf;
        this.gravitinoFileSystemCredentialsProvider = FileSystemUtils.getGvfsCredentialProvider((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSASToken(String account, String fileSystem, String path, String operation) {
        if (this.sasToken == null || System.currentTimeMillis() >= this.expirationTime) {
            AzureSasCredentialsProvider azureSasCredentialsProvider = this;
            synchronized (azureSasCredentialsProvider) {
                this.refresh();
            }
        }
        return this.sasToken;
    }

    private void refresh() {
        Credential[] gravitinoCredentials = this.gravitinoFileSystemCredentialsProvider.getCredentials();
        Credential credential = AzureStorageUtils.getADLSTokenCredential(gravitinoCredentials);
        if (credential == null) {
            throw new RuntimeException("No token credential for OSS found...");
        }
        if (credential instanceof ADLSTokenCredential) {
            ADLSTokenCredential adlsTokenCredential = (ADLSTokenCredential)credential;
            this.sasToken = adlsTokenCredential.sasToken();
            if (credential.expireTimeInMs() > 0L) {
                this.expirationTime = System.currentTimeMillis() + (long)((double)(credential.expireTimeInMs() - System.currentTimeMillis()) * 0.5);
            }
        }
    }
}

