/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import java.lang.reflect.Method;
import java.util.List;
import ognl.ASTChain;
import ognl.ASTConst;
import ognl.ASTCtor;
import ognl.ASTList;
import ognl.ASTProperty;
import ognl.ASTStaticMethod;
import ognl.ASTTest;
import ognl.Node;
import ognl.NodeType;
import ognl.NullHandler;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlOps;
import ognl.OgnlParser;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.enhance.ExpressionCompiler;
import ognl.enhance.OrderedReturn;
import ognl.enhance.UnsupportedCompilationException;

public class ASTMethod
extends SimpleNode
implements OrderedReturn,
NodeType {
    private static final long serialVersionUID = -6108508556131109533L;
    private String methodName;
    private String lastExpression;
    private String coreExpression;
    private Class<?> getterClass;

    public ASTMethod(int id) {
        super(id);
    }

    public ASTMethod(OgnlParser p, int id) {
        super(p, id);
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        Object[] args = new Object[this.jjtGetNumChildren()];
        Object root = context.getRoot();
        int icount = args.length;
        for (int i = 0; i < icount; ++i) {
            args[i] = this.children[i].getValue(context, root);
        }
        Object result = OgnlRuntime.callMethod(context, source, this.methodName, args);
        if (result == null) {
            NullHandler nh = OgnlRuntime.getNullHandler(OgnlRuntime.getTargetClass(source));
            result = nh.nullMethodResult(context, source, this.methodName, args);
        }
        return result;
    }

    @Override
    public String getLastExpression() {
        return this.lastExpression;
    }

    @Override
    public String getCoreExpression() {
        return this.coreExpression;
    }

    @Override
    public Class<?> getGetterClass() {
        return this.getterClass;
    }

    @Override
    public Class<?> getSetterClass() {
        return this.getterClass;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(this.methodName);
        result.append("(");
        if (this.children != null && this.children.length > 0) {
            for (int i = 0; i < this.children.length; ++i) {
                if (i > 0) {
                    result.append(", ");
                }
                result.append(this.children[i]);
            }
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        StringBuilder result;
        Method m;
        if (target == null) {
            throw new UnsupportedCompilationException("Target object is null.");
        }
        String post = "";
        try {
            m = OgnlRuntime.getMethod(context, context.getCurrentType() != null ? context.getCurrentType() : target.getClass(), this.methodName, this.children, false);
            Class<?>[] argumentClasses = ASTMethod.getChildrenClasses(context, this.children);
            if (m == null) {
                m = OgnlRuntime.getReadMethod(target.getClass(), this.methodName, argumentClasses);
            }
            if (m == null) {
                m = OgnlRuntime.getWriteMethod(target.getClass(), this.methodName, argumentClasses);
                if (m != null) {
                    context.setCurrentType(m.getReturnType());
                    context.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
                    this.coreExpression = this.toSetSourceString(context, target);
                    if (this.coreExpression == null || this.coreExpression.length() < 1) {
                        throw new UnsupportedCompilationException("can't find suitable getter method");
                    }
                    this.coreExpression = this.coreExpression + ";";
                    this.lastExpression = "null";
                    return this.coreExpression;
                }
                return "";
            }
            this.getterClass = m.getReturnType();
            boolean varArgs = m.isVarArgs();
            if (varArgs) {
                throw new UnsupportedCompilationException("Javassist does not currently support varargs method calls");
            }
            result = new StringBuilder("." + m.getName() + "(");
            if (this.children != null && this.children.length > 0) {
                Class<?>[] parms = m.getParameterTypes();
                String prevCast = (String)context.remove("_preCast");
                for (int i = 0; i < this.children.length; ++i) {
                    Class<?> valueClass;
                    if (i > 0) {
                        result.append(", ");
                    }
                    Class<?> prevType = context.getCurrentType();
                    context.setCurrentObject(context.getRoot());
                    context.setCurrentType(context.getRoot() != null ? context.getRoot().getClass() : null);
                    context.setCurrentAccessor(null);
                    context.setPreviousType(null);
                    Object value = this.children[i].getValue(context, context.getRoot());
                    String parmString = this.children[i].toGetSourceString(context, context.getRoot());
                    if (parmString == null || parmString.trim().length() < 1) {
                        parmString = "null";
                    }
                    if (this.children[i] instanceof ASTConst) {
                        context.setCurrentType(prevType);
                    }
                    parmString = ExpressionCompiler.getRootExpression(this.children[i], context.getRoot(), context) + parmString;
                    String cast = "";
                    if (ExpressionCompiler.shouldCast(this.children[i])) {
                        cast = (String)context.remove("_preCast");
                    }
                    if (cast == null) {
                        cast = "";
                    }
                    if (!(this.children[i] instanceof ASTConst)) {
                        parmString = cast + parmString;
                    }
                    Class<?> clazz = valueClass = value != null ? value.getClass() : null;
                    if (NodeType.class.isAssignableFrom(this.children[i].getClass())) {
                        valueClass = ((NodeType)((Object)this.children[i])).getGetterClass();
                    }
                    if (valueClass != parms[i]) {
                        if (parms[i].isArray()) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + ExpressionCompiler.getCastString(parms[i]) + ")ognl.OgnlOps#toArray(" + parmString + ", " + parms[i].getComponentType().getName() + ".class, true)", parms[i]);
                        } else if (parms[i].isPrimitive()) {
                            Class<?> wrapClass = OgnlRuntime.getPrimitiveWrapperClass(parms[i]);
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "((" + wrapClass.getName() + ")ognl.OgnlOps#convertValue(" + parmString + "," + wrapClass.getName() + ".class, true))." + OgnlRuntime.getNumericValueGetter(wrapClass), parms[i]);
                        } else if (parms[i] != Object.class) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + parms[i].getName() + ")ognl.OgnlOps#convertValue(" + parmString + "," + parms[i].getName() + ".class)", parms[i]);
                        } else if (this.children[i] instanceof NodeType && ((NodeType)((Object)this.children[i])).getGetterClass() != null && Number.class.isAssignableFrom(((NodeType)((Object)this.children[i])).getGetterClass()) || valueClass != null && valueClass.isPrimitive()) {
                            parmString = " ($w) " + parmString;
                        }
                    }
                    result.append(parmString);
                }
                if (prevCast != null) {
                    context.put("_preCast", (Object)prevCast);
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        try {
            Object contextObj = this.getValueBody(context, target);
            context.setCurrentObject(contextObj);
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        result.append(")").append(post);
        if (m.getReturnType() == Void.TYPE) {
            this.coreExpression = result + ";";
            this.lastExpression = "null";
        }
        context.setCurrentType(m.getReturnType());
        context.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
        return result.toString();
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        boolean varArgs;
        Method m = OgnlRuntime.getWriteMethod(context.getCurrentType() != null ? context.getCurrentType() : target.getClass(), this.methodName, ASTMethod.getChildrenClasses(context, this.children));
        if (m == null) {
            throw new UnsupportedCompilationException("Unable to determine setter method generation for " + this.methodName);
        }
        String post = "";
        StringBuilder result = new StringBuilder("." + m.getName() + "(");
        if (m.getReturnType() != Void.TYPE && m.getReturnType().isPrimitive() && !(this.parent instanceof ASTTest)) {
            Class<?> wrapper = OgnlRuntime.getPrimitiveWrapperClass(m.getReturnType());
            ExpressionCompiler.addCastString(context, "new " + wrapper.getName() + "(");
            post = ")";
            this.getterClass = wrapper;
        }
        if (varArgs = m.isVarArgs()) {
            throw new UnsupportedCompilationException("Javassist does not currently support varargs method calls");
        }
        try {
            if (this.children != null && this.children.length > 0) {
                Class<?>[] parms = m.getParameterTypes();
                String prevCast = (String)context.remove("_preCast");
                for (int i = 0; i < this.children.length; ++i) {
                    Class<?> valueClass;
                    if (i > 0) {
                        result.append(", ");
                    }
                    Class<?> prevType = context.getCurrentType();
                    context.setCurrentObject(context.getRoot());
                    context.setCurrentType(context.getRoot() != null ? context.getRoot().getClass() : null);
                    context.setCurrentAccessor(null);
                    context.setPreviousType(null);
                    Object value = this.children[i].getValue(context, context.getRoot());
                    String parmString = this.children[i].toSetSourceString(context, context.getRoot());
                    if (context.getCurrentType() == Void.TYPE || context.getCurrentType() == Void.TYPE) {
                        throw new UnsupportedCompilationException("Method argument can't be a void type.");
                    }
                    if (parmString == null || parmString.trim().length() < 1) {
                        if (this.children[i] instanceof ASTProperty || this.children[i] instanceof ASTMethod || this.children[i] instanceof ASTStaticMethod || this.children[i] instanceof ASTChain) {
                            throw new UnsupportedCompilationException("ASTMethod setter child returned null from a sub property expression.");
                        }
                        parmString = "null";
                    }
                    if (this.children[i] instanceof ASTConst) {
                        context.setCurrentType(prevType);
                    }
                    parmString = ExpressionCompiler.getRootExpression(this.children[i], context.getRoot(), context) + parmString;
                    String cast = "";
                    if (ExpressionCompiler.shouldCast(this.children[i])) {
                        cast = (String)context.remove("_preCast");
                    }
                    if (cast == null) {
                        cast = "";
                    }
                    parmString = cast + parmString;
                    Class<?> clazz = valueClass = value != null ? value.getClass() : null;
                    if (NodeType.class.isAssignableFrom(this.children[i].getClass())) {
                        valueClass = ((NodeType)((Object)this.children[i])).getGetterClass();
                    }
                    if (valueClass != parms[i]) {
                        if (parms[i].isArray()) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + ExpressionCompiler.getCastString(parms[i]) + ")ognl.OgnlOps#toArray(" + parmString + ", " + parms[i].getComponentType().getName() + ".class)", parms[i]);
                        } else if (parms[i].isPrimitive()) {
                            Class<?> wrapClass = OgnlRuntime.getPrimitiveWrapperClass(parms[i]);
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "((" + wrapClass.getName() + ")ognl.OgnlOps#convertValue(" + parmString + "," + wrapClass.getName() + ".class, true))." + OgnlRuntime.getNumericValueGetter(wrapClass), parms[i]);
                        } else if (parms[i] != Object.class) {
                            parmString = OgnlRuntime.getCompiler().createLocalReference(context, "(" + parms[i].getName() + ")ognl.OgnlOps#convertValue(" + parmString + "," + parms[i].getName() + ".class)", parms[i]);
                        } else if (this.children[i] instanceof NodeType && ((NodeType)((Object)this.children[i])).getGetterClass() != null && Number.class.isAssignableFrom(((NodeType)((Object)this.children[i])).getGetterClass()) || valueClass != null && valueClass.isPrimitive()) {
                            parmString = " ($w) " + parmString;
                        }
                    }
                    result.append(parmString);
                }
                if (prevCast != null) {
                    context.put("_preCast", (Object)prevCast);
                }
            }
        }
        catch (Throwable t) {
            throw OgnlOps.castToRuntime(t);
        }
        try {
            Object contextObj = this.getValueBody(context, target);
            context.setCurrentObject(contextObj);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        context.setCurrentType(m.getReturnType());
        context.setCurrentAccessor(OgnlRuntime.getCompiler().getSuperOrInterfaceClass(m, m.getDeclaringClass()));
        return result + ")" + post;
    }

    private static Class<?> getClassMatchingAllChildren(OgnlContext context, Node[] _children) {
        Class<?>[] cc = ASTMethod.getChildrenClasses(context, _children);
        Class componentType = null;
        for (Class<?> ic : cc) {
            Class pc;
            if (ic == null) {
                componentType = Object.class;
                break;
            }
            if (componentType == null) {
                componentType = ic;
                continue;
            }
            if (componentType.isAssignableFrom(ic)) continue;
            if (ic.isAssignableFrom(componentType)) {
                componentType = ic;
                continue;
            }
            while ((pc = componentType.getSuperclass()) != null) {
                if (!pc.isAssignableFrom(ic)) continue;
                componentType = pc;
                break;
            }
            if (componentType.isAssignableFrom(ic)) continue;
            componentType = Object.class;
            break;
        }
        if (componentType == null) {
            componentType = Object.class;
        }
        return componentType;
    }

    private static Class<?>[] getChildrenClasses(OgnlContext context, Node[] _children) {
        if (_children == null) {
            return null;
        }
        Class[] argumentClasses = new Class[_children.length];
        for (int i = 0; i < _children.length; ++i) {
            Node child = _children[i];
            if (child instanceof ASTList) {
                argumentClasses[i] = List.class;
                continue;
            }
            if (child instanceof NodeType) {
                argumentClasses[i] = ((NodeType)((Object)child)).getGetterClass();
                continue;
            }
            if (child instanceof ASTCtor) {
                try {
                    argumentClasses[i] = ((ASTCtor)child).getCreatedClass(context);
                    continue;
                }
                catch (ClassNotFoundException nfe) {
                    throw OgnlOps.castToRuntime(nfe);
                }
            }
            if (child instanceof ASTTest) {
                argumentClasses[i] = ASTMethod.getClassMatchingAllChildren(context, ((ASTTest)child).children);
                continue;
            }
            throw new UnsupportedOperationException("Don't know how to handle child: " + child);
        }
        return argumentClasses;
    }

    @Override
    public boolean isSimpleMethod(OgnlContext context) {
        return true;
    }
}

