/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.gravitino.iceberg.common.ClosableHiveCatalog;
import org.apache.gravitino.iceberg.common.cache.SupportsMetadataLocation;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.thrift.TException;

public class HiveCatalogWithMetadataLocationSupport
extends ClosableHiveCatalog
implements SupportsMetadataLocation {
    private ClientPool<IMetaStoreClient, TException> metaClients;

    @Override
    public void initialize(String name, Map<String, String> properties) {
        super.initialize(name, properties);
        this.loadFields();
    }

    @Override
    public String metadataLocation(TableIdentifier tableIdentifier) {
        String dbName = tableIdentifier.namespace().level(0);
        String tableName = tableIdentifier.name();
        try {
            Table table = (Table)this.metaClients.run(client -> client.getTable(dbName, tableName));
            String tableType = (String)table.getParameters().get("table_type");
            if (tableType == null || !tableType.equalsIgnoreCase("iceberg")) {
                return null;
            }
            return (String)table.getParameters().get("metadata_location");
        }
        catch (Exception e) {
            return null;
        }
    }

    private void loadFields() {
        try {
            this.metaClients = (ClientPool)FieldUtils.readField((Object)this, (String)"clients", (boolean)true);
            Preconditions.checkState((this.metaClients != null ? 1 : 0) != 0, (Object)"Failed to get clients field from hive catalog");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

