/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.BytesInput;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.util.BytesUtil;
import org.apache.hugegraph.computer.core.util.CoderUtil;
import org.apache.hugegraph.util.E;
import sun.misc.Unsafe;

public class UnsafeBytesInput
implements BytesInput {
    private static final Unsafe UNSAFE;
    private final byte[] buffer;
    private int limit;
    private int position;

    public UnsafeBytesInput(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public UnsafeBytesInput(byte[] buffer, int limit) {
        this(buffer, 0, limit);
    }

    public UnsafeBytesInput(byte[] buffer, int position, int limit) {
        E.checkArgumentNotNull((Object)buffer, (String)"The buffer can't be null", (Object[])new Object[0]);
        this.buffer = buffer;
        this.limit = limit;
        this.position = position;
    }

    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.require(len);
        System.arraycopy(this.buffer, this.position, b, off, len);
        this.position += len;
    }

    public int skipBytes(int n) {
        int remaining = this.remaining();
        if (remaining >= n) {
            this.position += n;
            return n;
        }
        this.position += remaining;
        return remaining;
    }

    public boolean readBoolean() throws IOException {
        this.require(1);
        boolean value = UNSAFE.getBoolean(this.buffer, this.offset());
        ++this.position;
        return value;
    }

    public byte readByte() throws IOException {
        this.require(1);
        byte value = this.buffer[this.position];
        ++this.position;
        return value;
    }

    public int readUnsignedByte() throws IOException {
        this.require(1);
        int value = this.buffer[this.position] & 0xFF;
        ++this.position;
        return value;
    }

    public short readShort() throws IOException {
        this.require(2);
        short value = UNSAFE.getShort(this.buffer, this.offset());
        this.position += 2;
        return value;
    }

    public int readUnsignedShort() throws IOException {
        this.require(2);
        int value = UNSAFE.getShort(this.buffer, this.offset()) & 0xFFFF;
        this.position += 2;
        return value;
    }

    public char readChar() throws IOException {
        this.require(2);
        char value = UNSAFE.getChar(this.buffer, this.offset());
        this.position += 2;
        return value;
    }

    public int readInt() throws IOException {
        this.require(4);
        int value = UNSAFE.getInt(this.buffer, this.offset());
        this.position += 4;
        return value;
    }

    public long readLong() throws IOException {
        this.require(8);
        long value = UNSAFE.getLong(this.buffer, this.offset());
        this.position += 8;
        return value;
    }

    public float readFloat() throws IOException {
        this.require(4);
        float value = UNSAFE.getFloat(this.buffer, this.offset());
        this.position += 4;
        return value;
    }

    public double readDouble() throws IOException {
        this.require(8);
        double value = UNSAFE.getDouble(this.buffer, this.offset());
        this.position += 8;
        return value;
    }

    public String readLine() {
        throw new ComputerException("Not implemented yet");
    }

    public String readUTF() throws IOException {
        int len = this.readUnsignedShort();
        byte[] bytes = new byte[len];
        this.readFully(bytes, 0, len);
        return CoderUtil.decode((byte[])bytes);
    }

    public long position() {
        return this.position;
    }

    public void seek(long position) throws IOException {
        this.position = (int)position;
    }

    public long skip(long bytesToSkip) throws IOException {
        int positionBeforeSkip = this.position;
        this.require((int)bytesToSkip);
        this.position = (int)((long)this.position + bytesToSkip);
        return positionBeforeSkip;
    }

    public long available() throws IOException {
        return this.limit - this.position;
    }

    protected int remaining() {
        return this.limit - this.position;
    }

    public void close() throws IOException {
    }

    public UnsafeBytesInput duplicate() throws IOException {
        return new UnsafeBytesInput(this.buffer, this.position, this.limit);
    }

    public int compare(long offset, long length, RandomAccessInput other, long otherOffset, long otherLength) throws IOException {
        E.checkArgument((offset < (long)this.buffer.length ? 1 : 0) != 0, (String)"Invalid offset parameter %s, expect < %s", (Object[])new Object[]{offset, this.buffer.length});
        E.checkArgument((length <= (long)this.buffer.length - offset ? 1 : 0) != 0, (String)"Invalid length parameter %s, expect <= %s", (Object[])new Object[]{length, (long)this.buffer.length - offset});
        if (other.getClass() == UnsafeBytesInput.class) {
            return BytesUtil.compare((byte[])this.buffer, (int)((int)offset), (int)((int)length), (byte[])((UnsafeBytesInput)other).buffer, (int)((int)otherOffset), (int)((int)otherLength));
        }
        long otherPosition = other.position();
        other.seek(otherOffset);
        byte[] bytes = other.readBytes((int)otherLength);
        other.seek(otherPosition);
        return BytesUtil.compare((byte[])this.buffer, (int)((int)offset), (int)((int)length), (byte[])bytes, (int)0, (int)bytes.length);
    }

    protected void require(int size) throws IOException {
        if (this.position + size > this.limit) {
            throw new ComputerException("Only %s bytes available, trying to read %s bytes", new Object[]{this.limit - this.position, size});
        }
    }

    protected byte[] buffer() {
        return this.buffer;
    }

    protected void shiftBuffer() {
        int remaining = this.remaining();
        if (remaining > 0) {
            System.arraycopy(this.buffer, this.position, this.buffer, 0, remaining);
        }
        this.position = 0;
        this.limit = remaining;
    }

    protected void limit(int limit) {
        E.checkArgument((limit <= this.buffer.length ? 1 : 0) != 0, (String)"The limit must be >= buffer length %s", (Object[])new Object[]{this.buffer.length});
        this.limit = limit;
    }

    public int limit() {
        return this.limit;
    }

    private int offset() {
        return Unsafe.ARRAY_BYTE_BASE_OFFSET + this.position;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            UNSAFE = (Unsafe)field.get(null);
        }
        catch (Exception e) {
            throw new ComputerException("Failed to get unsafe", (Throwable)e);
        }
    }
}

