/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sender;

import java.util.Map;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.sender.MessageSendPartition;
import org.apache.hugegraph.computer.core.sender.WriteBuffers;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.InsertionOrderUtil;

public class MessageSendBuffers {
    private final MessageSendPartition[] buffers;

    public MessageSendBuffers(ComputerContext context) {
        Config config = context.config();
        int partitionCount = (Integer)config.get((TypedOption)ComputerOptions.JOB_PARTITIONS_COUNT);
        int threshold = (Integer)config.get((TypedOption)ComputerOptions.WORKER_WRITE_BUFFER_THRESHOLD);
        int capacity = (Integer)config.get((TypedOption)ComputerOptions.WORKER_WRITE_BUFFER_INIT_CAPACITY);
        this.buffers = new MessageSendPartition[partitionCount];
        for (int i = 0; i < partitionCount; ++i) {
            this.buffers[i] = new MessageSendPartition(context, threshold, capacity);
        }
    }

    public WriteBuffers get(int partitionId) {
        if (partitionId < 0 || partitionId >= this.buffers.length) {
            throw new ComputerException("Invalid partition id %s", new Object[]{partitionId});
        }
        return this.buffers[partitionId].buffersForCurrentThread();
    }

    public Map<Integer, MessageSendPartition> all() {
        Map all = InsertionOrderUtil.newMap();
        for (int i = 0; i < this.buffers.length; ++i) {
            all.put(i, this.buffers[i]);
        }
        return all;
    }

    public void clear() {
        for (MessageSendPartition partition : this.buffers) {
            partition.clear();
        }
    }
}

