/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.event;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.client.aft.FaultToleranceConfigManager;
import com.alipay.sofa.rpc.client.aft.InvocationStat;
import com.alipay.sofa.rpc.client.aft.InvocationStatFactory;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.event.ClientAsyncReceiveEvent;
import com.alipay.sofa.rpc.event.ClientSyncReceiveEvent;
import com.alipay.sofa.rpc.event.Event;
import com.alipay.sofa.rpc.event.ProviderInfoRemoveEvent;
import com.alipay.sofa.rpc.event.ProviderInfoUpdateAllEvent;
import com.alipay.sofa.rpc.event.ProviderInfoUpdateEvent;
import com.alipay.sofa.rpc.event.Subscriber;
import java.util.ArrayList;

public class FaultToleranceSubscriber
extends Subscriber {
    public FaultToleranceSubscriber() {
        super(false);
    }

    @Override
    public void onEvent(Event originEvent) {
        block11: {
            Class<?> eventClass;
            block13: {
                block12: {
                    ProviderInfo providerInfo;
                    block10: {
                        ProviderInfo providerInfo2;
                        eventClass = originEvent.getClass();
                        if (eventClass != ClientSyncReceiveEvent.class) break block10;
                        if (!FaultToleranceConfigManager.isEnable()) {
                            return;
                        }
                        ClientSyncReceiveEvent event = (ClientSyncReceiveEvent)originEvent;
                        ConsumerConfig consumerConfig = event.getConsumerConfig();
                        InvocationStat result = InvocationStatFactory.getInvocationStat(consumerConfig, providerInfo2 = event.getProviderInfo());
                        if (result == null) break block11;
                        result.invoke();
                        Throwable t = event.getThrowable();
                        if (t != null) {
                            result.catchException(t);
                        }
                        break block11;
                    }
                    if (eventClass != ClientAsyncReceiveEvent.class) break block12;
                    if (!FaultToleranceConfigManager.isEnable()) {
                        return;
                    }
                    ClientAsyncReceiveEvent event = (ClientAsyncReceiveEvent)originEvent;
                    ConsumerConfig consumerConfig = event.getConsumerConfig();
                    InvocationStat result = InvocationStatFactory.getInvocationStat(consumerConfig, providerInfo = event.getProviderInfo());
                    if (result == null) break block11;
                    result.invoke();
                    Throwable t = event.getThrowable();
                    if (t != null) {
                        result.catchException(t);
                    }
                    break block11;
                }
                if (eventClass != ProviderInfoRemoveEvent.class) break block13;
                ProviderInfoRemoveEvent event = (ProviderInfoRemoveEvent)originEvent;
                ConsumerConfig consumerConfig = event.getConsumerConfig();
                ProviderGroup providerGroup = event.getProviderGroup();
                if (ProviderHelper.isEmpty(providerGroup)) break block11;
                for (ProviderInfo providerInfo : providerGroup.getProviderInfos()) {
                    InvocationStatFactory.removeInvocationStat(consumerConfig, providerInfo);
                }
                break block11;
            }
            if (eventClass == ProviderInfoUpdateEvent.class) {
                ProviderInfoUpdateEvent event = (ProviderInfoUpdateEvent)originEvent;
                ConsumerConfig consumerConfig = event.getConsumerConfig();
                ArrayList<ProviderInfo> add = new ArrayList<ProviderInfo>();
                ArrayList<ProviderInfo> remove = new ArrayList<ProviderInfo>();
                ProviderHelper.compareGroup(event.getOldProviderGroup(), event.getNewProviderGroup(), add, remove);
                for (ProviderInfo providerInfo : remove) {
                    InvocationStatFactory.removeInvocationStat(consumerConfig, providerInfo);
                }
            } else if (eventClass == ProviderInfoUpdateAllEvent.class) {
                ProviderInfoUpdateAllEvent event = (ProviderInfoUpdateAllEvent)originEvent;
                ConsumerConfig consumerConfig = event.getConsumerConfig();
                ArrayList<ProviderInfo> add = new ArrayList<ProviderInfo>();
                ArrayList<ProviderInfo> remove = new ArrayList<ProviderInfo>();
                ProviderHelper.compareGroups(event.getOldProviderGroups(), event.getNewProviderGroups(), add, remove);
                for (ProviderInfo providerInfo : remove) {
                    InvocationStatFactory.removeInvocationStat(consumerConfig, providerInfo);
                }
            }
        }
    }
}

