/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.dht.BootstrapDiagnostics;
import org.apache.cassandra.dht.RangeStreamer;
import org.apache.cassandra.dht.StreamStateStore;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.dht.tokenallocator.TokenAllocation;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.schema.Schema;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.StreamEvent;
import org.apache.cassandra.streaming.StreamEventHandler;
import org.apache.cassandra.streaming.StreamOperation;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.progress.ProgressEvent;
import org.apache.cassandra.utils.progress.ProgressEventNotifierSupport;
import org.apache.cassandra.utils.progress.ProgressEventType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootStrapper
extends ProgressEventNotifierSupport {
    private static final Logger logger = LoggerFactory.getLogger(BootStrapper.class);
    protected final InetAddressAndPort address;
    protected final Collection<Token> tokens;
    protected final TokenMetadata tokenMetadata;

    public BootStrapper(InetAddressAndPort address, Collection<Token> tokens, TokenMetadata tmd) {
        assert (address != null);
        assert (tokens != null && !tokens.isEmpty());
        this.address = address;
        this.tokens = tokens;
        this.tokenMetadata = tmd;
    }

    public ListenableFuture<StreamState> bootstrap(StreamStateStore stateStore, boolean useStrictConsistency) {
        logger.trace("Beginning bootstrap process");
        RangeStreamer streamer = new RangeStreamer(this.tokenMetadata, this.tokens, this.address, StreamOperation.BOOTSTRAP, useStrictConsistency, DatabaseDescriptor.getEndpointSnitch(), stateStore, true, DatabaseDescriptor.getStreamingConnectionsPerHost());
        List<String> nonLocalStrategyKeyspaces = Schema.instance.getNonLocalStrategyKeyspaces();
        if (nonLocalStrategyKeyspaces.isEmpty()) {
            logger.debug("Schema does not contain any non-local keyspaces to stream on bootstrap");
        }
        for (String keyspaceName : nonLocalStrategyKeyspaces) {
            AbstractReplicationStrategy strategy = Keyspace.open(keyspaceName).getReplicationStrategy();
            streamer.addRanges(keyspaceName, strategy.getPendingAddressRanges(this.tokenMetadata, this.tokens, this.address));
        }
        StreamResultFuture bootstrapStreamResult = streamer.fetchAsync();
        bootstrapStreamResult.addEventListener(new StreamEventHandler(){
            private final AtomicInteger receivedFiles = new AtomicInteger();
            private final AtomicInteger totalFilesToReceive = new AtomicInteger();

            @Override
            public void handleStreamEvent(StreamEvent event) {
                switch (event.eventType) {
                    case STREAM_PREPARED: {
                        StreamEvent.SessionPreparedEvent prepared = (StreamEvent.SessionPreparedEvent)event;
                        int currentTotal = this.totalFilesToReceive.addAndGet((int)prepared.session.getTotalFilesToReceive());
                        ProgressEvent prepareProgress = new ProgressEvent(ProgressEventType.PROGRESS, this.receivedFiles.get(), currentTotal, "prepare with " + prepared.session.peer + " complete");
                        BootStrapper.this.fireProgressEvent("bootstrap", prepareProgress);
                        break;
                    }
                    case FILE_PROGRESS: {
                        StreamEvent.ProgressEvent progress = (StreamEvent.ProgressEvent)event;
                        if (!progress.progress.isCompleted()) break;
                        int received = this.receivedFiles.incrementAndGet();
                        ProgressEvent currentProgress = new ProgressEvent(ProgressEventType.PROGRESS, received, this.totalFilesToReceive.get(), "received file " + progress.progress.fileName);
                        BootStrapper.this.fireProgressEvent("bootstrap", currentProgress);
                        break;
                    }
                    case STREAM_COMPLETE: {
                        StreamEvent.SessionCompleteEvent completeEvent = (StreamEvent.SessionCompleteEvent)event;
                        ProgressEvent completeProgress = new ProgressEvent(ProgressEventType.PROGRESS, this.receivedFiles.get(), this.totalFilesToReceive.get(), "session with " + completeEvent.peer + " complete");
                        BootStrapper.this.fireProgressEvent("bootstrap", completeProgress);
                    }
                }
            }

            public void onSuccess(StreamState streamState) {
                String message;
                ProgressEventType type;
                if (streamState.hasFailedSession()) {
                    type = ProgressEventType.ERROR;
                    message = "Some bootstrap stream failed";
                } else {
                    type = ProgressEventType.SUCCESS;
                    message = "Bootstrap streaming success";
                }
                ProgressEvent currentProgress = new ProgressEvent(type, this.receivedFiles.get(), this.totalFilesToReceive.get(), message);
                BootStrapper.this.fireProgressEvent("bootstrap", currentProgress);
            }

            public void onFailure(Throwable throwable) {
                ProgressEvent currentProgress = new ProgressEvent(ProgressEventType.ERROR, this.receivedFiles.get(), this.totalFilesToReceive.get(), throwable.getMessage());
                BootStrapper.this.fireProgressEvent("bootstrap", currentProgress);
            }
        });
        return bootstrapStreamResult;
    }

    public static Collection<Token> getBootstrapTokens(TokenMetadata metadata, InetAddressAndPort address, long schemaWaitDelay) throws ConfigurationException {
        String allocationKeyspace = DatabaseDescriptor.getAllocateTokensForKeyspace();
        Integer allocationLocalRf = DatabaseDescriptor.getAllocateTokensForLocalRf();
        Collection<String> initialTokens = DatabaseDescriptor.getInitialTokens();
        if (initialTokens.size() > 0 && allocationKeyspace != null) {
            logger.warn("manually specified tokens override automatic allocation");
        }
        if (initialTokens.size() > 0) {
            Collection<Token> tokens = BootStrapper.getSpecifiedTokens(metadata, initialTokens);
            BootstrapDiagnostics.useSpecifiedTokens(address, allocationKeyspace, tokens, DatabaseDescriptor.getNumTokens());
            return tokens;
        }
        int numTokens = DatabaseDescriptor.getNumTokens();
        if (numTokens < 1) {
            throw new ConfigurationException("num_tokens must be >= 1");
        }
        if (allocationKeyspace != null) {
            return BootStrapper.allocateTokens(metadata, address, allocationKeyspace, numTokens, schemaWaitDelay);
        }
        if (allocationLocalRf != null) {
            return BootStrapper.allocateTokens(metadata, address, allocationLocalRf, numTokens, schemaWaitDelay);
        }
        if (numTokens == 1) {
            logger.warn("Picking random token for a single vnode.  You should probably add more vnodes and/or use the automatic token allocation mechanism.");
        }
        Collection<Token> tokens = BootStrapper.getRandomTokens(metadata, numTokens);
        BootstrapDiagnostics.useRandomTokens(address, metadata, numTokens, tokens);
        return tokens;
    }

    private static Collection<Token> getSpecifiedTokens(TokenMetadata metadata, Collection<String> initialTokens) {
        logger.info("tokens manually specified as {}", initialTokens);
        ArrayList<Token> tokens = new ArrayList<Token>(initialTokens.size());
        for (String tokenString : initialTokens) {
            Token token = metadata.partitioner.getTokenFactory().fromString(tokenString);
            if (metadata.getEndpoint(token) != null) {
                throw new ConfigurationException("Bootstrapping to existing token " + tokenString + " is not allowed (decommission/removenode the old node first).");
            }
            tokens.add(token);
        }
        return tokens;
    }

    static Collection<Token> allocateTokens(TokenMetadata metadata, InetAddressAndPort address, String allocationKeyspace, int numTokens, long schemaWaitDelay) {
        Keyspace ks;
        StorageService.instance.waitForSchema(schemaWaitDelay);
        if (!FBUtilities.getBroadcastAddressAndPort().equals(InetAddressAndPort.getLoopbackAddress())) {
            Gossiper.waitToSettle();
        }
        if ((ks = Keyspace.open(allocationKeyspace)) == null) {
            throw new ConfigurationException("Problem opening token allocation keyspace " + allocationKeyspace);
        }
        AbstractReplicationStrategy rs = ks.getReplicationStrategy();
        Collection<Token> tokens = TokenAllocation.allocateTokens(metadata, rs, address, numTokens);
        BootstrapDiagnostics.tokensAllocated(address, metadata, allocationKeyspace, numTokens, tokens);
        return tokens;
    }

    static Collection<Token> allocateTokens(TokenMetadata metadata, InetAddressAndPort address, int rf, int numTokens, long schemaWaitDelay) {
        StorageService.instance.waitForSchema(schemaWaitDelay);
        if (!FBUtilities.getBroadcastAddressAndPort().equals(InetAddressAndPort.getLoopbackAddress())) {
            Gossiper.waitToSettle();
        }
        Collection<Token> tokens = TokenAllocation.allocateTokens(metadata, rf, address, numTokens);
        BootstrapDiagnostics.tokensAllocated(address, metadata, rf, numTokens, tokens);
        return tokens;
    }

    public static Collection<Token> getRandomTokens(TokenMetadata metadata, int numTokens) {
        HashSet<Token> tokens = new HashSet<Token>(numTokens);
        while (tokens.size() < numTokens) {
            Token token = metadata.partitioner.getRandomToken();
            if (metadata.getEndpoint(token) != null) continue;
            tokens.add(token);
        }
        logger.info("Generated random tokens. tokens are {}", tokens);
        return tokens;
    }
}

