/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.DeleteFromIcebergTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.connector.catalog.SupportsDelete;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.datasources.DataSourceStrategy$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.sources.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;

public final class OptimizeMetadataOnlyDeleteFromIcebergTable$
extends Rule<LogicalPlan>
implements PredicateHelper {
    public static OptimizeMetadataOnlyDeleteFromIcebergTable$ MODULE$;
    private final Logger logger;

    static {
        new OptimizeMetadataOnlyDeleteFromIcebergTable$();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger logger() {
        return this.logger;
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return (LogicalPlan)plan.transform((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof DeleteFromIcebergTable) {
                    DeleteFromIcebergTable deleteFromIcebergTable = (DeleteFromIcebergTable)A1;
                    LogicalPlan relation = deleteFromIcebergTable.table();
                    Option<Expression> cond = deleteFromIcebergTable.condition();
                    Option<LogicalPlan> option = deleteFromIcebergTable.rewritePlan();
                    if (relation instanceof DataSourceV2Relation) {
                        DataSourceV2Relation dataSourceV2Relation = (DataSourceV2Relation)relation;
                        if (option instanceof Some) {
                            Expression deleteCond = (Expression)cond.getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.TrueLiteral());
                            Table table = dataSourceV2Relation.table();
                            if (table instanceof SupportsDelete) {
                                SupportsDelete supportsDelete = (SupportsDelete)table;
                                if (!SubqueryExpression$.MODULE$.hasSubquery(deleteCond)) {
                                    boolean allPredicatesTranslated;
                                    Seq<Expression> predicates = OptimizeMetadataOnlyDeleteFromIcebergTable$.MODULE$.splitConjunctivePredicates(deleteCond);
                                    Seq normalizedPredicates = DataSourceStrategy$.MODULE$.normalizeExprs(predicates, dataSourceV2Relation.output());
                                    Filter[] dataSourceFilters = OptimizeMetadataOnlyDeleteFromIcebergTable$.MODULE$.toDataSourceFilters((Seq<Expression>)normalizedPredicates);
                                    boolean bl = allPredicatesTranslated = normalizedPredicates.size() == dataSourceFilters.length;
                                    if (allPredicatesTranslated && supportsDelete.canDeleteWhere(dataSourceFilters)) {
                                        OptimizeMetadataOnlyDeleteFromIcebergTable$.MODULE$.logger().info(new StringBuilder(49).append("Optimizing delete expression: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSourceFilters)).mkString(",")).append(" as metadata delete").toString());
                                        None$ x$1 = None$.MODULE$;
                                        LogicalPlan x$2 = deleteFromIcebergTable.copy$default$1();
                                        Option<Expression> x$3 = deleteFromIcebergTable.copy$default$2();
                                        return (B1)deleteFromIcebergTable.copy(x$2, x$3, (Option<LogicalPlan>)x$1);
                                    }
                                    return (B1)deleteFromIcebergTable;
                                }
                            }
                            return (B1)deleteFromIcebergTable;
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof DeleteFromIcebergTable) {
                    DeleteFromIcebergTable deleteFromIcebergTable = (DeleteFromIcebergTable)logicalPlan;
                    LogicalPlan relation = deleteFromIcebergTable.table();
                    Option<LogicalPlan> option = deleteFromIcebergTable.rewritePlan();
                    if (relation instanceof DataSourceV2Relation && option instanceof Some) {
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1()}, serializedLambda);
            }
        });
    }

    public Filter[] toDataSourceFilters(Seq<Expression> predicates) {
        return (Filter[])((TraversableOnce)predicates.flatMap((Function1 & Serializable & scala.Serializable)p -> {
            Option filter;
            block0: {
                filter = DataSourceStrategy$.MODULE$.translateFilter(p, true);
                if (!filter.isEmpty()) break block0;
                MODULE$.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Cannot translate expression to source filter: ").append(p).toString());
            }
            return Option$.MODULE$.option2Iterable(filter);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class));
    }

    private OptimizeMetadataOnlyDeleteFromIcebergTable$() {
        MODULE$ = this;
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
    }
}

