/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.context;

import java.util.Set;
import org.apache.flink.datastream.api.common.Collector;
import org.apache.flink.datastream.api.context.JobInfo;
import org.apache.flink.datastream.api.context.NonPartitionedContext;
import org.apache.flink.datastream.api.context.PartitionedContext;
import org.apache.flink.datastream.api.context.TaskInfo;
import org.apache.flink.datastream.api.function.ApplyPartitionFunction;
import org.apache.flink.datastream.impl.context.DefaultPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.metrics.MetricGroup;

public class DefaultNonPartitionedContext<OUT>
implements NonPartitionedContext<OUT> {
    private final DefaultRuntimeContext context;
    private final DefaultPartitionedContext partitionedContext;
    private final Collector<OUT> collector;
    private final boolean isKeyed;
    private final Set<Object> keySet;

    public DefaultNonPartitionedContext(DefaultRuntimeContext context, DefaultPartitionedContext partitionedContext, Collector<OUT> collector, boolean isKeyed, Set<Object> keySet) {
        this.context = context;
        this.partitionedContext = partitionedContext;
        this.collector = collector;
        this.isKeyed = isKeyed;
        this.keySet = keySet;
    }

    public void applyToAllPartitions(ApplyPartitionFunction<OUT> applyPartitionFunction) throws Exception {
        if (this.isKeyed) {
            for (Object key : this.keySet) {
                this.partitionedContext.getStateManager().executeInKeyContext(() -> {
                    try {
                        applyPartitionFunction.apply(this.collector, (PartitionedContext)this.partitionedContext);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, key);
            }
        } else {
            applyPartitionFunction.apply(this.collector, (PartitionedContext)this.partitionedContext);
        }
    }

    public JobInfo getJobInfo() {
        return this.context.getJobInfo();
    }

    public TaskInfo getTaskInfo() {
        return this.context.getTaskInfo();
    }

    public MetricGroup getMetricGroup() {
        return this.context.getMetricGroup();
    }
}

