/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.datastream.impl.context;

import java.util.Set;
import org.apache.flink.datastream.api.common.Collector;
import org.apache.flink.datastream.api.context.JobInfo;
import org.apache.flink.datastream.api.context.PartitionedContext;
import org.apache.flink.datastream.api.context.TaskInfo;
import org.apache.flink.datastream.api.context.TwoOutputNonPartitionedContext;
import org.apache.flink.datastream.api.function.TwoOutputApplyPartitionFunction;
import org.apache.flink.datastream.impl.context.DefaultPartitionedContext;
import org.apache.flink.datastream.impl.context.DefaultRuntimeContext;
import org.apache.flink.metrics.MetricGroup;

public class DefaultTwoOutputNonPartitionedContext<OUT1, OUT2>
implements TwoOutputNonPartitionedContext<OUT1, OUT2> {
    protected final DefaultRuntimeContext context;
    private final DefaultPartitionedContext partitionedContext;
    protected final Collector<OUT1> firstCollector;
    protected final Collector<OUT2> secondCollector;
    private final boolean isKeyed;
    private final Set<Object> keySet;

    public DefaultTwoOutputNonPartitionedContext(DefaultRuntimeContext context, DefaultPartitionedContext partitionedContext, Collector<OUT1> firstCollector, Collector<OUT2> secondCollector, boolean isKeyed, Set<Object> keySet) {
        this.context = context;
        this.partitionedContext = partitionedContext;
        this.firstCollector = firstCollector;
        this.secondCollector = secondCollector;
        this.isKeyed = isKeyed;
        this.keySet = keySet;
    }

    public void applyToAllPartitions(TwoOutputApplyPartitionFunction<OUT1, OUT2> applyPartitionFunction) throws Exception {
        if (this.isKeyed) {
            for (Object key : this.keySet) {
                this.partitionedContext.getStateManager().executeInKeyContext(() -> {
                    try {
                        applyPartitionFunction.apply(this.firstCollector, this.secondCollector, (PartitionedContext)this.partitionedContext);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, key);
            }
        } else {
            applyPartitionFunction.apply(this.firstCollector, this.secondCollector, (PartitionedContext)this.partitionedContext);
        }
    }

    public JobInfo getJobInfo() {
        return this.context.getJobInfo();
    }

    public TaskInfo getTaskInfo() {
        return this.context.getTaskInfo();
    }

    public MetricGroup getMetricGroup() {
        return this.context.getMetricGroup();
    }
}

