/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark;

import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.iceberg.StructLike;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SparkInternalRowWrapper
implements StructLike {
    private final DataType[] types;
    private final BiFunction<InternalRow, Integer, ?>[] getters;
    private InternalRow row = null;

    public SparkInternalRowWrapper(StructType rowType) {
        this.types = (DataType[])Stream.of(rowType.fields()).map(StructField::dataType).toArray(DataType[]::new);
        this.getters = (BiFunction[])Stream.of(this.types).map(SparkInternalRowWrapper::getter).toArray(BiFunction[]::new);
    }

    public int size() {
        return this.types.length;
    }

    public <T> T get(int pos, Class<T> javaClass) {
        if (this.row.isNullAt(pos)) {
            return null;
        }
        if (this.getters[pos] != null) {
            return javaClass.cast(this.getters[pos].apply(this.row, pos));
        }
        return javaClass.cast(this.row.get(pos, this.types[pos]));
    }

    public <T> void set(int pos, T value) {
        this.row.update(pos, value);
    }

    public SparkInternalRowWrapper wrap(InternalRow internalRow) {
        this.row = internalRow;
        return this;
    }

    private static BiFunction<InternalRow, Integer, ?> getter(DataType type) {
        if (type instanceof StringType) {
            return (row, pos) -> row.getUTF8String(pos.intValue()).toString();
        }
        if (type instanceof DecimalType) {
            DecimalType decimal = (DecimalType)type;
            return (row, pos) -> row.getDecimal(pos.intValue(), decimal.precision(), decimal.scale()).toJavaBigDecimal();
        }
        if (type instanceof BinaryType) {
            return (row, pos) -> ByteBuffer.wrap(row.getBinary(pos.intValue()));
        }
        if (type instanceof StructType) {
            StructType structType = (StructType)type;
            SparkInternalRowWrapper nestedWrapper = new SparkInternalRowWrapper(structType);
            return (row, pos) -> nestedWrapper.wrap(row.getStruct(pos.intValue(), structType.size()));
        }
        return null;
    }
}

