/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.ObjectArrays;
import org.apache.amoro.spark.SparkAdapterLoader;
import org.apache.amoro.spark.sql.connector.expressions.FileIndexBucket;
import org.apache.amoro.spark.util.ExpressionHelper;
import org.apache.amoro.spark.util.SortOrderToSpark;
import org.apache.amoro.table.DistributionHashMode;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.transforms.SortOrderVisitor;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;

public class DistributionAndOrderingUtil {
    private static final ExpressionHelper expressionHelper = SparkAdapterLoader.getOrLoad().expressions();
    private static final NamedReference SPEC_ID = org.apache.spark.sql.connector.expressions.Expressions.column((String)MetadataColumns.SPEC_ID.name());
    private static final NamedReference PARTITION = org.apache.spark.sql.connector.expressions.Expressions.column((String)"_partition");
    private static final NamedReference FILE_PATH = org.apache.spark.sql.connector.expressions.Expressions.column((String)MetadataColumns.FILE_PATH.name());
    private static final NamedReference ROW_POSITION = org.apache.spark.sql.connector.expressions.Expressions.column((String)MetadataColumns.ROW_POSITION.name());
    private static final Expression SPEC_ID_ORDER = expressionHelper.sort((Expression)SPEC_ID, true);
    private static final Expression PARTITION_ORDER = expressionHelper.sort((Expression)PARTITION, true);
    private static final Expression FILE_PATH_ORDER = expressionHelper.sort((Expression)FILE_PATH, true);
    private static final Expression ROW_POSITION_ORDER = expressionHelper.sort((Expression)ROW_POSITION, true);
    private static final Expression[] METADATA_ORDERS = new Expression[]{PARTITION_ORDER, FILE_PATH_ORDER, ROW_POSITION_ORDER};

    public static Expression[] buildTableRequiredDistribution(MixedTable table, boolean writeBase) {
        DistributionHashMode distributionHashMode = DistributionHashMode.autoSelect((boolean)table.isKeyedTable(), (!table.spec().isUnpartitioned() ? 1 : 0) != 0);
        ArrayList distributionExpressions = Lists.newArrayList();
        if (distributionHashMode.isSupportPartition()) {
            distributionExpressions.addAll(Arrays.asList(Spark3Util.toTransforms((PartitionSpec)table.spec())));
        }
        if (distributionHashMode.isSupportPrimaryKey()) {
            Transform transform = DistributionAndOrderingUtil.toTransformsFromPrimary(table, table.asKeyedTable().primaryKeySpec(), writeBase);
            distributionExpressions.add(transform);
        }
        return distributionExpressions.toArray(new Expression[0]);
    }

    private static Transform toTransformsFromPrimary(MixedTable table, PrimaryKeySpec primaryKeySpec, boolean writeBase) {
        int numBucket = PropertyUtil.propertyAsInt((Map)table.properties(), (String)"base.file-index.hash-bucket", (int)4);
        if (!writeBase) {
            numBucket = PropertyUtil.propertyAsInt((Map)table.properties(), (String)"change.file-index.hash-bucket", (int)4);
        }
        return new FileIndexBucket(table.schema(), primaryKeySpec, numBucket - 1);
    }

    public static Expression[] buildTableRequiredSortOrder(MixedTable table, boolean rowLevelOperation, boolean writeBase) {
        boolean withMetaColumn;
        Schema schema = table.schema();
        PartitionSpec partitionSpec = table.spec();
        PrimaryKeySpec keySpec = PrimaryKeySpec.noPrimaryKey();
        if (table.isKeyedTable()) {
            keySpec = table.asKeyedTable().primaryKeySpec();
        }
        boolean bl = withMetaColumn = table.isUnkeyedTable() && rowLevelOperation;
        if (partitionSpec.isUnpartitioned() && !keySpec.primaryKeyExisted() && !withMetaColumn) {
            return new Expression[0];
        }
        SortOrder.Builder builder = SortOrder.builderFor((Schema)schema);
        if (partitionSpec.isPartitioned()) {
            for (PartitionField field : partitionSpec.fields()) {
                String sourceName = schema.findColumnName(field.sourceId());
                builder.asc((Term)Expressions.transform((String)sourceName, (org.apache.iceberg.transforms.Transform)field.transform()));
            }
        }
        SortOrder sortOrder = builder.build();
        List converted = SortOrderVisitor.visit((SortOrder)sortOrder, (SortOrderVisitor)new SortOrderToSpark(expressionHelper));
        if (keySpec.primaryKeyExisted()) {
            Transform fileIndexBucket = DistributionAndOrderingUtil.toTransformsFromPrimary(table, keySpec, writeBase);
            converted.add(expressionHelper.sort((Expression)fileIndexBucket, true));
        }
        Object[] orders = converted.toArray(new Expression[0]);
        if (withMetaColumn) {
            orders = (Expression[])ObjectArrays.concat((Object[])orders, (Object[])METADATA_ORDERS, Expression.class);
        }
        return orders;
    }
}

