/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.data;

import org.apache.iceberg.FileContent;

public enum DataFileType {
    BASE_FILE(0, "B"),
    INSERT_FILE(1, "I"),
    EQ_DELETE_FILE(2, "ED"),
    POS_DELETE_FILE(3, "PD"),
    ICEBERG_EQ_DELETE_FILE(4, "IED"),
    LOG_FILE(5, "L");

    private final int id;
    private final String shortName;

    private DataFileType(int id, String shortName) {
        this.id = id;
        this.shortName = shortName;
    }

    public int id() {
        return this.id;
    }

    public String shortName() {
        return this.shortName;
    }

    public static DataFileType ofId(int id) {
        for (DataFileType type : DataFileType.values()) {
            if (type.id() != id) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown file type id:" + id);
    }

    public static DataFileType ofContentId(Integer id) {
        if (id == null) {
            return BASE_FILE;
        }
        if (id.intValue() == FileContent.DATA.id()) {
            return BASE_FILE;
        }
        if (id.intValue() == FileContent.POSITION_DELETES.id()) {
            return POS_DELETE_FILE;
        }
        if (id.intValue() == FileContent.EQUALITY_DELETES.id()) {
            return EQ_DELETE_FILE;
        }
        throw new IllegalArgumentException("Unknown file content id:" + id);
    }

    public static DataFileType ofShortName(String shortName) {
        for (DataFileType type : DataFileType.values()) {
            if (!type.shortName().equals(shortName)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown file type short name:" + shortName);
    }
}

