/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.data;

import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.data.DefaultKeyedFile;
import org.apache.amoro.io.writer.TaskWriterKey;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.utils.IdGenerator;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.iceberg.FileFormat;

public class FileNameRules {
    private static final String KEYED_FILE_NAME_PATTERN_STRING = "\\.?(\\d+)-(\\w+)-(\\d+)-(\\d+)-(\\d+)-.*";
    private static final Pattern KEYED_FILE_NAME_PATTERN = Pattern.compile("\\.?(\\d+)-(\\w+)-(\\d+)-(\\d+)-(\\d+)-.*");
    private static final String FORMAT = "%d-%s-%d-%05d-%d-%s-%05d";
    public static final DefaultKeyedFile.FileMeta DEFAULT_BASE_FILE_META = new DefaultKeyedFile.FileMeta(0L, DataFileType.BASE_FILE, DataTreeNode.ROOT);
    private final FileFormat fileFormat;
    private final int partitionId;
    private final long taskId;
    private final long transactionId;
    private final String operationId = IdGenerator.randomId() + "";
    private final AtomicLong fileCount = new AtomicLong(0L);

    public FileNameRules(FileFormat fileFormat, int partitionId, Long taskId, Long transactionId) {
        this.fileFormat = fileFormat;
        this.partitionId = partitionId;
        this.taskId = taskId;
        this.transactionId = transactionId == null ? 0L : transactionId;
    }

    public String fileName(TaskWriterKey key) {
        return this.fileFormat.addExtension(String.format(FORMAT, key.getTreeNode().getId(), key.getFileType().shortName(), this.transactionId, this.partitionId, this.taskId, this.operationId, this.fileCount.incrementAndGet()));
    }

    public static DefaultKeyedFile.FileMeta parseChange(String path, Long sequenceNumber) {
        String fileName = TableFileUtil.getFileName(path);
        Matcher matcher = KEYED_FILE_NAME_PATTERN.matcher(fileName);
        if (FileNameRules.matchMixedFileFormat(matcher)) {
            long nodeId = Long.parseLong(matcher.group(1));
            DataFileType type = DataFileType.ofShortName(matcher.group(2));
            long transactionId = Long.parseLong(matcher.group(3));
            Preconditions.checkArgument((transactionId > 0L || sequenceNumber != null ? 1 : 0) != 0, (Object)"Data sequence number of File is null");
            transactionId = transactionId == 0L ? sequenceNumber : transactionId;
            DataTreeNode node = DataTreeNode.ofId(nodeId);
            return new DefaultKeyedFile.FileMeta(transactionId, type, node);
        }
        Preconditions.checkArgument((sequenceNumber != null ? 1 : 0) != 0, (Object)"Data sequence number of File is null");
        return new DefaultKeyedFile.FileMeta(sequenceNumber, DataFileType.INSERT_FILE, DataTreeNode.ROOT);
    }

    public static DefaultKeyedFile.FileMeta parseBase(String path) {
        String fileName = TableFileUtil.getFileName(path);
        Matcher matcher = KEYED_FILE_NAME_PATTERN.matcher(fileName);
        if (FileNameRules.matchMixedFileFormat(matcher)) {
            long nodeId = Long.parseLong(matcher.group(1));
            DataFileType type = DataFileType.ofShortName(matcher.group(2));
            if (type == DataFileType.INSERT_FILE) {
                type = DataFileType.BASE_FILE;
            }
            long transactionId = Long.parseLong(matcher.group(3));
            DataTreeNode node = DataTreeNode.ofId(nodeId);
            return new DefaultKeyedFile.FileMeta(transactionId, type, node);
        }
        return DEFAULT_BASE_FILE_META;
    }

    public static DataFileType parseFileTypeForChange(String path) {
        String fileName = TableFileUtil.getFileName(path);
        Matcher matcher = KEYED_FILE_NAME_PATTERN.matcher(fileName);
        if (FileNameRules.matchMixedFileFormat(matcher)) {
            return DataFileType.ofShortName(matcher.group(2));
        }
        return DataFileType.INSERT_FILE;
    }

    public static DataFileType parseFileTypeForBase(String path) {
        String fileName = TableFileUtil.getFileName(path);
        Matcher matcher = KEYED_FILE_NAME_PATTERN.matcher(fileName);
        if (FileNameRules.matchMixedFileFormat(matcher)) {
            DataFileType type = DataFileType.ofShortName(matcher.group(2));
            if (type == DataFileType.INSERT_FILE) {
                type = DataFileType.BASE_FILE;
            }
            return type;
        }
        return DataFileType.BASE_FILE;
    }

    public static DataFileType parseFileType(String path, String tableType) {
        if ("change".equals(tableType)) {
            return FileNameRules.parseFileTypeForChange(path);
        }
        if ("base".equals(tableType)) {
            return FileNameRules.parseFileTypeForBase(path);
        }
        throw new IllegalArgumentException("unknown tableType " + tableType);
    }

    public static DataTreeNode parseFileNodeFromFileName(String path) {
        Matcher matcher = KEYED_FILE_NAME_PATTERN.matcher(path = TableFileUtil.getFileName(path));
        if (FileNameRules.matchMixedFileFormat(matcher)) {
            long nodeId = Long.parseLong(matcher.group(1));
            return DataTreeNode.ofId(nodeId);
        }
        return DataTreeNode.ROOT;
    }

    public static long parseTransactionId(String path) {
        String fileName = TableFileUtil.getFileName(path);
        Matcher matcher = KEYED_FILE_NAME_PATTERN.matcher(fileName);
        if (FileNameRules.matchMixedFileFormat(matcher)) {
            return Long.parseLong(matcher.group(3));
        }
        return 0L;
    }

    public static long parseChangeTransactionId(String path, long sequenceNumber) {
        long transactionId = FileNameRules.parseTransactionId(path);
        return transactionId == 0L ? sequenceNumber : transactionId;
    }

    private static boolean matchMixedFileFormat(Matcher fileNameMatcher) {
        return fileNameMatcher.matches() && FileNameRules.validFileType(fileNameMatcher.group(2));
    }

    private static boolean validFileType(String typeName) {
        try {
            DataFileType.ofShortName(typeName);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

