/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.formats.iceberg;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.FormatCatalog;
import org.apache.amoro.NoSuchTableException;
import org.apache.amoro.formats.iceberg.IcebergTable;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.MixedFormatCatalogUtil;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;

public class IcebergCatalog
implements FormatCatalog {
    private SupportsNamespaces asNamespaceCatalog;
    private final Catalog icebergCatalog;
    private final TableMetaStore metaStore;
    private final Map<String, String> properties;

    public IcebergCatalog(Catalog catalog, Map<String, String> properties, TableMetaStore metaStore) {
        this.icebergCatalog = MixedFormatCatalogUtil.buildCacheCatalog(catalog, properties);
        if (catalog instanceof SupportsNamespaces) {
            this.asNamespaceCatalog = (SupportsNamespaces)catalog;
        }
        this.metaStore = metaStore;
        this.properties = properties;
    }

    public List<String> listDatabases() {
        return (List)this.metaStore.doAs(() -> this.asNamespaceCatalog().listNamespaces().stream().map(ns -> ns.level(0)).collect(Collectors.toList()));
    }

    public boolean databaseExists(String database) {
        return this.listDatabases().contains(database);
    }

    public boolean tableExists(String database, String table) {
        TableIdentifier identifier = TableIdentifier.of((String[])new String[]{database, table});
        return (Boolean)this.metaStore.doAs(() -> this.icebergCatalog.tableExists(identifier));
    }

    public void createDatabase(String database) {
        this.metaStore.doAs(() -> {
            this.asNamespaceCatalog().createNamespace(Namespace.of((String[])new String[]{database}));
            return null;
        });
    }

    public void dropDatabase(String database) {
        this.metaStore.doAs(() -> {
            this.asNamespaceCatalog().dropNamespace(Namespace.of((String[])new String[]{database}));
            return null;
        });
    }

    public List<String> listTables(String database) {
        return (List)this.metaStore.doAs(() -> this.icebergCatalog.listTables(Namespace.of((String[])new String[]{database})).stream().map(TableIdentifier::name).collect(Collectors.toList()));
    }

    public AmoroTable<?> loadTable(String database, String table) {
        return (AmoroTable)this.metaStore.doAs(() -> {
            try {
                Table icebergTable = this.icebergCatalog.loadTable(TableIdentifier.of((String[])new String[]{database, table}));
                return IcebergTable.newIcebergTable(org.apache.amoro.table.TableIdentifier.of((String)this.icebergCatalog.name(), (String)database, (String)table), icebergTable, this.metaStore, this.properties);
            }
            catch (org.apache.iceberg.exceptions.NoSuchTableException e) {
                throw new NoSuchTableException((Throwable)e);
            }
        });
    }

    private SupportsNamespaces asNamespaceCatalog() {
        if (this.asNamespaceCatalog == null) {
            throw new UnsupportedOperationException(String.format("Iceberg catalog: %s doesn't implement SupportsNamespaces", this.icebergCatalog.getClass().getName()));
        }
        return this.asNamespaceCatalog;
    }

    public boolean dropTable(String database, String table, boolean purge) {
        return (Boolean)this.metaStore.doAs(() -> this.icebergCatalog.dropTable(TableIdentifier.of((String[])new String[]{database, table}), purge));
    }
}

