/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.io.reader;

import java.util.Set;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.StructProjection;

public class StructForDelete<T extends StructLike> {
    private T structLike;
    private final StructProjection pkProjection;
    private final Accessor<StructLike> posAccessor;
    private final Accessor<StructLike> filePathAccessor;
    private final Accessor<StructLike> dataTransactionIdAccessor;

    public StructForDelete(Schema schema, Set<Integer> deleteIds) {
        this.pkProjection = StructProjection.create((Schema)schema, (Schema)TypeUtil.select((Schema)schema, deleteIds));
        this.dataTransactionIdAccessor = schema.accessorForField(2147482646);
        this.posAccessor = schema.accessorForField(MetadataColumns.ROW_POSITION.fieldId());
        this.filePathAccessor = schema.accessorForField(MetadataColumns.FILE_PATH.fieldId());
    }

    public StructForDelete<T> wrap(T structLike) {
        this.structLike = structLike;
        return this;
    }

    public StructLike getPk() {
        return this.pkProjection.copyFor(this.structLike);
    }

    public Long getLsn() {
        return (Long)this.dataTransactionIdAccessor.get(this.structLike);
    }

    public Long getPosition() {
        return (Long)this.posAccessor.get(this.structLike);
    }

    public String filePath() {
        return (String)this.filePathAccessor.get(this.structLike);
    }

    public T recover() {
        return this.structLike;
    }
}

