/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.log;

import java.io.IOException;
import java.io.Serializable;
import java.util.function.Predicate;
import org.apache.amoro.log.Bytes;
import org.apache.amoro.log.JsonToLogDataConverters;
import org.apache.amoro.log.LogData;
import org.apache.amoro.log.data.LogArrayData;
import org.apache.amoro.log.data.LogMapData;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.primitives.Longs;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.amoro.utils.FlipUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDataJsonDeserialization<T>
implements Serializable {
    private static final long serialVersionUID = -5741370033707067127L;
    private static final Logger LOG = LoggerFactory.getLogger(LogDataJsonDeserialization.class);
    private static final int ROW_BEGINNING_POS = 18;
    private final JsonToLogDataConverters.JsonToLogDataConverter<T> jsonToLogDataConverter;
    private final LogData.Factory<T> factory;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public LogDataJsonDeserialization(Schema schema, LogData.Factory<T> factory, LogArrayData.Factory arrayFactory, LogMapData.Factory mapFactory) {
        this.factory = factory;
        this.jsonToLogDataConverter = new JsonToLogDataConverters<T>(factory, arrayFactory, mapFactory).createConverter((Type)schema.asStruct());
        boolean hasDecimalType = this.hasDecimalType(schema.asStruct());
        if (hasDecimalType) {
            this.objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        }
    }

    private boolean hasDecimalType(Types.StructType structType) {
        return structType.fields().stream().map(Types.NestedField::type).anyMatch((Predicate<Type>)((org.apache.amoro.shade.guava32.com.google.common.base.Predicate)type -> {
            boolean hasDecimalType;
            if (type.typeId() == Type.TypeID.STRUCT && (hasDecimalType = this.hasDecimalType((Types.StructType)type))) {
                return true;
            }
            return type.typeId() == Type.TypeID.DECIMAL;
        }));
    }

    public LogData<T> deserialize(byte[] message) throws IOException {
        try {
            Preconditions.checkArgument((message != null ? 1 : 0) != 0, (Object)"message is null.");
            Preconditions.checkArgument((message.length >= 18 ? 1 : 0) != 0, (Object)"message is illegal.");
            byte[] versionBytes = Bytes.subByte(message, 0, 4);
            byte[] upstreamIdBytes = Bytes.subByte(message, 4, 4);
            long epicNo = Longs.fromByteArray((byte[])Bytes.subByte(message, 8, 8));
            byte flip = Bytes.subByte(message, 16, 1)[0];
            byte changeActionByte = Bytes.subByte(message, 17, 1)[0];
            boolean flipBoolean = FlipUtil.convertToBoolean((byte)flip);
            if (flipBoolean) {
                return this.factory.create(null, versionBytes, upstreamIdBytes, epicNo, true, changeActionByte);
            }
            byte[] actualValueBytes = Bytes.subByte(message, 18, message.length - 18);
            JsonNode root = this.objectMapper.readTree(actualValueBytes);
            Object actualValue = this.jsonToLogDataConverter.convert(root, null);
            return this.factory.create(actualValue, versionBytes, upstreamIdBytes, epicNo, false, changeActionByte);
        }
        catch (Throwable t) {
            LOG.error("", t);
            throw t;
        }
    }
}

