/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.function.Supplier;
import org.apache.amoro.op.MixedUpdate;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;

public class MixedReplacePartitions
extends MixedUpdate<ReplacePartitions>
implements ReplacePartitions {
    private final ReplacePartitions replacePartitions;

    public static Builder buildFor(MixedTable table) {
        return new Builder(table);
    }

    private MixedReplacePartitions(MixedTable mixedTable, ReplacePartitions replacePartitions) {
        super(mixedTable, replacePartitions);
        this.replacePartitions = replacePartitions;
    }

    private MixedReplacePartitions(MixedTable mixedTable, ReplacePartitions replacePartitions, Transaction transaction, boolean autoCommitTransaction) {
        super(mixedTable, replacePartitions, transaction, autoCommitTransaction);
        this.replacePartitions = replacePartitions;
    }

    public ReplacePartitions addFile(DataFile file) {
        this.replacePartitions.addFile(file);
        this.addIcebergDataFile(file);
        return this;
    }

    public ReplacePartitions validateAppendOnly() {
        this.replacePartitions.validateAppendOnly();
        return this;
    }

    public ReplacePartitions validateFromSnapshot(long snapshotId) {
        this.replacePartitions.validateFromSnapshot(snapshotId);
        return this;
    }

    public ReplacePartitions validateNoConflictingDeletes() {
        this.replacePartitions.validateNoConflictingDeletes();
        return this;
    }

    public ReplacePartitions validateNoConflictingData() {
        this.replacePartitions.validateNoConflictingData();
        return this;
    }

    @Override
    protected ReplacePartitions self() {
        return this;
    }

    public static class Builder
    extends MixedUpdate.Builder<MixedReplacePartitions, ReplacePartitions> {
        private Builder(MixedTable table) {
            super(table);
            this.generateWatermark();
        }

        @Override
        protected MixedReplacePartitions updateWithWatermark(Transaction transaction, boolean autoCommitTransaction) {
            return new MixedReplacePartitions(this.table, transaction.newReplacePartitions(), transaction, autoCommitTransaction);
        }

        @Override
        protected MixedReplacePartitions updateWithoutWatermark(Supplier<ReplacePartitions> delegateSupplier) {
            return new MixedReplacePartitions(this.table, delegateSupplier.get());
        }

        @Override
        protected Supplier<ReplacePartitions> transactionDelegateSupplier(Transaction transaction) {
            return () -> ((Transaction)transaction).newReplacePartitions();
        }

        @Override
        protected Supplier<ReplacePartitions> tableStoreDelegateSupplier(Table tableStore) {
            return () -> ((Table)tableStore).newReplacePartitions();
        }
    }
}

