/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Types;

public class PrimaryKeySpec
implements Serializable {
    public static final String PRIMARY_KEY_COLUMN_JOIN_DELIMITER = ",";
    private final Schema schema;
    private final ImmutableList<PrimaryKeyField> pkFields;
    private static final PrimaryKeySpec NO_PRIMARY_KEY_SPEC = new PrimaryKeySpec(new Schema(new Types.NestedField[0]), (List<PrimaryKeyField>)ImmutableList.of());

    private PrimaryKeySpec(Schema schema, List<PrimaryKeyField> pkFields) {
        this.schema = schema;
        this.pkFields = ImmutableList.copyOf(pkFields);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Schema getPkSchema() {
        return this.schema.select((Collection)this.pkFields.stream().map(PrimaryKeyField::fieldName).collect(Collectors.toList()));
    }

    public static Builder builderFor(Schema schema) {
        return new Builder(schema);
    }

    public static PrimaryKeySpec fromDescription(Schema schema, String keyDescription) {
        Builder keyBuilder = PrimaryKeySpec.builderFor(schema);
        Arrays.stream(keyDescription.split(PRIMARY_KEY_COLUMN_JOIN_DELIMITER)).filter(StringUtils::isNotBlank).forEach(keyBuilder::addColumn);
        return keyBuilder.build();
    }

    public List<PrimaryKeyField> fields() {
        return this.pkFields;
    }

    public PrimaryKeyField field(int index) {
        return (PrimaryKeyField)this.pkFields.get(index);
    }

    public Types.StructType primaryKeyStruct() {
        return Types.StructType.of(this.pkFields.stream().map(field -> this.schema.findField(field.fieldName())).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimaryKeySpec that = (PrimaryKeySpec)o;
        return this.pkFields.equals(that.pkFields);
    }

    public int hashCode() {
        return Objects.hash(this.pkFields);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("primary key(");
        for (PrimaryKeyField field : this.pkFields) {
            sb.append(field).append(PRIMARY_KEY_COLUMN_JOIN_DELIMITER);
        }
        if (!this.pkFields.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    public String description() {
        return this.pkFields.stream().map(PrimaryKeyField::fieldName).collect(Collectors.joining(PRIMARY_KEY_COLUMN_JOIN_DELIMITER));
    }

    public List<String> fieldNames() {
        return this.pkFields.stream().map(PrimaryKeyField::fieldName).collect(Collectors.toList());
    }

    public boolean primaryKeyExisted() {
        return !NO_PRIMARY_KEY_SPEC.equals(this);
    }

    public static PrimaryKeySpec noPrimaryKey() {
        return NO_PRIMARY_KEY_SPEC;
    }

    public static class PrimaryKeyField
    implements Serializable {
        private final String fieldName;

        PrimaryKeyField(String fieldName) {
            this.fieldName = fieldName;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public String toString() {
            return this.fieldName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PrimaryKeyField that = (PrimaryKeyField)o;
            return Objects.equals(this.fieldName, that.fieldName);
        }

        public int hashCode() {
            return Objects.hash(this.fieldName);
        }
    }

    public static class Builder {
        private final Schema schema;
        private final List<PrimaryKeyField> pkFields = new ArrayList<PrimaryKeyField>();

        private Builder(Schema schema) {
            this.schema = schema;
        }

        public Builder addColumn(String columnName) {
            Types.NestedField sourceColumn = this.schema.findField(columnName);
            Preconditions.checkArgument((sourceColumn != null ? 1 : 0) != 0, (String)"Cannot find source column: %s", (Object)columnName);
            this.addColumn(sourceColumn);
            return this;
        }

        public Builder addColumn(Integer columnIndex) {
            Types.NestedField sourceColumn = this.schema.findField(columnIndex.intValue());
            Preconditions.checkArgument((sourceColumn != null ? 1 : 0) != 0, (String)"Cannot find source column by id: %s", (Object)columnIndex);
            this.addColumn(sourceColumn);
            return this;
        }

        public Builder addColumn(Types.NestedField sourceColumn) {
            this.pkFields.add(new PrimaryKeyField(sourceColumn.name()));
            return this;
        }

        public PrimaryKeySpec build() {
            if (!this.pkFields.isEmpty()) {
                return new PrimaryKeySpec(this.schema, this.pkFields);
            }
            return PrimaryKeySpec.noPrimaryKey();
        }
    }
}

