/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.amoro.data.DefaultKeyedFile;
import org.apache.amoro.scan.BasicMixedFileScanTask;
import org.apache.amoro.scan.ChangeTableIncrementalScan;
import org.apache.amoro.utils.TablePropertyUtil;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataTableScan;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ImmutableTableScanContext;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.util.StructLikeMap;

public class MixedChangeTableScan
extends DataTableScan
implements ChangeTableIncrementalScan {
    private StructLikeMap<Long> fromPartitionSequence;
    private Long toSequence;
    private Long fromSequence;

    public MixedChangeTableScan(Table table, Schema schema) {
        super(table, schema, (TableScanContext)ImmutableTableScanContext.builder().build());
    }

    protected MixedChangeTableScan(Table table, Schema schema, TableScanContext context) {
        super(table, schema, context);
    }

    @Override
    public MixedChangeTableScan useSnapshot(long scanSnapshotId) {
        TableScan scan = (TableScan)super.useSnapshot(scanSnapshotId);
        return this.newRefinedScan(this.table(), scan.schema(), this.context().useSnapshotId(Long.valueOf(scanSnapshotId)));
    }

    @Override
    public MixedChangeTableScan filter(Expression expr) {
        TableScan scan = (TableScan)super.filter(expr);
        return this.newRefinedScan(this.table(), scan.schema(), this.context().filterRows(scan.filter()));
    }

    protected MixedChangeTableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
        MixedChangeTableScan scan = new MixedChangeTableScan(table, schema, context);
        scan.fromPartitionSequence = this.fromPartitionSequence;
        scan.toSequence = this.toSequence;
        return scan;
    }

    @Override
    public ChangeTableIncrementalScan fromSequence(StructLikeMap<Long> partitionSequence) {
        MixedChangeTableScan scan = this.newRefinedScan(this.table(), this.schema(), this.context());
        scan.fromPartitionSequence = partitionSequence;
        return scan;
    }

    @Override
    public ChangeTableIncrementalScan fromSequence(long sequence) {
        MixedChangeTableScan scan = this.newRefinedScan(this.table(), this.schema(), this.context());
        scan.fromSequence = sequence;
        return scan;
    }

    @Override
    public ChangeTableIncrementalScan toSequence(long sequence) {
        MixedChangeTableScan scan = this.newRefinedScan(this.table(), this.schema(), this.context());
        scan.toSequence = sequence;
        return scan;
    }

    public ChangeTableIncrementalScan useRef(String ref) {
        return (ChangeTableIncrementalScan)super.useRef(ref);
    }

    public CloseableIterable<FileScanTask> doPlanFiles() {
        CloseableIterable filteredTasks = CloseableIterable.filter((CloseableIterable)super.doPlanFiles(), fileScanTask -> {
            StructLike partition = ((DataFile)fileScanTask.file()).partition();
            long sequenceNumber = ((DataFile)fileScanTask.file()).dataSequenceNumber();
            return this.shouldKeepFile(partition, sequenceNumber);
        });
        return CloseableIterable.transform((CloseableIterable)filteredTasks, fileScanTask -> new BasicMixedFileScanTask(DefaultKeyedFile.parseChange((DataFile)fileScanTask.file()), null, this.table().spec(), null));
    }

    private boolean shouldKeepFile(StructLike partition, long sequence) {
        if (this.biggerThanToSequence(sequence)) {
            return false;
        }
        if (this.fromSequence == null && (this.fromPartitionSequence == null || this.fromPartitionSequence.isEmpty())) {
            return true;
        }
        Long fromSequence = this.table().spec().isUnpartitioned() ? this.scanFromSequence(TablePropertyUtil.EMPTY_STRUCT) : this.scanFromSequence(partition);
        if (fromSequence != null) {
            return sequence > fromSequence;
        }
        return true;
    }

    private Long scanFromSequence(StructLike partitionData) {
        Long fromSequence = null;
        if (this.fromPartitionSequence != null) {
            fromSequence = (Long)this.fromPartitionSequence.get((Object)partitionData);
        }
        if (fromSequence == null) {
            fromSequence = this.fromSequence;
        }
        return fromSequence;
    }

    private boolean biggerThanToSequence(long sequence) {
        return this.toSequence != null && sequence > this.toSequence;
    }
}

