/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.op;

import java.util.List;
import java.util.Map;
import org.apache.amoro.client.ClientPool;
import org.apache.amoro.hive.HMSClient;
import org.apache.amoro.hive.HMSClientPool;
import org.apache.amoro.hive.op.HiveSchemaUpdate;
import org.apache.amoro.hive.op.OverwriteHiveFiles;
import org.apache.amoro.hive.op.ReplaceHivePartitions;
import org.apache.amoro.hive.op.RewriteHiveFiles;
import org.apache.amoro.hive.table.UnkeyedHiveTable;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateStatistics;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.thrift.TException;

public class HiveOperationTransaction
implements Transaction {
    private final UnkeyedHiveTable unkeyedHiveTable;
    private final Transaction wrapped;
    private final HMSClientPool client;
    private final TransactionalHMSClient transactionalClient;
    private final TransactionalTable transactionalTable;

    public HiveOperationTransaction(UnkeyedHiveTable unkeyedHiveTable, Transaction wrapped, HMSClientPool client) {
        this.unkeyedHiveTable = unkeyedHiveTable;
        this.wrapped = wrapped;
        this.client = client;
        this.transactionalTable = new TransactionalTable();
        this.transactionalClient = new TransactionalHMSClient();
    }

    public Table table() {
        return this.transactionalTable;
    }

    public UpdateSchema updateSchema() {
        return new HiveSchemaUpdate(this.unkeyedHiveTable, this.client, this.transactionalClient, this.wrapped.updateSchema());
    }

    public UpdatePartitionSpec updateSpec() {
        return this.wrapped.updateSpec();
    }

    public UpdateProperties updateProperties() {
        return this.wrapped.updateProperties();
    }

    public ReplaceSortOrder replaceSortOrder() {
        return this.wrapped.replaceSortOrder();
    }

    public UpdateLocation updateLocation() {
        return this.wrapped.updateLocation();
    }

    public AppendFiles newAppend() {
        return this.wrapped.newAppend();
    }

    public AppendFiles newFastAppend() {
        return this.wrapped.newFastAppend();
    }

    public RewriteFiles newRewrite() {
        return new RewriteHiveFiles(this.wrapped, true, this.unkeyedHiveTable, this.client, this.transactionalClient);
    }

    public RewriteManifests rewriteManifests() {
        return this.wrapped.rewriteManifests();
    }

    public OverwriteFiles newOverwrite() {
        return new OverwriteHiveFiles(this.wrapped, true, this.unkeyedHiveTable, this.client, this.transactionalClient);
    }

    public RowDelta newRowDelta() {
        return this.wrapped.newRowDelta();
    }

    public ReplacePartitions newReplacePartitions() {
        return new ReplaceHivePartitions(this.wrapped, true, this.unkeyedHiveTable, this.client, this.transactionalClient);
    }

    public DeleteFiles newDelete() {
        return this.wrapped.newDelete();
    }

    public ExpireSnapshots expireSnapshots() {
        return this.wrapped.expireSnapshots();
    }

    public void commitTransaction() {
        this.wrapped.commitTransaction();
        this.transactionalClient.commit();
    }

    public UpdateStatistics updateStatistics() {
        return this.wrapped.updateStatistics();
    }

    public ManageSnapshots manageSnapshots() {
        return this.wrapped.manageSnapshots();
    }

    private class TransactionalTable
    implements Table {
        Table transactionTable;

        public TransactionalTable() {
            this.transactionTable = HiveOperationTransaction.this.wrapped.table();
        }

        public String name() {
            return this.transactionTable.name();
        }

        public void refresh() {
            this.transactionTable.refresh();
        }

        public TableScan newScan() {
            return this.transactionTable.newScan();
        }

        public Schema schema() {
            return this.transactionTable.schema();
        }

        public Map<Integer, Schema> schemas() {
            return this.transactionTable.schemas();
        }

        public PartitionSpec spec() {
            return this.transactionTable.spec();
        }

        public Map<Integer, PartitionSpec> specs() {
            return this.transactionTable.specs();
        }

        public SortOrder sortOrder() {
            return this.transactionTable.sortOrder();
        }

        public Map<Integer, SortOrder> sortOrders() {
            return this.transactionTable.sortOrders();
        }

        public Map<String, String> properties() {
            return this.transactionTable.properties();
        }

        public String location() {
            return this.transactionTable.location();
        }

        public Snapshot currentSnapshot() {
            return this.transactionTable.currentSnapshot();
        }

        public Snapshot snapshot(long snapshotId) {
            return this.transactionTable.snapshot(snapshotId);
        }

        public Iterable<Snapshot> snapshots() {
            return this.transactionTable.snapshots();
        }

        public List<HistoryEntry> history() {
            return this.transactionTable.history();
        }

        public UpdateSchema updateSchema() {
            return HiveOperationTransaction.this.updateSchema();
        }

        public UpdatePartitionSpec updateSpec() {
            return HiveOperationTransaction.this.updateSpec();
        }

        public UpdateProperties updateProperties() {
            return HiveOperationTransaction.this.updateProperties();
        }

        public ReplaceSortOrder replaceSortOrder() {
            return HiveOperationTransaction.this.replaceSortOrder();
        }

        public UpdateLocation updateLocation() {
            return HiveOperationTransaction.this.updateLocation();
        }

        public AppendFiles newAppend() {
            return HiveOperationTransaction.this.newAppend();
        }

        public AppendFiles newFastAppend() {
            return HiveOperationTransaction.this.newFastAppend();
        }

        public RewriteFiles newRewrite() {
            return HiveOperationTransaction.this.newRewrite();
        }

        public RewriteManifests rewriteManifests() {
            return HiveOperationTransaction.this.rewriteManifests();
        }

        public OverwriteFiles newOverwrite() {
            return HiveOperationTransaction.this.newOverwrite();
        }

        public RowDelta newRowDelta() {
            return HiveOperationTransaction.this.newRowDelta();
        }

        public ReplacePartitions newReplacePartitions() {
            return HiveOperationTransaction.this.newReplacePartitions();
        }

        public DeleteFiles newDelete() {
            return HiveOperationTransaction.this.newDelete();
        }

        public ExpireSnapshots expireSnapshots() {
            return HiveOperationTransaction.this.expireSnapshots();
        }

        public ManageSnapshots manageSnapshots() {
            throw new UnsupportedOperationException("Transaction tables do not support rollback");
        }

        public Transaction newTransaction() {
            throw new UnsupportedOperationException("Transaction tables do not support rollback");
        }

        public FileIO io() {
            return this.transactionTable.io();
        }

        public EncryptionManager encryption() {
            return this.transactionTable.encryption();
        }

        public LocationProvider locationProvider() {
            return this.transactionTable.locationProvider();
        }

        public List<StatisticsFile> statisticsFiles() {
            return this.transactionTable.statisticsFiles();
        }

        public Map<String, SnapshotRef> refs() {
            return this.transactionTable.refs();
        }
    }

    private class TransactionalHMSClient
    implements HMSClientPool {
        List<ClientPool.Action<?, HMSClient, TException>> pendingActions = Lists.newArrayList();

        private TransactionalHMSClient() {
        }

        public <R> R run(ClientPool.Action<R, HMSClient, TException> action) {
            this.pendingActions.add(action);
            return null;
        }

        public <R> R run(ClientPool.Action<R, HMSClient, TException> action, boolean retry) throws TException, InterruptedException {
            this.pendingActions.add(action);
            return null;
        }

        public void commit() {
            for (ClientPool.Action<?, HMSClient, TException> action : this.pendingActions) {
                try {
                    HiveOperationTransaction.this.client.run(action);
                }
                catch (InterruptedException | TException e) {
                    throw new RuntimeException("execute pending hive operation failed.", e);
                }
            }
        }
    }
}

