/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizer.common;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.amoro.api.AmoroException;
import org.apache.amoro.api.OptimizingService;
import org.apache.amoro.client.OptimizingClientPools;
import org.apache.amoro.optimizer.common.OptimizerConfig;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.thrift.org.apache.thrift.TApplicationException;
import org.apache.amoro.shade.thrift.org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractOptimizerOperator
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOptimizerOperator.class);
    private static long callAmsInterval = TimeUnit.SECONDS.toMillis(5L);
    private final OptimizerConfig config;
    private final AtomicReference<String> token = new AtomicReference();
    private volatile boolean stopped = false;

    public AbstractOptimizerOperator(OptimizerConfig config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    protected <T> T callAms(AmsCallOperation<T> operation) throws TException {
        while (this.isStarted()) {
            try {
                return operation.call(OptimizingClientPools.getClient((String)this.config.getAmsUrl()));
            }
            catch (Throwable t) {
                if (this.shouldReturnNull(t)) {
                    return null;
                }
                if (this.shouldRetryLater(t)) {
                    LOG.error("Call ams got an error and will try again later", t);
                    this.waitAShortTime();
                    continue;
                }
                throw t;
            }
        }
        throw new IllegalStateException("Operator is stopped");
    }

    private boolean shouldRetryLater(Throwable t) {
        if (t instanceof AmoroException) {
            AmoroException amoroException = (AmoroException)t;
            return 1000 == amoroException.getErrorCode() || -1 == amoroException.getErrorCode();
        }
        return true;
    }

    private boolean shouldReturnNull(Throwable t) {
        if (t instanceof TApplicationException) {
            TApplicationException applicationException = (TApplicationException)t;
            return applicationException.getType() == 5;
        }
        return false;
    }

    protected <T> T callAuthenticatedAms(AmsAuthenticatedCallOperation<T> operation) throws TException {
        while (this.isStarted()) {
            if (this.tokenIsReady()) {
                String token = this.getToken();
                try {
                    return operation.call(OptimizingClientPools.getClient((String)this.config.getAmsUrl()), token);
                }
                catch (Throwable t) {
                    if (t instanceof AmoroException && 2006 == ((AmoroException)t).getErrorCode()) {
                        LOG.error("Got a authorization error while calling ams, reset token and wait for a new one", t);
                        this.resetToken(token);
                        continue;
                    }
                    if (this.shouldReturnNull(t)) {
                        return null;
                    }
                    if (this.shouldRetryLater(t)) {
                        LOG.error("Call ams got an error and will try again later", t);
                        this.waitAShortTime();
                        continue;
                    }
                    throw t;
                }
            }
            LOG.debug("Optimizer wait for token is ready");
            this.waitAShortTime();
        }
        throw new IllegalStateException("Operator is stopped");
    }

    public static void setCallAmsInterval(long callAmsInterval) {
        AbstractOptimizerOperator.callAmsInterval = callAmsInterval;
    }

    protected OptimizerConfig getConfig() {
        return this.config;
    }

    protected String getToken() {
        return this.token.get();
    }

    protected boolean tokenIsReady() {
        return this.token.get() != null;
    }

    protected void resetToken(String oldToken) {
        this.token.compareAndSet(oldToken, null);
    }

    public void setToken(String newToken) {
        this.token.set(newToken);
    }

    public boolean isStarted() {
        return !this.stopped;
    }

    public void stop() {
        this.stopped = true;
    }

    protected void waitAShortTime() {
        this.waitAShortTime(callAmsInterval);
    }

    protected void waitAShortTime(long waitTime) {
        try {
            TimeUnit.MILLISECONDS.sleep(waitTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static interface AmsAuthenticatedCallOperation<T> {
        public T call(OptimizingService.Iface var1, String var2) throws TException;
    }

    protected static interface AmsCallOperation<T> {
        public T call(OptimizingService.Iface var1) throws TException;
    }
}

