/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.DefaultChecksumAlgorithm;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.checksums.Algorithm;
import software.amazon.awssdk.core.checksums.ChecksumSpecs;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.interceptor.trait.HttpChecksum;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.s3.internal.s3express.S3ExpressUtils;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@SdkInternalApi
public final class S3ExpressChecksumInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest request = context.request();
        if (!S3ExpressUtils.useS3Express(executionAttributes)) {
            return request;
        }
        Optional resolvedChecksumSpecs = executionAttributes.getOptionalAttribute(SdkExecutionAttribute.RESOLVED_CHECKSUM_SPECS);
        HttpChecksum httpChecksumTraitInOperation = (HttpChecksum)executionAttributes.getAttribute(SdkInternalExecutionAttribute.HTTP_CHECKSUM);
        if (!resolvedChecksumSpecs.isPresent()) {
            if (httpChecksumTraitInOperation != null) {
                throw new IllegalStateException("S3Express: illegal checksum parameter combination");
            }
            return request;
        }
        ChecksumSpecs checksumSpecs = (ChecksumSpecs)resolvedChecksumSpecs.get();
        if (checksumSpecs.algorithm() != null || this.requestContainsUserCalculatedChecksum(request)) {
            return request;
        }
        if (this.shouldAlwaysAddChecksum(checksumSpecs, request)) {
            SelectedAuthScheme<?> authScheme = this.getAuthScheme(executionAttributes);
            AuthSchemeOption authSchemeOption = (AuthSchemeOption)authScheme.authSchemeOption().copy(o -> o.putSignerProperty(AwsV4FamilyHttpSigner.CHECKSUM_ALGORITHM, (Object)DefaultChecksumAlgorithm.CRC32));
            SelectedAuthScheme authSchemeWithCrc32 = new SelectedAuthScheme(authScheme.identity(), authScheme.signer(), authSchemeOption);
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME, (Object)authSchemeWithCrc32);
        }
        return request;
    }

    private boolean requestContainsUserCalculatedChecksum(SdkRequest request) {
        return request.getValueForField("ChecksumCRC32", String.class).isPresent() || request.getValueForField("ChecksumCRC32C", String.class).isPresent() || request.getValueForField("ChecksumSHA1", String.class).isPresent() || request.getValueForField("ChecksumSHA256", String.class).isPresent();
    }

    private boolean shouldAlwaysAddChecksum(ChecksumSpecs checksumSpecs, SdkRequest request) {
        return checksumSpecs.isRequestChecksumRequired() || request instanceof PutObjectRequest;
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Optional<String> headerValue;
        SdkHttpRequest sdkHttpRequest = context.httpRequest();
        SelectedAuthScheme<?> selectedAuthScheme = this.getAuthScheme(executionAttributes);
        ChecksumAlgorithm algorithm = (ChecksumAlgorithm)selectedAuthScheme.authSchemeOption().signerProperty(AwsV4FamilyHttpSigner.CHECKSUM_ALGORITHM);
        if (Objects.equals(algorithm, DefaultChecksumAlgorithm.CRC32) && !(headerValue = this.getFirstNestedValue(sdkHttpRequest.headers(), "x-amz-sdk-checksum-algorithm")).isPresent()) {
            return (SdkHttpRequest)((SdkHttpRequest.Builder)sdkHttpRequest.toBuilder()).appendHeader("x-amz-sdk-checksum-algorithm", Algorithm.CRC32.name()).build();
        }
        return sdkHttpRequest;
    }

    private SelectedAuthScheme<?> getAuthScheme(ExecutionAttributes executionAttributes) {
        SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
        if (selectedAuthScheme == null) {
            throw new IllegalStateException("Auth scheme should not be null");
        }
        return selectedAuthScheme;
    }

    private Optional<String> getFirstNestedValue(Map<String, List<String>> map, String key) {
        List<String> value = map.get(key);
        if (value == null) {
            return Optional.empty();
        }
        String firstValue = value.get(0);
        return firstValue.isEmpty() ? Optional.empty() : Optional.of(firstValue);
    }
}

