/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import java.util.Map;
import java.util.Set;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.server.AmoroManagementConf;
import org.apache.amoro.server.catalog.ExternalCatalog;
import org.apache.amoro.server.catalog.InternalCatalogImpl;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.utils.CatalogUtil;

public class CatalogBuilder {
    private static final Map<String, Set<TableFormat>> formatSupportedMatrix = ImmutableMap.of((Object)"hadoop", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG, TableFormat.PAIMON, TableFormat.HUDI}), (Object)"glue", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG}), (Object)"custom", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG}), (Object)"hive", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG, TableFormat.MIXED_HIVE, TableFormat.PAIMON, TableFormat.HUDI}), (Object)"ams", (Object)Sets.newHashSet((Object[])new TableFormat[]{TableFormat.ICEBERG, TableFormat.MIXED_ICEBERG}));

    private static String getAmsURI(Configurations serviceConfig) {
        String host = serviceConfig.getString(AmoroManagementConf.SERVER_EXPOSE_HOST);
        Integer port = serviceConfig.getInteger(AmoroManagementConf.TABLE_SERVICE_THRIFT_BIND_PORT);
        return String.format("thrift://%s:%d", host, port);
    }

    public static ServerCatalog buildServerCatalog(CatalogMeta catalogMeta, Configurations serverConfiguration) {
        String type = catalogMeta.getCatalogType();
        Set tableFormats = CatalogUtil.tableFormats((CatalogMeta)catalogMeta);
        Preconditions.checkState((boolean)formatSupportedMatrix.containsKey(type), (String)"unsupported catalog type: %s", (Object)type);
        Set<TableFormat> supportedFormats = formatSupportedMatrix.get(type);
        Preconditions.checkState((boolean)supportedFormats.containsAll(tableFormats), (String)"Table format %s is not supported for metastore type: %s", (Object)tableFormats, (Object)type);
        switch (type) {
            case "hadoop": 
            case "glue": 
            case "custom": {
                return new ExternalCatalog(catalogMeta);
            }
            case "hive": {
                String amsUri = CatalogBuilder.getAmsURI(serverConfiguration);
                catalogMeta.getCatalogProperties().put("ams.uri", amsUri);
                return new ExternalCatalog(catalogMeta);
            }
            case "ams": {
                return new InternalCatalogImpl(catalogMeta, serverConfiguration);
            }
        }
        throw new IllegalStateException("unsupported catalog type:" + type);
    }
}

