/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import java.util.Collections;
import java.util.Map;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.ImmutableMap;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.amoro.utils.JacksonUtil;

public class PluginConfiguration {
    private static final String NAME = "name";
    private static final String ENABLED = "enabled";
    private static final String PROPERTIES = "properties";
    private final String name;
    private final boolean enabled;
    private final Map<String, String> properties;

    public PluginConfiguration(String name, boolean enabled, Map<String, String> properties) {
        this.name = name;
        this.enabled = enabled;
        this.properties = properties;
    }

    public static PluginConfiguration fromJSONObject(JsonNode configOptions) {
        JsonNode nameNode = configOptions.get(NAME);
        Preconditions.checkNotNull((Object)nameNode, (Object)"plugin name is required");
        String name = nameNode.textValue();
        boolean enabled = JacksonUtil.getBoolean((JsonNode)configOptions, (String)ENABLED, (boolean)true);
        Map props = JacksonUtil.getMap((JsonNode)configOptions, (String)PROPERTIES, (TypeReference)new TypeReference<Map<String, String>>(){});
        if (props == null) {
            props = ImmutableMap.of();
        }
        return new PluginConfiguration(name, enabled, props);
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }
}

