/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.optimizing;

import org.apache.amoro.optimizing.OptimizingType;

public enum OptimizingStatus {
    FULL_OPTIMIZING("full", true, 100),
    MAJOR_OPTIMIZING("major", true, 200),
    MINOR_OPTIMIZING("minor", true, 300),
    COMMITTING("committing", true, 400),
    PLANNING("planning", false, 500),
    PENDING("pending", false, 600),
    IDLE("idle", false, 700);

    private final String displayValue;
    private final boolean isProcessing;
    private final int code;

    private OptimizingStatus(String displayValue, boolean isProcessing, int code) {
        this.displayValue = displayValue;
        this.isProcessing = isProcessing;
        this.code = code;
    }

    public boolean isProcessing() {
        return this.isProcessing;
    }

    public String displayValue() {
        return this.displayValue;
    }

    public int getCode() {
        return this.code;
    }

    public static OptimizingStatus ofCode(int code) {
        for (OptimizingStatus status : OptimizingStatus.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        return null;
    }

    public static OptimizingStatus ofDisplayValue(String displayValue) {
        for (OptimizingStatus status : OptimizingStatus.values()) {
            if (!status.displayValue.equals(displayValue)) continue;
            return status;
        }
        return null;
    }

    public static OptimizingStatus ofOptimizingType(OptimizingType optimizingType) {
        switch (optimizingType) {
            case FULL: {
                return FULL_OPTIMIZING;
            }
            case MAJOR: {
                return MAJOR_OPTIMIZING;
            }
            case MINOR: {
                return MINOR_OPTIMIZING;
            }
        }
        throw new IllegalStateException("unknown optimizing-type: " + optimizingType);
    }
}

